/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier;

import org.apache.geode.CancelException;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalCacheForClientAccess;

public class CachedRegionHelper {
    private final InternalCache cache;
    private final InternalCache realCache;
    private volatile boolean shutdown = false;

    public CachedRegionHelper(InternalCache cache) {
        this.realCache = cache;
        this.cache = new InternalCacheForClientAccess(cache);
    }

    public void checkCancelInProgress(Throwable e) throws CancelException {
        this.cache.getCancelCriterion().checkCancelInProgress(e);
    }

    public Region getRegion(String name) {
        return this.cache.getRegion(name);
    }

    public InternalCache getCache() {
        return this.cache;
    }

    public InternalCache getCacheForGatewayCommand() {
        return this.realCache;
    }

    public void setShutdown(boolean shutdown) {
        this.shutdown = shutdown;
    }

    public boolean isShutdown() {
        return this.shutdown || this.cache.getCancelCriterion().isCancelInProgress();
    }

    public void close() {
    }
}

