/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.IOException;
import java.util.Arrays;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.offheap.StoredObject;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.pdx.PdxInstance;
import org.apache.geode.pdx.PdxSerializable;
import org.apache.geode.pdx.PdxSerializationException;
import org.apache.geode.pdx.PdxSerializer;

public class ValueComparisonHelper {
    public static boolean checkEquals(Object v1, Object v2, boolean isCompressedOffHeap, InternalCache cache) {
        if (v1 instanceof PdxInstance) {
            return ValueComparisonHelper.checkPdxEquals((PdxInstance)v1, v2, cache);
        }
        if (v2 instanceof PdxInstance) {
            return ValueComparisonHelper.checkPdxEquals((PdxInstance)v2, v1, cache);
        }
        if (v1 instanceof StoredObject) {
            return ValueComparisonHelper.checkOffHeapEquals((StoredObject)v1, v2, cache);
        }
        if (v2 instanceof StoredObject) {
            return ValueComparisonHelper.checkOffHeapEquals((StoredObject)v2, v1, cache);
        }
        if (v1 instanceof CachedDeserializable) {
            return ValueComparisonHelper.checkCDEquals((CachedDeserializable)v1, v2, isCompressedOffHeap, cache);
        }
        if (v2 instanceof CachedDeserializable) {
            return ValueComparisonHelper.checkCDEquals((CachedDeserializable)v2, v1, isCompressedOffHeap, cache);
        }
        return ValueComparisonHelper.basicEquals(v1, v2);
    }

    static boolean basicEquals(Object v1, Object v2) {
        if (v2 != null) {
            if (v2.getClass().isArray()) {
                if (v2 instanceof byte[]) {
                    if (v1 instanceof byte[]) {
                        return Arrays.equals((byte[])v2, (byte[])v1);
                    }
                    return false;
                }
                if (v2 instanceof Object[]) {
                    if (v1 instanceof Object[]) {
                        return Arrays.deepEquals((Object[])v2, (Object[])v1);
                    }
                    return false;
                }
                if (v2 instanceof int[]) {
                    if (v1 instanceof int[]) {
                        return Arrays.equals((int[])v2, (int[])v1);
                    }
                    return false;
                }
                if (v2 instanceof long[]) {
                    if (v1 instanceof long[]) {
                        return Arrays.equals((long[])v2, (long[])v1);
                    }
                    return false;
                }
                if (v2 instanceof boolean[]) {
                    if (v1 instanceof boolean[]) {
                        return Arrays.equals((boolean[])v2, (boolean[])v1);
                    }
                    return false;
                }
                if (v2 instanceof short[]) {
                    if (v1 instanceof short[]) {
                        return Arrays.equals((short[])v2, (short[])v1);
                    }
                    return false;
                }
                if (v2 instanceof char[]) {
                    if (v1 instanceof char[]) {
                        return Arrays.equals((char[])v2, (char[])v1);
                    }
                    return false;
                }
                if (v2 instanceof float[]) {
                    if (v1 instanceof float[]) {
                        return Arrays.equals((float[])v2, (float[])v1);
                    }
                    return false;
                }
                if (v2 instanceof double[]) {
                    if (v1 instanceof double[]) {
                        return Arrays.equals((double[])v2, (double[])v1);
                    }
                    return false;
                }
            }
            return v2.equals(v1);
        }
        return v1 == null;
    }

    private static boolean checkPdxEquals(PdxInstance pdx, Object obj, InternalCache cache) {
        if (!(obj instanceof PdxInstance)) {
            PdxSerializer pdxSerializer;
            if (obj instanceof CachedDeserializable) {
                CachedDeserializable cdObj = (CachedDeserializable)obj;
                if (!cdObj.isSerialized()) {
                    return false;
                }
                Object cdVal = cdObj.getValue();
                if (cdVal instanceof byte[]) {
                    byte[] cdValBytes = (byte[])cdVal;
                    PdxInstance pi = InternalDataSerializer.readPdxInstance(cdValBytes, cache);
                    if (pi != null) {
                        return pi.equals(pdx);
                    }
                    return false;
                }
                obj = cdVal;
            }
            if (obj != null && obj.getClass().getName().equals(pdx.getClassName()) && ((pdxSerializer = obj instanceof PdxSerializable ? null : cache.getPdxSerializer()) != null || obj instanceof PdxSerializable)) {
                HeapDataOutputStream hdos = new HeapDataOutputStream(Version.CURRENT);
                try {
                    PdxInstance pi;
                    if ((InternalDataSerializer.autoSerialized(obj, hdos) || InternalDataSerializer.writePdx(hdos, cache, obj, pdxSerializer)) && (pi = InternalDataSerializer.readPdxInstance(hdos.toByteArray(), cache)) != null) {
                        obj = pi;
                    }
                }
                catch (IOException | PdxSerializationException exception) {
                    // empty catch block
                }
            }
        }
        return ValueComparisonHelper.basicEquals(obj, pdx);
    }

    private static boolean checkOffHeapEquals(StoredObject ohVal, Object obj, InternalCache cache) {
        byte[] serializedObj;
        if (ohVal.isSerializedPdxInstance()) {
            PdxInstance pi = InternalDataSerializer.readPdxInstance(ohVal.getSerializedValue(), cache);
            return ValueComparisonHelper.checkPdxEquals(pi, obj, cache);
        }
        if (obj instanceof StoredObject) {
            return ohVal.checkDataEquals((StoredObject)obj);
        }
        if (obj instanceof CachedDeserializable) {
            CachedDeserializable cdObj = (CachedDeserializable)obj;
            if (!ohVal.isSerialized()) {
                assert (cdObj.isSerialized());
                return false;
            }
            serializedObj = cdObj.getSerializedValue();
        } else if (obj instanceof byte[]) {
            if (ohVal.isSerialized()) {
                return false;
            }
            serializedObj = (byte[])obj;
        } else {
            if (!ohVal.isSerialized()) {
                return false;
            }
            if (obj == null || obj == Token.NOT_AVAILABLE || Token.isInvalidOrRemoved(obj)) {
                return false;
            }
            serializedObj = EntryEventImpl.serialize(obj);
        }
        return ohVal.checkDataEquals(serializedObj);
    }

    private static boolean checkCDEquals(CachedDeserializable cd, Object obj, boolean isCompressedOffHeap, InternalCache cache) {
        if (!cd.isSerialized()) {
            byte[] ba2;
            if (obj instanceof CachedDeserializable) {
                CachedDeserializable cdObj = (CachedDeserializable)obj;
                if (cdObj.isSerialized()) {
                    return false;
                }
                ba2 = (byte[])cdObj.getDeserializedForReading();
            } else if (obj instanceof byte[]) {
                ba2 = (byte[])obj;
            } else {
                return false;
            }
            byte[] ba1 = (byte[])cd.getDeserializedForReading();
            return Arrays.equals(ba1, ba2);
        }
        Object cdVal = cd.getValue();
        if (cdVal instanceof byte[]) {
            if (obj == null || obj == Token.NOT_AVAILABLE || Token.isInvalidOrRemoved(obj)) {
                return false;
            }
            byte[] cdValBytes = (byte[])cdVal;
            PdxInstance pi = InternalDataSerializer.readPdxInstance(cdValBytes, cache);
            if (pi != null) {
                return ValueComparisonHelper.checkPdxEquals(pi, obj, cache);
            }
            if (isCompressedOffHeap) {
                byte[] serializedObj = obj instanceof CachedDeserializable ? ((CachedDeserializable)obj).getSerializedValue() : EntryEventImpl.serialize(obj);
                return Arrays.equals(cdValBytes, serializedObj);
            }
            Object deserializedObj = obj instanceof CachedDeserializable ? ((CachedDeserializable)obj).getDeserializedForReading() : obj;
            return ValueComparisonHelper.basicEquals(deserializedObj, cd.getDeserializedForReading());
        }
        if (obj instanceof CachedDeserializable) {
            obj = ((CachedDeserializable)obj).getDeserializedForReading();
        }
        return ValueComparisonHelper.basicEquals(cdVal, obj);
    }
}

