/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.Region;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.PooledDistributionMessage;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public abstract class RegionAdminMessage
extends PooledDistributionMessage {
    private String regionName;

    public void setRegionName(String name) {
        this.regionName = name;
    }

    public String getRegionName() {
        return this.regionName;
    }

    protected Region getRegion(DistributedSystem sys) {
        Cache cache = CacheFactory.getInstance(sys);
        return cache.getRegion(this.regionName);
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        DataSerializer.writeString(this.regionName, out);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.regionName = DataSerializer.readString(in);
    }
}

