/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.utils;

import java.io.File;
import org.apache.commons.io.FilenameUtils;

public class FilenameNormalization {
    public static File[] normalize(File[] files) {
        File[] result = new File[files.length];
        for (int i = 0; i < files.length; ++i) {
            result[i] = FilenameNormalization.normalize(files[i]);
        }
        return result;
    }

    public static File normalize(File f) {
        String caseNormalizedAbsPath = f.getAbsolutePath();
        return new File(FilenameUtils.normalize((String)caseNormalizedAbsPath));
    }

    public static String normalize(String path) {
        File f = new File(path);
        String caseNormalizedAbsPath = f.getAbsolutePath();
        String normalized = FilenameUtils.normalize((String)caseNormalizedAbsPath);
        if (normalized == null) {
            return path;
        }
        if (normalized.equals(path)) {
            return path;
        }
        return normalized;
    }

    public static boolean isNormalized(String path) {
        String normalizedPath = FilenameNormalization.normalize(path);
        return normalizedPath.equals(path);
    }

    public static String normalizeFileToPath(File file) {
        return FilenameNormalization.normalize(file.getAbsolutePath());
    }
}

