/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.parsing.as;

import antlr.ANTLRException;
import antlr.LLkParser;
import antlr.MismatchedTokenException;
import antlr.NoViableAltException;
import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.io.IOUtils;
import org.apache.flex.abc.semantics.ECMASupport;
import org.apache.flex.compiler.asdoc.IASDocComment;
import org.apache.flex.compiler.asdoc.IASParserASDocDelegate;
import org.apache.flex.compiler.common.IFileSpecificationGetter;
import org.apache.flex.compiler.common.ISourceLocation;
import org.apache.flex.compiler.common.SourceLocation;
import org.apache.flex.compiler.filespecs.IFileSpecification;
import org.apache.flex.compiler.internal.filespecs.StringFileSpecification;
import org.apache.flex.compiler.internal.parsing.TokenBase;
import org.apache.flex.compiler.internal.parsing.as.ASParser;
import org.apache.flex.compiler.internal.parsing.as.ASToken;
import org.apache.flex.compiler.internal.parsing.as.ConfigProcessor;
import org.apache.flex.compiler.internal.parsing.as.DeferFunctionBody;
import org.apache.flex.compiler.internal.parsing.as.IProblemReporter;
import org.apache.flex.compiler.internal.parsing.as.IProjectConfigVariables;
import org.apache.flex.compiler.internal.parsing.as.IRepairingTokenBuffer;
import org.apache.flex.compiler.internal.parsing.as.IncludeHandler;
import org.apache.flex.compiler.internal.parsing.as.MetaDataPayloadToken;
import org.apache.flex.compiler.internal.parsing.as.MetadataParser;
import org.apache.flex.compiler.internal.parsing.as.MetadataToken;
import org.apache.flex.compiler.internal.parsing.as.MetadataTokenizer;
import org.apache.flex.compiler.internal.parsing.as.OffsetLookup;
import org.apache.flex.compiler.internal.parsing.as.StreamingASTokenizer;
import org.apache.flex.compiler.internal.parsing.as.StreamingTokenBuffer;
import org.apache.flex.compiler.internal.scopes.ASScope;
import org.apache.flex.compiler.internal.semantics.PostProcessStep;
import org.apache.flex.compiler.internal.tree.as.ArrayLiteralNode;
import org.apache.flex.compiler.internal.tree.as.BaseDefinitionNode;
import org.apache.flex.compiler.internal.tree.as.BinaryOperatorNodeBase;
import org.apache.flex.compiler.internal.tree.as.BlockNode;
import org.apache.flex.compiler.internal.tree.as.ClassNode;
import org.apache.flex.compiler.internal.tree.as.ConfigConstNode;
import org.apache.flex.compiler.internal.tree.as.ConfigExpressionNode;
import org.apache.flex.compiler.internal.tree.as.ContainerNode;
import org.apache.flex.compiler.internal.tree.as.EmbedNode;
import org.apache.flex.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.flex.compiler.internal.tree.as.FileNode;
import org.apache.flex.compiler.internal.tree.as.FullNameNode;
import org.apache.flex.compiler.internal.tree.as.FunctionNode;
import org.apache.flex.compiler.internal.tree.as.FunctionObjectNode;
import org.apache.flex.compiler.internal.tree.as.IdentifierNode;
import org.apache.flex.compiler.internal.tree.as.ImportNode;
import org.apache.flex.compiler.internal.tree.as.LiteralNode;
import org.apache.flex.compiler.internal.tree.as.MemberAccessExpressionNode;
import org.apache.flex.compiler.internal.tree.as.ModifierNode;
import org.apache.flex.compiler.internal.tree.as.NamespaceAccessExpressionNode;
import org.apache.flex.compiler.internal.tree.as.NamespaceIdentifierNode;
import org.apache.flex.compiler.internal.tree.as.NamespaceNode;
import org.apache.flex.compiler.internal.tree.as.NodeBase;
import org.apache.flex.compiler.internal.tree.as.QualifiedNamespaceExpressionNode;
import org.apache.flex.compiler.internal.tree.as.ScopedBlockNode;
import org.apache.flex.compiler.internal.tree.as.UnaryOperatorNodeBase;
import org.apache.flex.compiler.internal.tree.as.VariableNode;
import org.apache.flex.compiler.internal.tree.as.metadata.MetaTagsNode;
import org.apache.flex.compiler.internal.workspaces.Workspace;
import org.apache.flex.compiler.mxml.IMXMLTextData;
import org.apache.flex.compiler.parsing.GenericTokenStream;
import org.apache.flex.compiler.parsing.IASToken;
import org.apache.flex.compiler.problems.AttributesNotAllowedOnPackageDefinitionProblem;
import org.apache.flex.compiler.problems.CanNotInsertSemicolonProblem;
import org.apache.flex.compiler.problems.CompilerProblem;
import org.apache.flex.compiler.problems.EmbedInitialValueProblem;
import org.apache.flex.compiler.problems.EmbedMultipleMetaTagsProblem;
import org.apache.flex.compiler.problems.EmbedOnlyOnClassesAndVarsProblem;
import org.apache.flex.compiler.problems.EmbedUnsupportedTypeProblem;
import org.apache.flex.compiler.problems.ExpectDefinitionKeywordAfterAttributeProblem;
import org.apache.flex.compiler.problems.ExtraCharactersAfterEndOfProgramProblem;
import org.apache.flex.compiler.problems.FileNotFoundProblem;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.problems.InternalCompilerProblem;
import org.apache.flex.compiler.problems.InternalCompilerProblem2;
import org.apache.flex.compiler.problems.InvalidAttributeProblem;
import org.apache.flex.compiler.problems.InvalidConfigLocationProblem;
import org.apache.flex.compiler.problems.InvalidLabelProblem;
import org.apache.flex.compiler.problems.InvalidTypeProblem;
import org.apache.flex.compiler.problems.MXMLInvalidDatabindingExpressionProblem;
import org.apache.flex.compiler.problems.MissingLeftBraceBeforeFunctionBodyProblem;
import org.apache.flex.compiler.problems.MultipleConfigNamespaceDecorationsProblem;
import org.apache.flex.compiler.problems.MultipleNamespaceAttributesProblem;
import org.apache.flex.compiler.problems.MultipleReservedNamespaceAttributesProblem;
import org.apache.flex.compiler.problems.NamespaceAttributeNotAllowedProblem;
import org.apache.flex.compiler.problems.NestedClassProblem;
import org.apache.flex.compiler.problems.NestedInterfaceProblem;
import org.apache.flex.compiler.problems.NestedPackageProblem;
import org.apache.flex.compiler.problems.NonConstConfigVarProblem;
import org.apache.flex.compiler.problems.ParserProblem;
import org.apache.flex.compiler.problems.ShadowedConfigNamespaceProblem;
import org.apache.flex.compiler.problems.SyntaxProblem;
import org.apache.flex.compiler.problems.UnboundMetadataProblem;
import org.apache.flex.compiler.problems.UnexpectedEOFProblem;
import org.apache.flex.compiler.problems.UnexpectedTokenProblem;
import org.apache.flex.compiler.problems.XMLOpenCloseTagNotMatchProblem;
import org.apache.flex.compiler.projects.IASProject;
import org.apache.flex.compiler.tree.ASTNodeID;
import org.apache.flex.compiler.tree.as.IASNode;
import org.apache.flex.compiler.tree.as.IExpressionNode;
import org.apache.flex.compiler.tree.as.IFileNodeAccumulator;
import org.apache.flex.compiler.tree.as.ILiteralNode;
import org.apache.flex.compiler.tree.as.INamespaceDecorationNode;
import org.apache.flex.compiler.tree.as.IOperatorNode;
import org.apache.flex.compiler.tree.metadata.IMetaTagNode;
import org.apache.flex.compiler.tree.metadata.IMetaTagsNode;
import org.apache.flex.compiler.units.ICompilationUnit;
import org.apache.flex.compiler.workspaces.IWorkspace;
import org.apache.flex.utils.FilenameNormalization;
import org.apache.flex.utils.NonLockingStringReader;

abstract class BaseASParser
extends LLkParser
implements IProblemReporter {
    private static final String CONFIG_AS = "config.as";
    public static final IProjectConfigVariables EMPTY_CONFIGURATION = null;
    protected static final int NO_END_TOKEN = -1;
    private static final String SUB_SYSTEM = "ASParser";
    protected IRepairingTokenBuffer buffer;
    protected MetaTagsNode currentAttributes;
    protected final IASParserASDocDelegate asDocDelegate;
    protected Token errorToken = null;
    protected boolean allowEmbeds = true;
    protected boolean insideClass = false;
    private final boolean parsingProjectConfigVariables;
    private MismatchedTokenException exceptionPool = new MismatchedTokenException(this.tokenNames, null, null, false);
    protected final Set<ICompilerProblem> errors = new LinkedHashSet<ICompilerProblem>();
    private IFileNodeAccumulator fileNodeAccumulator;
    private ConfigProcessor configProcessor;
    private boolean allowErrorsInContext = true;
    protected DeferFunctionBody deferFunctionBody = DeferFunctionBody.DISABLED;
    private final Reader secondaryReader;
    private int secondaryReaderPosition = 0;
    private int packageDepth = 0;
    private int blockDepth = 0;
    private int groupDepth = 0;
    private final Stack<XMLTagInfo> xmlTags;
    private static final ImmutableMap<Integer, Integer> BINARY_PRECEDENCE = new ImmutableMap.Builder().put((Object)41, (Object)1).put((Object)52, (Object)2).put((Object)74, (Object)2).put((Object)75, (Object)2).put((Object)76, (Object)2).put((Object)77, (Object)2).put((Object)78, (Object)2).put((Object)79, (Object)2).put((Object)80, (Object)2).put((Object)81, (Object)2).put((Object)82, (Object)2).put((Object)83, (Object)2).put((Object)84, (Object)2).put((Object)85, (Object)2).put((Object)86, (Object)2).put((Object)87, (Object)3).put((Object)88, (Object)4).put((Object)89, (Object)5).put((Object)90, (Object)6).put((Object)91, (Object)7).put((Object)92, (Object)8).put((Object)93, (Object)9).put((Object)94, (Object)9).put((Object)95, (Object)9).put((Object)96, (Object)9).put((Object)73, (Object)10).put((Object)97, (Object)10).put((Object)98, (Object)10).put((Object)99, (Object)10).put((Object)100, (Object)10).put((Object)101, (Object)10).put((Object)102, (Object)10).put((Object)58, (Object)10).put((Object)103, (Object)11).put((Object)104, (Object)11).put((Object)105, (Object)11).put((Object)106, (Object)12).put((Object)107, (Object)12).put((Object)108, (Object)13).put((Object)109, (Object)13).put((Object)110, (Object)13).build();
    protected ExpressionMode expressionMode = ExpressionMode.normal;
    private boolean extraCharacterAfterEndOfProgramProblemLogged = false;
    private static final ImmutableSet<Integer> RESTRICTED_TOKEN_TYPES = ImmutableSet.of((Object)55, (Object)61, (Object)62, (Object)56);
    private static final ImmutableSet<String> RESERVED_NAMESPACE_ATTRIBUTES = ImmutableSet.of((Object)"private", (Object)"public", (Object)"protected", (Object)"internal");
    private static final ImmutableSet<String> CONTEXTUAL_RESERVED_KEYWORD_MODIFIERS = ImmutableSet.of((Object)"dynamic", (Object)"final", (Object)"native", (Object)"static", (Object)"override");
    private static final String TAG_NAME_BINDING = "{...}";

    public static FileNode parseFile(IFileSpecification spec, IFileSpecificationGetter fileSpecGetter) {
        return BaseASParser.parseFile(spec, fileSpecGetter, EnumSet.of(PostProcessStep.CALCULATE_OFFSETS), EMPTY_CONFIGURATION, true);
    }

    public static FileNode parseFile(IFileSpecification spec, IFileSpecificationGetter fileSpecGetter, EnumSet<PostProcessStep> postProcess, IProjectConfigVariables variables, boolean followIncludes) {
        return BaseASParser.parseFile(spec, fileSpecGetter, postProcess, variables, followIncludes, true, Collections.<String>emptyList(), DeferFunctionBody.DISABLED, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static FileNode parseFile(IFileSpecification spec, IFileSpecificationGetter fileSpecGetter, EnumSet<PostProcessStep> postProcess, IProjectConfigVariables variables, boolean followIncludes, boolean allowEmbeds, List<String> includedFiles, DeferFunctionBody deferFunctionBody, IASProject flashProject, ICompilationUnit compilationUnit) {
        StreamingASTokenizer tokenizer;
        FileNode node;
        block11: {
            assert (spec != null) : "File spec can't be null.";
            assert (fileSpecGetter != null) : "File specification getter can't be null";
            assert (fileSpecGetter.getWorkspace() instanceof Workspace) : "Expected Workspace type.";
            node = new FileNode(fileSpecGetter, spec.getPath());
            IncludeHandler includeHandler = node.getIncludeHandler();
            includeHandler.setProjectAndCompilationUnit(flashProject, compilationUnit);
            tokenizer = null;
            try {
                tokenizer = StreamingASTokenizer.createForASParser(spec, includeHandler, followIncludes, includedFiles);
                StreamingTokenBuffer buffer = new StreamingTokenBuffer(tokenizer);
                ASParser parser = new ASParser(fileSpecGetter.getWorkspace(), buffer);
                parser.deferFunctionBody = deferFunctionBody;
                parser.setProjectConfigVariables(variables);
                parser.setFilename(spec.getPath());
                parser.setAllowEmbeds(allowEmbeds);
                parser.parseFile(node, (EnumSet)postProcess);
                if (node.getAbsoluteEnd() < tokenizer.getEndOffset()) {
                    node.setEnd(tokenizer.getEndOffset());
                }
                node.setProblems(tokenizer.getTokenizationProblems());
                node.setProblems(parser.getSyntaxProblems());
                OffsetLookup offsetLookup = new OffsetLookup(includeHandler.getOffsetCueList());
                node.setOffsetLookup(offsetLookup);
                int[] absoluteOffset = offsetLookup.getAbsoluteOffset(spec.getPath(), tokenizer.getEndOffset());
                assert (absoluteOffset.length == 1) : "There seems to be a cycle in the include tree which has not been handled.";
                if (node.getAbsoluteEnd() >= absoluteOffset[0]) break block11;
                node.setEnd(absoluteOffset[0]);
            }
            catch (FileNotFoundException e) {
                node.addProblem(new FileNotFoundProblem(e.getMessage()));
                IOUtils.closeQuietly((Closeable)tokenizer);
            }
            catch (Exception e2) {
                InternalCompilerProblem2 problem = new InternalCompilerProblem2(spec.getPath(), e2, SUB_SYSTEM);
                node.addProblem(problem);
                {
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(tokenizer);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Closeable)tokenizer);
            }
        }
        IOUtils.closeQuietly((Closeable)tokenizer);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScopedBlockNode parseFragment2(String fragment, String path, int offset, int line, int column, Collection<ICompilerProblem> problems, IWorkspace workspace, IFileNodeAccumulator fileNodeAccumulator, ASScope containingScope, IProjectConfigVariables variables, EnumSet<PostProcessStep> postProcess, boolean followIncludes, IncludeHandler includeHandler) {
        assert (fragment != null);
        assert (path != null);
        assert (workspace != null);
        assert (includeHandler != null);
        assert (problems != null);
        StreamingASTokenizer tokenizer = null;
        BaseASParser parser = null;
        StringFileSpecification textFileSpec = new StringFileSpecification(path, fragment);
        ScopedBlockNode container = new ScopedBlockNode();
        container.setScope(containingScope);
        try {
            tokenizer = StreamingASTokenizer.create(textFileSpec, includeHandler);
            tokenizer.setSourcePositionAdjustment(offset, line, column);
            StreamingTokenBuffer buffer = new StreamingTokenBuffer(tokenizer);
            parser = new ASParser(workspace, buffer);
            parser.setFileNodeAccumulator(fileNodeAccumulator);
            parser.setFilename(path);
            ((ASParser)parser).setProjectConfigVariables(variables);
            parser.blockDepth = 1;
            while (buffer.LA(1) != 1) {
                ((ASParser)parser).directive(container, -1);
            }
            problems.addAll(tokenizer.getTokenizationProblems());
            problems.addAll(((ASParser)parser).getSyntaxProblems());
            problems.addAll(container.runPostProcess(postProcess, containingScope));
        }
        catch (RecognitionException e) {
            parser.consumeParsingError(e);
            problems.addAll(((ASParser)parser).getSyntaxProblems());
        }
        catch (TokenStreamException e) {
            ICompilerProblem problem = BaseASParser.genericParserProblem(path, offset, offset, line, column);
            problems.add(problem);
        }
        catch (FileNotFoundException e) {
            ICompilerProblem problem = BaseASParser.genericParserProblem(path, offset, offset, line, column);
            problems.add(problem);
        }
        finally {
            if (parser != null) {
                parser.disconnect();
            }
            IOUtils.closeQuietly((Closeable)tokenizer);
            if (includeHandler != null && tokenizer != null) {
                includeHandler.leaveFile(tokenizer.getEndOffset());
            }
        }
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseFunctionBody(ScopedBlockNode container, Reader reader, String path, ASToken blockOpenToken, Collection<ICompilerProblem> problems, IWorkspace workspace, FileNode fileNode, ConfigProcessor configProcessor) {
        assert (container != null);
        assert (reader != null);
        assert (path != null);
        assert (blockOpenToken != null);
        assert (problems != null);
        assert (workspace != null);
        assert (fileNode != null);
        assert (configProcessor != null);
        StreamingASTokenizer tokenizer = null;
        BaseASParser parser = null;
        try {
            tokenizer = new StreamingASTokenizer();
            tokenizer.setReader(reader);
            tokenizer.setPath(path);
            tokenizer.setSourcePositionAdjustment(blockOpenToken.getEnd(), blockOpenToken.getLine(), blockOpenToken.getColumn());
            StreamingTokenBuffer buffer = new StreamingTokenBuffer(tokenizer);
            parser = new ASParser(workspace, buffer);
            parser.setFileNodeAccumulator(fileNode);
            parser.setFilename(path);
            parser.setConfigProcessor(configProcessor);
            parser.blockDepth = 1;
            while (buffer.LA(1) != 1 && buffer.LA(1) != 20) {
                ((ASParser)parser).directive(container, 20);
            }
            problems.addAll(tokenizer.getTokenizationProblems());
            problems.addAll(((ASParser)parser).getSyntaxProblems());
        }
        catch (RecognitionException e) {
            parser.consumeParsingError(e);
            problems.addAll(((ASParser)parser).getSyntaxProblems());
        }
        catch (TokenStreamException e) {
            problems.add(new ParserProblem(container));
        }
        finally {
            if (parser != null) {
                parser.disconnect();
            }
            IOUtils.closeQuietly((Closeable)tokenizer);
        }
    }

    private static ICompilerProblem genericParserProblem(String path, int start, int end, int line, int column) {
        SourceLocation location = new SourceLocation(path, start, end, line, column);
        return new ParserProblem(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScopedBlockNode parseInlineScript(IFileNodeAccumulator fileNodeAccumulator, IMXMLTextData mxmlTextData, Collection<ICompilerProblem> problems, ASScope containingScope, IProjectConfigVariables variables, IncludeHandler includeHandler, EnumSet<PostProcessStep> postProcess) {
        assert (mxmlTextData != null) : "MXMLTextData can't be null.";
        assert (includeHandler != null) : "IncludeHandler can't be null.";
        assert (problems != null) : "Problem container can't be null";
        String scriptSourcePath = mxmlTextData.getParent().getPath();
        String scriptContent = mxmlTextData.getCompilableText();
        StringReader scriptReader = new StringReader(scriptContent);
        int compilableTextStart = mxmlTextData.getCompilableTextStart();
        int compilableTextLine = mxmlTextData.getCompilableTextLine();
        int compilableTextColumn = mxmlTextData.getCompilableTextColumn();
        ScopedBlockNode container = new ScopedBlockNode();
        StreamingASTokenizer tokenizer = StreamingASTokenizer.createForInlineScriptScopeBuilding(scriptReader, scriptSourcePath, includeHandler, compilableTextStart, compilableTextLine, compilableTextColumn);
        StreamingTokenBuffer buffer = new StreamingTokenBuffer(tokenizer);
        ASParser parser = new ASParser(containingScope.getWorkspace(), buffer);
        try {
            parser.setFilename(scriptSourcePath);
            parser.setProjectConfigVariables(variables);
            parser.setFileNodeAccumulator(fileNodeAccumulator);
            while (buffer.LA(1) != 1) {
                parser.directive(container, -1);
            }
            problems.addAll(tokenizer.getTokenizationProblems());
            problems.addAll(parser.getSyntaxProblems());
            container.setScope(containingScope);
            Collection<ICompilerProblem> postProcessProblems = container.runPostProcess(postProcess, containingScope);
            problems.addAll(postProcessProblems);
        }
        catch (RecognitionException e) {
            parser.consumeParsingError(e);
            problems.addAll(parser.getSyntaxProblems());
        }
        catch (TokenStreamException e) {
            ICompilerProblem problem = BaseASParser.genericParserProblem(scriptSourcePath, mxmlTextData.getAbsoluteStart(), mxmlTextData.getAbsoluteEnd(), mxmlTextData.getLine(), mxmlTextData.getColumn());
            problems.add(problem);
        }
        finally {
            parser.disconnect();
            IOUtils.closeQuietly((Closeable)tokenizer);
        }
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExpressionNodeBase parseExpression(IWorkspace workspace, Reader scriptReader, Collection<ICompilerProblem> problems, IProjectConfigVariables variables, ISourceLocation location) {
        assert (scriptReader != null) : "reader can't be null.";
        assert (problems != null) : "Problem container can't be null";
        String sourcePath = location.getSourcePath();
        StreamingASTokenizer tokenizer = StreamingASTokenizer.createForInlineExpressionParsing(scriptReader, sourcePath);
        StreamingTokenBuffer buffer = new StreamingTokenBuffer(tokenizer);
        ASParser parser = new ASParser(workspace, buffer);
        ExpressionNodeBase expressionNode = null;
        try {
            parser.setFilename(sourcePath);
            parser.setProjectConfigVariables(variables);
            if (buffer.LA(1) != 1) {
                expressionNode = parser.expression();
            }
            problems.addAll(tokenizer.getTokenizationProblems());
            problems.addAll(parser.getSyntaxProblems());
        }
        catch (RecognitionException e) {
            parser.consumeParsingError(e);
            problems.addAll(parser.getSyntaxProblems());
        }
        catch (TokenStreamException e) {
            ParserProblem genericParserProblem = new ParserProblem(location);
            problems.add(genericParserProblem);
        }
        finally {
            parser.disconnect();
            IOUtils.closeQuietly((Closeable)tokenizer);
        }
        return expressionNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final IASNode[] parseProjectConfigVariables(IWorkspace workspace, String fragment, Collection<ICompilerProblem> problems) {
        ScopedBlockNode container = new ScopedBlockNode();
        ASParser parser = null;
        try {
            StringFileSpecification fileSpec = new StringFileSpecification(CONFIG_AS, fragment, 0L);
            IncludeHandler includeHandler = new IncludeHandler(workspace);
            StreamingASTokenizer tokenizer = StreamingASTokenizer.create(fileSpec, includeHandler);
            tokenizer.setReader(new NonLockingStringReader(fragment));
            tokenizer.setPath(CONFIG_AS);
            tokenizer.setFollowIncludes(false);
            StreamingTokenBuffer buffer = new StreamingTokenBuffer(tokenizer);
            parser = new ASParser(workspace, buffer, true);
            parser.setFilename(CONFIG_AS);
            while (buffer.LA(1) != 1) {
                parser.directive(container, -1);
            }
            problems.addAll(tokenizer.getTokenizationProblems());
            problems.addAll(parser.getSyntaxProblems());
            IASNode[] iASNodeArray = parser.getConfigProcessorResults();
            return iASNodeArray;
        }
        catch (FileNotFoundException e) {
            assert (false) : "StringFileSpecification never raises this exception";
        }
        catch (ANTLRException e) {
        }
        catch (RuntimeException e) {
            String path = parser.getSourceFilePath();
            CompilerProblem problem = path == null ? new InternalCompilerProblem(e) : new InternalCompilerProblem2(path, e, SUB_SYSTEM);
            parser.errors.add(problem);
        }
        finally {
            if (parser != null) {
                parser.disconnect();
            }
        }
        int n = container.getChildCount();
        IASNode[] children = new IASNode[n];
        for (int i = 0; i < n; ++i) {
            children[i] = container.getChild(i);
        }
        return children;
    }

    public static final IExpressionNode parseDataBinding(IWorkspace workspace, Reader reader, Collection<ICompilerProblem> problems) {
        StreamingASTokenizer tokenizer = new StreamingASTokenizer();
        tokenizer.setReader(reader);
        StreamingTokenBuffer buffer = new StreamingTokenBuffer(tokenizer);
        ASParser parser = new ASParser(workspace, buffer);
        FileNode fileNode = new FileNode(workspace);
        parser.parseFile(fileNode, (EnumSet)EnumSet.noneOf(PostProcessStep.class));
        EnumSet<PostProcessStep> postProcessSteps = EnumSet.of(PostProcessStep.CALCULATE_OFFSETS);
        Collection<ICompilerProblem> postProcessProblems = fileNode.runPostProcess(postProcessSteps, null);
        problems.addAll(tokenizer.getTokenizationProblems());
        problems.addAll(parser.getSyntaxProblems());
        problems.addAll(postProcessProblems);
        int n = fileNode.getChildCount();
        if (n == 0) {
            return new LiteralNode(ILiteralNode.LiteralType.STRING, "");
        }
        if (n > 1) {
            MXMLInvalidDatabindingExpressionProblem problem = new MXMLInvalidDatabindingExpressionProblem(fileNode);
            problems.add(problem);
            return null;
        }
        IASNode firstChild = fileNode.getChild(0);
        if (!(firstChild instanceof IExpressionNode)) {
            MXMLInvalidDatabindingExpressionProblem problem = new MXMLInvalidDatabindingExpressionProblem(fileNode);
            problems.add(problem);
            return null;
        }
        return (IExpressionNode)firstChild;
    }

    protected BaseASParser(IWorkspace workspace, IRepairingTokenBuffer buffer) {
        this(workspace, buffer, false);
    }

    protected BaseASParser(IWorkspace workspace, IRepairingTokenBuffer buffer, boolean parsingProjectConfigVariables) {
        super(new ParserSharedInputState(), 1);
        this.xmlTags = new Stack();
        this.buffer = buffer;
        this.configProcessor = new ConfigProcessor(workspace, this);
        this.secondaryReader = BaseASParser.tryGetSecondaryReader(workspace, buffer);
        this.asDocDelegate = workspace.getASDocDelegate().getASParserASDocDelegate();
        this.parsingProjectConfigVariables = parsingProjectConfigVariables;
    }

    private static Reader tryGetSecondaryReader(IWorkspace workspace, IRepairingTokenBuffer buffer) {
        if (buffer instanceof StreamingTokenBuffer) {
            StreamingTokenBuffer streamingTokenBuffer = (StreamingTokenBuffer)buffer;
            if (streamingTokenBuffer.getSourcePath() == null) {
                return null;
            }
            String sourcePath = FilenameNormalization.normalize(streamingTokenBuffer.getSourcePath());
            if (!new File(sourcePath).isFile()) {
                return null;
            }
            IFileSpecification fileSpec = workspace.getFileSpecification(sourcePath);
            if (fileSpec != null) {
                try {
                    return fileSpec.createReader();
                }
                catch (FileNotFoundException e) {
                    return null;
                }
            }
        }
        return null;
    }

    protected BaseASParser(TokenBuffer tokenBuf, int k) {
        super(tokenBuf, k);
        throw new UnsupportedOperationException();
    }

    protected BaseASParser(TokenStream lexer, int k) {
        super(lexer, k);
        throw new UnsupportedOperationException();
    }

    protected BaseASParser(ParserSharedInputState state, int i) {
        super(state, i);
        throw new UnsupportedOperationException();
    }

    protected final void addConditionalCompilationNamespace(NamespaceNode node) {
        this.configProcessor.addConditionalCompilationNamespace(node);
        if (!this.isGlobalContext()) {
            InvalidConfigLocationProblem problem = new InvalidConfigLocationProblem(node);
            this.addProblem(problem);
        }
    }

    public void setProjectConfigVariables(IProjectConfigVariables variables) {
        this.configProcessor.connect(variables);
    }

    protected final void setConfigProcessor(ConfigProcessor configProcessor) {
        assert (configProcessor != null);
        configProcessor.setParser(this);
        this.configProcessor = configProcessor;
    }

    void addConfigConstNode(ConfigConstNode node) {
        CompilerProblem problem;
        this.configProcessor.addConfigConstNode(node);
        if (node.getKeywordNode().getKeywordId() != 51) {
            problem = new NonConstConfigVarProblem(node.getNameExpressionNode());
            this.addProblem(problem);
        }
        if (!this.isGlobalContext()) {
            problem = new InvalidConfigLocationProblem(node.getNameExpressionNode());
            this.addProblem(problem);
        }
    }

    IASNode[] getConfigProcessorResults() {
        if (this.configProcessor != null) {
            return this.configProcessor.getConfigChildren();
        }
        return new IASNode[0];
    }

    protected final LiteralNode evaluateConstNodeExpression(ConfigExpressionNode node) {
        return this.configProcessor.evaluateConstNodeExpression(node);
    }

    protected final boolean isConfigNamespace(NamespaceIdentifierNode id) {
        return this.configProcessor.isConfigNamespace(id.getName());
    }

    public Collection<ICompilerProblem> getSyntaxProblems() {
        return this.errors;
    }

    protected final void disconnect() {
        if (this.configProcessor != null) {
            this.configProcessor.detachParser(this);
        }
        IOUtils.closeQuietly((Reader)this.secondaryReader);
    }

    void setFileNodeAccumulator(IFileNodeAccumulator fileNodeAccumulator) {
        this.fileNodeAccumulator = fileNodeAccumulator;
    }

    @Override
    public String getSourceFilePath() {
        return this.getFilename();
    }

    protected void setAllowErrorsInContext(boolean allow) {
        this.allowErrorsInContext = allow;
    }

    @Override
    public void addProblem(ICompilerProblem problem) {
        if (this.allowErrorsInContext) {
            this.errors.add(problem);
        }
    }

    public void setAllowEmbeds(boolean allowEmbeds) {
        this.allowEmbeds = allowEmbeds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseFile(FileNode fileNode, EnumSet<PostProcessStep> features) {
        this.currentAttributes = null;
        fileNode.setStart(0);
        fileNode.setLine(0);
        fileNode.setColumn(0);
        String sourcePath = fileNode.getSourcePath();
        this.setFilename(sourcePath);
        this.exceptionPool.fileName = sourcePath;
        this.exceptionPool.mismatchType = 3;
        this.fileNodeAccumulator = fileNode;
        try {
            this.file(fileNode);
        }
        catch (RecognitionException e) {
            ASToken current = this.buffer.LT(1);
            if (e instanceof NoViableAltException) {
                this.addProblem(new SyntaxProblem(current));
            } else if (e instanceof MismatchedTokenException) {
                ASToken expected = new ASToken(((MismatchedTokenException)e).expecting, -1, -1, -1, -1, "");
                this.addProblem(this.unexpectedTokenProblem(current, expected.getTokenKind()));
            }
        }
        catch (TokenStreamException e) {
            this.addProblem(new SyntaxProblem(fileNode, null));
        }
        finally {
            this.disconnect();
        }
        fileNode.processAST(features);
    }

    protected abstract void fileLevelDirectives(ContainerNode var1) throws RecognitionException, TokenStreamException;

    protected void encounteredImport(ImportNode importNode) {
        if (this.fileNodeAccumulator != null) {
            this.fileNodeAccumulator.addImportNode(importNode);
        }
    }

    public static MetaTagsNode parseAtFunction(IWorkspace workspace, String metadataTagText, String sourcePath, int start, int line, int column, Collection<ICompilerProblem> problems) {
        StringBuilder stringBuffer = new StringBuilder();
        stringBuffer.append("[");
        stringBuffer.append(metadataTagText.substring(1));
        stringBuffer.append("]");
        return ASParser.parseMetadata(workspace, stringBuffer.toString(), sourcePath, start, line, column, problems);
    }

    public static MetaTagsNode parseMetadata(IWorkspace workspace, String metadataContent, String sourcePath, int start, int line, int column, Collection<ICompilerProblem> problems) {
        long lastModified = workspace.getFileSpecification(sourcePath).getLastModified();
        StringFileSpecification fileSpec = new StringFileSpecification(sourcePath, metadataContent, lastModified);
        IncludeHandler includeHandler = new IncludeHandler(workspace);
        ASParser parser = new ASParser(workspace, null);
        try {
            StreamingASTokenizer tokenizer = StreamingASTokenizer.create(fileSpec, includeHandler);
            tokenizer.setSourcePositionAdjustment(start, line, column);
            ASToken asToken = tokenizer.next();
            while (asToken != null) {
                switch (asToken.getType()) {
                    case 36: {
                        parser.parseMetadata(asToken, problems);
                        break;
                    }
                    case 28: {
                        parser.asDocDelegate.setCurrentASDocToken(asToken);
                        break;
                    }
                }
                asToken = tokenizer.next();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return parser.currentAttributes;
    }

    protected final void parseMetadata(Token attributeToken, Collection<ICompilerProblem> problems) {
        List<MetadataToken> metadataTokens;
        assert (problems != null) : "Expected problem collection.";
        assert (attributeToken != null) : "Expected attribute token.";
        if (attributeToken instanceof MetaDataPayloadToken) {
            metadataTokens = ((MetaDataPayloadToken)attributeToken).getPayload();
        } else {
            NonLockingStringReader metadataReader = new NonLockingStringReader(attributeToken.getText());
            MetadataTokenizer tokenizer = new MetadataTokenizer(metadataReader);
            tokenizer.setAdjust(((TokenBase)attributeToken).getStart());
            metadataTokens = tokenizer.parseTokens();
        }
        GenericTokenStream metadataTokenStream = new GenericTokenStream(metadataTokens);
        MetadataParser metadataParser = new MetadataParser(metadataTokenStream);
        metadataParser.setASDocDelegate(this.asDocDelegate.getMetadataParserASDocDelegate());
        if (this.currentAttributes == null) {
            this.currentAttributes = new MetaTagsNode();
        }
        try {
            metadataParser.meta(this.currentAttributes);
        }
        catch (RecognitionException e) {
            ParserProblem problem = new ParserProblem((TokenBase)attributeToken);
            problems.add(problem);
        }
        catch (TokenStreamException tokenStreamException) {
            // empty catch block
        }
    }

    protected final void preCheckMetadata(Token attributeToken, ContainerNode container) {
        if (this.currentAttributes == null) {
            return;
        }
        int la = this.LA(1);
        if (ASToken.isDefinitionKeyword(la) || ASToken.isModifier(la) || this.isConfigCondition() || la == 23 || la == 28 || la == 36) {
            return;
        }
        container.addItem(this.currentAttributes);
        UnboundMetadataProblem problem = new UnboundMetadataProblem((TokenBase)attributeToken);
        this.addProblem(problem);
        this.currentAttributes = null;
    }

    protected final boolean isConfigCondition() {
        return this.LA(1) == 21 && this.LA(2) == 22 && this.LA(3) == 15;
    }

    protected final boolean isXMLAttribute() {
        return this.LA(1) == 141 || this.LA(1) == 144 || this.LA(1) == 150 && this.hasEqualsAfterClose();
    }

    private final boolean hasEqualsAfterClose() {
        int i = 2;
        while (this.LA(i) != 151) {
            ++i;
        }
        return this.LA(i + 1) == 147;
    }

    protected void storeVariableDecorations(VariableNode decoratedNode, ContainerNode node, INamespaceDecorationNode namespace, List<ModifierNode> modList) {
        this.storeDecorations(decoratedNode, node, namespace, modList);
        this.storeEmbedDecoration(decoratedNode, decoratedNode.getMetaTags());
    }

    protected void storeEmbedDecoration(VariableNode variable, IMetaTagsNode metaTags) {
        if (!this.allowEmbeds) {
            return;
        }
        if (metaTags == null || !metaTags.hasTagByName("Embed")) {
            return;
        }
        if (variable.getAssignedValueNode() != null) {
            this.addProblem(new EmbedInitialValueProblem(variable));
            return;
        }
        String typeName = variable.getTypeName();
        if (!"Class".equals(typeName) && !"String".equals(typeName)) {
            this.addProblem(new EmbedUnsupportedTypeProblem(variable));
            return;
        }
        IMetaTagNode[] embedMetaTags = metaTags.getTagsByName("Embed");
        if (embedMetaTags.length > 1) {
            this.addProblem(new EmbedMultipleMetaTagsProblem(variable));
            return;
        }
        EmbedNode embedNode = new EmbedNode(this.getFilename(), embedMetaTags[0], this.fileNodeAccumulator);
        variable.setAssignedValue(null, embedNode);
    }

    protected void storeDecorations(BaseDefinitionNode decoratedNode, ContainerNode node, INamespaceDecorationNode namespace, List<ModifierNode> modList) {
        IASDocComment asDocComment;
        if (this.currentAttributes != null) {
            IMetaTagNode[] embedTags = this.currentAttributes.getTagsByName("Embed");
            assert (embedTags != null);
            if (embedTags.length > 0 && !(decoratedNode instanceof VariableNode) && !(decoratedNode instanceof ClassNode)) {
                for (IMetaTagNode embedTag : embedTags) {
                    this.addProblem(new EmbedOnlyOnClassesAndVarsProblem(embedTag));
                }
            }
            decoratedNode.setMetaTags(this.currentAttributes);
        }
        if (modList != null) {
            int size = modList.size();
            for (int i = 0; i < size; ++i) {
                ModifierNode modifierNode = modList.get(i);
                decoratedNode.addModifier(modifierNode);
            }
        }
        if (namespace != null) {
            decoratedNode.setNamespace(namespace);
        }
        if ((asDocComment = this.asDocDelegate.afterDefinition(decoratedNode)) != null) {
            decoratedNode.setASDocComment(asDocComment);
        }
        this.currentAttributes = null;
    }

    protected final boolean namespaceIsConfigNamespace(INamespaceDecorationNode node) {
        return node != null && node.getNamespaceDecorationKind() == INamespaceDecorationNode.NamespaceDecorationKind.CONFIG;
    }

    protected void logMultipleConfigNamespaceDecorationsError(NodeBase source) {
        MultipleConfigNamespaceDecorationsProblem problem = new MultipleConfigNamespaceDecorationsProblem(source);
        this.addProblem(problem);
    }

    protected void checkNamespaceDefinition(NamespaceNode ns) {
        if (this.configProcessor.isConfigNamespace(ns.getName())) {
            this.addProblem(new ShadowedConfigNamespaceProblem(ns, ns.getName()));
        }
    }

    protected final ExpressionNodeBase transformToNSAccessExpression(ExpressionNodeBase left, ASToken op, ExpressionNodeBase right) {
        ExpressionNodeBase result;
        this.checkForChainedNamespaceQualifierProblem(op, right);
        if (left instanceof FullNameNode) {
            QualifiedNamespaceExpressionNode qualifier = new QualifiedNamespaceExpressionNode((MemberAccessExpressionNode)((FullNameNode)left));
            result = new NamespaceAccessExpressionNode(qualifier, op, right);
        } else if (left instanceof MemberAccessExpressionNode) {
            IExpressionNode maRight = ((MemberAccessExpressionNode)left).getRightOperandNode();
            if (maRight instanceof NamespaceIdentifierNode) {
                ((MemberAccessExpressionNode)left).setRightOperandNode(new NamespaceAccessExpressionNode((NamespaceIdentifierNode)maRight, op, right));
            } else if (maRight instanceof IdentifierNode) {
                ((MemberAccessExpressionNode)left).setRightOperandNode(new NamespaceAccessExpressionNode(new NamespaceIdentifierNode((IdentifierNode)maRight), op, right));
            } else if (maRight instanceof UnaryOperatorNodeBase && ((UnaryOperatorNodeBase)maRight).getOperator() == IOperatorNode.OperatorType.AT) {
                ((UnaryOperatorNodeBase)maRight).setExpression(new NamespaceAccessExpressionNode((IdentifierNode)((UnaryOperatorNodeBase)maRight).getOperandNode(), op, right));
            }
            if (maRight.hasParenthesis() && maRight instanceof MemberAccessExpressionNode) {
                ((MemberAccessExpressionNode)left).setRightOperandNode(new NamespaceAccessExpressionNode(new QualifiedNamespaceExpressionNode((MemberAccessExpressionNode)maRight), op, right));
            }
            result = left;
        } else if (left instanceof NamespaceIdentifierNode && right instanceof IdentifierNode && ((NamespaceIdentifierNode)left).getNamespaceDecorationKind() == INamespaceDecorationNode.NamespaceDecorationKind.CONFIG) {
            ConfigExpressionNode cn = new ConfigExpressionNode((NamespaceIdentifierNode)left, op, (IdentifierNode)right);
            result = this.evaluateConstNodeExpression(cn);
        } else {
            result = new NamespaceAccessExpressionNode(left, op, right);
        }
        return result;
    }

    protected final void checkForChainedNamespaceQualifierProblem(ASToken nsAccessOp, ExpressionNodeBase right) {
        if (nsAccessOp != null && right != null && right.getNodeID() == ASTNodeID.NamespaceIdentifierID) {
            UnexpectedTokenProblem problem = new UnexpectedTokenProblem(nsAccessOp, IASToken.ASTokenKind.IDENTIFIER);
            this.addProblem(problem);
        }
    }

    protected void setOffsetsOfEmptyBlock(IASToken blockToken, BlockNode block) {
        if (blockToken.isImplicit()) {
            block.span((Token)blockToken);
        } else {
            block.span(blockToken.getStart() + 1, blockToken.getStart() + 1, blockToken.getLine(), blockToken.getColumn());
        }
    }

    protected final void disableSemicolonInsertion() {
        this.buffer.setEnableSemicolonInsertion(false);
    }

    protected final void enableSemicolonInsertion() {
        this.buffer.setEnableSemicolonInsertion(true);
    }

    protected final void consumeParsingError(RecognitionException ex, int endToken) {
        ICompilerProblem syntaxProblem;
        ASToken current = this.buffer.lookAheadSkipInsertedSemicolon();
        if (ex instanceof MismatchedTokenException) {
            IASToken.ASTokenKind expectedKind = ASToken.typeToKind(((MismatchedTokenException)ex).expecting);
            syntaxProblem = this.unexpectedTokenProblem(current, expectedKind);
        } else if (endToken != -1) {
            IASToken.ASTokenKind expectedKind = ASToken.typeToKind(endToken);
            syntaxProblem = this.unexpectedTokenProblem(current, expectedKind);
        } else {
            ASToken errorToken = current.getType() == 1 ? this.buffer.previous() : current;
            syntaxProblem = new SyntaxProblem(errorToken);
        }
        this.addProblem(syntaxProblem);
    }

    protected final void consumeParsingError(RecognitionException ex) {
        this.consumeParsingError(ex, -1);
    }

    protected IdentifierNode expectingIdentifier(NoViableAltException ex) {
        MismatchedTokenException mismatchedTokenException = new MismatchedTokenException(new String[]{"IDENTIFIER"}, ex.token, 15, false, ex.fileName);
        return this.handleMissingIdentifier((RecognitionException)mismatchedTokenException);
    }

    protected IdentifierNode handleMissingIdentifier(RecognitionException ex) {
        IdentifierNode node;
        this.consumeParsingError(ex);
        ASToken current = this.buffer.previous();
        ASToken la2 = this.LT(2);
        ASToken la1 = this.LT(1);
        if (current.getType() == 40) {
            node = IdentifierNode.createEmptyIdentifierNodeAfterToken(current);
        } else if (la2.getType() == 15 && la2.getLine() == current.getLine()) {
            ASToken token = this.LT(2);
            node = new IdentifierNode(token.getText(), token);
            this.consume();
            this.consume();
        } else if (la1.isKeywordOrContextualReservedWord() && la1.getLine() == current.getLine()) {
            node = new IdentifierNode(la1.getText(), la1);
            this.consume();
        } else {
            node = IdentifierNode.createEmptyIdentifierNodeAfterToken(current);
        }
        return node;
    }

    protected ExpressionNodeBase handleMissingIdentifier(RecognitionException ex, ExpressionNodeBase n) {
        if (n instanceof FullNameNode) {
            IdentifierNode temp = this.handleMissingIdentifier(ex);
            if (temp != null) {
                ((FullNameNode)n).setRightOperandNode(temp);
            }
            return n;
        }
        this.handleParsingError(ex);
        return n;
    }

    protected final void logSyntaxError(ASToken badToken) {
        this.addProblem(new SyntaxProblem(badToken));
    }

    protected boolean handleParsingError(RecognitionException ex, int endToken) {
        ASToken current = this.buffer.LT(1);
        ASToken errorToken = current.getType() == 54 ? this.buffer.lookAheadSkipInsertedSemicolon() : current;
        boolean result = this.handleParsingError(ex, current, errorToken, endToken);
        this.errorToken = errorToken;
        return result;
    }

    protected boolean handleParsingError(RecognitionException ex) {
        return this.handleParsingError(ex, -1);
    }

    private boolean handleParsingError(RecognitionException ex, ASToken current, ASToken errorToken, int endToken) {
        if (current.getType() == 28) {
            this.consume();
            return true;
        }
        if (errorToken != this.errorToken) {
            this.consumeParsingError(ex, endToken);
        }
        return this.recoverFromRecognitionException(ex, current);
    }

    private boolean recoverFromRecognitionException(RecognitionException ex, ASToken nextToken) {
        if (nextToken.getType() == 1) {
            return false;
        }
        if (nextToken == this.errorToken) {
            this.consume();
            return true;
        }
        if (nextToken.isKeywordOrContextualReservedWord()) {
            if (ex instanceof MismatchedTokenException) {
                switch (((MismatchedTokenException)ex).expecting) {
                    case 46: 
                    case 126: {
                        return true;
                    }
                }
            }
            nextToken.setType(15);
            return true;
        }
        if (nextToken.isOpenToken()) {
            this.buffer.insertSemicolon(false);
        } else if (ASToken.isCloseToken(nextToken.getType())) {
            this.buffer.insertSemicolon(true);
        } else if (nextToken.getType() == 54) {
            this.consume();
        } else {
            this.buffer.insertSemicolon(true);
        }
        return true;
    }

    protected void endContainerAtError(RecognitionException ex, NodeBase node) {
        Token endToken = null;
        if (ex instanceof NoViableAltException) {
            endToken = ((NoViableAltException)((Object)ex)).token;
        } else if (ex instanceof MismatchedTokenException) {
            endToken = ((MismatchedTokenException)ex).token;
        }
        if (endToken == null || endToken.getType() == 1) {
            endToken = this.buffer.previous();
        }
        node.endBefore(endToken);
    }

    public final void consume() {
        this.buffer.consume();
    }

    protected boolean matchOptionalSemicolon() {
        ICompilerProblem lastError;
        boolean success = this.buffer.matchOptionalSemicolon();
        if (!(success || (lastError = (ICompilerProblem)Iterables.getLast(this.errors, null)) != null && lastError.getLine() >= this.buffer.previous().getLine())) {
            this.addProblem(new CanNotInsertSemicolonProblem(this.buffer.LT(1)));
        }
        return success;
    }

    protected void reportFunctionBodyMissingLeftBraceProblem() {
        ICompilerProblem lastError = (ICompilerProblem)Iterables.getLast(this.errors, null);
        if (lastError == null || lastError.getLine() < this.buffer.previous().getLine()) {
            MissingLeftBraceBeforeFunctionBodyProblem problem = new MissingLeftBraceBeforeFunctionBodyProblem(this.buffer.LT(1));
            this.addProblem(problem);
        }
    }

    protected void consumeUntilKeywordOrIdentifier(int exitCondition) {
        this.consumeUntilKeywordOr(15, 36, 28, exitCondition);
    }

    protected void consumeUntilKeywordOr(Integer ... types) {
        ImmutableSet stopSet = new ImmutableSet.Builder().add((Object[])types).add((Object)1).build();
        while (!stopSet.contains((Object)this.buffer.LA(1)) && !this.LT(1).isKeywordOrContextualReservedWord()) {
            this.consume();
        }
    }

    public final void match(int t) throws MismatchedTokenException, TokenStreamException {
        int la = this.LA(1);
        if (la != t) {
            this.exceptionPool.expecting = t;
            this.exceptionPool.token = this.LT(1);
            throw this.exceptionPool;
        }
        if (this.inputState.guessing == 0) {
            switch (la) {
                case 19: {
                    ++this.blockDepth;
                    break;
                }
                case 20: {
                    this.blockDepth = this.blockDepth > 0 ? this.blockDepth - 1 : 0;
                    break;
                }
            }
        }
        this.consume();
    }

    public final int LA(int i) {
        return this.buffer.LA(i);
    }

    public final ASToken LT(int i) {
        return this.buffer.LT(i);
    }

    public final int mark() {
        return this.buffer.mark();
    }

    public final void rewind(int pos) {
        this.buffer.rewind(pos);
    }

    private final int precedence(ASToken op) {
        if (this.expressionMode == ExpressionMode.noIn && op.getType() == 58) {
            return 0;
        }
        Integer precedence = (Integer)BINARY_PRECEDENCE.get((Object)op.getType());
        if (precedence != null) {
            return precedence;
        }
        return 0;
    }

    protected final ExpressionNodeBase precedenceParseExpression(int prec) throws RecognitionException, TokenStreamException {
        int p1;
        ExpressionNodeBase result = this.unaryExpr();
        ASToken op = this.LT(1);
        int p2 = p1 = this.precedence(op);
        while (p1 >= prec) {
            while (p2 == p1) {
                this.consume();
                ExpressionNodeBase t = this.precedenceParseExpression(p1 + 1);
                result = BinaryOperatorNodeBase.create(op, result, t);
                op = this.LT(1);
                p2 = this.precedence(op);
            }
            --p1;
        }
        return result;
    }

    abstract ExpressionNodeBase unaryExpr() throws RecognitionException, TokenStreamException;

    protected void foundExtraCharacterAfterEndOfProgram(ASToken token) {
        if (!this.extraCharacterAfterEndOfProgramProblemLogged && this.errors.isEmpty()) {
            this.extraCharacterAfterEndOfProgramProblemLogged = true;
            this.addProblem(new ExtraCharactersAfterEndOfProgramProblem(token));
        }
    }

    protected boolean afterRestrictedToken(ASToken current) {
        assert (RESTRICTED_TOKEN_TYPES.contains((Object)current.getType())) : "Unexpected restricted token type: " + current.getTypeString();
        ASToken nextToken = this.LT(1);
        if (nextToken != null && nextToken.getLine() > current.getLine() && nextToken.getType() != 54) {
            return this.buffer.insertSemicolon(true);
        }
        return false;
    }

    protected boolean beforeRestrictedToken(ASToken nextToken) {
        ASToken current = this.buffer.previous();
        assert (nextToken != null) : "token can't be null";
        assert (nextToken.getType() == 112 || nextToken.getType() == 113) : "Unexpected restricted token type: " + nextToken.getTypeString();
        if (nextToken != null && nextToken.getLine() > current.getLine() && nextToken.getType() != 54) {
            return this.buffer.insertSemicolon(false);
        }
        return false;
    }

    protected final ICompilerProblem unexpectedTokenProblem(ASToken site, IASToken.ASTokenKind expectedKind) {
        if (site.getType() == 1) {
            return new UnexpectedEOFProblem(this.buffer.previous(), expectedKind);
        }
        return new UnexpectedTokenProblem(site, expectedKind);
    }

    protected void verifyNamespaceAttributes(List<INamespaceDecorationNode> namespaceAttributes) {
        SyntaxProblem problem;
        if (namespaceAttributes.size() < 2) {
            return;
        }
        ArrayList<INamespaceDecorationNode> reservedNamespaceAttributes = new ArrayList<INamespaceDecorationNode>();
        ArrayList<INamespaceDecorationNode> userDefinedNamespaceAttributes = new ArrayList<INamespaceDecorationNode>();
        for (INamespaceDecorationNode namespaceAttribute : namespaceAttributes) {
            String namespaceName = namespaceAttribute.getName();
            if (RESERVED_NAMESPACE_ATTRIBUTES.contains((Object)namespaceName)) {
                reservedNamespaceAttributes.add(namespaceAttribute);
                continue;
            }
            userDefinedNamespaceAttributes.add(namespaceAttribute);
        }
        if (reservedNamespaceAttributes.size() > 1) {
            problem = new MultipleReservedNamespaceAttributesProblem((INamespaceDecorationNode)reservedNamespaceAttributes.get(0));
            this.addProblem(problem);
        }
        if (userDefinedNamespaceAttributes.size() > 1) {
            problem = new MultipleNamespaceAttributesProblem((INamespaceDecorationNode)userDefinedNamespaceAttributes.get(0));
            this.addProblem(problem);
        }
        if (!userDefinedNamespaceAttributes.isEmpty() && !reservedNamespaceAttributes.isEmpty()) {
            problem = new NamespaceAttributeNotAllowedProblem((INamespaceDecorationNode)userDefinedNamespaceAttributes.get(0));
            this.addProblem(problem);
        }
    }

    protected final void recoverFromExpressionStatementMissingSemicolon(ExpressionNodeBase e) {
        ASToken lt = this.buffer.LT(1);
        SyntaxProblem problem = null;
        if (e instanceof IdentifierNode) {
            String name = ((IdentifierNode)e).getName();
            if (CONTEXTUAL_RESERVED_KEYWORD_MODIFIERS.contains((Object)name)) {
                problem = lt.getType() == 38 ? new AttributesNotAllowedOnPackageDefinitionProblem(lt) : new ExpectDefinitionKeywordAfterAttributeProblem(name, lt);
            }
        } else if (lt.getType() == 24) {
            problem = new InvalidLabelProblem(lt);
            this.consume();
        }
        if (problem != null) {
            ICompilerProblem lastError = (ICompilerProblem)Iterables.getLast(this.errors);
            this.errors.remove(lastError);
            this.errors.add(problem);
        }
    }

    protected void trapInvalidSubstatement(ASToken offendingNSToken) {
        InvalidAttributeProblem problem = new InvalidAttributeProblem(offendingNSToken);
        this.addProblem(problem);
    }

    protected void trapInvalidNamespaceAttribute(ASToken offendingNSToken) {
        NamespaceAttributeNotAllowedProblem problem = new NamespaceAttributeNotAllowedProblem(offendingNSToken);
        this.addProblem(problem);
    }

    protected boolean evaluateConfigurationVariable(IdentifierNode configNamespace, ASToken opToken, IdentifierNode configVar) {
        ConfigExpressionNode configExpression = new ConfigExpressionNode(configNamespace, opToken, configVar);
        Object value = this.configProcessor.evaluateConstNodeExpressionToJavaObject(configExpression);
        return value == null ? false : ECMASupport.toBoolean(value);
    }

    protected final void reportUnexpectedTokenProblem(ASToken token) {
        this.addProblem(new SyntaxProblem(token));
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void skipFunctionBody(FunctionNode functionNode, ASToken openT) {
        assert (functionNode != null) : "Function node can't be null.";
        assert (openT != null && openT.getType() == 19) : "Expected '{' token";
        if (this.deferFunctionBody != DeferFunctionBody.ENABLED || functionNode.getParent() instanceof FunctionObjectNode) {
            return;
        }
        if (this.LA(1) == 20 || this.LA(1) == 1) {
            return;
        }
        boolean functionBodyHasInclude = false;
        ASToken prevToken = null;
        int depth = 0;
        block5: while (depth > 0 || this.LA(1) != 20) {
            prevToken = this.LT(1);
            if (!this.getSourceFilePath().equals(this.LT(1).getSourcePath())) {
                functionBodyHasInclude = true;
            }
            switch (prevToken.getType()) {
                case 19: {
                    ++depth;
                    break;
                }
                case 20: {
                    --depth;
                    break;
                }
                case 1: {
                    break block5;
                }
            }
            this.consume();
        }
        assert (this.LA(1) == 20 || this.LA(1) == 1) : "Loop should stop before the '}' of the function body or 'eof'.";
        assert (prevToken != null) : "Function body must have at least one token if we reached here.";
        StringBuilder functionBodyText = this.tryGetFunctionBodyText(openT, functionBodyHasInclude, prevToken);
        functionNode.setFunctionBodyInfo(openT, prevToken, this.configProcessor, functionBodyText);
        this.fileNodeAccumulator.addDeferredFunctionNode(functionNode);
    }

    private StringBuilder tryGetFunctionBodyText(ASToken openT, boolean functionBodyHasInclude, ASToken lastToken) {
        StringBuilder functionBodyText;
        if (this.secondaryReader != null && !functionBodyHasInclude) {
            functionBodyText = new StringBuilder();
            try {
                int readerSkip = openT.getLocalEnd() - this.secondaryReaderPosition;
                assert (readerSkip >= 0) : "Invalid position";
                long skip = this.secondaryReader.skip(readerSkip);
                assert (skip == (long)readerSkip) : "The buffer didn't skip full length.";
                ASToken endToken = this.LA(1) == 20 ? this.LT(1) : lastToken;
                for (int position = openT.getLocalEnd(); position < endToken.getLocalEnd(); ++position) {
                    functionBodyText.append((char)this.secondaryReader.read());
                }
                this.secondaryReaderPosition = endToken.getLocalEnd();
            }
            catch (IOException e) {
                String path = openT.getSourcePath();
                CompilerProblem problem = path == null ? new InternalCompilerProblem(e) : new InternalCompilerProblem2(path, e, SUB_SYSTEM);
                this.errors.add(problem);
            }
        } else {
            functionBodyText = null;
        }
        return functionBodyText;
    }

    protected final void enterPackage(ASToken keywordPackage) {
        if (this.packageDepth > 0) {
            NestedPackageProblem problem = new NestedPackageProblem(keywordPackage);
            this.addProblem(problem);
        } else if (!this.isGlobalContext()) {
            SyntaxProblem problem = new SyntaxProblem(keywordPackage);
            this.addProblem(problem);
        }
        ++this.packageDepth;
    }

    protected final void enterTypeApplication(ExpressionNodeBase collectionExpression) {
        if (collectionExpression == null || collectionExpression.getNodeID() == ASTNodeID.IdentifierID || collectionExpression.getNodeID() == ASTNodeID.FunctionCallID || collectionExpression.getNodeID() == ASTNodeID.TypedExpressionID || collectionExpression instanceof MemberAccessExpressionNode) {
            return;
        }
        InvalidTypeProblem problem = new InvalidTypeProblem(this.LT(1), collectionExpression.getNodeID().getParaphrase());
        this.addProblem(problem);
    }

    protected final void enterGroup() {
        ++this.groupDepth;
    }

    protected final void leaveGroup() {
        --this.groupDepth;
    }

    protected final void enterClassDefinition(ASToken keywordClass) {
        if (!this.isGlobalContext()) {
            this.addProblem(new NestedClassProblem(keywordClass));
        }
    }

    protected final void enterInterfaceDefinition(ASToken keywordInterface) {
        if (!this.isGlobalContext()) {
            this.addProblem(new NestedInterfaceProblem(keywordInterface));
        }
    }

    protected final void leavePackage() {
        assert (this.blockDepth >= 0) : "package depth should never be negative";
        this.packageDepth = this.packageDepth > 0 ? this.packageDepth - 1 : 0;
    }

    protected final boolean isGlobalContext() {
        assert (this.blockDepth >= 0) : "block depth should never be negative";
        assert (this.packageDepth <= this.blockDepth) : "package depth can't be greater than block depth";
        assert (this.groupDepth <= this.blockDepth) : "group depth can't be greater than block depth";
        assert (this.packageDepth + this.groupDepth <= this.blockDepth) : "invalid state of block depth";
        return this.blockDepth - this.packageDepth - this.groupDepth == 0;
    }

    protected final boolean isFunctionClosure() {
        return this.LA(1) == 44 && (this.LA(2) == 45 || this.buffer.previous().canPreceedAnonymousFunction());
    }

    protected final void afterInnerSubstatement() {
        int lastTokenEnd;
        int problemEnd;
        ICompilerProblem lastError = (ICompilerProblem)Iterables.getLast(this.errors, null);
        if (lastError != null && lastError instanceof CanNotInsertSemicolonProblem && (problemEnd = ((CanNotInsertSemicolonProblem)lastError).getEnd()) == (lastTokenEnd = this.LT(1).getLocalEnd())) {
            this.errors.remove(lastError);
        }
    }

    protected final void recoverFromMetadataTag(ContainerNode container, ArrayLiteralNode arrayLiteralNode) {
        if (container == null || arrayLiteralNode == null) {
            return;
        }
        ContainerNode contents = arrayLiteralNode.getContentsNode();
        for (int i = 0; i < contents.getChildCount(); ++i) {
            IASNode child = contents.getChild(i);
            if (child.getNodeID() == ASTNodeID.FunctionObjectID) {
                container.addChild(((FunctionObjectNode)child).getFunctionNode());
                continue;
            }
            container.addChild((NodeBase)child);
        }
        ASToken lookback = this.buffer.previous();
        if (lookback != null && lookback.getType() == 15 && lookback.getText().equals("var")) {
            lookback.setType(50);
            this.buffer.rewind(this.buffer.mark() - 1);
        }
    }

    protected final boolean isIncompleteMetadataTagOnDefinition() {
        if (this.LA(1) == 37 && this.LT(1).getLine() > this.buffer.previous().getLine() && this.LT(2).getLine() > this.LT(1).getLine()) {
            switch (this.LA(2)) {
                case 23: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 39: 
                case 42: 
                case 50: {
                    return true;
                }
            }
        }
        return false;
    }

    protected final void xmlTagOpen(ASToken token) {
        assert (token.getType() == 138) : "unexpected token type: " + token;
        assert (token.getText().startsWith("<")) : "unexpected token text: " + token;
        String tagName = token.getText().substring(1);
        this.xmlTags.push(new XMLTagInfo(tagName, token));
    }

    protected final void xmlTagOpenBinding(ASToken token) {
        assert (token.getType() == 140) : "unexpected token " + token;
        assert (token.getText().equals("<")) : "unexpected token text: " + token;
        this.xmlTags.push(new XMLTagInfo(TAG_NAME_BINDING, token));
    }

    protected final void xmlTagClose(ASToken token) {
        assert (token.getType() == 139) : "unexpected token " + token;
        assert (token.getText().startsWith("</")) : "unexpected token text: " + token;
        String tagName = token.getText().substring(2);
        if (!this.xmlTags.isEmpty()) {
            XMLTagInfo openTag = this.xmlTags.pop();
            if (TAG_NAME_BINDING.equals(openTag.name) || tagName.isEmpty()) {
                return;
            }
            if (openTag.name.equals(tagName)) {
                return;
            }
            this.addProblem(new XMLOpenCloseTagNotMatchProblem(token));
            return;
        }
        this.addProblem(new SyntaxProblem(token));
    }

    protected final void xmlEmptyTagEnd(ASToken token) {
        assert (token.getType() == 143) : "unexpected token " + token;
        assert (token.getText().endsWith("/>")) : "unexpected token text: " + token;
        if (!this.xmlTags.isEmpty()) {
            this.xmlTags.pop();
        }
    }

    protected final void enterXMLLiteral() {
        assert (this.xmlTags.isEmpty()) : "Invalid state: must clear tag stack after each XML literal.";
        this.xmlTags.clear();
    }

    protected final void leaveXMLLiteral() {
        while (!this.xmlTags.isEmpty()) {
            XMLTagInfo openTag = this.xmlTags.pop();
            XMLOpenCloseTagNotMatchProblem problem = new XMLOpenCloseTagNotMatchProblem(openTag.location);
            this.addProblem(problem);
        }
    }

    protected final boolean isNextTokenPublicNamespace() {
        ASToken token = this.LT(1);
        return 23 == token.getType() && "public".equals(token.getText());
    }

    protected final boolean isDefinitionEnabled(ContainerNode containerNode) {
        IASNode lastChild;
        assert (containerNode != null) : "Container node can't be null.";
        int childCount = containerNode.getChildCount();
        if (childCount > 0 && (lastChild = containerNode.getChild(childCount - 1)).getNodeID() == ASTNodeID.LiteralBooleanID) {
            boolean eval = Boolean.parseBoolean(((LiteralNode)lastChild).getValue());
            containerNode.removeItem((NodeBase)lastChild);
            containerNode.setRemovedConditionalCompileNode(true);
            return eval;
        }
        return true;
    }

    public final void file(ContainerNode c) throws RecognitionException, TokenStreamException {
        while (this.LA(1) != 1) {
            this.fileLevelDirectives(c);
            if (this.LA(1) == 1) continue;
            this.foundExtraCharacterAfterEndOfProgram(this.LT(1));
            this.consume();
        }
    }

    public final boolean isParsingProjectConfigVariables() {
        return this.parsingProjectConfigVariables;
    }

    private static final class XMLTagInfo {
        final String name;
        final ASToken location;

        XMLTagInfo(String name, ASToken location) {
            this.name = name;
            this.location = location;
        }
    }

    protected static enum ExpressionMode {
        normal,
        noIn,
        e4x;

    }
}

