/*
 * Decompiled with CFR 0.152.
 */
package flash.swf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class RandomAccessBuffer
extends ByteArrayOutputStream {
    protected int pos = 0;

    public RandomAccessBuffer() {
        super(1024);
    }

    public RandomAccessBuffer(int n) {
        super(n);
    }

    public final int getPos() {
        return this.pos;
    }

    public final void setPos(int n) {
        this.pos = n;
    }

    @Override
    public final synchronized void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public final synchronized void write(byte[] byArray, int n, int n2) {
        if (this.pos > this.count) {
            byte[] byArray2 = new byte[this.pos - this.count];
            super.write(byArray2, 0, byArray2.length);
            this.pos = this.count;
        } else if (this.pos < this.count) {
            int n3 = Math.min(this.count - this.pos, n2);
            System.arraycopy(byArray, n, this.buf, this.pos, n3);
            this.pos += n3;
            n += n3;
            n2 -= n3;
        }
        super.write(byArray, n, n2);
        this.pos += n2;
    }

    public final synchronized void readFully(byte[] byArray) {
        int n = byArray.length;
        if (this.pos + n > this.count) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(this.buf, this.pos, byArray, 0, n);
        this.pos += n;
    }

    @Override
    public final synchronized void write(int n) {
        if (this.count > this.pos) {
            this.buf[this.pos++] = (byte)n;
        } else {
            super.write(n);
            ++this.pos;
        }
    }

    @Override
    public synchronized void reset() {
        super.reset();
        this.pos = 0;
    }

    @Override
    public synchronized byte[] toByteArray() {
        this.count = this.pos;
        return super.toByteArray();
    }

    @Override
    public synchronized void writeTo(OutputStream outputStream) throws IOException {
        this.count = this.pos;
        super.writeTo(outputStream);
    }

    public byte[] getByteArray() {
        return this.buf;
    }
}

