/*
 * Decompiled with CFR 0.152.
 */
package flash.swf;

import flash.swf.Action;
import flash.swf.Dictionary;
import flash.swf.Header;
import flash.swf.MFUCache;
import flash.swf.Tag;
import flash.swf.TagDecoder;
import flash.swf.TagHandler;
import flash.swf.actions.ConstantPool;
import flash.swf.actions.DefineFunction;
import flash.swf.actions.Push;
import flash.swf.actions.StoreRegister;
import flash.swf.debug.DebugModule;
import flash.swf.debug.LineRecord;
import flash.swf.tags.DefineButton;
import flash.swf.tags.DefineSprite;
import flash.swf.tags.DefineTag;
import flash.swf.tags.DoAction;
import flash.swf.tags.DoInitAction;
import flash.swf.tags.PlaceObject;
import flash.swf.types.ActionList;
import flash.swf.types.ButtonCondAction;
import flash.swf.types.ClipActionRecord;
import flash.swf.types.ClipActions;
import flash.swf.types.TagList;
import flash.util.IntMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public final class MovieMetaData
extends TagHandler {
    private Dictionary dict;
    private Header header;
    public IntMap actions;
    public IntMap modules;
    public IntMap functionNames;
    public IntMap functionSizes;
    public IntMap functionLines;
    public IntMap preciseLines;
    public Map<String, DebugModule> mxml;
    public List<Integer> skipOffsets;
    private String className;
    private String[] pool;
    private static final int[] regClassCall9;
    private static final int[] regClassCall10;
    private static Integer[] codes;
    private static Object dummy;
    private static Object[] registers;

    public MovieMetaData(byte[] byArray, byte[] byArray2) {
        this(new ByteArrayInputStream(byArray), new ByteArrayInputStream(byArray2));
    }

    public MovieMetaData(InputStream inputStream, InputStream inputStream2) {
        try {
            this.init();
            TagDecoder tagDecoder = new TagDecoder(inputStream, inputStream2);
            this.parse(tagDecoder);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public MovieMetaData(String string) {
        try {
            this.init();
            URL uRL = new URL(string);
            InputStream inputStream = uRL.openStream();
            TagDecoder tagDecoder = new TagDecoder(inputStream, uRL);
            this.parse(tagDecoder);
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void init() {
        this.actions = new IntMap();
        this.modules = new IntMap();
        this.functionNames = new IntMap();
        this.functionSizes = new IntMap();
        this.functionLines = new IntMap();
        this.preciseLines = new IntMap();
        this.mxml = new HashMap<String, DebugModule>();
        this.pool = null;
        this.skipOffsets = new ArrayList<Integer>();
    }

    private void parse(TagDecoder tagDecoder) throws IOException {
        tagDecoder.setKeepOffsets(true);
        tagDecoder.parse(this);
        Collections.sort(this.skipOffsets);
        this.className = null;
    }

    public DebugModule getDebugModule(int n) {
        DebugModule debugModule = (DebugModule)this.modules.get(n);
        if (debugModule == null) {
            return null;
        }
        return debugModule;
    }

    public String getFunctionName(int n) {
        return (String)this.functionNames.get(n);
    }

    public Iterator getFunctionLines() {
        return this.preciseLines.iterator();
    }

    public Integer getOpCode(int n) {
        return (Integer)this.actions.get(n);
    }

    protected Integer getFunctionLineNumber(int n) {
        return (Integer)this.functionLines.get(n);
    }

    protected boolean isFunction(int n) {
        String string = this.getFunctionName(n);
        return string != null;
    }

    @Override
    public void setDecoderDictionary(Dictionary dictionary) {
        this.dict = dictionary;
    }

    @Override
    public void header(Header header) {
        this.header = header;
    }

    @Override
    public void defineButton(DefineButton defineButton) {
        String[] stringArray = this.pool;
        this.collectActions(defineButton.condActions[0].actionList);
        this.pool = stringArray;
    }

    @Override
    public void doAction(DoAction doAction) {
        String[] stringArray = this.pool;
        this.collectActions(doAction.actionList);
        this.pool = stringArray;
    }

    @Override
    public void placeObject2(PlaceObject placeObject) {
        this.collectClipActions(placeObject.clipActions);
    }

    @Override
    public void placeObject3(PlaceObject placeObject) {
        this.collectClipActions(placeObject.clipActions);
    }

    @Override
    public void defineButton2(DefineButton defineButton) {
        this.collectCondActions(defineButton.condActions);
    }

    @Override
    public void defineSprite(DefineSprite defineSprite) {
        this.collectSpriteActions(defineSprite.tagList);
    }

    @Override
    public void doInitAction(DoInitAction doInitAction) {
        Object object;
        if (this.header.version > 6 && doInitAction.sprite != null) {
            object = this.idRef(doInitAction.sprite);
            String string = this.className = object != null && ((String)object).startsWith("__Packages") ? ((String)object).substring(11) : null;
            if (MovieMetaData.isRegisterClass(doInitAction.actionList)) {
                DebugModule debugModule = new DebugModule();
                debugModule.name = "<" + (String)object + ".2>";
                debugModule.setText("Object.registerClass(" + (String)object + ", " + (String)object + ");");
                debugModule.bitmap = 1;
                LineRecord lineRecord = new LineRecord(1, debugModule);
                int n = doInitAction.actionList.getOffset(0);
                debugModule.addOffset(lineRecord, n);
                doInitAction.actionList.insert(n, lineRecord);
                this.modules.put((int)(Math.random() * 2.147483647E9), debugModule);
            }
        }
        object = this.pool;
        this.collectActions(doInitAction.actionList);
        this.pool = object;
        this.className = null;
    }

    public static final boolean isRegisterClass(ActionList actionList) {
        if (!MovieMetaData.hasLineRecord(actionList)) {
            int[] nArray;
            if (actionList.size() == 9) {
                nArray = regClassCall9;
            } else if (actionList.size() == 10) {
                nArray = regClassCall10;
            } else {
                return false;
            }
            for (int i = 0; i < nArray.length; ++i) {
                if (actionList.getAction((int)i).code == nArray[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    String idRef(DefineTag defineTag) {
        return MovieMetaData.idRef(defineTag, this.dict);
    }

    public static String idRef(DefineTag defineTag, Dictionary dictionary) {
        if (defineTag == null) {
            return "-1";
        }
        if (defineTag.name == null) {
            return String.valueOf(dictionary.getId(defineTag));
        }
        return defineTag.name;
    }

    private static final boolean hasLineRecord(ActionList actionList) {
        if (actionList == null || actionList.size() == 0) {
            return true;
        }
        boolean bl = false;
        block4: for (int i = 0; i < actionList.size() && !bl; ++i) {
            Action action = actionList.getAction(i);
            switch (action.code) {
                case 142: 
                case 155: {
                    bl = bl || MovieMetaData.hasLineRecord(((DefineFunction)action).actionList);
                    continue block4;
                }
                case 257: {
                    bl = true;
                }
            }
        }
        return bl;
    }

    private void collectSpriteActions(TagList tagList) {
        int n = tagList.tags.size();
        block8: for (int i = 0; i < n; ++i) {
            Tag tag = tagList.tags.get(i);
            switch (tag.code) {
                case 12: {
                    String[] stringArray = this.pool;
                    this.collectActions(((DoAction)tag).actionList);
                    this.pool = stringArray;
                    continue block8;
                }
                case 34: {
                    this.collectCondActions(((DefineButton)tag).condActions);
                    continue block8;
                }
                case 7: {
                    String[] stringArray = this.pool;
                    this.collectActions(((DefineButton)tag).condActions[0].actionList);
                    this.pool = stringArray;
                    continue block8;
                }
                case 59: {
                    String[] stringArray = this.pool;
                    this.collectActions(((DoInitAction)tag).actionList);
                    this.pool = stringArray;
                    continue block8;
                }
                case 39: {
                    this.collectSpriteActions(((DefineSprite)tag).tagList);
                    continue block8;
                }
                case 26: {
                    this.collectClipActions(((PlaceObject)tag).clipActions);
                }
            }
        }
    }

    private DebugModule findDebugModule(ActionList actionList) {
        MFUCache mFUCache = new MFUCache();
        for (int i = 0; i < actionList.size(); ++i) {
            Action action = actionList.getAction(i);
            DebugModule debugModule = null;
            switch (action.code) {
                case 142: 
                case 155: {
                    debugModule = this.findDebugModule(((DefineFunction)action).actionList);
                    break;
                }
                case 257: {
                    if (((LineRecord)action).module == null) break;
                    debugModule = ((LineRecord)action).module;
                }
            }
            if (debugModule == null) continue;
            mFUCache.add(debugModule);
        }
        return mFUCache.topModule;
    }

    private void collectActions(ActionList actionList) {
        if (actionList == null) {
            return;
        }
        this.evalActions(actionList);
        DebugModule debugModule = this.findDebugModule(actionList);
        String string = null;
        for (int i = 0; i < actionList.size(); ++i) {
            Action action;
            int n = actionList.getOffset(i);
            Action action2 = actionList.getAction(i);
            if (string != null && string.length() != 0) {
                this.functionNames.put(n, string);
                string = null;
            }
            if (action2.code == 257) {
                action = (LineRecord)action2;
                if (action.module == null) continue;
                debugModule = action.module;
                if (!debugModule.name.endsWith(".mxml")) continue;
                this.mxml.put(debugModule.name, debugModule);
                continue;
            }
            if (action2.code >= 256) continue;
            this.actions.put(n, codes[action2.code]);
            this.modules.put(n, debugModule);
            switch (action2.code) {
                case 142: 
                case 155: {
                    action = (DefineFunction)action2;
                    Integer n2 = new Integer(((DefineFunction)action).codeSize);
                    if (((DefineFunction)action).actionList.size() == 0) {
                        string = ((DefineFunction)action).name;
                    } else {
                        int n3;
                        int n4;
                        Integer n5 = null;
                        for (n4 = 0; n4 < ((DefineFunction)action).actionList.size(); ++n4) {
                            n3 = ((DefineFunction)action).actionList.getOffset(n4);
                            Action action3 = ((DefineFunction)action).actionList.getAction(n4);
                            if (action3.code == 257) {
                                if (n5 == null) {
                                    n5 = new Integer(((LineRecord)action3).lineno);
                                }
                                this.preciseLines.put(n3, new Integer(((LineRecord)action3).lineno));
                            }
                            this.functionNames.put(n3, ((DefineFunction)action).name);
                            this.functionSizes.put(n3, n2);
                        }
                        for (n4 = 0; n4 < ((DefineFunction)action).actionList.size(); ++n4) {
                            n3 = ((DefineFunction)action).actionList.getOffset(n4);
                            this.functionLines.put(n3, n5);
                        }
                    }
                    this.collectActions(((DefineFunction)action).actionList);
                }
            }
        }
    }

    private void collectCondActions(ButtonCondAction[] buttonCondActionArray) {
        for (int i = 0; i < buttonCondActionArray.length; ++i) {
            this.collectActions(buttonCondActionArray[i].actionList);
        }
    }

    private void collectClipActions(ClipActions clipActions) {
        if (clipActions != null) {
            for (ClipActionRecord clipActionRecord : clipActions.clipActionRecords) {
                this.collectActions(clipActionRecord.actionList);
            }
        }
    }

    private static Object pop(Stack<Object> stack) {
        return stack.isEmpty() ? null : stack.pop();
    }

    private void evalActions(ActionList actionList) {
        try {
            MovieMetaData.walkActions(actionList, this.header.version, this.pool, this.className, this.skipOffsets);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void walkActions(ActionList actionList, int n, String[] stringArray, String string, List<Integer> list) {
        if (actionList == null) {
            return;
        }
        Stack<Object> stack = new Stack<Object>();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        block62: for (int i = 0; i < actionList.size(); ++i) {
            int n2 = actionList.getOffset(i);
            Action action = actionList.getAction(i);
            switch (action.code) {
                case 0: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 128: 
                case 129: 
                case 131: 
                case 138: 
                case 139: 
                case 140: {
                    continue block62;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 19: 
                case 33: 
                case 34: 
                case 41: 
                case 49: {
                    MovieMetaData.pop(stack);
                    continue block62;
                }
                case 18: 
                case 20: 
                case 24: 
                case 48: 
                case 50: 
                case 51: 
                case 54: 
                case 55: {
                    continue block62;
                }
                case 28: {
                    Object object = MovieMetaData.pop(stack);
                    if (hashMap.get(object) == null) {
                        stack.push(object);
                        continue block62;
                    }
                    stack.push(hashMap.get(object));
                    continue block62;
                }
                case 21: 
                case 53: {
                    MovieMetaData.pop(stack);
                    MovieMetaData.pop(stack);
                    continue block62;
                }
                case 150: {
                    Push push = (Push)action;
                    Object object = push.value;
                    int n3 = Push.getTypeCode(object);
                    switch (n3) {
                        case 0: {
                            stack.push(object);
                            continue block62;
                        }
                        case 2: {
                            stack.push("null");
                            continue block62;
                        }
                        case 3: {
                            stack.push("undefined");
                            continue block62;
                        }
                        case 4: {
                            stack.push(registers[((Byte)object).intValue() & 0xFF]);
                            continue block62;
                        }
                        case 8: 
                        case 9: {
                            stack.push(stringArray[((Number)object).intValue() & 0xFFFF]);
                            continue block62;
                        }
                        case 1: {
                            stack.push(object + "F");
                            continue block62;
                        }
                        case 5: 
                        case 6: 
                        case 7: {
                            stack.push(object);
                            continue block62;
                        }
                    }
                    stack.push("type" + n3);
                    continue block62;
                }
                case 157: {
                    MovieMetaData.pop(stack);
                    continue block62;
                }
                case 23: 
                case 32: 
                case 37: 
                case 38: 
                case 141: 
                case 158: 
                case 159: {
                    MovieMetaData.pop(stack);
                    continue block62;
                }
                case 40: 
                case 153: {
                    continue block62;
                }
                case 29: {
                    Object object = MovieMetaData.pop(stack);
                    Object object2 = MovieMetaData.pop(stack);
                    hashMap.put(object, object2);
                    continue block62;
                }
                case 154: {
                    MovieMetaData.pop(stack);
                    MovieMetaData.pop(stack);
                    continue block62;
                }
                case 35: 
                case 36: {
                    MovieMetaData.pop(stack);
                    MovieMetaData.pop(stack);
                    MovieMetaData.pop(stack);
                    continue block62;
                }
                case 39: {
                    MovieMetaData.pop(stack);
                    MovieMetaData.pop(stack);
                    Object object = MovieMetaData.pop(stack);
                    if (Integer.parseInt(object.toString()) == 0) continue block62;
                    MovieMetaData.pop(stack);
                    MovieMetaData.pop(stack);
                    MovieMetaData.pop(stack);
                    MovieMetaData.pop(stack);
                    continue block62;
                }
                case 52: {
                    stack.push(dummy);
                    continue block62;
                }
                case 58: {
                    MovieMetaData.pop(stack);
                    continue block62;
                }
                case 60: {
                    Object object2 = MovieMetaData.pop(stack);
                    Object object = MovieMetaData.pop(stack);
                    hashMap.put(object, object2);
                    continue block62;
                }
                case 142: 
                case 155: {
                    int n4;
                    Object object;
                    DefineFunction defineFunction = (DefineFunction)action;
                    if (n > 6 && string != null) {
                        if (defineFunction.name == null || defineFunction.name.length() == 0) {
                            int n5 = stack.size();
                            if (n5 != 0) {
                                object = stack.peek();
                                if (object == dummy) {
                                    defineFunction.name = "";
                                } else if (object != null) {
                                    defineFunction.name = object.toString();
                                }
                            }
                            stack.push(dummy);
                        }
                        if ("null".equals(defineFunction.name)) {
                            defineFunction.name = "";
                        }
                        if (defineFunction.name == null || defineFunction.name.length() == 0) continue block62;
                        if (!string.endsWith(defineFunction.name)) {
                            defineFunction.name = string + "." + defineFunction.name;
                            continue block62;
                        }
                        defineFunction.name = string + ".[constructor]";
                        continue block62;
                    }
                    if (defineFunction.name != null && defineFunction.name.length() != 0) continue block62;
                    StringBuilder stringBuilder = new StringBuilder();
                    int n6 = stack.size();
                    for (n4 = n6 - 1; n4 >= 0 && (object = stack.get(n4)) != dummy; --n4) {
                        if (n4 == n6 - 1) {
                            stringBuilder.append(object);
                            continue;
                        }
                        stringBuilder.insert(0, '.');
                        stringBuilder.insert(0, object);
                    }
                    defineFunction.name = stringBuilder.toString();
                    if (defineFunction.name != null && defineFunction.name.indexOf(".prototype.") == -1) {
                        defineFunction.name = "";
                    }
                    stack.push(dummy);
                    continue block62;
                }
                case 61: {
                    int n4;
                    Object object = MovieMetaData.pop(stack);
                    if (list != null && "profile".equals(object)) {
                        list.add(new Integer(n2 - 13));
                        list.add(new Integer(n2 - 5));
                        list.add(new Integer(n2));
                        list.add(new Integer(n2 + 1));
                    }
                    int n6 = ((Number)MovieMetaData.pop(stack)).intValue();
                    for (n4 = 0; n4 < n6; ++n4) {
                        MovieMetaData.pop(stack);
                    }
                    stack.push(dummy);
                    continue block62;
                }
                case 62: {
                    MovieMetaData.pop(stack);
                    continue block62;
                }
                case 63: {
                    continue block62;
                }
                case 64: {
                    MovieMetaData.pop(stack);
                    int n4 = ((Number)MovieMetaData.pop(stack)).intValue();
                    for (int j = 0; j < n4; ++j) {
                        MovieMetaData.pop(stack);
                    }
                    stack.push(dummy);
                    continue block62;
                }
                case 59: 
                case 65: 
                case 71: 
                case 72: {
                    MovieMetaData.pop(stack);
                    continue block62;
                }
                case 66: {
                    int n4 = ((Number)MovieMetaData.pop(stack)).intValue();
                    for (int j = 0; j < n4; ++j) {
                        MovieMetaData.pop(stack);
                    }
                    stack.push(dummy);
                    continue block62;
                }
                case 67: {
                    int n4 = ((Number)MovieMetaData.pop(stack)).intValue() * 2;
                    for (int j = 0; j < n4; ++j) {
                        MovieMetaData.pop(stack);
                    }
                    stack.push(dummy);
                    continue block62;
                }
                case 68: 
                case 69: 
                case 70: 
                case 74: 
                case 75: {
                    continue block62;
                }
                case 135: {
                    StoreRegister storeRegister = (StoreRegister)action;
                    MovieMetaData.registers[storeRegister.register] = stack.peek();
                    continue block62;
                }
                case 73: {
                    MovieMetaData.pop(stack);
                    continue block62;
                }
                case 76: {
                    stack.push(dummy);
                    continue block62;
                }
                case 77: {
                    continue block62;
                }
                case 78: {
                    Object object = MovieMetaData.pop(stack);
                    Object object3 = MovieMetaData.pop(stack);
                    if (stringArray != null) {
                        try {
                            stack.push(stringArray[Integer.parseInt(object3.toString())] + "." + stringArray[Integer.parseInt(object.toString())]);
                        }
                        catch (Exception exception) {
                            if (object == dummy || object3 == dummy) {
                                stack.push(dummy);
                                continue block62;
                            }
                            stack.push(object3 + "." + object);
                        }
                        continue block62;
                    }
                    stack.push(object3 + "." + object);
                    continue block62;
                }
                case 79: {
                    MovieMetaData.pop(stack);
                    MovieMetaData.pop(stack);
                    MovieMetaData.pop(stack);
                    continue block62;
                }
                case 80: 
                case 81: {
                    continue block62;
                }
                case 82: {
                    int n7;
                    int n6;
                    MovieMetaData.pop(stack);
                    MovieMetaData.pop(stack);
                    Object object = MovieMetaData.pop(stack);
                    if (object instanceof String) {
                        try {
                            n6 = Integer.parseInt((String)object);
                        }
                        catch (NumberFormatException numberFormatException) {
                            n6 = 1;
                        }
                    } else {
                        n6 = ((Number)object).intValue();
                    }
                    for (n7 = 0; n7 < n6; ++n7) {
                        MovieMetaData.pop(stack);
                    }
                    stack.push(dummy);
                    continue block62;
                }
                case 83: {
                    int n7;
                    MovieMetaData.pop(stack);
                    MovieMetaData.pop(stack);
                    int n4 = ((Number)MovieMetaData.pop(stack)).intValue();
                    for (n7 = 0; n7 < n4; ++n7) {
                        MovieMetaData.pop(stack);
                    }
                    stack.push(dummy);
                    continue block62;
                }
                case 148: {
                    MovieMetaData.pop(stack);
                    continue block62;
                }
                case 136: {
                    stringArray = ((ConstantPool)action).pool;
                    continue block62;
                }
                case 137: {
                    continue block62;
                }
                case 96: 
                case 97: 
                case 99: {
                    continue block62;
                }
                case 98: 
                case 100: 
                case 101: {
                    MovieMetaData.pop(stack);
                    continue block62;
                }
                case 84: {
                    MovieMetaData.pop(stack);
                    continue block62;
                }
                case 85: {
                    continue block62;
                }
                case 102: 
                case 103: 
                case 104: {
                    MovieMetaData.pop(stack);
                    continue block62;
                }
                case 143: {
                    continue block62;
                }
                case 42: {
                    MovieMetaData.pop(stack);
                    continue block62;
                }
                case 43: {
                    continue block62;
                }
                case 44: {
                    continue block62;
                }
                case 170: {
                    continue block62;
                }
            }
        }
    }

    static {
        int n;
        regClassCall9 = new int[]{150, 28, 150, 150, 150, 28, 150, 82, 23};
        regClassCall10 = new int[]{136, 150, 28, 150, 150, 150, 28, 150, 82, 23};
        codes = new Integer[256];
        for (n = 0; n < 256; ++n) {
            MovieMetaData.codes[n] = new Integer(n);
        }
        dummy = new Object();
        registers = new Object[256];
        for (n = 0; n < 256; ++n) {
            MovieMetaData.registers[n] = dummy;
        }
    }
}

