/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.cluster;

import flex.messaging.Destination;
import flex.messaging.MessageBroker;
import flex.messaging.cluster.Cluster;
import flex.messaging.cluster.ClusterException;
import flex.messaging.config.ClusterSettings;
import flex.messaging.config.ConfigMap;
import flex.messaging.endpoints.Endpoint;
import flex.messaging.util.ClassUtil;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ClusterManager {
    public static final String OPERATION_ADD_ENDPOINT_FOR_CHANNEL = "addEndpointForChannel";
    public static final String OPERATION_SEND_ENDPOINT_URL = "sendEndpointUrl";
    public static final String OPERATION_RECEIVE_ENDPOINT_URL = "receiveEndpointUrl";
    public static final String OPERATION_PUSH_MESSAGE_FROM_PEER = "pushMessageFromPeer";
    public static final String OPERATION_PEER_SYNC_AND_PUSH = "peerSyncAndPush";
    public static final String OPERATION_REQUEST_ADAPTER_STATE = "requestAdapterState";
    public static final String OPERATION_RECEIVE_ADAPTER_STATE = "receiveAdapterState";
    public static final String OPERATION_SEND_SUBSCRIPTIONS = "sendSubscriptions";
    public static final String OPERATION_RECEIVE_SUBSCRIPTIONS = "receiveSubscriptions";
    public static final String OPERATION_SUBSCRIBE_FROM_PEER = "subscribeFromPeer";
    public static final String OPERATION_PUSH_MESSAGE_FROM_PEER_TO_PEER = "pushMessageFromPeerToPeer";
    public static final String OPERATION_PEER_SYNC_AND_PUSH_ONE_TO_PEER = "peerSyncAndPushOneToPeer";
    private MessageBroker broker;
    private LinkedHashMap<String, Cluster> clusters;
    private Map<String, Cluster> clustersForDestination;
    private Map<String, Element> clusterConfig;
    private Map<String, ClusterSettings> clusterSettings;
    private Map<String, Boolean> backendSharedForDestination;
    private Cluster defaultCluster;
    private String defaultClusterId;

    public ClusterManager(MessageBroker broker) {
        this.broker = broker;
        this.clusters = new LinkedHashMap();
        this.clusterConfig = new HashMap<String, Element>();
        this.clusterSettings = new HashMap<String, ClusterSettings>();
        this.clustersForDestination = new HashMap<String, Cluster>();
        this.backendSharedForDestination = new HashMap<String, Boolean>();
    }

    public MessageBroker getMessageBroker() {
        return this.broker;
    }

    public Cluster getDefaultCluster() {
        return this.defaultCluster;
    }

    public String getDefaultClusterId() {
        return this.defaultClusterId;
    }

    public void invokeEndpointOperation(String endpointId, String operationName, Object[] params) {
        Object[] arguments = new Object[2 + params.length];
        arguments[0] = endpointId;
        arguments[1] = operationName;
        int n = params.length;
        int i = 2;
        for (int j = 0; j < n; ++j) {
            arguments[i] = params[j];
            ++i;
        }
        if (this.defaultCluster != null) {
            this.defaultCluster.broadcastServiceOperation(operationName, arguments);
        } else {
            for (Cluster cluster : this.clusters.values()) {
                cluster.broadcastServiceOperation(operationName, arguments);
            }
        }
    }

    public void invokePeerToPeerEndpointOperation(String endpointId, String operationName, Object[] params, Object targetAddress) {
        Object[] arguments = new Object[2 + params.length];
        arguments[0] = endpointId;
        arguments[1] = operationName;
        int n = params.length;
        int i = 2;
        for (int j = 0; j < n; ++j) {
            arguments[i] = params[j];
            ++i;
        }
        if (this.defaultCluster != null) {
            this.defaultCluster.sendPointToPointServiceOperation(operationName, arguments, targetAddress);
        } else {
            for (Cluster cluster : this.clusters.values()) {
                cluster.sendPointToPointServiceOperation(operationName, arguments, targetAddress);
            }
        }
    }

    public void invokeServiceOperation(String serviceType, String destinationName, String operationName, Object[] params) {
        Cluster c = this.getCluster(serviceType, destinationName);
        ArrayList<Object> newParams = new ArrayList<Object>(Arrays.asList(params));
        newParams.add(0, serviceType);
        newParams.add(1, destinationName);
        c.broadcastServiceOperation(operationName, newParams.toArray());
    }

    public void invokePeerToPeerOperation(String serviceType, String destinationName, String operationName, Object[] params, Object targetAddress) {
        Cluster c = this.getCluster(serviceType, destinationName);
        ArrayList<Object> newParams = new ArrayList<Object>(Arrays.asList(params));
        newParams.add(0, serviceType);
        newParams.add(1, destinationName);
        c.sendPointToPointServiceOperation(operationName, newParams.toArray(), targetAddress);
    }

    public boolean isDestinationClustered(String serviceType, String destinationName) {
        return this.getCluster(serviceType, destinationName) != null;
    }

    public boolean isBackendShared(String serviceType, String destinationName) {
        String destKey = Cluster.getClusterDestinationKey(serviceType, destinationName);
        Boolean shared = this.backendSharedForDestination.get(destKey);
        return shared != null ? shared : false;
    }

    public List getClusterMemberAddresses(String serviceType, String destinationName) {
        Cluster c = this.getCluster(serviceType, destinationName);
        return c != null ? c.getMemberAddresses() : Collections.EMPTY_LIST;
    }

    public List getClusterMemberAddresses() {
        if (this.defaultCluster != null) {
            return this.defaultCluster.getMemberAddresses();
        }
        TreeSet uniqueAddresses = new TreeSet();
        for (Cluster cluster : this.clusters.values()) {
            uniqueAddresses.addAll(cluster.getMemberAddresses());
        }
        return new ArrayList(uniqueAddresses);
    }

    public void prepareCluster(ClusterSettings settings) {
        String propsFileName = settings.getPropsFileName();
        this.checkForNullPropertiesFile(settings.getClusterName(), propsFileName);
        InputStream propsFile = this.resolveInternalPath(propsFileName);
        if (propsFile == null) {
            propsFile = this.resolveExternalPath(propsFileName);
        }
        if (propsFile == null) {
            this.throwClusterException(10208, new Object[]{propsFileName}, null);
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(false);
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(propsFile);
            if (settings.isDefault()) {
                this.defaultClusterId = settings.getClusterName();
            }
            this.clusterConfig.put(settings.getClusterName(), doc.getDocumentElement());
            this.clusterSettings.put(settings.getClusterName(), settings);
        }
        catch (Exception ex) {
            this.throwClusterException(10213, new Object[]{propsFileName}, ex);
        }
    }

    public Object getLocalAddress(String serviceType, String destinationName) {
        Cluster c = this.getCluster(serviceType, destinationName);
        return c != null ? c.getLocalAddress() : null;
    }

    public Object getLocalAddress() {
        if (this.defaultCluster != null) {
            return this.defaultCluster.getLocalAddress();
        }
        Iterator<Map.Entry<String, Cluster>> iterator = this.clusters.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<String, Cluster> entry = iterator.next();
            return entry.getValue().getLocalAddress();
        }
        return null;
    }

    public Cluster getClusterById(String clusterId) {
        return this.clusters.get(clusterId);
    }

    public Cluster getCluster(String serviceType, String destinationName) {
        Cluster cluster = null;
        try {
            String destKey = Cluster.getClusterDestinationKey(serviceType, destinationName);
            cluster = this.clustersForDestination.get(destKey);
            if (cluster == null) {
                cluster = this.defaultCluster;
            }
        }
        catch (NoClassDefFoundError nex) {
            ClusterException cx = new ClusterException();
            cx.setMessage(10202, new Object[]{destinationName});
            cx.setRootCause(nex);
            throw cx;
        }
        return cluster;
    }

    public void destroyClusters() {
        Iterator<Cluster> iter = this.clusters.values().iterator();
        while (iter.hasNext()) {
            Cluster cluster = iter.next();
            cluster.destroy();
            iter.remove();
        }
    }

    public void clusterDestinationChannel(String clusterId, String serviceType, String destinationName, String channelId, String endpointUrl, int endpointPort, boolean sharedBackend) {
        Cluster cluster = this.getClusterById(clusterId);
        String destKey = Cluster.getClusterDestinationKey(serviceType, destinationName);
        if (cluster == null) {
            if (!this.clusterConfig.containsKey(clusterId)) {
                ClusterException cx = new ClusterException();
                cx.setMessage(10207, new Object[]{destinationName, clusterId});
                throw cx;
            }
            cluster = this.createCluster(clusterId, serviceType, destinationName);
        } else {
            this.clustersForDestination.put(destKey, cluster);
        }
        this.backendSharedForDestination.put(destKey, sharedBackend ? Boolean.TRUE : Boolean.FALSE);
        if (cluster.getURLLoadBalancing()) {
            cluster.addLocalEndpointForChannel(serviceType, destinationName, channelId, endpointUrl, endpointPort);
        }
    }

    public void clusterDestination(Destination destination) {
        ClusterSettings cls;
        String clusterId = destination.getNetworkSettings().getClusterId();
        if (clusterId == null) {
            clusterId = this.getDefaultClusterId();
        }
        if ((cls = this.clusterSettings.get(clusterId)) == null) {
            ClusterException ce = new ClusterException();
            ce.setMessage(10217, new Object[]{destination.getId(), clusterId});
            throw ce;
        }
        for (String channelId : destination.getChannels()) {
            int tokenStart;
            Endpoint endpoint = this.broker.getEndpoint(channelId);
            String endpointUrl = endpoint.getUrl();
            int endpointPort = endpoint.getPort();
            if (cls.getURLLoadBalancing() && (tokenStart = endpointUrl.indexOf(123)) != -1) {
                int tokenEnd = endpointUrl.indexOf(125, tokenStart);
                tokenEnd = tokenEnd == -1 ? endpointUrl.length() : ++tokenEnd;
                ClusterException ce = new ClusterException();
                ce.setMessage(10209, new Object[]{destination.getId(), channelId, endpointUrl.substring(tokenStart, tokenEnd)});
                throw ce;
            }
            this.clusterDestinationChannel(clusterId, destination.getServiceType(), destination.getId(), channelId, endpointUrl, endpointPort, destination.getNetworkSettings().isSharedBackend());
        }
    }

    public List getEndpointsForDestination(String serviceType, String destinationName) {
        Cluster c = this.getCluster(serviceType, destinationName);
        return c != null ? c.getAllEndpoints(serviceType, destinationName) : null;
    }

    private void checkForNullPropertiesFile(String clusterName, String propsFileName) {
        if (propsFileName == null) {
            this.throwClusterException(10201, new Object[]{clusterName, propsFileName}, null);
        }
    }

    private Cluster createCluster(String clusterId, String serviceType, String destinationName) {
        String destKey = Cluster.getClusterDestinationKey(serviceType, destinationName);
        Element propsFile = this.clusterConfig.get(clusterId);
        ClusterSettings cls = this.clusterSettings.get(clusterId);
        Cluster cluster = null;
        Class clusterClass = ClassUtil.createClass(cls.getImplementationClass());
        Constructor clusterConstructor = null;
        try {
            clusterConstructor = clusterClass.getConstructor(ClusterManager.class);
        }
        catch (Exception e) {
            ClusterException cx = new ClusterException();
            cx.setMessage(10210);
            cx.setRootCause(e);
            throw cx;
        }
        try {
            cluster = (Cluster)clusterConstructor.newInstance(this);
            cluster.setClusterPropertiesFile(propsFile);
            cluster.setURLLoadBalancing(cls.getURLLoadBalancing());
            cluster.initialize(clusterId, cls.getProperties());
        }
        catch (Exception e) {
            ClusterException cx = new ClusterException();
            cx.setMessage(10211);
            cx.setRootCause(e);
            throw cx;
        }
        this.clustersForDestination.put(destKey, cluster);
        this.clusters.put(clusterId, cluster);
        if (this.defaultClusterId != null && this.defaultClusterId.equals(clusterId)) {
            this.defaultCluster = cluster;
        }
        return cluster;
    }

    private InputStream resolveExternalPath(String propsFileName) {
        try {
            return this.broker.resolveExternalPath(propsFileName);
        }
        catch (Throwable t) {
            this.throwClusterException(10208, new Object[]{propsFileName}, t);
            return null;
        }
    }

    private InputStream resolveInternalPath(String propsFileName) {
        try {
            return this.broker.resolveInternalPath(propsFileName);
        }
        catch (Throwable t) {
            this.throwClusterException(10208, new Object[]{propsFileName}, t);
            return null;
        }
    }

    private void throwClusterException(int number, Object[] args, Throwable t) {
        ClusterException cx = new ClusterException();
        cx.setMessage(number, args);
        if (t != null) {
            cx.setRootCause(t);
        }
        throw cx;
    }

    public ConfigMap describeClusters() {
        ConfigMap result = new ConfigMap();
        for (Map.Entry<String, Cluster> entry : this.clusters.entrySet()) {
            Cluster cluster = entry.getValue();
            ConfigMap clusterMap = new ConfigMap();
            clusterMap.put((Object)"id", (Object)entry.getKey());
            ClusterSettings settings = this.clusterSettings.get(entry.getKey());
            clusterMap.put((Object)"properties", (Object)settings.getPropsFileName());
            if (settings.isDefault()) {
                clusterMap.put((Object)"default", (Object)"true");
            }
            clusterMap.put((Object)"class", (Object)cluster.getClass().getCanonicalName());
            result.addProperty("cluster", clusterMap);
        }
        return result;
    }
}

