/*
 * Decompiled with CFR 0.152.
 */
package flex.management.runtime.messaging;

import flex.management.BaseControl;
import flex.management.runtime.messaging.DestinationControl;
import flex.management.runtime.messaging.MessageDestinationControlMBean;
import flex.messaging.Destination;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.ObjectName;

public class MessageDestinationControl
extends DestinationControl
implements MessageDestinationControlMBean {
    private static final String TYPE = "MessageDestination";
    private ObjectName messageCache;
    private ObjectName throttleManager;
    private ObjectName subscriptionManager;
    private AtomicInteger serviceMessageCount = new AtomicInteger(0);
    private Date lastServiceMessageTimestamp;
    private long serviceMessageStart;
    private AtomicInteger serviceCommandCount = new AtomicInteger(0);
    private Date lastServiceCommandTimestamp;
    private long serviceCommandStart;
    private AtomicInteger serviceMessageFromAdapterCount = new AtomicInteger(0);
    private Date lastServiceMessageFromAdapterTimestamp;
    private long serviceMessageFromAdapterStart;

    public MessageDestinationControl(Destination destination, BaseControl parent) {
        super(destination, parent);
        this.serviceCommandStart = this.serviceMessageStart = System.currentTimeMillis();
        this.serviceMessageFromAdapterStart = this.serviceMessageStart;
    }

    @Override
    protected void onRegistrationComplete() {
        String name = this.getObjectName().getCanonicalName();
        String[] pollablePerInterval = new String[]{"ServiceCommandCount", "ServiceMessageCount", "ServiceMessageFromAdapterCount"};
        String[] pollableGeneral = new String[]{"ServiceCommandFrequency", "ServiceMessageFrequency", "ServiceMessageFromAdapterFrequency", "LastServiceCommandTimestamp", "LastServiceMessageTimestamp", "LastServiceMessageFromAdapterTimestamp"};
        this.getRegistrar().registerObjects(new int[]{151, 50}, name, pollablePerInterval);
        this.getRegistrar().registerObjects(151, name, pollableGeneral);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public ObjectName getMessageCache() {
        return this.messageCache;
    }

    public void setMessageCache(ObjectName value) {
        this.messageCache = value;
    }

    @Override
    public ObjectName getThrottleManager() {
        return this.throttleManager;
    }

    public void setThrottleManager(ObjectName value) {
        this.throttleManager = value;
    }

    @Override
    public ObjectName getSubscriptionManager() {
        return this.subscriptionManager;
    }

    public void setSubscriptionManager(ObjectName value) {
        this.subscriptionManager = value;
    }

    @Override
    public Integer getServiceMessageCount() {
        return this.serviceMessageCount.get();
    }

    @Override
    public void resetServiceMessageCount() {
        this.serviceMessageStart = System.currentTimeMillis();
        this.serviceMessageCount = new AtomicInteger(0);
        this.lastServiceMessageTimestamp = null;
    }

    public void incrementServiceMessageCount() {
        this.serviceMessageCount.incrementAndGet();
        this.lastServiceMessageTimestamp = new Date();
    }

    @Override
    public Date getLastServiceMessageTimestamp() {
        return this.lastServiceMessageTimestamp;
    }

    @Override
    public Double getServiceMessageFrequency() {
        if (this.serviceMessageCount.get() > 0) {
            double runtime = this.differenceInMinutes(this.serviceMessageStart, System.currentTimeMillis());
            return new Double((double)this.serviceMessageCount.get() / runtime);
        }
        return new Double(0.0);
    }

    @Override
    public Integer getServiceCommandCount() {
        return this.serviceCommandCount.get();
    }

    @Override
    public void resetServiceCommandCount() {
        this.serviceCommandStart = System.currentTimeMillis();
        this.serviceCommandCount = new AtomicInteger(0);
        this.lastServiceCommandTimestamp = null;
    }

    public void incrementServiceCommandCount() {
        this.serviceCommandCount.incrementAndGet();
        this.lastServiceCommandTimestamp = new Date();
    }

    @Override
    public Date getLastServiceCommandTimestamp() {
        return this.lastServiceCommandTimestamp;
    }

    @Override
    public Double getServiceCommandFrequency() {
        if (this.serviceCommandCount.get() > 0) {
            double runtime = this.differenceInMinutes(this.serviceCommandStart, System.currentTimeMillis());
            return new Double((double)this.serviceCommandCount.get() / runtime);
        }
        return new Double(0.0);
    }

    @Override
    public Integer getServiceMessageFromAdapterCount() {
        return this.serviceMessageFromAdapterCount.get();
    }

    @Override
    public void resetServiceMessageFromAdapterCount() {
        this.serviceMessageFromAdapterStart = System.currentTimeMillis();
        this.serviceMessageFromAdapterCount = new AtomicInteger(0);
        this.lastServiceMessageFromAdapterTimestamp = null;
    }

    public void incrementServiceMessageFromAdapterCount() {
        this.serviceMessageFromAdapterCount.incrementAndGet();
        this.lastServiceMessageFromAdapterTimestamp = new Date();
    }

    @Override
    public Date getLastServiceMessageFromAdapterTimestamp() {
        return this.lastServiceMessageFromAdapterTimestamp;
    }

    @Override
    public Double getServiceMessageFromAdapterFrequency() {
        if (this.serviceMessageFromAdapterCount.get() > 0) {
            double runtime = this.differenceInMinutes(this.serviceMessageFromAdapterStart, System.currentTimeMillis());
            return new Double((double)this.serviceMessageFromAdapterCount.get() / runtime);
        }
        return new Double(0.0);
    }
}

