/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import adobe.abc.Block;
import adobe.abc.Edge;
import adobe.abc.Expr;
import adobe.abc.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Algorithms {
    public static Set<Integer> foreach(BitSet x) {
        TreeSet<Integer> result = new TreeSet<Integer>();
        for (int i = 0; i < x.length(); ++i) {
            if (!x.get(i)) continue;
            result.add(i);
        }
        return result;
    }

    public static Map<Block, Block> idoms(Deque<Block> all, SetMap<Block, Edge> pred) {
        boolean changed;
        Block entry = all.peekFirst();
        Block[] doms = new Block[entry.postorder + 1];
        doms[entry.postorder] = entry;
        do {
            changed = false;
            for (Block b : all) {
                Block p;
                Edge e;
                if (b == entry) continue;
                Block new_idom = null;
                Iterator iterator = pred.get(b).iterator();
                while (iterator.hasNext()) {
                    e = (Edge)iterator.next();
                    p = e.from;
                    if (doms[p.postorder] == null) continue;
                    new_idom = p;
                    break;
                }
                iterator = pred.get(b).iterator();
                while (iterator.hasNext()) {
                    e = (Edge)iterator.next();
                    p = e.from;
                    if (p == new_idom || doms[p.postorder] == null) continue;
                    new_idom = Algorithms.intersect(p, new_idom, doms);
                }
                if (doms[b.postorder] == new_idom) continue;
                doms[b.postorder] = new_idom;
                changed = true;
            }
        } while (changed);
        TreeMap<Block, Block> map = new TreeMap<Block, Block>();
        for (Block b : all) {
            if (b == entry) continue;
            map.put(b, doms[b.postorder]);
        }
        return map;
    }

    public static Block intersect(Block b1, Block b2, Block[] doms) {
        while (b1 != b2) {
            while (b1.postorder < b2.postorder) {
                b1 = doms[b1.postorder];
            }
            while (b2.postorder < b1.postorder) {
                b2 = doms[b2.postorder];
            }
        }
        return b1;
    }

    public static boolean dominates(Block p, Block s, Map<Block, Block> idom) {
        Block b = s;
        while (b != null) {
            if (b == p) {
                return true;
            }
            b = idom.get(b);
        }
        return false;
    }

    public static SetMap<Block, Edge> preds(Deque<Block> code) {
        SetMap<Block, Edge> pred = new SetMap<Block, Edge>();
        for (Block b : code) {
            for (Edge s : b.succ()) {
                pred.get(s.to).add(s);
            }
        }
        return pred;
    }

    static void checkPredecessors(SetMap<Block, Edge> pred, Deque<Block> code) {
        block0: for (Block b : code) {
            for (Expr e : b) {
                if (e.op != 10) continue block0;
                TreeSet<Edge> phi_in = new TreeSet<Edge>();
                for (Edge p : e.pred) {
                    phi_in.add(p);
                }
                Object blk_in = pred.get(b);
                assert (phi_in.equals(blk_in));
            }
        }
    }

    static SetMap<Block, Edge> allpreds(Deque<Block> code) {
        SetMap<Block, Edge> pred = new SetMap<Block, Edge>();
        for (Block b : code) {
            for (Edge s : b.succ()) {
                pred.get(s.to).add(s);
            }
            for (Edge x : b.xsucc) {
                pred.get(x.to).add(x);
            }
        }
        return pred;
    }

    public static EdgeMap<Expr> findUses(Deque<Block> code) {
        EdgeMap<Expr> uses = new EdgeMap<Expr>();
        for (Block b : code) {
            for (Expr e : b) {
                for (Expr a : e.args) {
                    uses.get(a).add(e);
                }
                for (Expr a : e.locals) {
                    uses.get(a).add(e);
                }
                for (Expr a : e.scopes) {
                    uses.get(a).add(e);
                }
            }
        }
        return uses;
    }

    private static void dfs_visit_el(Edge[] el, BitSet visited, Deque<Block> list) {
        for (int i = el.length - 1; i >= 0; --i) {
            Algorithms.dfs_visit(el[i].to, visited, list);
        }
    }

    private static Deque<Block> dfs_visit(Block b, BitSet visited, Deque<Block> list) {
        if (!visited.get(b.id)) {
            visited.set(b.id);
            Algorithms.dfs_visit_el(b.xsucc, visited, list);
            Algorithms.dfs_visit_el(b.succ(), visited, list);
            b.postorder = list.size();
            list.addFirst(b);
        }
        return list;
    }

    public static Deque<Block> dfs(Block entry) {
        return Algorithms.dfs_visit(entry, new BitSet(), new LinkedDeque<Block>());
    }

    public static Block getBlock(Set<Block> work) {
        Iterator<Block> i = work.iterator();
        Block b = i.next();
        i.remove();
        return b;
    }

    public static Expr getExpr(Set<Expr> work) {
        Iterator<Expr> i = work.iterator();
        Expr e = i.next();
        i.remove();
        return e;
    }

    public static Edge getEdge(Set<Edge> work) {
        Iterator<Edge> i = work.iterator();
        Edge e = i.next();
        i.remove();
        return e;
    }

    public static Method getMethod(List<Method> list) {
        return list.remove(list.size() - 1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TopologicalSort<T> {
        public List<T> toplogicalSort(List<T> unsorted, DependencyChecker<T> checker) {
            HashMap dep = new HashMap(unsorted.size());
            for (T x : unsorted) {
                HashSet<T> parents = new HashSet<T>();
                dep.put(x, parents);
                for (T y : unsorted) {
                    if (x == y || !checker.depends(x, y)) continue;
                    if (checker.depends(y, x)) {
                        throw new IllegalArgumentException("Cyclical graphs can't be topologically sorted.");
                    }
                    parents.add(y);
                }
            }
            ArrayList sorted = new ArrayList(unsorted.size());
            while (dep.size() > 0) {
                boolean found_sorted_element = false;
                for (Object x : dep.keySet()) {
                    if (0 != ((Set)dep.get(x)).size()) continue;
                    sorted.add(x);
                    found_sorted_element = true;
                    for (T y : unsorted) {
                        if (!dep.containsKey(y)) continue;
                        ((Set)dep.get(y)).remove(x);
                    }
                    dep.remove(x);
                    break;
                }
                if (found_sorted_element) continue;
                throw new IllegalArgumentException("Cyclical graphs can't be topologically sorted.");
            }
            return sorted;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface DependencyChecker<T> {
            public boolean depends(T var1, T var2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Pool<T extends Comparable> {
        Map<T, Integer> refs = new HashMap<T, Integer>();
        ArrayList<T> values;
        int countFrom;

        Pool(int countFrom) {
            this.countFrom = countFrom;
        }

        int add(T e) {
            int n = !this.refs.containsKey(e) ? 1 : this.refs.get(e) + 1;
            this.refs.put(e, n);
            return n;
        }

        void sort() {
            Object[] arr = new Ranker[this.refs.size()];
            int i = 0;
            for (Comparable e : this.refs.keySet()) {
                arr[i++] = new Ranker<Comparable>(e, this.refs.get(e));
            }
            assert (i == this.refs.size());
            Arrays.sort(arr);
            this.values = new ArrayList();
            i = this.countFrom;
            for (Object r : arr) {
                this.values.add(((Ranker)r).value);
                this.refs.put(((Ranker)r).value, i++);
            }
        }

        int id(T e) {
            assert (this.refs.containsKey(e));
            assert (this.refs.get(e) < this.size());
            return this.refs.get(e);
        }

        public String toString() {
            return String.valueOf(this.refs);
        }

        int size() {
            return this.countFrom + this.refs.size();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class Ranker<T>
        implements Comparable {
            T value;
            int rank;

            Ranker(T value, int rank) {
                this.value = value;
                this.rank = rank;
            }

            public int compareTo(Object o) {
                return ((Ranker)o).rank - this.rank;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LinkedDeque<E>
    extends LinkedList<E>
    implements Deque<E> {
        public static final long serialVersionUID = 0L;

        @Override
        public E peekFirst() {
            return this.isEmpty() ? null : (E)this.getFirst();
        }

        @Override
        public E peekLast() {
            return this.isEmpty() ? null : (E)this.getLast();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ArrayDeque<E>
    extends ArrayList<E>
    implements Deque<E> {
        public static final long serialVersionUID = 0L;

        public ArrayDeque() {
        }

        public ArrayDeque(Collection<E> c) {
            this.addAll(c);
        }

        @Override
        public void addFirst(E e) {
            this.add(0, e);
        }

        @Override
        public E removeFirst() {
            return this.remove(0);
        }

        @Override
        public E peekFirst() {
            return this.isEmpty() ? null : (E)this.get(0);
        }

        @Override
        public E removeLast() {
            return this.remove(this.size() - 1);
        }

        @Override
        public E peekLast() {
            return this.isEmpty() ? null : (E)this.get(this.size() - 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Deque<E>
    extends List<E> {
        @Override
        public E removeFirst();

        public E peekFirst();

        @Override
        public E removeLast();

        public E peekLast();

        @Override
        public void addFirst(E var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EdgeMap<E>
    extends SetMap<E, E> {
        static final long serialVersionUID = 0L;

        @Override
        public Set<E> get(Object e) {
            return super.get(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetMap<K, V>
    extends TreeMap<K, Set<V>> {
        static final long serialVersionUID = 0L;

        @Override
        public Set<V> get(Object e) {
            TreeSet s = (TreeSet)super.get(e);
            if (s == null) {
                s = new TreeSet();
                this.put(e, s);
            }
            return s;
        }
    }
}

