/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import org.apache.felix.webconsole.internal.NavigationRenderer;
import org.apache.felix.webconsole.internal.servlet.BrandingPluginImpl;
import org.apache.felix.webconsole.servlet.RequestVariableResolver;
import org.apache.felix.webconsole.spi.BrandingPlugin;
import org.osgi.framework.BundleContext;

public abstract class AbstractPluginAdapter
extends HttpServlet {
    public static final String ATTR_LANG_MAP = "felix.webconsole.langMap";
    private static final long serialVersionUID = 1L;
    private static volatile BrandingPlugin BRANDING_PLUGIN = new BrandingPluginImpl();
    private volatile BundleContext bundleContext;
    private final String title;
    protected final String label;
    private final String[] cssReferences;

    protected abstract URL getResource(String var1);

    public AbstractPluginAdapter(BundleContext bundleContext, String label, String title, String[] cssReferences) {
        this.title = title;
        this.label = label;
        this.cssReferences = cssReferences;
        this.activate(bundleContext);
    }

    protected abstract void renderContent(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;

    public String getServletName() {
        return this.title;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.spoolResource(request, response)) {
            if (this.isHtmlRequest(request)) {
                PrintWriter pw = this.startResponse(request, response);
                this.renderTopNavigation(request, pw);
                pw.println("<div id='content'>");
                this.renderContent(request, response);
                pw.println("</div>");
                this.endResponse(pw);
            } else {
                this.renderContent(request, response);
            }
        }
    }

    protected boolean isHtmlRequest(HttpServletRequest request) {
        return true;
    }

    protected void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void deactivate() {
        this.bundleContext = null;
    }

    protected BundleContext getBundleContext() {
        return this.bundleContext;
    }

    private final boolean spoolResource(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String pi = request.getPathInfo();
        URL url = this.getResource(pi);
        if (url == null) {
            return false;
        }
        URLConnection connection = url.openConnection();
        try (InputStream ins = connection.getInputStream();){
            int rd;
            String contentType;
            if (ins == null) {
                boolean bl = false;
                return bl;
            }
            long lastModified = connection.getLastModified();
            if (lastModified > 0L) {
                long ifModifiedSince = request.getDateHeader("If-Modified-Since");
                if (ifModifiedSince >= lastModified / 1000L * 1000L) {
                    response.setStatus(304);
                    boolean bl = true;
                    return bl;
                }
                response.setDateHeader("Last-Modified", lastModified);
            }
            if ((contentType = this.getServletContext().getMimeType(pi)) != null) {
                response.setContentType(contentType);
            }
            if (connection.getContentLength() != -1) {
                response.setContentLength(connection.getContentLength());
            }
            ServletOutputStream out = response.getOutputStream();
            byte[] buf = new byte[2048];
            while ((rd = ins.read(buf)) >= 0) {
                out.write(buf, 0, rd);
            }
            boolean bl = true;
            return bl;
        }
    }

    private PrintWriter startResponse(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setCharacterEncoding("utf-8");
        response.setContentType("text/html");
        PrintWriter pw = response.getWriter();
        String appRoot = (String)request.getAttribute("felix.webconsole.appRoot");
        Object t = this.title;
        if (((String)t).startsWith("%")) {
            t = "${" + ((String)t).substring(1) + "}";
        }
        RequestVariableResolver r = this.getVariableResolver((ServletRequest)request);
        r.put("head.title", t);
        r.put("head.label", this.label);
        r.put("head.cssLinks", this.getCssLinks(appRoot));
        r.put("brand.name", BRANDING_PLUGIN.getBrandName());
        r.put("brand.product.url", BRANDING_PLUGIN.getProductURL());
        r.put("brand.product.name", BRANDING_PLUGIN.getProductName());
        r.put("brand.product.img", AbstractPluginAdapter.toUrl(BRANDING_PLUGIN.getProductImage(), appRoot));
        r.put("brand.favicon", AbstractPluginAdapter.toUrl(BRANDING_PLUGIN.getFavIcon(), appRoot));
        r.put("brand.css", AbstractPluginAdapter.toUrl(BRANDING_PLUGIN.getMainStyleSheet(), appRoot));
        pw.println(NavigationRenderer.HEADER);
        return pw;
    }

    private void renderTopNavigation(HttpServletRequest request, PrintWriter pw) {
        String appRoot = (String)request.getAttribute("felix.webconsole.appRoot");
        Map menuMap = (Map)request.getAttribute("felix.webconsole.labelMap.categorized");
        Map langMap = (Map)request.getAttribute(ATTR_LANG_MAP);
        NavigationRenderer.renderTopNavigation(pw, appRoot, menuMap, langMap, request.getLocale());
    }

    private void endResponse(PrintWriter pw) {
        pw.println(NavigationRenderer.FOOTER);
    }

    public static final void setBrandingPlugin(BrandingPlugin brandingPlugin) {
        BRANDING_PLUGIN = brandingPlugin == null ? new BrandingPluginImpl() : brandingPlugin;
    }

    private final String getCssLinks(String appRoot) {
        if (this.cssReferences == null || this.cssReferences.length == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.cssReferences.length; ++i) {
            buf.append("<link href='");
            buf.append(AbstractPluginAdapter.toUrl(this.cssReferences[i], appRoot));
            buf.append("' rel='stylesheet' type='text/css' />");
        }
        return buf.toString();
    }

    private static final String toUrl(String url, String appRoot) {
        if (url.startsWith("/")) {
            return appRoot + url;
        }
        return url;
    }

    protected RequestVariableResolver getVariableResolver(ServletRequest request) {
        return (RequestVariableResolver)request.getAttribute("felix.webconsole.variable.resolver");
    }
}

