/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.core;

import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.text.MessageFormat;
import java.util.TreeMap;
import org.apache.felix.inventory.Format;
import org.apache.felix.webconsole.internal.AbstractConfigurationPrinter;
import org.apache.felix.webconsole.internal.core.BundleContextUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleRevision;

public class BundlesConfigurationPrinter
extends AbstractConfigurationPrinter {
    private String getHeaderValue(Bundle b, String name) {
        String val = (String)b.getHeaders().get(name);
        if (val == null) {
            val = "";
        }
        return val;
    }

    private String getState(int state) {
        switch (state) {
            case 32: {
                return "active";
            }
            case 2: {
                return "installed";
            }
            case 4: {
                return "resolved";
            }
            case 8: {
                return "starting";
            }
            case 16: {
                return "stopping";
            }
            case 1: {
                return "uninstalled";
            }
        }
        return String.valueOf(state);
    }

    private final boolean isFragmentBundle(Bundle bundle) {
        BundleRevision rev = (BundleRevision)bundle.adapt(BundleRevision.class);
        return rev != null && (rev.getTypes() & 1) == 1;
    }

    @Override
    protected final String getTitle() {
        return "Bundlelist";
    }

    public void print(PrintWriter pw, Format format, boolean isZip) {
        Bundle[] bundles = BundleContextUtil.getWorkingBundleContext(this.getBundleContext()).getBundles();
        TreeMap<CallSite, String> bundlesMap = new TreeMap<CallSite, String>();
        int active = 0;
        int installed = 0;
        int resolved = 0;
        int fragments = 0;
        for (int i = 0; i < bundles.length; ++i) {
            Bundle bundle = bundles[i];
            String symbolicName = bundle.getSymbolicName();
            String version = (String)bundle.getHeaders().get("Bundle-Version");
            switch (bundle.getState()) {
                case 32: {
                    ++active;
                    break;
                }
                case 2: {
                    ++installed;
                    break;
                }
                case 4: {
                    if (this.isFragmentBundle(bundle)) {
                        ++fragments;
                        break;
                    }
                    ++resolved;
                }
            }
            String key = symbolicName + ":" + version;
            String value = MessageFormat.format("{0} ({1}) \"{2}\" [{3}, {4}] {5}", symbolicName, version, this.getHeaderValue(bundle, "Bundle-Name"), this.getState(bundle.getState()), String.valueOf(bundle.getBundleId()), this.isFragmentBundle(bundle) ? "(fragment)" : "");
            bundlesMap.put((CallSite)((Object)key), value);
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("Status: ");
        this.appendBundleInfoCount(buffer, "in total", bundles.length);
        if (active == bundles.length || active + fragments == bundles.length) {
            buffer.append(" - all ");
            this.appendBundleInfoCount(buffer, "active.", bundles.length);
        } else {
            if (active != 0) {
                buffer.append(", ");
                this.appendBundleInfoCount(buffer, "active", active);
            }
            if (fragments != 0) {
                buffer.append(", ");
                this.appendBundleInfoCount(buffer, "active fragments", fragments);
            }
            if (resolved != 0) {
                buffer.append(", ");
                this.appendBundleInfoCount(buffer, "resolved", resolved);
            }
            if (installed != 0) {
                buffer.append(", ");
                this.appendBundleInfoCount(buffer, "installed", installed);
            }
        }
        pw.println(buffer.toString());
        pw.println();
        for (String value : bundlesMap.values()) {
            pw.println(value);
        }
    }

    private void appendBundleInfoCount(StringBuilder buf, String msg, int count) {
        buf.append(count);
        buf.append(" bundle");
        if (count != 1) {
            buf.append('s');
        }
        buf.append(' ');
        buf.append(msg);
    }
}

