/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.test.scenarios.annotations;

import org.apache.felix.ipojo.junit4osgi.OSGiTestCase;
import org.apache.felix.ipojo.junit4osgi.helpers.IPOJOHelper;
import org.apache.felix.ipojo.metadata.Element;

public class TemporalDependencies
extends OSGiTestCase {
    private IPOJOHelper helper;

    public void setUp() {
        this.helper = new IPOJOHelper((OSGiTestCase)this);
    }

    public void testSimple() {
        Element meta = this.helper.getMetadata("org.apache.felix.ipojo.test.scenarios.component.temporal.TemporalSimple");
        Element[] provs = meta.getElements("requires", "org.apache.felix.ipojo.handler.temporal");
        TemporalDependencies.assertNotNull((String)"Temporal exists ", (Object)provs);
        String field = provs[0].getAttribute("field");
        TemporalDependencies.assertNotNull((String)"Field not null", (Object)field);
        TemporalDependencies.assertEquals((String)"Field is fs", (String)"fs", (String)field);
        String to = provs[0].getAttribute("timeout");
        TemporalDependencies.assertNull((String)"No timeout", (Object)to);
        String oto = provs[0].getAttribute("onTimeout");
        TemporalDependencies.assertNull((String)"No onTimeout", (Object)oto);
    }

    public void testDI() {
        Element meta = this.helper.getMetadata("org.apache.felix.ipojo.test.scenarios.component.temporal.TemporalWithDI");
        Element[] provs = meta.getElements("requires", "org.apache.felix.ipojo.handler.temporal");
        TemporalDependencies.assertNotNull((String)"Temporal exists ", (Object)provs);
        String field = provs[0].getAttribute("field");
        TemporalDependencies.assertNotNull((String)"Field not null", (Object)field);
        TemporalDependencies.assertEquals((String)"Field is fs", (String)"fs", (String)field);
        String oto = provs[0].getAttribute("onTimeout");
        TemporalDependencies.assertEquals((String)"onTimeout is the DI", (String)"org.apache.felix.ipojo.test.scenarios.component.ProvidesSimple", (String)oto);
    }

    public void testEmptyArray() {
        Element meta = this.helper.getMetadata("org.apache.felix.ipojo.test.scenarios.component.temporal.TemporalWithEmptyArray");
        Element[] provs = meta.getElements("requires", "org.apache.felix.ipojo.handler.temporal");
        TemporalDependencies.assertNotNull((String)"Temporal exists ", (Object)provs);
        String field = provs[0].getAttribute("field");
        TemporalDependencies.assertNotNull((String)"Field not null", (Object)field);
        TemporalDependencies.assertEquals((String)"Field is fs", (String)"fs", (String)field);
        String oto = provs[0].getAttribute("onTimeout");
        TemporalDependencies.assertEquals((String)"onTimeout is empty-array", (String)"empty-array", (String)oto);
    }

    public void testNull() {
        Element meta = this.helper.getMetadata("org.apache.felix.ipojo.test.scenarios.component.temporal.TemporalWithNull");
        Element[] provs = meta.getElements("requires", "org.apache.felix.ipojo.handler.temporal");
        TemporalDependencies.assertNotNull((String)"Temporal exists ", (Object)provs);
        String field = provs[0].getAttribute("field");
        TemporalDependencies.assertNotNull((String)"Field not null", (Object)field);
        TemporalDependencies.assertEquals((String)"Field is fs", (String)"fs", (String)field);
        String oto = provs[0].getAttribute("onTimeout");
        TemporalDependencies.assertEquals((String)"onTimeout is null", (String)"null", (String)oto);
    }

    public void testNullable() {
        Element meta = this.helper.getMetadata("org.apache.felix.ipojo.test.scenarios.component.temporal.TemporalWithNullable");
        Element[] provs = meta.getElements("requires", "org.apache.felix.ipojo.handler.temporal");
        TemporalDependencies.assertNotNull((String)"Temporal exists ", (Object)provs);
        String field = provs[0].getAttribute("field");
        TemporalDependencies.assertNotNull((String)"Field not null", (Object)field);
        TemporalDependencies.assertEquals((String)"Field is fs", (String)"fs", (String)field);
        String oto = provs[0].getAttribute("onTimeout");
        TemporalDependencies.assertEquals((String)"onTimeout is nullable", (String)"nullable", (String)oto);
    }

    public void testFilter() {
        Element meta = this.helper.getMetadata("org.apache.felix.ipojo.test.scenarios.component.temporal.TemporalWithFilter");
        Element[] provs = meta.getElements("requires", "org.apache.felix.ipojo.handler.temporal");
        TemporalDependencies.assertNotNull((String)"Temporal exists ", (Object)provs);
        String field = provs[0].getAttribute("field");
        TemporalDependencies.assertNotNull((String)"Field not null", (Object)field);
        TemporalDependencies.assertEquals((String)"Field is fs", (String)"fs", (String)field);
        String filter = provs[0].getAttribute("filter");
        TemporalDependencies.assertEquals((String)"Filter", (String)"(vendor=clement)", (String)filter);
    }

    public void testTimeout() {
        Element meta = this.helper.getMetadata("org.apache.felix.ipojo.test.scenarios.component.temporal.TemporalWithTimeout");
        Element[] provs = meta.getElements("requires", "org.apache.felix.ipojo.handler.temporal");
        TemporalDependencies.assertNotNull((String)"Temporal exists ", (Object)provs);
        String field = provs[0].getAttribute("field");
        TemporalDependencies.assertNotNull((String)"Field not null", (Object)field);
        TemporalDependencies.assertEquals((String)"Field is fs", (String)"fs", (String)field);
        String to = provs[0].getAttribute("timeout");
        TemporalDependencies.assertEquals((String)"Check timeout", (String)"100", (String)to);
    }

    public void testSimpleCollection() {
        Element meta = this.helper.getMetadata("org.apache.felix.ipojo.test.scenarios.component.temporal.TemporalCollection");
        Element dep = this.getElementPerField(meta, "fs1");
        String spec = dep.getAttribute("specification");
        TemporalDependencies.assertNotNull((String)"Specification not null", (Object)spec);
        TemporalDependencies.assertEquals((String)"Check specification", (String)"org.apache.felix.ipojo.test.scenarios.annotations.service.FooService", (String)spec);
    }

    public void testCollectionWithTimeout() {
        Element meta = this.helper.getMetadata("org.apache.felix.ipojo.test.scenarios.component.temporal.TemporalCollection");
        Element dep = this.getElementPerField(meta, "fs2");
        String spec = dep.getAttribute("specification");
        TemporalDependencies.assertNotNull((String)"Specification not null", (Object)spec);
        TemporalDependencies.assertEquals((String)"Check specification", (String)"org.apache.felix.ipojo.test.scenarios.annotations.service.FooService", (String)spec);
        String to = dep.getAttribute("timeout");
        TemporalDependencies.assertEquals((String)"Check timeout", (String)"300", (String)to);
    }

    public void testCollectionWithPolicy() {
        Element meta = this.helper.getMetadata("org.apache.felix.ipojo.test.scenarios.component.temporal.TemporalCollection");
        Element dep = this.getElementPerField(meta, "fs3");
        String spec = dep.getAttribute("specification");
        TemporalDependencies.assertNotNull((String)"Specification not null", (Object)spec);
        TemporalDependencies.assertEquals((String)"Check specification", (String)"org.apache.felix.ipojo.test.scenarios.annotations.service.FooService", (String)spec);
        String to = dep.getAttribute("ontimeout");
        TemporalDependencies.assertEquals((String)"Check policy", (String)"empty", (String)to);
    }

    public void testCollectionWithProxy() {
        Element meta = this.helper.getMetadata("org.apache.felix.ipojo.test.scenarios.component.temporal.TemporalCollection");
        Element dep = this.getElementPerField(meta, "fs4");
        String spec = dep.getAttribute("specification");
        TemporalDependencies.assertNotNull((String)"Specification not null", (Object)spec);
        TemporalDependencies.assertEquals((String)"Check specification", (String)"org.apache.felix.ipojo.test.scenarios.annotations.service.FooService", (String)spec);
        String proxy = dep.getAttribute("proxy");
        TemporalDependencies.assertEquals((String)"Check proxy", (String)"true", (String)proxy);
    }

    private Element getElementPerField(Element elem, String field) {
        Element[] provs = elem.getElements("requires", "org.apache.felix.ipojo.handler.temporal");
        TemporalDependencies.assertNotNull((String)"Temporal exists ", (Object)provs);
        int i = 0;
        while (i < provs.length) {
            if (provs[i].getAttribute("field").equals(field)) {
                return provs[i];
            }
            ++i;
        }
        return null;
    }
}

