/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.atomos.utils.core.plugins.collector;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.felix.atomos.utils.api.Context;
import org.apache.felix.atomos.utils.api.plugin.FileCollectorPlugin;
import org.apache.felix.atomos.utils.core.plugins.collector.PathCollectorPluginConfig;

public class PathCollectorPlugin
implements FileCollectorPlugin<PathCollectorPluginConfig> {
    private PathCollectorPluginConfig config;

    public void collectFiles(final Context context) {
        SimpleFileVisitor<Path> v = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attr) {
                block3: {
                    block2: {
                        if (PathCollectorPlugin.this.config.filters() == null) break block2;
                        if (!PathCollectorPlugin.this.config.filters().stream().filter(file.toString()::matches).findAny().isPresent()) break block3;
                    }
                    context.addFile(file, PathCollectorPlugin.this.config.fileType());
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                System.err.println(exc);
                return FileVisitResult.CONTINUE;
            }
        };
        this.config.paths().forEach(p -> {
            try {
                Files.walkFileTree(p, v);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    public void init(PathCollectorPluginConfig config) {
        this.config = config;
    }
}

