/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.atomos.impl.modules;

import java.io.IOException;
import java.lang.module.Configuration;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleReader;
import java.lang.module.ModuleReference;
import java.lang.module.ResolvedModule;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedActionException;
import java.security.SecureClassLoader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.felix.atomos.impl.modules.AtomosModules;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;

public final class ModuleConnectLoader
extends SecureClassLoader
implements BundleReference {
    private final ResolvedModule resolvedModule;
    private final ModuleReader reader;
    private final AtomosModules atomos;
    private final AtomicReference<Module> module = new AtomicReference();
    private final HashMap<String, ClassLoader> edges = new HashMap();

    public ModuleConnectLoader(ResolvedModule resolvedModule, AtomosModules atomosModules) throws IOException {
        super("ModuleConnectLoader-" + resolvedModule.name(), null);
        this.resolvedModule = resolvedModule;
        ModuleReference reference = resolvedModule.reference();
        this.reader = reference.open();
        this.atomos = atomosModules;
    }

    public static void close() {
    }

    void initEdges(Module module, Configuration loaderConfig, Map<String, ? extends ClassLoader> loaders) {
        this.module.set(module);
        for (ResolvedModule moduleRead : this.resolvedModule.reads()) {
            ClassLoader cl;
            ClassLoader loaderForModuleRead = moduleRead.configuration().equals(loaderConfig) ? loaders.get(moduleRead.name()) : ((cl = module.getLayer().findLoader(moduleRead.name())) != null ? cl : ClassLoader.getPlatformClassLoader());
            ModuleDescriptor descriptor = moduleRead.reference().descriptor();
            if (descriptor.isAutomatic()) {
                descriptor.packages().forEach(p -> this.edges.putIfAbsent((String)p, loaderForModuleRead));
                continue;
            }
            descriptor.exports().stream().filter(p -> !p.isQualified() || p.targets().contains(module.getName())).map(ModuleDescriptor.Exports::source).forEach(pn -> this.edges.putIfAbsent((String)pn, loaderForModuleRead));
        }
    }

    private String packageName(String name) {
        int lSlash = name.lastIndexOf(47);
        if (lSlash < 0) {
            return "";
        }
        return name.substring(0, lSlash).replace('/', '.');
    }

    @Override
    protected URL findResource(String moduleName, String name) throws IOException {
        URL resource = null;
        if (this.resolvedModule.name().equals(moduleName)) {
            try {
                resource = AccessController.doPrivileged(() -> {
                    URI rURI = this.reader.find(name).orElse(null);
                    return rURI == null ? null : rURI.toURL();
                });
            }
            catch (PrivilegedActionException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw new IOException(e);
            }
        }
        return resource;
    }

    @Override
    public URL findResource(String name) {
        URL retVal = null;
        try {
            retVal = this.findResource(this.module.get().getName(), name);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String pkg = this.packageName(name);
        if (this.module.get().getDescriptor().packages().contains(pkg) && !name.endsWith(".class") && !name.endsWith("/") && !this.module.get().isOpen(pkg)) {
            retVal = null;
        }
        return retVal;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        return null;
    }

    @Override
    public URL getResource(String name) {
        URL retVal = this.findResource(name);
        if (retVal == null) {
            retVal = ClassLoader.getSystemResource(name);
        }
        return retVal;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return null;
    }

    @Override
    protected Class<?> findClass(String className) throws ClassNotFoundException {
        Class<?> cls = null;
        ByteBuffer clsBytes = null;
        try {
            Optional<ByteBuffer> optBB = this.reader.read(className.replace('.', '/') + ".class");
            if (optBB.isPresent()) {
                clsBytes = optBB.get();
                cls = this.defineClass(className, clsBytes, (CodeSource)null);
            }
            if (clsBytes != null) {
                this.reader.release(clsBytes);
            }
        }
        catch (IOException e) {
            try {
                throw new LinkageError("Could not find class: " + className, e);
            }
            catch (Throwable throwable) {
                if (clsBytes != null) {
                    this.reader.release(clsBytes);
                }
                throw throwable;
            }
        }
        if (cls == null) {
            throw new ClassNotFoundException("Could not find class: " + className);
        }
        return cls;
    }

    @Override
    protected Class<?> findClass(String moduleName, String className) {
        try {
            return this.findClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String className, boolean resolve) throws ClassNotFoundException {
        Class<?> cls = null;
        Object object = this.getClassLoadingLock(className);
        synchronized (object) {
            cls = this.findLoadedClass(className);
            if (cls == null) {
                String pkg = className.substring(0, className.lastIndexOf(46));
                if (this.module.get().getDescriptor().packages().contains(pkg)) {
                    cls = this.findClass(this.module.get().getName(), className);
                } else {
                    ClassLoader l = this.edges.get(pkg);
                    if (l != null) {
                        cls = l.loadClass(className);
                    }
                }
            }
            if (cls == null) {
                throw new ClassNotFoundException("Could not find class: " + className);
            }
            if (resolve) {
                this.resolveClass(cls);
            }
        }
        return cls;
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource cs) {
        return super.getPermissions(cs);
    }

    public Bundle getBundle() {
        return this.atomos.getBundle(this.module.get());
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

