/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.junit4osgi.plugin;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import junit.framework.Test;
import junit.framework.TestResult;
import org.apache.felix.ipojo.junit4osgi.plugin.Report;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class XMLReport
extends Report {
    private List m_results = new ArrayList();

    public void testSucceeded(Test test) {
        super.testSucceeded();
        long runTime = this.m_endTime - this.m_startTime;
        Xpp3Dom testCase = this.createTestElement(test, runTime);
        this.m_results.add(testCase);
    }

    public void testError(Test test, Throwable e, String out, String err, String log) {
        super.testError(test);
        this.writeTestProblems(test, e, "error", out, err, log);
    }

    public void testFailed(Test test, Throwable e, String out, String err, String log) {
        super.testFailed(test);
        this.writeTestProblems(test, e, "failure", out, err, log);
    }

    private void writeTestProblems(Test test, Throwable e, String name, String out, String err, String log) {
        long runTime = this.m_endTime - this.m_startTime;
        Xpp3Dom testCase = this.createTestElement(test, runTime);
        Xpp3Dom element = this.createElement(testCase, name);
        String stackTrace = this.getStackTrace(test, e);
        Throwable t = e;
        if (t != null) {
            String message = t.getMessage();
            if (message != null) {
                element.setAttribute("message", message);
                element.setAttribute("type", stackTrace.indexOf(":") > -1 ? stackTrace.substring(0, stackTrace.indexOf(":")) : stackTrace);
            } else {
                element.setAttribute("type", new StringTokenizer(stackTrace).nextToken());
            }
        }
        if (stackTrace != null) {
            element.setValue(stackTrace);
        }
        this.addOutputStreamElement(out, "system-out", testCase);
        this.addOutputStreamElement(err, "system-err", testCase);
        if (log != null) {
            this.addOutputStreamElement(log, "log-service", testCase);
        }
        this.m_results.add(testCase);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generateReport(Test test, TestResult tr, File reportsDirectory, BundleContext bc, Map configuration) throws Exception {
        long runTime = this.m_endTime - this.m_startTime;
        Xpp3Dom testSuite = this.createTestSuiteElement(test, runTime);
        this.showProperties(testSuite, bc, configuration);
        testSuite.setAttribute("tests", String.valueOf(tr.runCount()));
        testSuite.setAttribute("errors", String.valueOf(tr.errorCount()));
        testSuite.setAttribute("failures", String.valueOf(tr.failureCount()));
        Iterator i = this.m_results.iterator();
        while (i.hasNext()) {
            Xpp3Dom testcase = (Xpp3Dom)i.next();
            testSuite.addChild(testcase);
        }
        File reportFile = new File(reportsDirectory, "TEST-" + XMLReport.getReportName(test).replace(' ', '_') + ".xml");
        File reportDir = reportFile.getParentFile();
        reportDir.mkdirs();
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(reportFile), "UTF-8")));
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>" + NL);
            Xpp3DomWriter.write((XMLWriter)new PrettyPrintXMLWriter(writer), (Xpp3Dom)testSuite);
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new Exception("Unable to use UTF-8 encoding", e);
                catch (FileNotFoundException e2) {
                    throw new Exception("Unable to create file: " + e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close((Writer)writer);
    }

    private Xpp3Dom createTestElement(Test test, long runTime) {
        Xpp3Dom testCase = new Xpp3Dom("testcase");
        testCase.setAttribute("name", XMLReport.getReportName(test));
        testCase.setAttribute("time", Long.toString(runTime) + " sec");
        return testCase;
    }

    private Xpp3Dom createTestSuiteElement(Test test, long runTime) {
        Xpp3Dom testCase = new Xpp3Dom("testsuite");
        testCase.setAttribute("name", XMLReport.getReportName(test));
        testCase.setAttribute("time", Long.toString(runTime) + " sec");
        return testCase;
    }

    private static String getReportName(Test test) {
        String report = test.toString();
        if (report.indexOf("(") > 0) {
            report = report.substring(0, report.indexOf("("));
        }
        return report;
    }

    private Xpp3Dom createElement(Xpp3Dom element, String name) {
        Xpp3Dom component = new Xpp3Dom(name);
        element.addChild(component);
        return component;
    }

    private void showProperties(Xpp3Dom testSuite, BundleContext bc, Map configuration) {
        String key;
        Xpp3Dom properties = this.createElement(testSuite, "properties");
        Properties systemProperties = System.getProperties();
        if (systemProperties != null) {
            Enumeration<?> propertyKeys = systemProperties.propertyNames();
            while (propertyKeys.hasMoreElements()) {
                key = (String)propertyKeys.nextElement();
                String value = systemProperties.getProperty(key);
                if (value == null) {
                    value = "null";
                }
                Xpp3Dom property = this.createElement(properties, "property");
                property.setAttribute("name", key);
                property.setAttribute("value", value);
            }
        }
        if (configuration != null) {
            Iterator it = configuration.keySet().iterator();
            while (it.hasNext()) {
                key = (String)it.next();
                Object obj = configuration.get(key);
                String value = null;
                value = obj == null ? "null" : (obj instanceof String ? (String)obj : obj.toString());
                Xpp3Dom property = this.createElement(properties, "property");
                property.setAttribute("name", key);
                property.setAttribute("value", value);
            }
        }
        Xpp3Dom buns = this.createElement(properties, "bundles");
        Bundle[] bundles = bc.getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            String sn = bundles[i].getSymbolicName();
            String state = "UNKNOWN";
            switch (bundles[i].getState()) {
                case 32: {
                    state = "ACTIVE";
                    break;
                }
                case 2: {
                    state = "INSTALLED";
                    break;
                }
                case 4: {
                    state = "RESOLVED";
                    break;
                }
                case 1: {
                    state = "UNINSTALLED";
                    break;
                }
            }
            Xpp3Dom bundle = this.createElement(buns, "bundle");
            bundle.setAttribute("symbolic-name", sn);
            bundle.setAttribute("state", state);
        }
    }

    private void addOutputStreamElement(String stdOut, String name, Xpp3Dom testCase) {
        if (stdOut != null && stdOut.trim().length() > 0) {
            this.createElement(testCase, name).setValue(stdOut);
        }
    }
}

