/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.components;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.component.html.HtmlOutputLabel;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.data.Column;
import org.apache.empire.jsf2.controls.InputControl;
import org.apache.empire.jsf2.utils.ControlRenderInfo;
import org.apache.empire.jsf2.utils.StyleClass;
import org.apache.empire.jsf2.utils.TagEncodingHelper;
import org.apache.empire.jsf2.utils.TagEncodingHelperFactory;
import org.apache.empire.jsf2.utils.TagStyleClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlTag
extends UIInput
implements NamingContainer,
TagEncodingHelperFactory.TagEncodingHolder {
    private static final Logger log = LoggerFactory.getLogger(ControlTag.class);
    protected static final String readOnlyState = "readOnlyState";
    protected final TagEncodingHelper helper = TagEncodingHelperFactory.create((UIOutput)this, TagStyleClass.INPUT.get());
    protected InputControl control = null;
    protected InputControl.InputInfo inpInfo = null;
    protected ControlRenderInfo renderInfo = null;
    protected boolean submittedValueDetected = false;
    protected Object submittedValue;
    protected boolean valueValidated = false;
    protected boolean controlVisible = true;
    protected String treeClientId = null;

    public String getFamily() {
        return "javax.faces.NamingContainer";
    }

    @Override
    public TagEncodingHelper getEncodingHelper() {
        return this.helper;
    }

    protected void saveState() {
        this.getStateHelper().put((Serializable)((Object)readOnlyState), (Object)(this.inpInfo == null ? 1 : 0));
    }

    protected boolean initInputState(FacesContext context) {
        if (this.getChildCount() <= 1) {
            return false;
        }
        Boolean ros = (Boolean)this.getStateHelper().get((Serializable)((Object)readOnlyState));
        if (ros != null && ros.booleanValue()) {
            return false;
        }
        if (this.getChildCount() == 0) {
            log.warn("ControlTag '{}' has no children. encodeBegin may not have been called yet.", (Object)this.getClientId());
            return false;
        }
        this.helper.prepareData();
        this.control = this.helper.getInputControl();
        this.inpInfo = this.helper.getInputInfo(context);
        return this.control != null && this.inpInfo != null;
    }

    public String getId() {
        String compId = super.getId();
        if ("null".equals(compId)) {
            compId = this.helper.completeInputTagId(null);
        }
        return compId;
    }

    public void setId(String id) {
        id = this.helper.completeInputTagId(id);
        super.setId(id);
    }

    public void setParent(UIComponent parent) {
        super.setParent(parent);
        if (this.helper.hasComponentId()) {
            return;
        }
        String autoId = this.helper.getAutoControlId();
        if (autoId != null) {
            this.setId(autoId);
            log.debug("Auto-Setting compontent id for Control to {}", (Object)this.getId());
        }
    }

    public boolean visitTree(VisitContext visitContext, VisitCallback callback) {
        FacesContext context = visitContext.getFacesContext();
        this.treeClientId = this.getClientId(context);
        return super.visitTree(visitContext, callback);
    }

    public String getClientId(FacesContext context) {
        if (this.treeClientId != null && this.control != null && this.control.isCreatingComponents()) {
            return this.treeClientId;
        }
        return super.getClientId(context);
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
        this.helper.encodeBegin();
        if (this.control == null) {
            this.control = this.helper.getInputControl();
        }
        if (this.renderInfo == null) {
            this.renderInfo = this.helper.getControlRenderInfo();
            if (this.renderInfo == null) {
                this.renderInfo = ControlRenderInfo.getDefault();
            }
        }
        this.controlVisible = this.helper.isVisible();
        if (this.controlVisible && this.renderInfo.CONTROL_TAG != null) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement(this.renderInfo.CONTROL_TAG, (UIComponent)this);
            this.helper.writeComponentId(writer, false);
            String controlClass = this.helper.getTagAttributeStringEx("controlClass", true);
            String styleClass = this.helper.getTagAttributeString("styleClass");
            String contextClass = this.helper.getContextStyleClass();
            this.helper.writeStyleClass(writer, TagStyleClass.CONTROL.get(), controlClass, styleClass, contextClass);
        } else if (!this.controlVisible) {
            this.renderInfo.renderPlaceholder(context, this);
        }
        boolean customInput = this.isCustomInput();
        ControlSeparatorComponent labelSepTag = null;
        if (this.getChildCount() > 0) {
            labelSepTag = (ControlSeparatorComponent)((Object)this.getChildren().get(0));
        }
        if (labelSepTag == null) {
            labelSepTag = new LabelSeparatorComponent();
            this.getChildren().add(labelSepTag);
            this.helper.resetComponentId((UIComponent)labelSepTag);
        }
        labelSepTag.setRendered(this.controlVisible);
        this.encodeLabel(context, labelSepTag, customInput);
        ControlSeparatorComponent inputSepTag = null;
        if (!customInput) {
            if (this.getChildCount() > 1) {
                inputSepTag = (ControlSeparatorComponent)((Object)this.getChildren().get(1));
            }
            if (inputSepTag == null) {
                inputSepTag = new InputSeparatorComponent();
                this.getChildren().add(inputSepTag);
                this.helper.resetComponentId((UIComponent)inputSepTag);
            }
            inputSepTag.setRendered(this.controlVisible);
            this.encodeInput(context, (UIComponent)inputSepTag);
        } else if (this.getChildCount() > 1) {
            this.getChildren().remove(1);
        }
        if (labelSepTag != null) {
            labelSepTag.encodeAll(context);
        }
        if (inputSepTag != null) {
            inputSepTag.encodeAll(context);
        }
        this.saveState();
    }

    public void encodeChildren(FacesContext context) throws IOException {
        if (this.controlVisible && this.isCustomInput()) {
            ResponseWriter writer = null;
            String tagName = this.renderInfo.INPUT_WRAPPER_TAG;
            if (tagName != null && tagName.length() > 0) {
                String colSpan;
                writer = context.getResponseWriter();
                writer.startElement(tagName, (UIComponent)this);
                String inpClass = this.helper.getTagAttributeStringEx("inputClass", true);
                this.helper.writeStyleClass(writer, TagStyleClass.CONTROL_INPUT.get(), inpClass);
                String string = colSpan = tagName.equalsIgnoreCase("td") ? this.helper.getTagAttributeStringEx("colspan", false) : null;
                if (colSpan != null) {
                    writer.writeAttribute("colspan", (Object)colSpan, null);
                }
            }
            super.encodeChildren(context);
            if (writer != null) {
                writer.endElement(tagName);
            }
        }
    }

    public void encodeEnd(FacesContext context) throws IOException {
        if (this.controlVisible && this.renderInfo.CONTROL_TAG != null) {
            ResponseWriter writer = context.getResponseWriter();
            writer.endElement(this.renderInfo.CONTROL_TAG);
        }
        super.encodeEnd(context);
    }

    public boolean isCustomInput() {
        Object custom = this.getAttributes().get("custom");
        if (custom != null) {
            return ObjectUtils.getBoolean(custom);
        }
        return false;
    }

    protected void encodeLabel(FacesContext context, UIComponentBase parent, boolean customInput) throws IOException {
        UIComponent labelFacet = this.getFacet("label");
        if (labelFacet != null) {
            return;
        }
        HtmlOutputLabel labelComponent = null;
        if (parent.getChildCount() == 0) {
            String forInput = customInput ? this.helper.getTagAttributeString("for") : "*";
            StyleClass styleClass = new StyleClass((Object)TagStyleClass.LABEL);
            labelComponent = this.helper.createLabelComponent(context, forInput, styleClass, null, this.getColon());
            parent.getChildren().add(0, labelComponent);
            this.helper.resetComponentId((UIComponent)labelComponent);
        } else if (this.controlVisible) {
            labelComponent = (HtmlOutputLabel)parent.getChildren().get(0);
            this.helper.updateLabelComponent(context, labelComponent, null);
        }
    }

    protected void encodeInput(FacesContext context, UIComponent parent) throws IOException {
        int count = parent.getChildCount();
        Object valueComp = count > 0 ? (UIComponent)parent.getChildren().get(count - 1) : null;
        boolean resetChildId = count == 0;
        this.inpInfo = this.helper.getInputInfo(context);
        super.setRequired(this.controlVisible && this.helper.isValueRequired());
        if (count == 0) {
            this.control.createInput(parent, this.inpInfo, context);
            if (valueComp == null) {
                valueComp = new ValueOutputComponent();
                parent.getChildren().add(valueComp);
            }
        } else if (this.controlVisible) {
            this.control.updateInputState(parent, this.inpInfo, context, context.getCurrentPhaseId());
        }
        boolean renderValue = this.helper.isRenderValueComponent();
        List children = parent.getChildren();
        for (UIComponent child : children) {
            boolean valueOutput;
            if (resetChildId && child.getId() != null) {
                child.setId(child.getId());
            }
            child.setRendered((valueOutput = child instanceof ValueOutputComponent) ? renderValue : !renderValue);
        }
    }

    public void renderInput(FacesContext context, UIComponent parent, boolean allowWrapper) throws IOException {
        if (allowWrapper) {
            boolean renderValue = this.helper.isRenderValueComponent();
            String wrapperTag = this.helper.writeWrapperTag(context, false, renderValue);
            this.control.renderInput(parent, this.inpInfo, context);
            if (wrapperTag != null) {
                ResponseWriter writer = context.getResponseWriter();
                writer.endElement(wrapperTag);
            }
        } else {
            this.control.renderInput(parent, this.inpInfo, context);
        }
    }

    public Object getValue() {
        if (this.helper.getRecord() != null) {
            return this.helper.getDataValue(true);
        }
        Object value = super.getValue();
        return value;
    }

    public Object getSubmittedValue() {
        if (this.submittedValueDetected) {
            return this.submittedValue;
        }
        if (this.getChildCount() <= 1) {
            return null;
        }
        if (this.control == null || this.inpInfo == null || this.helper.isReadOnly()) {
            return null;
        }
        ControlSeparatorComponent inputSepTag = (ControlSeparatorComponent)((Object)this.getChildren().get(1));
        this.submittedValue = this.control.getInputValue((UIComponent)inputSepTag, this.inpInfo, true);
        this.submittedValueDetected = true;
        return this.submittedValue;
    }

    public void setSubmittedValue(Object submittedValue) {
        this.submittedValue = submittedValue;
        this.submittedValueDetected = true;
    }

    protected Object getConvertedValue(FacesContext context, Object newSubmittedValue) throws ConverterException {
        if (this.control == null || this.inpInfo == null || this.helper.isReadOnly()) {
            return null;
        }
        if (this.getChildCount() <= 1) {
            return null;
        }
        try {
            ControlSeparatorComponent inputSepTag = (ControlSeparatorComponent)((Object)this.getChildren().get(1));
            return this.control.getConvertedValue((UIComponent)inputSepTag, this.inpInfo, newSubmittedValue);
        }
        catch (Exception e) {
            FacesMessage msg = this.helper.getFieldValueErrorMessage(context, e, newSubmittedValue);
            throw new ConverterException(msg);
        }
    }

    public void processDecodes(FacesContext context) {
        if (this.getChildCount() > 1 && this.helper.isInsideUIData()) {
            this.updateControlInputState(context);
            boolean renderValue = this.helper.isRenderValueComponent();
            this.setRenderInput(!renderValue);
        }
        super.processDecodes(context);
    }

    public void processValidators(FacesContext context) {
        this.resetSubmittedValue();
        if (this.getChildCount() > 1 && this.helper.isInsideUIData()) {
            this.updateControlInputState(context);
            boolean hasValue = this.getSubmittedValue() != null;
            this.setRenderInput(hasValue);
        }
        super.processValidators(context);
    }

    public void validate(FacesContext context) {
        if (!this.initInputState(context)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Validating input for {}.", (Object)this.inpInfo.getColumn().getName());
        }
        this.resetSubmittedValue();
        this.valueValidated = false;
        super.validate(context);
        if (this.isValid() && !this.valueValidated && !this.helper.isReadOnly() && !this.helper.isDisabled()) {
            Object value = this.helper.getDataValue(true);
            log.warn("No Submitted value for {}. Validating Record value of \"{}\" instead.", (Object)this.helper.getColumnName(), value);
            if (value != null) {
                this.validateValue(context, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateValue(FacesContext context, Object value) {
        try {
            if (this.inpInfo == null || !this.isValid()) {
                return;
            }
            if (this.helper.beginValidateValue(context, value)) {
                this.inpInfo.validate(value);
            }
            this.setValid(true);
        }
        catch (Exception e) {
            this.helper.addFieldValueErrorMessage(context, e, value);
            this.setValid(false);
        }
        finally {
            this.valueValidated = true;
        }
    }

    public void processUpdates(FacesContext context) {
        if (this.getChildCount() <= 1) {
            super.processUpdates(context);
            return;
        }
        try {
            this.pushComponentToEL(context, (UIComponent)this);
            if (!this.isRendered()) {
                return;
            }
            try {
                this.updateModel(context);
            }
            catch (RuntimeException e) {
                context.renderResponse();
                throw e;
            }
            if (!this.isValid()) {
                context.renderResponse();
            }
        }
        finally {
            this.popComponentFromEL(context);
        }
    }

    public void updateModel(FacesContext context) {
        if (!this.initInputState(context)) {
            return;
        }
        if (!this.isValid() || !this.isLocalValueSet()) {
            return;
        }
        Object value = this.getLocalValue();
        if (this.helper.beginUpdateModel(context, value)) {
            log.debug("Updating model input for {}.", (Object)this.inpInfo.getColumn().getName());
            this.inpInfo.setValue(value);
        }
        this.setValue(null);
        this.setLocalValueSet(false);
        if (this.getChildCount() <= 1) {
            return;
        }
        ControlSeparatorComponent inputSepTag = (ControlSeparatorComponent)((Object)this.getChildren().get(1));
        this.control.postUpdateModel((UIComponent)inputSepTag, this.inpInfo, context);
    }

    public InputControl getInputControl() {
        return this.control;
    }

    public Column getInputColumn() {
        return this.helper.getColumn();
    }

    public boolean isInputReadOnly() {
        return this.helper.isRecordReadOnly();
    }

    public boolean isInputRequired() {
        return this.helper.isValueRequired();
    }

    protected void resetSubmittedValue() {
        this.submittedValueDetected = false;
        this.submittedValue = null;
    }

    protected void updateControlInputState(FacesContext context) {
        if (this.getChildCount() <= 1) {
            return;
        }
        this.helper.prepareData();
        if (this.control == null) {
            this.control = this.helper.getInputControl();
        }
        if (this.inpInfo == null) {
            this.inpInfo = this.helper.getInputInfo(context);
        }
        ControlSeparatorComponent inputSepTag = (ControlSeparatorComponent)((Object)this.getChildren().get(1));
        this.control.updateInputState((UIComponent)inputSepTag, this.inpInfo, context, context.getCurrentPhaseId());
    }

    protected void setRenderInput(boolean renderInput) {
        if (this.getChildCount() <= 1) {
            return;
        }
        if (this.getChildren().get(1) instanceof InputSeparatorComponent) {
            boolean hasChanged = false;
            InputSeparatorComponent parent = (InputSeparatorComponent)((Object)this.getChildren().get(1));
            for (UIComponent child : parent.getChildren()) {
                boolean rendered;
                boolean bl = child instanceof ValueOutputComponent ? !renderInput : (rendered = renderInput);
                if (child.isRendered() == rendered) continue;
                child.setRendered(rendered);
                hasChanged = true;
            }
            if (hasChanged && log.isDebugEnabled()) {
                log.debug("Changing UIInput readOnly state for {} to {}", (Object)this.helper.getColumnName(), (Object)renderInput);
            }
        } else {
            log.warn("Control-Tag does not have separate Label and Input components");
        }
    }

    protected boolean getColon() {
        Object colon = this.getAttributes().get("colon");
        if (colon != null) {
            return ObjectUtils.getBoolean(colon);
        }
        return true;
    }

    public static class ValueOutputComponent
    extends UIComponentBase {
        private final String tagName = "span";

        public String getFamily() {
            return "javax.faces.NamingContainer";
        }

        public void encodeBegin(FacesContext context) throws IOException {
            super.encodeBegin(context);
            UIComponent parent = this.getParent();
            if (!(parent instanceof ControlTag)) {
                parent = parent.getParent();
            }
            if (!(parent instanceof ControlTag)) {
                parent = parent.getParent();
            }
            if (!(parent instanceof ControlTag)) {
                log.error("Invalid parent component for " + ((Object)((Object)this)).getClass().getName());
                return;
            }
            ControlTag controlTag = (ControlTag)parent;
            if (!controlTag.controlVisible) {
                return;
            }
            InputControl control = controlTag.control;
            InputControl.ValueInfo valInfo = controlTag.inpInfo;
            TagEncodingHelper helper = controlTag.helper;
            if (control == null) {
                control = helper.getInputControl();
            }
            if (valInfo == null) {
                valInfo = helper.getValueInfo(context);
            }
            StyleClass styleClass = helper.getTagStyleClass();
            styleClass.add((Object)TagStyleClass.INPUT_DIS);
            String tooltip = helper.getValueTooltip(helper.getTagAttributeValue("title"));
            control.renderValue((UIComponent)this, this.tagName, styleClass, tooltip, valInfo, context);
        }
    }

    public static class InputSeparatorComponent
    extends ControlSeparatorComponent {
        @Override
        protected String getTagName(ControlRenderInfo renderInfo) {
            return renderInfo.INPUT_WRAPPER_TAG;
        }

        @Override
        protected void writeAttributes(ResponseWriter writer) throws IOException {
            this.control.renderInfo.writeInputWrapperAttributes(writer, this.control.helper);
        }

        public void encodeChildren(FacesContext context) throws IOException {
            this.control.renderInput(context, (UIComponent)this, this.tagName == null);
        }
    }

    public static class LabelSeparatorComponent
    extends ControlSeparatorComponent {
        @Override
        protected String getTagName(ControlRenderInfo renderInfo) {
            return renderInfo.LABEL_WRAPPER_TAG;
        }

        @Override
        protected void writeAttributes(ResponseWriter writer) throws IOException {
            this.control.renderInfo.writeLabelWrapperAttributes(writer, this.control.helper);
        }

        public void encodeChildren(FacesContext context) throws IOException {
            UIComponent labelFacet = this.getControl().getFacet("label");
            if (labelFacet != null) {
                labelFacet.encodeAll(context);
            } else {
                super.encodeChildren(context);
            }
        }
    }

    public static abstract class ControlSeparatorComponent
    extends UIComponentBase {
        protected ControlTag control = null;
        protected String tagName = null;

        protected abstract String getTagName(ControlRenderInfo var1);

        protected abstract void writeAttributes(ResponseWriter var1) throws IOException;

        public String getFamily() {
            return "javax.faces.NamingContainer";
        }

        protected final ControlTag getControl() {
            return this.control;
        }

        public void encodeBegin(FacesContext context) throws IOException {
            super.encodeBegin(context);
            UIComponent parent = this.getParent();
            if (!(parent instanceof ControlTag)) {
                parent = parent.getParent();
            }
            if (!(parent instanceof ControlTag)) {
                log.error("Invalid parent component for " + ((Object)((Object)this)).getClass().getName());
                return;
            }
            this.control = (ControlTag)parent;
            String string = this.tagName = this.control.controlVisible ? this.getTagName(this.control.renderInfo) : null;
            if (this.tagName != null && this.tagName.length() > 0) {
                ResponseWriter writer = context.getResponseWriter();
                writer.startElement(this.tagName, (UIComponent)this);
                this.writeAttributes(writer);
            }
        }

        public void encodeEnd(FacesContext context) throws IOException {
            if (this.tagName != null && this.tagName.length() > 0) {
                ResponseWriter writer = context.getResponseWriter();
                writer.endElement(this.tagName);
            }
            super.encodeEnd(context);
        }

        public boolean getRendersChildren() {
            return this.control.helper.isVisible();
        }
    }
}

