/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.dialogs.properties;

import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.common.ui.widgets.WidgetModifyEvent;
import org.apache.directory.studio.common.ui.widgets.WidgetModifyListener;
import org.apache.directory.studio.connection.core.Utils;
import org.apache.directory.studio.ldapbrowser.common.widgets.search.SearchPageWrapper;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.events.SearchUpdateEvent;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.impl.Search;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIConstants;
import org.apache.directory.studio.ldapbrowser.ui.dialogs.properties.Messages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

public class SearchPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage,
WidgetModifyListener {
    private ISearch search;
    private SearchPageWrapper spw;

    public void dispose() {
        this.spw.removeWidgetModifyListener((WidgetModifyListener)this);
        super.dispose();
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(BrowserUIConstants.PLUGIN_ID) + "." + "tools_search_properties");
        ISearch search = (ISearch)this.getElement();
        this.search = search != null ? search : new Search();
        super.setMessage(String.valueOf(Messages.getString("SearchPropertyPage.Search")) + Utils.shorten((String)search.getName(), (int)30));
        Composite composite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)3, (int)1);
        this.spw = new SearchPageWrapper(16);
        this.spw.createContents(composite);
        this.spw.loadFromSearch(search);
        this.spw.addWidgetModifyListener((WidgetModifyListener)this);
        this.widgetModified(new WidgetModifyEvent((Object)this));
        return composite;
    }

    public boolean performOk() {
        boolean modified = this.spw.saveToSearch(this.search);
        if (modified && this.search.getBrowserConnection() != null) {
            EventRegistry.fireSearchUpdated((SearchUpdateEvent)new SearchUpdateEvent(this.search, SearchUpdateEvent.EventDetail.SEARCH_PARAMETER_UPDATED), (Object)((Object)this));
            return this.spw.performSearch(this.search);
        }
        return true;
    }

    public void widgetModified(WidgetModifyEvent event) {
        this.setValid(this.spw.isValid());
        this.setErrorMessage(this.spw.getErrorMessage());
    }
}

