/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.util.Strings;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;

public class AttributeDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String description;
    private String parsedAttributeType;
    private List<String> parsedLangList;
    private List<String> parsedOptionList;

    public AttributeDescription(String description) {
        this.description = description;
        String[] attributeDescriptionComponents = description.split(";");
        this.parsedAttributeType = attributeDescriptionComponents[0];
        this.parsedLangList = new ArrayList<String>();
        this.parsedOptionList = new ArrayList<String>();
        int i = 1;
        while (i < attributeDescriptionComponents.length) {
            String component = attributeDescriptionComponents[i];
            if (component.startsWith("lang-")) {
                this.parsedLangList.add(component);
            } else {
                this.parsedOptionList.add(component);
            }
            ++i;
        }
    }

    public String getDescription() {
        return this.description;
    }

    public String getParsedAttributeType() {
        return this.parsedAttributeType;
    }

    public List<String> getParsedLangList() {
        return this.parsedLangList;
    }

    public List<String> getParsedOptionList() {
        return this.parsedOptionList;
    }

    public String toOidString(Schema schema) {
        String element;
        Iterator<String> it;
        if (schema == null) {
            return this.description;
        }
        AttributeType atd = schema.getAttributeTypeDescription(this.parsedAttributeType);
        String oidString = atd.getOid();
        if (!this.parsedLangList.isEmpty()) {
            it = this.parsedLangList.iterator();
            while (it.hasNext()) {
                element = it.next();
                oidString = String.valueOf(oidString) + element;
                if (!it.hasNext() && this.parsedOptionList.isEmpty()) continue;
                oidString = String.valueOf(oidString) + ";";
            }
        }
        if (!this.parsedOptionList.isEmpty()) {
            it = this.parsedOptionList.iterator();
            while (it.hasNext()) {
                element = it.next();
                oidString = String.valueOf(oidString) + element;
                if (!it.hasNext()) continue;
                oidString = String.valueOf(oidString) + ";";
            }
        }
        return oidString;
    }

    public boolean isSubtypeOf(AttributeDescription other, Schema schema) {
        if (this.toOidString(schema).equals(other.toOidString(schema))) {
            return false;
        }
        AttributeType myAtd = schema.getAttributeTypeDescription(this.getParsedAttributeType());
        AttributeType otherAtd = schema.getAttributeTypeDescription(other.getParsedAttributeType());
        if ("*".equals(other.description) && !SchemaUtils.isOperational(myAtd)) {
            return true;
        }
        if ("+".equals(other.description) && SchemaUtils.isOperational(myAtd)) {
            return true;
        }
        if (other.description.length() > 1 && other.description.startsWith("@")) {
            String objectClass = other.description.substring(1);
            ObjectClass ocd = schema.getObjectClassDescription(objectClass);
            ocd.getMayAttributeTypes();
            ocd.getMustAttributeTypes();
            HashSet<String> names = new HashSet<String>();
            names.addAll(SchemaUtils.getMayAttributeTypeDescriptionNamesTransitive(ocd, schema));
            names.addAll(SchemaUtils.getMustAttributeTypeDescriptionNamesTransitive(ocd, schema));
            for (String name : names) {
                AttributeType atd = schema.getAttributeTypeDescription(name);
                if (myAtd != atd) continue;
                return true;
            }
        }
        if (myAtd != otherAtd) {
            AttributeType superiorAtd = null;
            String superiorName = myAtd.getSuperiorOid();
            while (superiorName != null) {
                superiorAtd = schema.getAttributeTypeDescription(superiorName);
                if (superiorAtd == otherAtd) break;
                superiorName = superiorAtd.getSuperiorOid();
            }
            if (superiorAtd != otherAtd) {
                return false;
            }
        }
        ArrayList<String> myOptionsList = new ArrayList<String>(this.getParsedOptionList());
        ArrayList<String> otherOptionsList = new ArrayList<String>(other.getParsedOptionList());
        otherOptionsList.removeAll(myOptionsList);
        if (!otherOptionsList.isEmpty()) {
            return false;
        }
        ArrayList<String> myLangList = new ArrayList<String>(this.getParsedLangList());
        ArrayList<String> otherLangList = new ArrayList<String>(other.getParsedLangList());
        for (String myLang : myLangList) {
            Iterator otherIt = otherLangList.iterator();
            while (otherIt.hasNext()) {
                String otherLang = (String)otherIt.next();
                if (otherLang.endsWith("-")) {
                    if (!Strings.toLowerCase((String)myLang).startsWith(Strings.toLowerCase((String)otherLang))) continue;
                    otherIt.remove();
                    continue;
                }
                if (!myLang.equalsIgnoreCase(otherLang)) continue;
                otherIt.remove();
            }
        }
        return otherLangList.isEmpty();
    }
}

