/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.rest;

import java.lang.annotation.Annotation;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.interceptor.security.SimpleAuthorizingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FortressInterceptor
extends SimpleAuthorizingInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger((String)FortressInterceptor.class.getName());
    private static final String DEFAULT_ANNOTATION_CLASS_NAME = "jakarta.annotation.security.RolesAllowed";
    private static final Set<String> SKIP_METHODS = new HashSet();
    private String annotationClassName = "jakarta.annotation.security.RolesAllowed";

    public void setAnnotationClassName(String name) {
        try {
            LOG.info("FortressInterceptor.setAnnotationClassName:" + name);
            ClassLoaderUtils.loadClass((String)name, FortressInterceptor.class);
            this.annotationClassName = name;
        }
        catch (ClassNotFoundException ex) {
            LOG.info("FortressInterceptor.setAnnotationClassName caught ClassNotFoundException-" + ex);
        }
    }

    public void setSecuredObject(Object object) {
        LOG.info("FortressInterceptor.setSecuredObject:" + object);
        Class cls = ClassHelper.getRealClass((Object)object);
        HashMap rolesMap = new HashMap();
        this.findRoles(cls, rolesMap);
        if (rolesMap.isEmpty()) {
            LOG.info("FortressInterceptor.setSecuredObject The roles map is empty, the service object is not protected");
        } else if (LOG.isDebugEnabled()) {
            for (Map.Entry entry : rolesMap.entrySet()) {
                LOG.debug("FortressInterceptor.setSecuredObject Method: " + (String)entry.getKey() + ", roles: " + (String)entry.getValue());
            }
        }
        super.setMethodRolesMap(rolesMap);
    }

    protected void findRoles(Class<?> cls, Map<String, String> rolesMap) {
        LOG.info("FortressInterceptor.findRoles:" + rolesMap);
        if (cls == null || cls == Object.class) {
            return;
        }
        String classRolesAllowed = this.getRoles(cls.getAnnotations(), this.annotationClassName);
        for (Method method : cls.getMethods()) {
            if (SKIP_METHODS.contains(method.getName())) continue;
            String methodRolesAllowed = this.getRoles(method.getAnnotations(), this.annotationClassName);
            if (methodRolesAllowed != null) {
                rolesMap.put(method.getName(), methodRolesAllowed);
                continue;
            }
            if (classRolesAllowed == null) continue;
            rolesMap.put(method.getName(), classRolesAllowed);
        }
        if (!rolesMap.isEmpty()) {
            return;
        }
        this.findRoles(cls.getSuperclass(), rolesMap);
        if (!rolesMap.isEmpty()) {
            return;
        }
        for (GenericDeclaration genericDeclaration : cls.getInterfaces()) {
            this.findRoles((Class)genericDeclaration, rolesMap);
        }
    }

    private String getRoles(Annotation[] anns, String annName) {
        LOG.debug("FortressInterceptor.getRoles:" + annName);
        for (Annotation ann : anns) {
            if (!ann.annotationType().getName().equals(annName)) continue;
            try {
                Method valueMethod = ann.annotationType().getMethod("value", new Class[0]);
                String[] roles = (String[])valueMethod.invoke((Object)ann, new Object[0]);
                StringBuilder sb = new StringBuilder();
                boolean isFirst = false;
                for (String role : roles) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        sb.append(" ");
                    }
                    sb.append(role);
                }
                return sb.toString();
            }
            catch (NoSuchMethodException ex) {
                LOG.info("FortressInterceptor.getRoles annName=" + annName + ", caught NoSuchMethodException=" + ex);
                break;
            }
            catch (IllegalAccessException ex) {
                LOG.info("FortressInterceptor.getRoles annName=" + annName + ", caught IllegalAccessException=" + ex);
                break;
            }
            catch (InvocationTargetException ex) {
                LOG.info("FortressInterceptor.getRoles annName=" + annName + ", caught InvocationTargetException=" + ex);
                break;
            }
        }
        return null;
    }

    static {
        SKIP_METHODS.addAll(Arrays.asList("wait", "notify", "notifyAll", "equals", "toString", "hashCode"));
    }
}

