/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.rest;

import java.util.List;
import org.apache.directory.fortress.core.GroupMgr;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.impl.Manageable;
import org.apache.directory.fortress.core.model.FortRequest;
import org.apache.directory.fortress.core.model.FortResponse;
import org.apache.directory.fortress.core.model.Group;
import org.apache.directory.fortress.core.model.Role;
import org.apache.directory.fortress.core.model.User;
import org.apache.directory.fortress.core.model.UserRole;
import org.apache.directory.fortress.core.rest.RestUtils;
import org.apache.directory.fortress.core.util.VUtil;

public class GroupMgrRestImpl
extends Manageable
implements GroupMgr {
    private static final String CLS_NM = GroupMgrRestImpl.class.getName();

    @Override
    public Group add(Group group) throws SecurityException {
        VUtil.assertNotNull(group, 10308, CLS_NM + ".add");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(group);
        if (this.adminSess != null) {
            // empty if block
        }
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "groupAdd");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        Group retGroup = (Group)response.getEntity();
        return retGroup;
    }

    @Override
    public Group update(Group group) throws SecurityException {
        VUtil.assertNotNull(group, 10308, CLS_NM + ".update");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(group);
        if (this.adminSess != null) {
            // empty if block
        }
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "groupUpdate");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        Group retGroup = (Group)response.getEntity();
        return retGroup;
    }

    @Override
    public Group delete(Group group) throws SecurityException {
        VUtil.assertNotNull(group, 10308, CLS_NM + ".delete");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(group);
        if (this.adminSess != null) {
            // empty if block
        }
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "groupDelete");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        Group retGroup = (Group)response.getEntity();
        return retGroup;
    }

    @Override
    public Group add(Group group, String key, String value) throws SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Group delete(Group group, String key, String value) throws SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Group read(Group group) throws SecurityException {
        VUtil.assertNotNull(group, 10308, CLS_NM + ".read");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(group);
        if (this.adminSess != null) {
            request.setSession(this.adminSess);
        }
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "groupRead");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        Group retGroup = (Group)response.getEntity();
        return retGroup;
    }

    @Override
    public List<Group> find(Group group) throws SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Group> find(User user) throws SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Group> roleGroups(Role role) throws SecurityException {
        VUtil.assertNotNull(role, 5007, CLS_NM + ".roleGroups");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(role);
        if (this.adminSess != null) {
            request.setSession(this.adminSess);
        }
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "groupAsigned");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        List<Group> retGroups = response.getEntities();
        return retGroups;
    }

    @Override
    public List<UserRole> groupRoles(Group group) throws SecurityException {
        VUtil.assertNotNull(group, 10308, CLS_NM + ".groupRoles");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(group);
        if (this.adminSess != null) {
            request.setSession(this.adminSess);
        }
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "roleGroupAsigned");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        List<UserRole> retRoles = response.getEntities();
        return retRoles;
    }

    @Override
    public Group assign(Group group, String member) throws SecurityException {
        VUtil.assertNotNull(group, 10308, CLS_NM + ".assign");
        VUtil.assertNotNull(member, 10315, CLS_NM + ".assign");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(group);
        request.setValue(member);
        if (this.adminSess != null) {
            // empty if block
        }
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "groupAsgn");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        Group retGroup = (Group)response.getEntity();
        return retGroup;
    }

    @Override
    public Group deassign(Group group, String member) throws SecurityException {
        VUtil.assertNotNull(group, 10308, CLS_NM + ".deassign");
        VUtil.assertNotNull(member, 10315, CLS_NM + ".deassign");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(group);
        request.setValue(member);
        if (this.adminSess != null) {
            // empty if block
        }
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "groupDeasgn");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        Group retGroup = (Group)response.getEntity();
        return retGroup;
    }
}

