/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.apache.directory.fortress.core.model.FortEntity;
import org.apache.directory.fortress.core.model.Props;

@XmlRootElement(name="fortConfiguration")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="configuration", propOrder={"name", "props", "uidNumber", "gidNumber"})
public class Configuration
extends FortEntity {
    private String name;
    private Props props = new Props();
    private String uidNumber;
    private String gidNumber;

    public Configuration() {
    }

    public Configuration(String name, Properties props) {
        this.name = name;
        this.addProperties(props);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Props getProps() {
        return this.props;
    }

    public void setProps(Props value) {
        this.props = value;
    }

    public void addProperty(String key, String value) {
        Props.Entry entry = new Props.Entry();
        entry.setKey(key);
        entry.setValue(value);
        this.props.getEntry().add(entry);
    }

    public String getProperty(String key) {
        List<Props.Entry> props = this.props.getEntry();
        Props.Entry keyObj = new Props.Entry();
        keyObj.setKey(key);
        String value = null;
        int indx = props.indexOf(keyObj);
        if (indx != -1) {
            Props.Entry entry = props.get(props.indexOf(keyObj));
            value = entry.getValue();
        }
        return value;
    }

    public void addProperties(Properties props) {
        if (props != null) {
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String val = props.getProperty(key);
                this.addProperty(key, val);
            }
        }
    }

    public Properties getProperties() {
        Properties properties = null;
        List<Props.Entry> props = this.props.getEntry();
        if (props.size() > 0) {
            properties = new Properties();
            for (Props.Entry entry : props) {
                String key = entry.getKey();
                String val = entry.getValue();
                properties.setProperty(key, val);
            }
        }
        return properties;
    }

    public String getUidNumber() {
        return this.uidNumber;
    }

    public void setUidNumber(String uidNumber) {
        this.uidNumber = uidNumber;
    }

    public String getGidNumber() {
        return this.gidNumber;
    }

    public void setGidNumber(String gidNumber) {
        this.gidNumber = gidNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Configuration that = (Configuration)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

