/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.sasl.external.certificate;

import java.security.cert.Certificate;
import javax.net.ssl.SSLSession;
import javax.security.sasl.SaslException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.directory.api.ldap.model.constants.AuthenticationLevel;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapAuthenticationException;
import org.apache.directory.api.ldap.model.filter.EqualityNode;
import org.apache.directory.api.ldap.model.message.BindRequest;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.LdapPrincipal;
import org.apache.directory.server.core.api.OperationEnum;
import org.apache.directory.server.core.api.OperationManager;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.sasl.AbstractSaslServer;
import org.apache.mina.filter.ssl.SslFilter;

public final class ExternalSaslServer
extends AbstractSaslServer {
    private NegotiationState state = NegotiationState.INITIALIZED;

    ExternalSaslServer(LdapSession ldapSession, CoreSession adminSession, BindRequest bindRequest) {
        super(ldapSession, adminSession, bindRequest);
    }

    @Override
    public String getMechanismName() {
        return "EXTERNAL";
    }

    @Override
    public byte[] evaluateResponse(byte[] initialResponse) throws SaslException {
        try {
            SSLSession sslSession = (SSLSession)this.getLdapSession().getIoSession().getAttribute(SslFilter.SSL_SECURED);
            Certificate[] peerCertificates = sslSession.getPeerCertificates();
            if (null == peerCertificates || 1 > peerCertificates.length) {
                throw new SaslException("No peer certificate provided - cancel bind.");
            }
            this.getLdapSession().setCoreSession(this.authenticate(peerCertificates[0]));
            this.state = NegotiationState.COMPLETED;
        }
        catch (Exception e) {
            throw new SaslException("Error authentication using client certificate: " + ExceptionUtils.getStackTrace(e), e);
        }
        return Strings.EMPTY_BYTES;
    }

    @Override
    public boolean isComplete() {
        return this.state == NegotiationState.COMPLETED;
    }

    private CoreSession authenticate(Certificate peerCertificate) throws Exception {
        LdapSession ldapSession = this.getLdapSession();
        CoreSession adminSession = this.getAdminSession();
        DirectoryService directoryService = adminSession.getDirectoryService();
        LdapServer ldapServer = ldapSession.getLdapServer();
        OperationManager operationManager = directoryService.getOperationManager();
        EqualityNode filter = new EqualityNode(directoryService.getSchemaManager().getAttributeType("userCertificate"), new Value(peerCertificate.getEncoded()));
        SearchOperationContext searchContext = new SearchOperationContext(directoryService.getAdminSession());
        searchContext.setDn(directoryService.getDnFactory().create(ldapServer.getSearchBaseDn()));
        searchContext.setScope(SearchScope.SUBTREE);
        searchContext.setFilter(filter);
        searchContext.setSizeLimit(1L);
        searchContext.setNoAttributes(true);
        Throwable throwable = null;
        try (EntryFilteringCursor cursor = operationManager.search(searchContext);){
            if (cursor.next()) {
                Entry entry = (Entry)cursor.get();
                BindOperationContext bindContext = new BindOperationContext(ldapSession.getCoreSession());
                bindContext.setDn(entry.getDn());
                bindContext.setSaslMechanism(this.getMechanismName());
                bindContext.setSaslAuthId(this.getBindRequest().getName());
                bindContext.setIoSession(ldapSession.getIoSession());
                bindContext.setInterceptors(directoryService.getInterceptors(OperationEnum.BIND));
                operationManager.bind(bindContext);
                ldapSession.putSaslProperty("saslAuthentUser", new LdapPrincipal(directoryService.getSchemaManager(), entry.getDn(), AuthenticationLevel.STRONG));
                this.getLdapSession().putSaslProperty("java.naming.security.principal", this.getBindRequest().getName());
                CoreSession coreSession = bindContext.getSession();
                return coreSession;
            }
            try {
                throw new LdapAuthenticationException("Cannot authenticate user cert=" + peerCertificate);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private static enum NegotiationState {
        INITIALIZED,
        COMPLETED;

    }
}

