/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.config.view;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.apache.deltaspike.core.api.config.view.DefaultErrorView;
import org.apache.deltaspike.core.api.config.view.ViewConfig;
import org.apache.deltaspike.core.api.config.view.ViewRef;
import org.apache.deltaspike.core.api.config.view.metadata.InlineViewMetaData;
import org.apache.deltaspike.core.api.config.view.metadata.ViewConfigResolver;
import org.apache.deltaspike.core.spi.activation.Deactivatable;
import org.apache.deltaspike.core.spi.config.view.ConfigDescriptorValidator;
import org.apache.deltaspike.core.spi.config.view.ConfigNodeConverter;
import org.apache.deltaspike.core.spi.config.view.InlineMetaDataTransformer;
import org.apache.deltaspike.core.spi.config.view.TargetViewConfigProvider;
import org.apache.deltaspike.core.spi.config.view.ViewConfigInheritanceStrategy;
import org.apache.deltaspike.core.spi.config.view.ViewConfigNode;
import org.apache.deltaspike.core.spi.config.view.ViewConfigRoot;
import org.apache.deltaspike.core.util.ClassDeactivationUtils;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.core.util.ExceptionUtils;
import org.apache.deltaspike.jsf.api.config.view.Folder;
import org.apache.deltaspike.jsf.impl.config.view.AbstractConfigNode;
import org.apache.deltaspike.jsf.impl.config.view.DefaultConfigNodeConverter;
import org.apache.deltaspike.jsf.impl.config.view.DefaultViewConfigInheritanceStrategy;
import org.apache.deltaspike.jsf.impl.config.view.DefaultViewConfigResolver;
import org.apache.deltaspike.jsf.impl.config.view.FolderConfigNode;
import org.apache.deltaspike.jsf.impl.config.view.PageViewConfigNode;
import org.apache.deltaspike.jsf.impl.util.ViewConfigUtils;

public class ViewConfigExtension
implements Extension,
Deactivatable {
    private boolean isActivated = true;
    private ViewConfigNode rootViewConfigNode;
    private ViewConfigResolver viewConfigResolver;
    private boolean transformed = false;

    public ViewConfigExtension() {
        this.resetRootNode();
    }

    protected void init(@Observes BeforeBeanDiscovery beforeBeanDiscovery) {
        this.isActivated = ClassDeactivationUtils.isActivated(this.getClass());
    }

    protected void buildViewConfigMetaDataTree(final @Observes ProcessAnnotatedType pat) {
        if (!this.isActivated) {
            return;
        }
        this.buildViewConfigMetaDataTreeFor(pat.getAnnotatedType().getJavaClass(), pat.getAnnotatedType().getAnnotations(), new VetoCallback(){

            @Override
            public void veto() {
                pat.veto();
            }
        });
    }

    protected void buildViewConfigMetaDataTreeFor(Class beanClass, Set<Annotation> annotations, VetoCallback vetoCallback) {
        if (ViewConfig.class.isAssignableFrom(beanClass)) {
            this.addConfigClass(beanClass, annotations);
            vetoCallback.veto();
        } else if (ViewConfigUtils.isFolderConfig(beanClass) && beanClass.isAnnotationPresent(Folder.class)) {
            this.addConfigClass(beanClass, annotations);
            vetoCallback.veto();
        } else {
            this.addIndirectlyInheritedMetaData(beanClass, annotations);
        }
    }

    public void addIndirectlyInheritedMetaData(Class configClass) {
        this.addIndirectlyInheritedMetaData(configClass, new HashSet<Annotation>(Arrays.asList(configClass.getAnnotations())));
    }

    protected void addIndirectlyInheritedMetaData(Class configClass, Set<Annotation> annotations) {
        for (Annotation annotation : annotations) {
            InlineViewMetaData inlineViewMetaData = annotation.annotationType().getAnnotation(InlineViewMetaData.class);
            if (inlineViewMetaData == null) continue;
            Class targetViewConfigProviderClass = inlineViewMetaData.targetViewConfigProvider();
            TargetViewConfigProvider targetViewConfigProvider = (TargetViewConfigProvider)ClassUtils.tryToInstantiateClass((Class)targetViewConfigProviderClass);
            for (Class viewConfigRef : targetViewConfigProvider.getTarget(annotation)) {
                Class inlineNodeTransformerClass;
                ViewConfigNode viewConfigNode = this.findNode(viewConfigRef);
                if (viewConfigNode == null) {
                    this.addPageDefinition(viewConfigRef);
                    viewConfigNode = this.findNode(viewConfigRef);
                    if (viewConfigNode == null) {
                        throw new IllegalStateException("No node created for: " + viewConfigRef);
                    }
                }
                if (!InlineMetaDataTransformer.class.equals((Object)(inlineNodeTransformerClass = inlineViewMetaData.inlineMetaDataTransformer()))) {
                    InlineMetaDataTransformer inlineMetaDataTransformer = (InlineMetaDataTransformer)ClassUtils.tryToInstantiateClass((Class)inlineNodeTransformerClass);
                    viewConfigNode.getInheritedMetaData().add(inlineMetaDataTransformer.convertToViewMetaData(annotation, configClass));
                    continue;
                }
                viewConfigNode.getInheritedMetaData().add(annotation);
            }
        }
    }

    public void addPageDefinition(Class<? extends ViewConfig> viewConfigClass) {
        this.addConfigClass(viewConfigClass, new HashSet<Annotation>(Arrays.asList(viewConfigClass.getAnnotations())));
    }

    public void addFolderDefinition(Class configClass) {
        if (!ViewConfigUtils.isFolderConfig(configClass)) {
            throw new IllegalArgumentException(configClass != null ? configClass.getName() : "null is an invalid config for folders");
        }
        this.addConfigClass(configClass, new HashSet<Annotation>(Arrays.asList(configClass.getAnnotations())));
    }

    protected void addConfigClass(Class viewConfigClass, Set<Annotation> viewConfigAnnotations) {
        if (this.isInternal(viewConfigClass)) {
            return;
        }
        String className = viewConfigClass.getName();
        if (!className.contains(".")) {
            if (className.contains("$")) {
                className = className.substring(0, className.indexOf("$"));
            }
            throw new IllegalStateException("Please move the class '" + className + "' to a package!");
        }
        for (Annotation annotation : viewConfigAnnotations) {
            if (!annotation.annotationType().equals(ViewConfigRoot.class)) continue;
            if (this.rootViewConfigNode.getSource() != null) {
                throw new IllegalStateException("@" + ViewConfigRoot.class.getName() + " has been found at " + viewConfigClass.getName() + " and " + this.rootViewConfigNode.getSource().getName());
            }
            this.rootViewConfigNode.getMetaData().add(annotation);
            this.rootViewConfigNode = new FolderConfigNode(this.rootViewConfigNode, viewConfigClass);
            if (viewConfigClass.getAnnotation(ApplicationScoped.class) == null) break;
            HashSet<Class> manuallyDiscoveredViewConfigs = new HashSet<Class>();
            this.findNestedClasses(viewConfigClass, manuallyDiscoveredViewConfigs);
            for (Class foundClass : manuallyDiscoveredViewConfigs) {
                this.buildViewConfigMetaDataTreeFor(foundClass, new HashSet<Annotation>(Arrays.asList(foundClass.getAnnotations())), new VetoCallback(){

                    @Override
                    public void veto() {
                    }
                });
            }
        }
        List<Class> treePath = ViewConfigUtils.toNodeList(viewConfigClass);
        ViewConfigNode previousRootNode = null;
        for (Class currentNode : treePath) {
            ViewConfigNode baseNode = this.findNode(currentNode);
            if (baseNode == null) {
                Set<Annotation> metaData = viewConfigAnnotations;
                if (!currentNode.equals(viewConfigClass)) {
                    metaData = new HashSet<Annotation>(Arrays.asList(currentNode.getAnnotations()));
                }
                previousRootNode = this.addNode(previousRootNode, currentNode, metaData);
                continue;
            }
            previousRootNode = baseNode;
        }
    }

    private void findNestedClasses(Class viewConfigClass, Set<Class> nestedClasses) {
        for (Class<?> nestedClass : viewConfigClass.getDeclaredClasses()) {
            nestedClasses.add(nestedClass);
            this.findNestedClasses(nestedClass, nestedClasses);
        }
    }

    private boolean isInternal(Class configClass) {
        return ViewConfig.class.equals((Object)configClass) || DefaultErrorView.class.equals((Object)configClass) || ViewRef.Manual.class.equals((Object)configClass);
    }

    private ViewConfigNode addNode(ViewConfigNode parentNode, Class idOfNewNode, Set<Annotation> viewConfigAnnotations) {
        if (parentNode == null) {
            parentNode = this.rootViewConfigNode;
        }
        AbstractConfigNode viewConfigNode = ViewConfigUtils.isFolderConfig(idOfNewNode) ? new FolderConfigNode(idOfNewNode, parentNode, viewConfigAnnotations) : new PageViewConfigNode(idOfNewNode, parentNode, viewConfigAnnotations);
        parentNode.getChildren().add(viewConfigNode);
        return viewConfigNode;
    }

    public ViewConfigNode findNode(Class nodeClass) {
        if (nodeClass == null) {
            return null;
        }
        List<Class> path = ViewConfigUtils.toNodeList(nodeClass);
        ViewConfigNode currentNode = this.rootViewConfigNode;
        block0: for (int i = 0; i < path.size(); ++i) {
            Class nodeId = path.get(i);
            for (ViewConfigNode node : currentNode.getChildren()) {
                if (!node.getSource().equals(nodeId)) continue;
                currentNode = node;
                if (i != path.size() - 1) continue block0;
                return currentNode;
            }
            return null;
        }
        return null;
    }

    public void buildViewConfig(@Observes AfterDeploymentValidation adv) {
        if (!this.isActivated) {
            return;
        }
        this.transformMetaDataTree();
        this.transformed = true;
    }

    protected void transformMetaDataTree() {
        if (!this.isActivated) {
            return;
        }
        if (this.viewConfigResolver == null) {
            DefaultConfigNodeConverter configNodeConverter = new DefaultConfigNodeConverter();
            DefaultViewConfigInheritanceStrategy inheritanceStrategy = new DefaultViewConfigInheritanceStrategy();
            List<ConfigDescriptorValidator> configDescriptorValidators = new ArrayList<ConfigDescriptorValidator>();
            for (Annotation annotation : this.rootViewConfigNode.getMetaData()) {
                if (!annotation.annotationType().equals(ViewConfigRoot.class)) continue;
                ViewConfigRoot viewConfigRoot = (ViewConfigRoot)annotation;
                configNodeConverter = this.createCustomConfigNodeConverter(viewConfigRoot, configNodeConverter);
                inheritanceStrategy = this.createCustomInheritanceStrategy(viewConfigRoot, inheritanceStrategy);
                configDescriptorValidators = this.createCustomConfigDescriptorValidators(viewConfigRoot);
                this.viewConfigResolver = this.createCustomViewConfigResolver(viewConfigRoot, configNodeConverter, inheritanceStrategy, configDescriptorValidators);
                break;
            }
            if (this.viewConfigResolver == null) {
                this.viewConfigResolver = new DefaultViewConfigResolver(this.rootViewConfigNode, configNodeConverter, inheritanceStrategy, configDescriptorValidators);
            }
            this.resetRootNode();
        }
    }

    private ViewConfigResolver createCustomViewConfigResolver(ViewConfigRoot viewConfigRoot, ConfigNodeConverter configNodeConverter, ViewConfigInheritanceStrategy inheritanceStrategy, List<ConfigDescriptorValidator> validators) {
        Class viewConfigResolverClass = viewConfigRoot.viewConfigResolver();
        if (!ViewConfigResolver.class.equals((Object)viewConfigResolverClass)) {
            try {
                Constructor viewConfigResolverConstructor = viewConfigResolverClass.getConstructor(ViewConfigNode.class, ConfigNodeConverter.class, ViewConfigInheritanceStrategy.class, List.class);
                return (ViewConfigResolver)viewConfigResolverConstructor.newInstance(this.rootViewConfigNode, configNodeConverter, inheritanceStrategy, validators);
            }
            catch (Exception e) {
                throw ExceptionUtils.throwAsRuntimeException((Throwable)e);
            }
        }
        return null;
    }

    private ConfigNodeConverter createCustomConfigNodeConverter(ViewConfigRoot viewConfigRoot, ConfigNodeConverter defaultConverter) {
        Class converterClass = viewConfigRoot.configNodeConverter();
        if (!ConfigNodeConverter.class.equals((Object)converterClass)) {
            try {
                return (ConfigNodeConverter)converterClass.newInstance();
            }
            catch (Exception e) {
                throw ExceptionUtils.throwAsRuntimeException((Throwable)e);
            }
        }
        return defaultConverter;
    }

    private ViewConfigInheritanceStrategy createCustomInheritanceStrategy(ViewConfigRoot viewConfigRoot, ViewConfigInheritanceStrategy defaultStrategy) {
        Class strategyClass = viewConfigRoot.viewConfigInheritanceStrategy();
        if (!ViewConfigInheritanceStrategy.class.equals((Object)strategyClass)) {
            try {
                return (ViewConfigInheritanceStrategy)strategyClass.newInstance();
            }
            catch (Exception e) {
                throw ExceptionUtils.throwAsRuntimeException((Throwable)e);
            }
        }
        return defaultStrategy;
    }

    private List<ConfigDescriptorValidator> createCustomConfigDescriptorValidators(ViewConfigRoot viewConfigRoot) {
        ArrayList<ConfigDescriptorValidator> result = new ArrayList<ConfigDescriptorValidator>();
        for (Class validatorClass : viewConfigRoot.configDescriptorValidators()) {
            try {
                ConfigDescriptorValidator validator = (ConfigDescriptorValidator)validatorClass.newInstance();
                result.add(validator);
            }
            catch (Exception e) {
                throw ExceptionUtils.throwAsRuntimeException((Throwable)e);
            }
        }
        return result;
    }

    public void freeViewConfigCache(@Observes BeforeShutdown bs) {
        this.viewConfigResolver = null;
        this.transformed = false;
    }

    private void resetRootNode() {
        this.rootViewConfigNode = new FolderConfigNode(null, null, new HashSet<Annotation>());
    }

    boolean isActivated() {
        return this.isActivated;
    }

    boolean isTransformed() {
        return this.transformed;
    }

    ViewConfigResolver getViewConfigResolver() {
        return this.viewConfigResolver;
    }

    static interface VetoCallback {
        public void veto();
    }
}

