/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.config.view;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.enterprise.inject.Stereotype;
import org.apache.deltaspike.core.api.config.view.ViewConfig;
import org.apache.deltaspike.core.api.config.view.metadata.Aggregated;
import org.apache.deltaspike.core.api.config.view.metadata.ViewMetaData;
import org.apache.deltaspike.core.spi.config.view.ViewConfigInheritanceStrategy;
import org.apache.deltaspike.core.spi.config.view.ViewConfigNode;
import org.apache.deltaspike.jsf.api.config.view.Folder;
import org.apache.deltaspike.jsf.api.config.view.View;
import org.apache.deltaspike.jsf.impl.util.ViewConfigUtils;

public class DefaultViewConfigInheritanceStrategy
implements ViewConfigInheritanceStrategy {
    public List<Annotation> resolveInheritedMetaData(ViewConfigNode viewConfigNode) {
        ArrayList<Annotation> inheritedAnnotations = new ArrayList<Annotation>();
        HashSet<Class> processedTypes = new HashSet<Class>();
        processedTypes.add(ViewConfig.class);
        Stack<Class> classesToAnalyze = new Stack<Class>();
        this.addInterfaces(processedTypes, classesToAnalyze, viewConfigNode.getSource());
        while (!classesToAnalyze.empty()) {
            Class nextClass;
            Class currentClass = classesToAnalyze.pop();
            if (processedTypes.contains(currentClass)) continue;
            processedTypes.add(currentClass);
            this.addInterfaces(processedTypes, classesToAnalyze, currentClass);
            if (ViewConfigUtils.isFolderConfig(currentClass)) {
                inheritedAnnotations.addAll(this.findViewMetaData(currentClass, viewConfigNode));
            }
            if ((nextClass = currentClass.getSuperclass()) == null || Object.class.equals(nextClass) || processedTypes.contains(nextClass)) continue;
            classesToAnalyze.push(nextClass);
        }
        inheritedAnnotations.addAll(this.findViewMetaData(viewConfigNode.getSource(), viewConfigNode));
        return inheritedAnnotations;
    }

    protected List<Annotation> findViewMetaData(Class currentClass, ViewConfigNode viewConfigNode) {
        if (currentClass.equals(viewConfigNode.getSource())) {
            return Collections.emptyList();
        }
        List<Annotation> result = new ArrayList<Annotation>();
        for (Annotation annotation : currentClass.getAnnotations()) {
            Class<? extends Annotation> annotationClass = annotation.annotationType();
            if (annotationClass.getName().startsWith("java")) continue;
            this.addViewMetaData(annotation, result);
        }
        result = this.tryToReplaceWithMergedMetaDataFromAncestor(currentClass, viewConfigNode.getParent(), result);
        return result;
    }

    protected List<Annotation> tryToReplaceWithMergedMetaDataFromAncestor(Class currentClass, ViewConfigNode parentViewConfigNode, List<Annotation> foundResult) {
        ViewConfigNode ancestorNode = this.findNodeWithClass(currentClass, parentViewConfigNode);
        if (ancestorNode == null) {
            return foundResult;
        }
        ArrayList<Annotation> result = new ArrayList<Annotation>(foundResult.size());
        for (Annotation annotation : foundResult) {
            Annotation finalMetaData = this.getFinalMetaDataFromNode(ancestorNode, annotation);
            result.add(finalMetaData);
        }
        return result;
    }

    private Annotation getFinalMetaDataFromNode(ViewConfigNode viewConfigNode, Annotation annotation) {
        Class<? extends Annotation> targetType = annotation.annotationType();
        if (View.class.equals(targetType) || Folder.class.equals(targetType)) {
            return annotation;
        }
        ViewMetaData viewMetaData = annotation.annotationType().getAnnotation(ViewMetaData.class);
        if (viewMetaData == null) {
            return annotation;
        }
        Aggregated aggregated = viewMetaData.annotationType().getAnnotation(Aggregated.class);
        if (aggregated == null || aggregated.value()) {
            return annotation;
        }
        for (Annotation nodeMetaData : viewConfigNode.getMetaData()) {
            if (!targetType.equals(nodeMetaData.annotationType())) continue;
            return nodeMetaData;
        }
        return annotation;
    }

    private ViewConfigNode findNodeWithClass(Class nodeClass, ViewConfigNode viewConfigNode) {
        if (viewConfigNode == null || nodeClass == null) {
            return null;
        }
        if (nodeClass.equals(viewConfigNode.getSource())) {
            return viewConfigNode;
        }
        return this.findNodeWithClass(nodeClass, viewConfigNode.getParent());
    }

    protected void addViewMetaData(Annotation currentAnnotation, List<Annotation> metaDataList) {
        Class<? extends Annotation> annotationClass = currentAnnotation.annotationType();
        if (annotationClass.isAnnotationPresent(ViewMetaData.class)) {
            metaDataList.add(currentAnnotation);
        }
        if (annotationClass.isAnnotationPresent(Stereotype.class)) {
            for (Annotation inheritedViaStereotype : annotationClass.getAnnotations()) {
                if (!inheritedViaStereotype.annotationType().isAnnotationPresent(ViewMetaData.class)) continue;
                metaDataList.add(inheritedViaStereotype);
            }
        }
    }

    protected void addInterfaces(Set<Class> processedTypes, Stack<Class> classesToAnalyze, Class nextClass) {
        for (Class<?> interfaceToAdd : nextClass.getInterfaces()) {
            this.addInterfaces(processedTypes, classesToAnalyze, interfaceToAdd);
            if (processedTypes.contains(interfaceToAdd)) continue;
            classesToAnalyze.push(interfaceToAdd);
        }
    }
}

