package org.apache.torque.templates.typemapping;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * All available village value conversion methods.
 *
 * $Id: VillageMethod.java 1331196 2012-04-27 02:56:12Z tfischer $
 */
public enum VillageMethod
{
    STRING("asString()"),
    BIG_DECIMAL("asBigDecimal()"),
    BOOLEAN("asBoolean()"),
    BYTE("asByte()"),
    SHORT("asShort()"),
    INT("asInt()"),
    LONG("asLong()"),
    FLOAT("asFloat()"),
    DOUBLE("asDouble()"),
    BYTES("asBytes()"),
    UTIL_DATE("asUtilDate()"),

    BOOLEAN_OBJECT("asBooleanObj()"),
    BYTE_OBJECT("asByteObj()"),
    SHORT_OBJECT("asShortObj()"),
    INTEGER_OBJECT("asIntegerObj()"),
    LONG_OBJECT("asLongObj()"),
    FLOAT_OBJECT("asFloatObj()"),
    DOUBLE_OBJECT("asDoubleObj()");

    private String method;

    private VillageMethod(String method)
    {
        this.method = method;
    }

    public String getMethod()
    {
        return method;
    }

    public String toString()
    {
        return method;
    }
}
