package org.apache.torque.om;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import java.sql.Types;

/**
 * This class can be used as an ObjectKey to uniquely identify an
 * object within an application where the id  consists
 * of a single entity such a GUID or the value of a db row's primary key.
 *
 * @author <a href="mailto:jmcnally@apache.org">John McNally</a>
 * @version $Id: StringKey.java 1351125 2012-06-17 16:51:03Z tv $
 */
public class StringKey extends SimpleKey
{
    /**
     * Serial version
     */
    private static final long serialVersionUID = 5109588772086713341L;

    /**
     * Creates an SimpleKey whose internal representation will be
     * set later, through a set method
     */
    public StringKey()
    {
        // empty
    }

    /**
     * Creates a StringKey whose internal representation is a String
     *
     * @param key the key value
     */
    public StringKey(String key)
    {
        this.key = key;
    }

    /**
     * Creates a StringKey that is equivalent to key.
     *
     * @param key the key value
     */
    public StringKey(StringKey key)
    {
        if (key != null)
        {
            this.key = key.getValue();
        }
        else
        {
            this.key = null;
        }
    }

    /**
     * Sets the internal representation to a String
     *
     * @param key the key value
     */
    public void setValue(String key)
    {
        this.key = key;
    }

    /**
     * Sets the internal representation to the same object used by key.
     *
     * @param key the key value
     */
    public void setValue(StringKey key)
    {
        if (key != null)
        {
            this.key = key.getValue();
        }
        else
        {
            this.key = null;
        }
    }

    /**
     * Access the underlying String object.
     *
     * @return a <code>String</code> value
     */
    public String getString()
    {
        return (String) key;
    }

    /**
     * Returns the JDBC type of the key
     * as defined in <code>java.sql.Types</code>.
     *
     * @return <code>Types.VARCHAR</code>.
     */
    public int getJdbcType()
    {
        return Types.VARCHAR;
    }

    /**
     * Get a String representation of this key.
     *
     * @return a String representation of this key,
     *         or an empty String if the value is null.
     */
    @Override
    public String toString()
    {
        if (key != null)
        {
            return (String) key;
        }
        return "";
    }
}
