/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.derby.iapi.types.XMLDataValue;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SqlXmlUtil {
    private DocumentBuilder dBuilder;
    private Transformer serializer;
    private XPathExpression query;
    private QName returnType;

    public SqlXmlUtil() throws StandardException {
        try {
            DocumentBuilderFactory dBF = null;
            try {
                dBF = DocumentBuilderFactory.newInstance();
            }
            catch (Throwable e) {
                throw StandardException.newException("XML00", "JAXP");
            }
            dBF.setValidating(false);
            dBF.setNamespaceAware(true);
            dBF.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            dBF.setFeature("http://xml.org/sax/features/external-general-entities", false);
            this.dBuilder = dBF.newDocumentBuilder();
            this.dBuilder.setErrorHandler(new XMLErrorHandler(this));
            this.loadSerializer();
        }
        catch (StandardException se) {
            throw se;
        }
        catch (Throwable t) {
            throw StandardException.newException("XML01", t, t.getMessage());
        }
        this.query = null;
    }

    public void compileXQExpr(String queryExpr, String opName) throws StandardException {
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            xpath.setNamespaceContext(NullNamespaceContext.SINGLETON);
            this.query = xpath.compile(queryExpr);
        }
        catch (Throwable te) {
            throw StandardException.newException("10000", te, opName, te.getMessage());
        }
    }

    protected String serializeToString(String xmlAsText) throws Exception {
        InputSource is = new InputSource(new StringReader(xmlAsText));
        Document doc = this.dBuilder.parse(is);
        return this.serializeToString(Collections.singletonList(doc), null);
    }

    protected String serializeToString(List items, XMLDataValue xmlVal) throws TransformerException {
        if (items.isEmpty()) {
            return "";
        }
        if (items.size() == 1 && items.get(0) instanceof String) {
            return (String)items.get(0);
        }
        StringWriter sWriter = new StringWriter();
        SanityManager.ASSERT(this.serializer != null, "Tried to serialize with uninitialized XML serializer.");
        for (Object obj : items) {
            if (obj instanceof Attr) {
                xmlVal.markAsHavingTopLevelAttr();
                this.serializer.transform(new DOMSource((Node)obj), new StreamResult(sWriter));
                continue;
            }
            Node n = (Node)obj;
            if (n instanceof Text) {
                sWriter.write(n.getNodeValue());
                continue;
            }
            this.serializer.transform(new DOMSource(n), new StreamResult(sWriter));
        }
        sWriter.flush();
        return sWriter.toString();
    }

    protected List evalXQExpression(XMLDataValue xmlContext, boolean returnResults, int[] resultXType) throws Exception {
        List<Object> itemRefs;
        SanityManager.ASSERT(this.query != null, "Failed to locate compiled XML query expression.");
        if (xmlContext.getXType() != 0) {
            throw StandardException.newException("2200V", returnResults ? "XMLQUERY" : "XMLEXISTS");
        }
        Document docNode = this.dBuilder.parse(new InputSource(new StringReader(xmlContext.getString())));
        Object result = this.evaluate(docNode);
        if (!returnResults) {
            if (result instanceof NodeList && ((NodeList)result).getLength() == 0) {
                return null;
            }
            return Collections.emptyList();
        }
        if (result instanceof NodeList) {
            NodeList list = (NodeList)result;
            ArrayList<Object> nodes = new ArrayList<Object>();
            for (int i = 0; i < list.getLength(); ++i) {
                nodes.add(list.item(i));
            }
            itemRefs = nodes;
        } else {
            itemRefs = Collections.singletonList(result);
        }
        resultXType[0] = itemRefs.size() == 1 && itemRefs.get(0) instanceof Document ? 0 : 1;
        return itemRefs;
    }

    private Object evaluate(Document doc) throws XPathExpressionException {
        if (this.returnType != null) {
            return this.query.evaluate(doc, this.returnType);
        }
        try {
            Object result = this.query.evaluate(doc, XPathConstants.NODESET);
            this.returnType = XPathConstants.NODESET;
            return result;
        }
        catch (Exception xpee) {
            Object result = this.query.evaluate(doc, XPathConstants.STRING);
            this.returnType = XPathConstants.STRING;
            return result;
        }
    }

    private void loadSerializer() throws TransformerConfigurationException {
        Properties props = new Properties();
        props.setProperty("method", "xml");
        props.setProperty("omit-xml-declaration", "yes");
        props.setProperty("encoding", "UTF-8");
        this.serializer = TransformerFactory.newInstance().newTransformer();
        this.serializer.setOutputProperties(props);
    }

    private class XMLErrorHandler
    implements ErrorHandler {
        private XMLErrorHandler(SqlXmlUtil sqlXmlUtil) {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw new SAXException(exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw new SAXException(exception);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            throw new SAXException(exception);
        }
    }

    private static class NullNamespaceContext
    implements NamespaceContext {
        private static final NullNamespaceContext SINGLETON = new NullNamespaceContext();

        private NullNamespaceContext() {
        }

        @Override
        public String getNamespaceURI(String prefix) {
            return "";
        }

        @Override
        public String getPrefix(String namespaceURI) {
            return null;
        }

        @Override
        public Iterator<String> getPrefixes(String namespaceURI) {
            List emptylist = Collections.emptyList();
            return emptylist.iterator();
        }
    }
}

