/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.services;

import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.locks.Lockable;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.services.T_L1;

class T_User
implements Runnable {
    private LockFactory lf;
    private Lockable[] refs;
    private long iterations;
    private long offset;
    private int test;
    Throwable error = null;

    T_User(int test, LockFactory lf, Lockable[] refs, long iterations, long offset) {
        this.lf = lf;
        this.refs = refs;
        this.iterations = iterations;
        this.test = test;
        this.offset = offset;
    }

    @Override
    public void run() {
        try {
            switch (this.test) {
                case 1: {
                    this.T001();
                    break;
                }
                case 2: {
                    this.T002();
                    break;
                }
                case 3: {
                    this.T003();
                }
            }
        }
        catch (Throwable t) {
            this.error = t;
        }
    }

    private void T001() throws StandardException, T_Fail {
        CompatibilitySpace cs = this.lf.createCompatibilitySpace(null);
        Integer g0 = 1;
        this.checkLockCount(cs, 0);
        while (--this.iterations > 0L) {
            long value = this.offset + this.iterations;
            this.lf.lockObject(cs, (Object)g0, this.refs[0], null, -1);
            T_L1 ref = (T_L1)this.refs[0];
            ref.value = value;
            this.checkLockCount(cs, 1);
            Thread.yield();
            this.checkValue(ref, value);
            this.lf.lockObject(cs, (Object)g0, this.refs[1], null, -1);
            ref = (T_L1)this.refs[1];
            ref.value = value;
            Thread.yield();
            this.checkValue((T_L1)this.refs[0], value);
            this.checkValue((T_L1)this.refs[1], value);
            this.lf.unlock(cs, (Object)g0, this.refs[0], null);
            this.checkValue((T_L1)this.refs[1], value);
            Thread.yield();
            this.lf.unlock(cs, (Object)g0, this.refs[1], null);
            this.checkLockCount(cs, 0);
            Thread.yield();
        }
    }

    private void T002() throws StandardException, T_Fail {
        CompatibilitySpace cs = this.lf.createCompatibilitySpace(null);
        Integer g0 = 1;
        this.checkLockCount(cs, 0);
        while (--this.iterations > 0L) {
            long value = this.offset + this.iterations;
            T_L1 ref = (T_L1)this.refs[0];
            this.lf.lockObject(cs, (Object)g0, this.refs[0], null, -1);
            ref.value = value;
            this.checkLockCount(cs, 1);
            Thread.yield();
            this.checkValue(ref, value);
            this.lf.unlock(cs, (Object)g0, this.refs[0], null);
            this.checkLockCount(cs, 0);
        }
    }

    private void T003() throws StandardException, T_Fail {
        CompatibilitySpace cs = this.lf.createCompatibilitySpace(null);
        Integer g0 = 1;
        this.checkLockCount(cs, 0);
        while (--this.iterations > 0L) {
            this.lf.lockObject(cs, (Object)g0, this.refs[0], null, -1);
            this.checkLockCount(cs, 1);
            Thread.yield();
            this.lf.unlock(cs, (Object)g0, this.refs[0], null);
            this.checkLockCount(cs, 0);
        }
    }

    private void T004() throws StandardException, T_Fail {
        CompatibilitySpace cs = this.lf.createCompatibilitySpace(null);
        Integer g0 = 1;
        this.checkLockCount(cs, 0);
        while (--this.iterations > 0L) {
            this.lf.lockObject(cs, (Object)g0, this.refs[0], null, -1);
            this.checkLockCount(cs, 1);
            Thread.yield();
            this.lf.lockObject(cs, (Object)g0, this.refs[0], null, -1);
            this.checkLockCount(cs, 2);
            Thread.yield();
            this.lf.unlockGroup(cs, (Object)g0);
            this.checkLockCount(cs, 0);
        }
    }

    private void checkValue(T_L1 item, long value) throws T_Fail {
        if (item.value != value) {
            throw T_Fail.testFailMsg("value corrupted in multi-user test, exapected " + value + ", got " + item.value);
        }
    }

    void checkLockCount(CompatibilitySpace cs, int expected) throws T_Fail {
        boolean expect = expected != 0;
        boolean got = this.lf.areLocksHeld(cs);
        if (got != expect) {
            throw T_Fail.testFailMsg("Expected lock count (" + expect + "), got (" + got + ")");
        }
    }
}

