/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.services;

import java.util.Hashtable;
import org.apache.derby.iapi.services.locks.Latch;
import org.apache.derby.iapi.services.locks.Lockable;
import org.apache.derby.shared.common.sanity.SanityManager;

class T_L2
implements Lockable {
    private int allowed;
    private Object[] lockers;
    private int[] counts;

    T_L2(int allowed) {
        this.allowed = allowed;
        this.lockers = new Object[allowed];
        this.counts = new int[allowed];
    }

    public void lockEvent(Latch lockInfo) {
        int empty = -1;
        for (int i = 0; i < this.allowed; ++i) {
            if (this.lockers[i] == lockInfo.getCompatabilitySpace()) {
                int n = i;
                this.counts[n] = this.counts[n] + 1;
                return;
            }
            if (this.lockers[i] != null) continue;
            empty = i;
        }
        SanityManager.ASSERT((empty != -1 ? 1 : 0) != 0);
        this.lockers[empty] = lockInfo.getCompatabilitySpace();
        this.counts[empty] = 1;
    }

    public boolean requestCompatible(Object requestedQualifier, Object grantedQualifier) {
        return false;
    }

    public boolean lockerAlwaysCompatible() {
        return true;
    }

    public void unlockEvent(Latch lockInfo) {
        for (int i = 0; i < this.allowed; ++i) {
            if (this.lockers[i] != lockInfo.getCompatabilitySpace()) continue;
            int n = i;
            this.counts[n] = this.counts[n] - 1;
            SanityManager.ASSERT((this.counts[i] >= 0 ? 1 : 0) != 0);
            if (this.counts[i] == 0) {
                this.lockers[i] = null;
                return;
            }
            return;
        }
        SanityManager.THROWASSERT((String)"unlocked by a compatability space that does not exist");
    }

    public boolean lockAttributes(int flag, Hashtable t) {
        return false;
    }
}

