/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class PrepareExecuteDDL
extends BaseJDBCTestCase {
    private Connection connDDL;
    private static final String[] STMTS = new String[]{"SELECT * FROM PED001", "SELECT A, B FROM PED001", "GRANT SELECT ON PED001 TO U_PED_001", "GRANT SELECT(A,B) ON PED001 TO U_PED_001", "REVOKE SELECT(A,B) ON PED001 FROM U_PED_001", "REVOKE SELECT ON PED001 FROM U_PED_001"};
    private static final String[] DDL = new String[]{"ALTER TABLE PED001 ADD COLUMN D BIGINT", "ALTER TABLE PED001 ADD CONSTRAINT PED001_PK PRIMARY KEY (A)", "ALTER TABLE PED001 LOCKSIZE ROW", "ALTER TABLE PED001 LOCKSIZE TABLE", "DROP TABLE PED001"};
    private final String ddl;

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("PrepareExecuteDDL");
        for (int i = 0; i < DDL.length; ++i) {
            suite.addTest((Test)new PrepareExecuteDDL("testPrepareExcute", DDL[i]));
        }
        return TestConfiguration.sqlAuthorizationDecorator((Test)suite);
    }

    private PrepareExecuteDDL(String name, String ddl) {
        super(name);
        this.ddl = ddl;
    }

    private boolean tableDropped() {
        return this.ddl.startsWith("DROP TABLE ");
    }

    public void testPrepareExcute() throws SQLException {
        String sql;
        int i;
        Connection conn = this.getConnection();
        PreparedStatement[] psa = new PreparedStatement[STMTS.length];
        for (i = 0; i < STMTS.length; ++i) {
            sql = STMTS[i];
            psa[i] = conn.prepareStatement(sql);
        }
        this.connDDL.createStatement().execute(this.ddl);
        for (i = 0; i < STMTS.length; ++i) {
            sql = STMTS[i];
            if (sql.startsWith("SELECT ")) {
                this.checkSelect(psa[i], sql);
            } else if (sql.startsWith("GRANT ") || sql.startsWith("REVOKE ")) {
                this.checkGrantRevoke(psa[i], sql);
            } else {
                PrepareExecuteDDL.fail((String)("unknown SQL" + sql));
            }
            psa[i].close();
        }
    }

    private void checkSelect(PreparedStatement ps, String sql) throws SQLException {
        boolean result;
        PrepareExecuteDDL.assertEquals((boolean)true, (boolean)sql.startsWith("SELECT "));
        try {
            result = ps.execute();
        }
        catch (SQLException e) {
            PrepareExecuteDDL.assertSQLState("42X05", e);
            PrepareExecuteDDL.assertTrue((boolean)this.tableDropped());
            return;
        }
        PrepareExecuteDDL.assertTrue((boolean)result);
        ResultSet rs = ps.getResultSet();
        DatabaseMetaData dmd = this.connDDL.getMetaData();
        JDBC.assertMetaDataMatch(dmd, rs.getMetaData());
        boolean isSelectStar = sql.startsWith("SELECT * ");
        if (isSelectStar) {
            // empty if block
        }
        JDBC.assertDrainResults(rs);
    }

    private void checkGrantRevoke(PreparedStatement ps, String sql) throws SQLException {
        PrepareExecuteDDL.assertEquals((boolean)true, (sql.startsWith("GRANT ") || sql.startsWith("REVOKE ") ? 1 : 0) != 0);
        try {
            PrepareExecuteDDL.assertFalse((boolean)ps.execute());
        }
        catch (SQLException e) {
            PrepareExecuteDDL.assertSQLState("42X05", e);
            PrepareExecuteDDL.assertTrue((boolean)this.tableDropped());
            return;
        }
    }

    protected void setUp() throws SQLException {
        this.connDDL = this.openDefaultConnection();
        Statement s = this.connDDL.createStatement();
        s.execute("CREATE TABLE PED001 (A INT NOT NULL, B DECIMAL(6,4), C VARCHAR(20))");
        s.close();
    }

    @Override
    protected void tearDown() throws Exception {
        Statement s = this.connDDL.createStatement();
        try {
            s.execute("DROP TABLE PED001");
        }
        catch (SQLException e) {
            PrepareExecuteDDL.assertSQLState("42Y55", e);
        }
        s.close();
        JDBC.cleanup(this.connDDL);
        this.connDDL = null;
        super.tearDown();
    }
}

