/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Enumeration;
import javax.sql.PooledConnection;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class StatementEventsTest
extends BaseJDBCTestCase {
    private boolean xa;
    private boolean callable;
    private Statement closedStatement;
    private int closedCount;
    private Statement errorStatement;
    private int errorCount;
    private PooledConnection pooledConnection;
    private Connection connection;

    public StatementEventsTest(String name) {
        super(name);
    }

    private void setXA(boolean xa) {
        this.xa = xa;
    }

    private void setCallable(boolean callable) {
        this.callable = callable;
    }

    public String getName() {
        return super.getName() + (this.xa ? "_xa" : "_pooled") + (this.callable ? "_callable" : "_prepared");
    }

    public void setUp() throws SQLException {
        if (this.xa) {
            ds = J2EEDataSource.getXADataSource();
            J2EEDataSource.setBeanProperty(ds, "createDatabase", "create");
            this.pooledConnection = ds.getXAConnection();
        } else {
            ds = J2EEDataSource.getConnectionPoolDataSource();
            J2EEDataSource.setBeanProperty(ds, "createDatabase", "create");
            this.pooledConnection = ds.getPooledConnection();
        }
        StatementEventListener listener = new StatementEventListener(){

            @Override
            public void statementClosed(StatementEvent event) {
                StatementEventsTest.this.closedStatement = event.getStatement();
                ++StatementEventsTest.this.closedCount;
            }

            @Override
            public void statementErrorOccurred(StatementEvent event) {
                StatementEventsTest.this.errorStatement = event.getStatement();
                ++StatementEventsTest.this.errorCount;
            }
        };
        this.pooledConnection.addStatementEventListener(listener);
        this.connection = this.pooledConnection.getConnection();
    }

    @Override
    protected void tearDown() throws Exception {
        this.connection.close();
        this.pooledConnection.close();
        this.connection = null;
        this.pooledConnection = null;
        this.closedStatement = null;
        this.errorStatement = null;
        super.tearDown();
    }

    private static Test baseSuite(String name) {
        boolean[] truefalse;
        BaseTestSuite suites = new BaseTestSuite(name);
        for (boolean xa : truefalse = new boolean[]{true, false}) {
            for (boolean callable : truefalse) {
                suites.addTest((Test)new Suite(xa, callable));
            }
        }
        return suites;
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("StatementEventsTest suite");
        suite.addTest(StatementEventsTest.baseSuite("StatementEventsTest:embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(StatementEventsTest.baseSuite("StatementEventsTest:client")));
        return suite;
    }

    private PreparedStatement prepare(String sql) throws SQLException {
        if (this.callable) {
            return this.connection.prepareCall(sql);
        }
        return this.connection.prepareStatement(sql);
    }

    public void testCloseEvent() throws SQLException {
        PreparedStatement ps = this.prepare("VALUES (1)");
        ps.close();
        StatementEventsTest.assertSame((String)"Close event raised on wrong statement.", (Object)ps, (Object)this.closedStatement);
        StatementEventsTest.assertEquals((String)"Incorrect close count.", (int)1, (int)this.closedCount);
    }

    public void testAddNullListener() throws SQLException {
        this.pooledConnection.addStatementEventListener(null);
        PreparedStatement ps = this.prepare("VALUES (1)");
        ps.close();
        StatementEventsTest.assertEquals((int)1, (int)this.closedCount);
        StatementEventsTest.assertEquals((int)0, (int)this.errorCount);
        ps = this.prepare("VALUES (1)");
        this.connection.close();
        try {
            ps.execute();
            StatementEventsTest.fail((String)"Execute should fail on closed connection");
        }
        catch (SQLNonTransientConnectionException e) {
            StatementEventsTest.assertSQLState("08003", e);
        }
        StatementEventsTest.assertEquals((int)1, (int)this.errorCount);
    }

    public void testRemoveNullListener() throws SQLException {
        this.pooledConnection.removeStatementEventListener(null);
    }

    public void testDoubleAddListener() throws SQLException {
        SimpleListener listener = new SimpleListener();
        this.pooledConnection.addStatementEventListener(listener);
        this.pooledConnection.addStatementEventListener(listener);
        this.prepare("VALUES (1)").close();
        StatementEventsTest.assertEquals((int)2, (int)listener.getCloseCount());
        StatementEventsTest.assertEquals((int)0, (int)listener.getErrorCount());
        listener.resetCounts();
        PreparedStatement ps = this.prepare("VALUES (1)");
        this.connection.close();
        StatementEventsTest.assertStatementError("08003", ps);
        StatementEventsTest.assertEquals((int)2, (int)listener.getErrorCount());
        StatementEventsTest.assertEquals((int)(StatementEventsTest.usingDerbyNetClient() ? 2 : 0), (int)listener.getCloseCount());
    }

    public void testCloseEventOnClosedConnection() throws SQLException {
        PreparedStatement ps = this.prepare("VALUES (1)");
        this.connection.close();
        if (StatementEventsTest.usingDerbyNetClient()) {
            StatementEventsTest.assertSame((String)"Close event raised on wrong statement.", (Object)ps, (Object)this.closedStatement);
            StatementEventsTest.assertEquals((String)"Incorrect close count.", (int)1, (int)this.closedCount);
        } else if (StatementEventsTest.usingEmbedded()) {
            StatementEventsTest.assertNull((String)"Didn't expect close event.", (Object)this.closedStatement);
            StatementEventsTest.assertEquals((String)"Incorrect close count.", (int)0, (int)this.closedCount);
        } else {
            StatementEventsTest.fail((String)"Unknown framework.");
        }
    }

    public void testErrorEventOnClosedConnection() throws SQLException {
        PreparedStatement ps = this.prepare("VALUES (1)");
        this.connection.close();
        try {
            ps.execute();
            StatementEventsTest.fail((String)"No exception thrown.");
        }
        catch (SQLException e) {
            StatementEventsTest.assertSQLState("Unexpected SQL state.", "08003", e);
            StatementEventsTest.assertSame((String)"Error event raised on wrong statement.", (Object)ps, (Object)this.errorStatement);
            StatementEventsTest.assertEquals((String)"Incorrect error count.", (int)1, (int)this.errorCount);
        }
    }

    public void testRemoveListenerFromListener() throws SQLException {
        int i;
        final int[] counters = new int[2];
        for (i = 0; i < 5; ++i) {
            StatementEventListener close = new StatementEventListener(){

                @Override
                public void statementClosed(StatementEvent event) {
                    StatementEventsTest.this.pooledConnection.removeStatementEventListener(this);
                    counters[0] = counters[0] + 1;
                }

                @Override
                public void statementErrorOccurred(StatementEvent event) {
                }
            };
            this.pooledConnection.addStatementEventListener(close);
            StatementEventListener error = new StatementEventListener(){

                @Override
                public void statementClosed(StatementEvent event) {
                }

                @Override
                public void statementErrorOccurred(StatementEvent event) {
                    StatementEventsTest.this.pooledConnection.removeStatementEventListener(this);
                    counters[1] = counters[1] + 1;
                }
            };
            this.pooledConnection.addStatementEventListener(error);
        }
        for (i = 0; i < 2; ++i) {
            this.prepare("VALUES (1)").close();
            StatementEventsTest.assertEquals((String)"unexpected number of close events", (int)5, (int)counters[0]);
            StatementEventsTest.assertEquals((String)"unexpected number of error events", (int)0, (int)counters[1]);
        }
        Arrays.fill(counters, 0);
        for (i = 0; i < 2; ++i) {
            PreparedStatement ps = this.prepare("VALUES (1)");
            this.connection.close();
            try {
                ps.execute();
                StatementEventsTest.fail((String)"Execute on closed connection should fail");
            }
            catch (SQLNonTransientConnectionException e) {
                StatementEventsTest.assertSQLState("08003", e);
            }
            StatementEventsTest.assertEquals((String)"unexpected number of close events", (int)0, (int)counters[0]);
            StatementEventsTest.assertEquals((String)"unexpected number of error events", (int)5, (int)counters[1]);
            this.connection = this.pooledConnection.getConnection();
        }
        StatementEventsTest.assertEquals((String)"Incorrect error count", (int)2, (int)this.errorCount);
        if (StatementEventsTest.usingEmbedded()) {
            StatementEventsTest.assertEquals((String)"Incorrect close count", (int)2, (int)this.closedCount);
        } else if (StatementEventsTest.usingDerbyNetClient()) {
            StatementEventsTest.assertEquals((String)"Incorrect close count", (int)4, (int)this.closedCount);
        } else {
            StatementEventsTest.fail((String)"unknown framework");
        }
    }

    public void testAddListenerFromListener() throws SQLException {
        final int[] counters = new int[4];
        for (int i = 0; i < 5; ++i) {
            StatementEventListener close = new StatementEventListener(){

                @Override
                public void statementClosed(StatementEvent event) {
                    counters[0] = counters[0] + 1;
                    StatementEventsTest.this.pooledConnection.addStatementEventListener(new StatementEventListener(){

                        @Override
                        public void statementClosed(StatementEvent e) {
                            counters[2] = counters[2] + 1;
                        }

                        @Override
                        public void statementErrorOccurred(StatementEvent e) {
                            counters[2] = counters[2] + 1;
                        }
                    });
                }

                @Override
                public void statementErrorOccurred(StatementEvent event) {
                }
            };
            this.pooledConnection.addStatementEventListener(close);
            StatementEventListener error = new StatementEventListener(){

                @Override
                public void statementClosed(StatementEvent event) {
                }

                @Override
                public void statementErrorOccurred(StatementEvent event) {
                    counters[1] = counters[1] + 1;
                    StatementEventsTest.this.pooledConnection.addStatementEventListener(new StatementEventListener(){

                        @Override
                        public void statementClosed(StatementEvent e) {
                            counters[3] = counters[3] + 1;
                        }

                        @Override
                        public void statementErrorOccurred(StatementEvent e) {
                            counters[3] = counters[3] + 1;
                        }
                    });
                }
            };
            this.pooledConnection.addStatementEventListener(error);
        }
        this.prepare("VALUES (1)").close();
        StatementEventsTest.assertEquals((String)"unexpected number of close events", (int)5, (int)counters[0]);
        StatementEventsTest.assertEquals((String)"unexpected number of error events", (int)0, (int)counters[1]);
        StatementEventsTest.assertEquals((String)"unexpected number of added close listeners triggered", (int)0, (int)counters[2]);
        StatementEventsTest.assertEquals((String)"unexpected number of added error listeners triggered", (int)0, (int)counters[3]);
        this.prepare("VALUES (1)").close();
        StatementEventsTest.assertEquals((String)"unexpected number of close events", (int)10, (int)counters[0]);
        StatementEventsTest.assertEquals((String)"unexpected number of error events", (int)0, (int)counters[1]);
        StatementEventsTest.assertEquals((String)"unexpected number of added close listeners triggered", (int)5, (int)counters[2]);
        StatementEventsTest.assertEquals((String)"unexpected number of added error listeners triggered", (int)0, (int)counters[3]);
        PreparedStatement ps = this.prepare("VALUES (1)");
        this.connection.close();
        Arrays.fill(counters, 0);
        try {
            ps.execute();
            StatementEventsTest.fail((String)"Execute on closed connection should fail");
        }
        catch (SQLNonTransientConnectionException e) {
            StatementEventsTest.assertSQLState("08003", e);
        }
        StatementEventsTest.assertEquals((String)"unexpected number of close events", (int)0, (int)counters[0]);
        StatementEventsTest.assertEquals((String)"unexpected number of error events", (int)5, (int)counters[1]);
        StatementEventsTest.assertEquals((String)"unexpected number of added close listeners triggered", (int)(StatementEventsTest.usingEmbedded() ? 10 : 15), (int)counters[2]);
        StatementEventsTest.assertEquals((String)"unexpected number of added error listeners triggered", (int)0, (int)counters[3]);
        Arrays.fill(counters, 0);
        try {
            ps.execute();
            StatementEventsTest.fail((String)"Execute on closed connection should fail");
        }
        catch (SQLNonTransientConnectionException e) {
            StatementEventsTest.assertSQLState("08003", e);
        }
        StatementEventsTest.assertEquals((String)"unexpected number of close events", (int)0, (int)counters[0]);
        StatementEventsTest.assertEquals((String)"unexpected number of error events", (int)5, (int)counters[1]);
        StatementEventsTest.assertEquals((String)"unexpected number of added close listeners triggered", (int)(StatementEventsTest.usingEmbedded() ? 10 : 15), (int)counters[2]);
        StatementEventsTest.assertEquals((String)"unexpected number of added error listeners triggered", (int)5, (int)counters[3]);
        StatementEventsTest.assertEquals((String)"Incorrect error count", (int)2, (int)this.errorCount);
        if (StatementEventsTest.usingEmbedded()) {
            StatementEventsTest.assertEquals((String)"Incorrect close count", (int)2, (int)this.closedCount);
        } else if (StatementEventsTest.usingDerbyNetClient()) {
            StatementEventsTest.assertEquals((String)"Incorrect close count", (int)3, (int)this.closedCount);
        } else {
            StatementEventsTest.fail((String)"unknown framework");
        }
    }

    public void testAddRemoveListenerOnClosedObject() throws SQLException {
        SimpleListener listener = new SimpleListener();
        this.pooledConnection.addStatementEventListener(listener);
        this.pooledConnection.close();
        this.pooledConnection.removeStatementEventListener(listener);
        this.pooledConnection.addStatementEventListener(new SimpleListener());
    }

    public void testRemoveListenerNotAddedFirst() throws SQLException {
        this.pooledConnection.removeStatementEventListener(new SimpleListener());
        this.prepare("VALUES (1)").close();
        StatementEventsTest.assertEquals((int)1, (int)this.closedCount);
        StatementEventsTest.assertEquals((int)0, (int)this.errorCount);
    }

    private static class Suite
    extends BaseTestSuite {
        private Suite(boolean xa, boolean callable) {
            super(StatementEventsTest.class);
            Enumeration i = this.tests();
            while (i.hasMoreElements()) {
                StatementEventsTest test = (StatementEventsTest)((Object)i.nextElement());
                test.setXA(xa);
                test.setCallable(callable);
            }
        }
    }

    private static class SimpleListener
    implements StatementEventListener {
        private int closeCount;
        private int errorCount;

        private SimpleListener() {
        }

        @Override
        public void statementClosed(StatementEvent event) {
            ++this.closeCount;
        }

        @Override
        public void statementErrorOccurred(StatementEvent event) {
            ++this.errorCount;
        }

        private int getCloseCount() {
            return this.closeCount;
        }

        private int getErrorCount() {
            return this.errorCount;
        }

        private void resetCounts() {
            this.closeCount = 0;
            this.errorCount = 0;
        }
    }
}

