/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.sql.Blob;
import java.sql.ClientInfoStatus;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ConnectionTest
extends BaseJDBCTestCase {
    public ConnectionTest(String name) {
        super(name);
    }

    public void embeddedCreateBlob() throws SQLException {
        Blob blob = this.getConnection().createBlob();
        if (blob.length() > 0L) {
            ConnectionTest.fail((String)"The new Blob should not have more than zero bytes contained in it");
        }
    }

    public void embeddedCreateClob() throws SQLException {
        Clob clob = this.getConnection().createClob();
        if (clob.length() > 0L) {
            ConnectionTest.fail((String)"The new Clob should not have a length of greater than zero");
        }
    }

    public void testCreateArrayNotImplemented() throws SQLException {
        try {
            this.getConnection().createArrayOf(null, null);
            ConnectionTest.fail((String)"createArrayOf(String,Object[]) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testCreateNClobNotImplemented() throws SQLException {
        try {
            this.getConnection().createNClob();
            ConnectionTest.fail((String)"createNClob() should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testCreateSQLXMLNotImplemented() throws SQLException {
        try {
            this.getConnection().createSQLXML();
            ConnectionTest.fail((String)"createSQLXML() should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testCreateStructNotImplemented() throws SQLException {
        try {
            this.getConnection().createStruct(null, null);
            ConnectionTest.fail((String)"createStruct(String,Object[]) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testGetClientInfo() throws SQLException {
        ConnectionTest.assertTrue((String)"getClientInfo() must return an empty Properties object", (boolean)this.getConnection().getClientInfo().isEmpty());
    }

    public void testGetClientInfoString() throws SQLException {
        ConnectionTest.assertNull((String)"getClientInfo(null) must return null", (Object)this.getConnection().getClientInfo(null));
        ConnectionTest.assertNull((String)"getClientInfo(\"someProperty\") must return null", (Object)this.getConnection().getClientInfo("someProperty"));
    }

    public void testIsValidImplemented() throws SQLException {
        ConnectionTest.assertTrue((boolean)this.getConnection().isValid(0));
        ConnectionTest.assertTrue((boolean)this.getConnection().isValid(200));
        try {
            this.getConnection().isValid(-1);
        }
        catch (SQLException sqle) {
            ConnectionTest.assertSQLState("Incorrect SQL state when calling isValid(-1)", "XJ081", sqle);
        }
    }

    public void xtestIsValidWithTimeout() throws SQLException {
        if (ConnectionTest.usingEmbedded()) {
            return;
        }
        boolean convalid = true;
        Connection conn = this.getConnection();
        convalid = conn.isValid(200);
        ConnectionTest.assertTrue((boolean)convalid);
        convalid = conn.isValid(1);
        ConnectionTest.assertFalse((boolean)convalid);
        try {
            conn.rollback();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testGetTypeMapReturnsEmptyMap() throws SQLException {
        ConnectionTest.assertTrue((boolean)this.getConnection().getTypeMap().isEmpty());
    }

    public void testGetTypeMapReturnsAsExpected() throws SQLException {
        int ret;
        Statement s = this.getConnection().createStatement();
        try {
            ret = s.executeUpdate("DROP TABLE T1");
            ret = s.executeUpdate("DROP TYPE JAVA_UTIL_LIST RESTRICT");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ret = s.executeUpdate("CREATE TYPE JAVA_UTIL_LIST EXTERNAL NAME 'java.util.List'LANGUAGE JAVA");
        s.execute("CREATE TABLE T1 (A1 JAVA_UTIL_LIST)");
        PreparedStatement ps = this.getConnection().prepareStatement("INSERT INTO T1(A1) VALUES (?)");
        ArrayList<String> lst = new ArrayList<String>();
        lst.add("First element");
        lst.add("Second element");
        ps.setObject(1, lst);
        ps.execute();
        Map<String, Class<?>> map = this.getConnection().getTypeMap();
        try {
            map.put("JAVA_UTIL_LIST", List.class);
            ConnectionTest.fail((String)"returned map should be immutable");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        HashMap emptyMap = new HashMap();
        this.getConnection().setTypeMap(emptyMap);
        map = new HashMap();
        map.put("JAVA_UTIL_LIST", List.class);
        try {
            this.getConnection().setTypeMap(map);
            ConnectionTest.fail((String)"Should raise an Unimplemented Feature exception.");
        }
        catch (SQLException se) {
            ConnectionTest.assertEquals((String)SQLFeatureNotSupportedException.class.getName(), (String)se.getClass().getName());
        }
        ResultSet rs = s.executeQuery("select * from T1");
        ConnectionTest.assertTrue((boolean)rs.next());
        for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
            Object o = rs.getObject(i);
            ConnectionTest.assertEquals(lst, (Object)o);
        }
        s.executeUpdate("DROP TABLE T1");
        s.executeUpdate("DROP TYPE JAVA_UTIL_LIST RESTRICT");
        s.close();
        ps.close();
    }

    public void testIsWrapperReturnsFalse() throws SQLException {
        ConnectionTest.assertFalse((boolean)this.getConnection().isWrapperFor(ResultSet.class));
    }

    public void testIsWrapperReturnsTrue() throws SQLException {
        ConnectionTest.assertTrue((boolean)this.getConnection().isWrapperFor(Connection.class));
    }

    public void testSetClientInfoProperties() throws SQLException {
        this.getConnection().setClientInfo(null);
        Properties p = new Properties();
        this.getConnection().setClientInfo(p);
        p.setProperty("prop1", "val1");
        p.setProperty("prop2", "val2");
        try {
            this.getConnection().setClientInfo(p);
            ConnectionTest.fail((String)"setClientInfo(String,String) should throw SQLClientInfoException");
        }
        catch (SQLClientInfoException cie) {
            ConnectionTest.assertSQLState("SQLStates must match", "XCY02", cie);
            ConnectionTest.assertTrue((String)"Setting property 'prop1' must fail with REASON_UNKNOWN_PROPERTY", (boolean)cie.getFailedProperties().get("prop1").equals((Object)ClientInfoStatus.REASON_UNKNOWN_PROPERTY));
            ConnectionTest.assertTrue((String)"Setting property 'prop2' must fail with REASON_UNKNOWN_PROPERTY", (boolean)cie.getFailedProperties().get("prop2").equals((Object)ClientInfoStatus.REASON_UNKNOWN_PROPERTY));
        }
    }

    public void testSetClientInfoString() throws SQLException {
        this.getConnection().setClientInfo(null, null);
        try {
            this.getConnection().setClientInfo("foo", null);
            ConnectionTest.fail((String)"setClientInfo(String, null) should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.getConnection().setClientInfo("name", "value");
            ConnectionTest.fail((String)"setClientInfo(String,String) should throw SQLClientInfoException");
        }
        catch (SQLClientInfoException cie) {
            ConnectionTest.assertSQLState("SQLState must match 'unsupported'", "XCY02", cie);
            ConnectionTest.assertTrue((String)"Setting property 'name' must fail with REASON_UNKNOWN_PROPERTY", (boolean)cie.getFailedProperties().get("name").equals((Object)ClientInfoStatus.REASON_UNKNOWN_PROPERTY));
        }
    }

    public void testUnwrapValid() throws SQLException {
        Connection unwrappedCon = this.getConnection().unwrap(Connection.class);
        ConnectionTest.assertSame((String)"Unwrap returned wrong object.", (Object)this.getConnection(), (Object)unwrappedCon);
    }

    public void testUnwrapInvalid() throws SQLException {
        try {
            ResultSet unwrappedRs = this.getConnection().unwrap(ResultSet.class);
            ConnectionTest.fail((String)"unwrap should have thrown an exception");
        }
        catch (SQLException sqle) {
            ConnectionTest.assertSQLState("Incorrect SQL state when unable to unwrap", "XJ128", sqle);
        }
    }

    private static BaseTestSuite clientSuite(String name) {
        BaseTestSuite clientSuite = new BaseTestSuite(name);
        return clientSuite;
    }

    private static BaseTestSuite embeddedSuite(String name) {
        BaseTestSuite embeddedSuite = new BaseTestSuite(name);
        embeddedSuite.addTest((Test)new ConnectionTest("embeddedCreateBlob"));
        embeddedSuite.addTest((Test)new ConnectionTest("embeddedCreateClob"));
        return embeddedSuite;
    }

    public static Test suite() {
        BaseTestSuite connSuite = new BaseTestSuite("ConnectionTest suite");
        BaseTestSuite embedded = new BaseTestSuite("ConnectionTest:embedded");
        embedded.addTestSuite(ConnectionTest.class);
        embedded.addTest((Test)ConnectionTest.embeddedSuite("ConnectionTest:embedded-only"));
        connSuite.addTest((Test)embedded);
        embedded = new BaseTestSuite("ConnectionTest:embedded XADataSource");
        embedded.addTestSuite(ConnectionTest.class);
        embedded.addTest((Test)ConnectionTest.embeddedSuite("ConnectionTest:embedded-only XADataSource"));
        connSuite.addTest(TestConfiguration.connectionXADecorator((Test)embedded));
        BaseTestSuite client = new BaseTestSuite("ConnectionTest:client");
        client.addTestSuite(ConnectionTest.class);
        client.addTest((Test)ConnectionTest.clientSuite("ConnectionTest:client-only"));
        connSuite.addTest(TestConfiguration.clientServerDecorator((Test)client));
        client = new BaseTestSuite("ConnectionTest:client XADataSource");
        client.addTestSuite(ConnectionTest.class);
        client.addTest((Test)ConnectionTest.clientSuite("ConnectionTest:client-only XADataSource"));
        connSuite.addTest(TestConfiguration.clientServerDecorator(TestConfiguration.connectionXADecorator((Test)client)));
        return connSuite;
    }
}

