/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.tools.JDBCDisplayUtil;
import org.apache.derby.tools.ij;

public abstract class BaseTest {
    private static boolean debug_system_procedures_created = false;
    protected static boolean verbose = false;
    protected static final int SPACE_INFO_IS_INDEX = 0;
    protected static final int SPACE_INFO_NUM_ALLOC = 1;
    protected static final int SPACE_INFO_NUM_FREE = 2;
    protected static final int SPACE_INFO_NUM_UNFILLED = 3;
    protected static final int SPACE_INFO_PAGE_SIZE = 4;
    protected static final int SPACE_INFO_ESTIMSPACESAVING = 5;
    protected static final int SPACE_INFO_NUMCOLS = 6;

    public abstract void testList(Connection var1) throws SQLException;

    void runTests(String[] stringArray) throws Throwable {
        ij.getPropertyArg((String[])stringArray);
        Connection connection = ij.startJBMS();
        System.out.println("conn from ij.startJBMS() = " + String.valueOf(connection));
        connection.setAutoCommit(false);
        try {
            this.testList(connection);
        }
        catch (SQLException sQLException) {
            JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sQLException);
            sQLException.printStackTrace(System.out);
        }
    }

    protected void beginTest(Connection connection, String string) throws SQLException {
        this.log("Beginning test: " + string);
        connection.commit();
    }

    protected void testProgress(String string) throws SQLException {
        this.log("Executing test: " + string);
    }

    protected void endTest(Connection connection, String string) throws SQLException {
        connection.commit();
        this.log("Ending test: " + string);
    }

    protected void log(String string) {
        System.out.println(string);
    }

    protected void logError(String string) {
        System.out.println("ERROR: " + string);
    }

    public void executeQuery(Connection connection, String string, boolean bl) throws SQLException {
        Statement statement = connection.createStatement();
        statement.executeUpdate(string);
        statement.close();
        if (bl) {
            connection.commit();
        }
    }

    protected boolean checkConsistency(Connection connection, String string, String string2) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("values SYSCS_UTIL.SYSCS_CHECK_TABLE('" + string + "', '" + string2 + "')");
        if (!resultSet.next()) {
            // empty if block
        }
        boolean bl = resultSet.getBoolean(1);
        resultSet.close();
        connection.commit();
        return bl;
    }

    protected boolean checkAllConsistency(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select schemaname, tablename, SYSCS_UTIL.SYSCS_CHECK_TABLE(schemaname, tablename) from sys.systables a,  sys.sysschemas b where a.schemaid = b.schemaid");
        int n = 0;
        while (resultSet.next()) {
            ++n;
            if (resultSet.getInt(3) == 1) continue;
            System.out.println("Bad return from consistency check of " + resultSet.getString(1) + "." + resultSet.getString(2));
        }
        if (n < 5) {
            System.out.println("Something wrong with consistency check query, found only " + n + " tables.");
        }
        resultSet.close();
        statement.close();
        connection.commit();
        return true;
    }

    protected void createDebugSystemProcedures(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        statement.executeUpdate("CREATE FUNCTION D_CONGLOMID_PRINT(DBNAME VARCHAR(128), CONGLOMID INT) RETURNS VARCHAR(32000) RETURNS NULL ON NULL INPUT EXTERNAL NAME 'org.apache.derby.impl.store.raw.data.D_DiagnosticUtil.diag_conglomid' LANGUAGE JAVA PARAMETER STYLE JAVA");
        statement.executeUpdate("CREATE FUNCTION DIAG_CONGLOMID(DBNAME VARCHAR(128), CONGLOMID INT) RETURNS VARCHAR(32000) RETURNS NULL ON NULL INPUT EXTERNAL NAME 'org.apache.derby.impl.store.raw.data.D_DiagnosticUtil.diag_conglomid' LANGUAGE JAVA PARAMETER STYLE JAVA");
        statement.close();
        connection.commit();
        debug_system_procedures_created = true;
    }

    String dump_table(Connection connection, String string, String string2, boolean bl) throws SQLException {
        if (!debug_system_procedures_created) {
            this.createDebugSystemProcedures(connection);
        }
        PreparedStatement preparedStatement = connection.prepareStatement("select sys.systables.tablename, sys.sysconglomerates.conglomeratenumber, DIAG_CONGLOMID('wombat', conglomeratenumber) from sys.systables, sys.sysconglomerates where sys.systables.tableid = sys.sysconglomerates.tableid and sys.systables.schemaid = sys.sysconglomerates.schemaid and sys.systables.tablename = ?");
        preparedStatement.setString(1, string2);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (!resultSet.next()) {
            // empty if block
        }
        String string3 = resultSet.getString(3);
        resultSet.close();
        if (bl) {
            connection.commit();
        }
        return string3;
    }

    protected String get_lock_info(Connection connection, boolean bl) throws SQLException {
        Object object = "select cast(l.xid as char(8)) as xid, cast(username as char(8)) as username, cast(t.type as char(8)) as trantype, cast(l.type as char(8)) as type, cast(lockcount as char(3)) as cnt, cast(mode as char(4)) as mode, cast(tablename as char(12)) as tabname, cast(lockname as char(10)) as lockname, state, status from SYSCS_DIAG.LOCK_TABLE l right outer join SYSCS_DIAG.LOCK_TABLE t on l.xid = t.xid where l.tableType <> 'S' ";
        if (!bl) {
            object = (String)object + "and t.type='UserTransaction' ";
        }
        object = (String)object + "order by tabname, type desc, mode, cnt, lockname";
        PreparedStatement preparedStatement = connection.prepareStatement((String)object);
        ResultSet resultSet = preparedStatement.executeQuery();
        Object object2 = "xid     |username|trantype|type    |cnt|mode|tabname     |lockname  |state|status\n---------------------------------------------------------------------------------\n";
        while (resultSet.next()) {
            String string = resultSet.getString(1);
            String string2 = resultSet.getString(2);
            String string3 = resultSet.getString(3);
            String string4 = resultSet.getString(4);
            String string5 = resultSet.getString(5);
            String string6 = resultSet.getString(6);
            String string7 = resultSet.getString(7);
            String string8 = resultSet.getString(8);
            String string9 = resultSet.getString(9);
            object2 = (String)object2 + string + "|" + string2 + "|" + string3 + "|" + string4 + "|" + string5 + "|" + string6 + "|" + string7 + "|" + string8 + "|" + string9 + "\n";
        }
        resultSet.close();
        return object2;
    }

    public void createTable(Connection connection, String string, String string2) throws SQLException {
        Statement statement = connection.createStatement();
        try {
            statement.executeUpdate("drop table " + string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        statement.executeUpdate(string2);
    }

    protected int[] getSpaceInfo(Connection connection, String string, String string2, boolean bl) throws SQLException {
        String string3 = "select conglomeratename, isindex, numallocatedpages, numfreepages, numunfilledpages, pagesize, estimspacesaving from new org.apache.derby.diag.SpaceTable('" + string2 + "') t where isindex = 0";
        PreparedStatement preparedStatement = connection.prepareStatement(string3);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (!resultSet.next()) {
            // empty if block
        }
        int[] nArray = new int[6];
        String string4 = resultSet.getString(1);
        for (int i = 0; i < 6; ++i) {
            nArray[i] = resultSet.getInt(i + 2);
        }
        if (resultSet.next()) {
            // empty if block
        }
        if (verbose) {
            System.out.println("Space information for " + string + "." + string2 + ":");
            System.out.println("isindex = " + nArray[0]);
            System.out.println("num_alloc = " + nArray[1]);
            System.out.println("num_free = " + nArray[2]);
            System.out.println("num_unfilled = " + nArray[3]);
            System.out.println("page_size = " + nArray[4]);
            System.out.println("estimspacesaving = " + nArray[5]);
        }
        resultSet.close();
        if (bl) {
            connection.commit();
        }
        return nArray;
    }

    protected int total_pages(int[] nArray) {
        return nArray[2] + nArray[1];
    }
}

