/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.largedata;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Random;
import junit.extensions.TestSetup;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.largedata.BlobImplT;
import org.apache.derbyTesting.functionTests.tests.largedata.ClobImplT;
import org.apache.derbyTesting.functionTests.tests.largedata.RandomByteStreamT;
import org.apache.derbyTesting.functionTests.tests.largedata.RandomCharReaderT;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class LobLimitsTest
extends BaseJDBCTestCase {
    static boolean trace = false;
    static final int _2GB = Integer.MAX_VALUE;
    static final int _100MB = 0x6400000;
    static final long _4GB = 0x100000000L;
    static final int NUM_TRAILING_SPACES = 33792;
    static int BIGGEST_LOB_SZ = Integer.MAX_VALUE;
    static int BIG_LOB_SZ = 0x6400000;
    static int MORE_DATA_THAN_COL_WIDTH = 104857601;
    static final String DATAFILE = "extinout/byteLobLimits.dat";
    static final String CHARDATAFILE = "extinout/charLobLimits.txt";

    public LobLimitsTest(String string) {
        super(string);
    }

    public static void setBIGGEST_LOB_SZ(int n) {
        BIGGEST_LOB_SZ = n;
    }

    public static void setBIG_LOB_SZ(int n) {
        BIG_LOB_SZ = n;
    }

    public static void setMORE_DATA_THAN_COL_WIDTH(int n) {
        MORE_DATA_THAN_COL_WIDTH = n;
    }

    static void setupTables(Statement statement, int n, int n2) throws SQLException {
        LobLimitsTest.setBIGGEST_LOB_SZ(n);
        LobLimitsTest.setBIG_LOB_SZ(n2);
        LobLimitsTest.setMORE_DATA_THAN_COL_WIDTH(n2 + 1);
        LobLimitsTest.println("BIGGEST_LOB_SZ=" + BIGGEST_LOB_SZ + " BIG_LOB_SZ=" + BIG_LOB_SZ);
        statement.execute("CREATE TABLE BLOBTBL (ID INT NOT NULL PRIMARY KEY, POS BIGINT, DLEN BIGINT, CONTENT BLOB(2G))");
        statement.execute("CREATE TABLE CLOBTBL (ID INT NOT NULL PRIMARY KEY,POS BIGINT, DLEN BIGINT, CONTENT CLOB(2G))");
        statement.execute("CREATE TABLE BLOBTBL2 (ID INT NOT NULL PRIMARY KEY, POS BIGINT, CONTENT BLOB(" + BIG_LOB_SZ + "),DLEN BIGINT)");
        statement.execute("CREATE TABLE CLOBTBL2 (ID INT NOT NULL PRIMARY KEY,POS BIGINT, CONTENT CLOB(" + BIG_LOB_SZ + "), DLEN BIGINT)");
    }

    public static Test suite() {
        return LobLimitsTest.baseSuite(Integer.MAX_VALUE, 0x6400000);
    }

    static Test baseSuite(final int n, final int n2) {
        Properties properties = new Properties();
        properties.setProperty("derby.locks.deadlockTrace", "true");
        properties.setProperty("derby.locks.monitor", "true");
        TestSetup testSetup = new CleanDatabaseTestSetup((Test)new BaseTestSuite(LobLimitsTest.class)){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                LobLimitsTest.setupTables(statement, n, n2);
            }
        };
        testSetup = new SystemPropertyTestSetup((Test)testSetup, properties);
        return new SupportFilesSetup((Test)testSetup);
    }

    public void test_01_Blob() throws Exception {
        this.setAutoCommit(false);
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO BLOBTBL values (?,?,?,?)");
        PreparedStatement preparedStatement2 = this.prepareStatement("SELECT CONTENT,DLEN FROM BLOBTBL WHERE ID = ?");
        PreparedStatement preparedStatement3 = this.prepareStatement("INSERT INTO BLOBTBL2 values (?,?,?,?)");
        PreparedStatement preparedStatement4 = this.prepareStatement("SELECT CONTENT,DLEN FROM BLOBTBL2 WHERE ID = ?");
        this.insertBlob_SetBinaryStream("BlobTest #1", preparedStatement, BIGGEST_LOB_SZ, 0, 2, BIGGEST_LOB_SZ);
        this.selectBlob("BlobTest #2", preparedStatement2, BIGGEST_LOB_SZ, 0, 1);
        this.selectBlob("BlobTest #3", preparedStatement2, BIGGEST_LOB_SZ, 1, 1);
        this.selectUpdateBlob("BlobTest #4", preparedStatement2, BIGGEST_LOB_SZ, 0, 1);
        this.selectInsertBlob("BlobTest #4.1", preparedStatement2, preparedStatement, BIGGEST_LOB_SZ, 0, 3);
        FileOutputStream fileOutputStream = PrivilegedFileOpsForTests.getFileOutputStream(new File(DATAFILE));
        RandomByteStreamT randomByteStreamT = new RandomByteStreamT(new Random(), BIG_LOB_SZ);
        byte[] byArray = new byte[32768];
        int n = 0;
        while ((n = randomByteStreamT.read(byArray)) >= 0) {
            fileOutputStream.write(byArray, 0, n);
        }
        fileOutputStream.flush();
        fileOutputStream.close();
        this.insertBlob2("BlobTest #5.1 ", preparedStatement3, BIG_LOB_SZ, 0, 1, BIG_LOB_SZ, DATAFILE);
        this.selectBlob2("BlobTest #5.2 ", preparedStatement4, BIG_LOB_SZ, 0, 1, DATAFILE);
        this.selectUpdateBlob2("BlobTest #6", preparedStatement4, preparedStatement2, BIG_LOB_SZ, 0, 1, DATAFILE);
        this.deleteAndTruncateTable("BLOBTBL2", 1);
        this.commit();
        this.deleteAndTruncateTable("BLOBTBL", 3);
    }

    public void test_02_BlobNegative() throws SQLException {
        this.setAutoCommit(false);
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO BLOBTBL values (?,?,?,?)");
        BlobImplT blobImplT = new BlobImplT(new RandomByteStreamT(new Random(), 0x100000000L), 0x100000000L);
        try {
            this.insertBlob_SetBlob("BlobTest #7 (setBlob with 4Gb blob", preparedStatement, blobImplT, 0x100000000L, 0, 1, 0);
            LobLimitsTest.fail((String)"Inserting 4BG blob should have thrown exception");
        }
        catch (SQLException sQLException) {
            if (LobLimitsTest.usingDerbyNetClient()) {
                LobLimitsTest.assertSQLState("XN015", sQLException);
            } else {
                LobLimitsTest.assertSQLState("22003", sQLException);
            }
            this.commit();
        }
    }

    public void test_03_Clob1() throws Exception {
        this.setAutoCommit(false);
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO CLOBTBL values (?,?,?,?)");
        PreparedStatement preparedStatement2 = this.prepareStatement("SELECT CONTENT,DLEN FROM CLOBTBL WHERE ID = ?");
        this.insertClob_SetCharacterStream("ClobTest #1", preparedStatement, BIGGEST_LOB_SZ, 0, 2, BIGGEST_LOB_SZ);
        this.selectClob("ClobTest #2", preparedStatement2, BIGGEST_LOB_SZ, 0, 1);
        this.selectClob("ClobTest #3", preparedStatement2, BIGGEST_LOB_SZ, 0, 1);
        this.selectUpdateClob("ClobTest #4", preparedStatement2, BIGGEST_LOB_SZ, 0, 1);
    }

    public void test_04_Clob2() throws Exception {
        this.setAutoCommit(false);
        PreparedStatement preparedStatement = this.prepareStatement("SELECT CONTENT,DLEN FROM CLOBTBL WHERE ID = ?");
        PreparedStatement preparedStatement2 = this.prepareStatement("INSERT INTO CLOBTBL2 values (?,?,?,?)");
        PreparedStatement preparedStatement3 = this.prepareStatement("SELECT CONTENT,DLEN FROM CLOBTBL2 WHERE ID = ?");
        LobLimitsTest.writeToFile(CHARDATAFILE, new RandomCharReaderT(new Random(), BIG_LOB_SZ));
        this.insertClob2("ClobTest #5.1 ", preparedStatement2, BIG_LOB_SZ, 0, 1, BIG_LOB_SZ, CHARDATAFILE);
        this.selectClob2("ClobTest #5.2 ", preparedStatement3, BIG_LOB_SZ, 0, 1, CHARDATAFILE);
        if (!LobLimitsTest.usingEmbedded() || BIGGEST_LOB_SZ != Integer.MAX_VALUE) {
            this.updateClob2("ClobTest #8.1", preparedStatement, BIG_LOB_SZ, 0, 0, 10, CHARDATAFILE);
        }
        this.selectUpdateClob2("ClobTest #8.2", preparedStatement3, preparedStatement, BIG_LOB_SZ, 0, 1, CHARDATAFILE);
        LobLimitsTest.writeToFile(CHARDATAFILE, new RandomCharReaderT(new Random(), 33792 + BIG_LOB_SZ, 33792L));
        this.insertClob2("ClobTest #6.1 ", preparedStatement2, BIG_LOB_SZ, 3, 1, 33792 + BIG_LOB_SZ, CHARDATAFILE);
        this.selectClob2("ClobTest #6.2 ", preparedStatement3, BIG_LOB_SZ, 3, 1, CHARDATAFILE);
    }

    public void test_05_ClobNegative() throws Exception {
        this.setAutoCommit(false);
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO CLOBTBL values (?,?,?,?)");
        PreparedStatement preparedStatement2 = this.prepareStatement("SELECT CONTENT,DLEN FROM CLOBTBL WHERE ID = ?");
        PreparedStatement preparedStatement3 = this.prepareStatement("INSERT INTO CLOBTBL2 values (?,?,?,?)");
        PreparedStatement preparedStatement4 = this.prepareStatement("SELECT CONTENT,DLEN FROM CLOBTBL2 WHERE ID = ?");
        this.negativeSpaceTruncationTest("ClobTest #7");
        LobLimitsTest.writeToFile(CHARDATAFILE, new RandomCharReaderT(new Random(), MORE_DATA_THAN_COL_WIDTH));
        if (!LobLimitsTest.usingDerbyNetClient()) {
            try {
                this.insertClob2("ClobTest #9.1 ", preparedStatement3, MORE_DATA_THAN_COL_WIDTH, 4, 1, MORE_DATA_THAN_COL_WIDTH, CHARDATAFILE);
                LobLimitsTest.fail((String)"ClobTest #9.1 should have thrown XSDA4");
            }
            catch (SQLException sQLException) {
                LobLimitsTest.assertSQLState("XSDA4", sQLException);
            }
        }
        this.selectClob2("ClobTest #9.2 ", preparedStatement4, BIG_LOB_SZ, 4, 0, CHARDATAFILE);
        try {
            this.insertClob2("ClobTest #10 ", preparedStatement3, MORE_DATA_THAN_COL_WIDTH, 4, 1, MORE_DATA_THAN_COL_WIDTH + 1, CHARDATAFILE);
            LobLimitsTest.fail((String)"ClobTest #10. Should have thrown XSDA4");
        }
        catch (SQLException sQLException) {
            LobLimitsTest.assertSQLState("XSDA4", sQLException);
        }
        try {
            this.insertClob2("ClobTest #11 ", preparedStatement3, MORE_DATA_THAN_COL_WIDTH, 4, 1, MORE_DATA_THAN_COL_WIDTH - 1, CHARDATAFILE);
            LobLimitsTest.fail((String)"ClobTest #11. Should have thrown XSDA4");
        }
        catch (SQLException sQLException) {
            LobLimitsTest.assertSQLState("XSDA4", sQLException);
        }
        this.deleteAndTruncateTable("CLOBTBL2", 2);
        try {
            this.insertClob_SetCharacterStream("ClobTest #12.1", preparedStatement, BIG_LOB_SZ, 4, 1, -1);
            LobLimitsTest.fail((String)"ClobTest #12. Should have thrown XJ025");
        }
        catch (SQLException sQLException) {
            LobLimitsTest.assertSQLState("XJ025", sQLException);
        }
        this.selectClob("ClobTest #12.2", preparedStatement2, BIG_LOB_SZ, 4, 0);
        this.deleteAndTruncateTable("CLOBTBL", 2);
        ClobImplT clobImplT = new ClobImplT(new RandomCharReaderT(new Random(), 0x100000000L), 0x100000000L);
        try {
            this.insertClob_SetClob("ClobTest #13 (setClob with 4Gb clob", preparedStatement, clobImplT, 0x100000000L, 0, 1, 0);
            LobLimitsTest.fail((String)"ClobTest #13. Should have thrown 22033");
        }
        catch (SQLException sQLException) {
            if (LobLimitsTest.usingDerbyNetClient()) {
                LobLimitsTest.assertSQLState("XN015", sQLException);
            }
            LobLimitsTest.assertSQLState("22003", sQLException);
        }
        this.rollback();
    }

    public void test_06_shutdownDB() throws Exception {
        TestConfiguration.getCurrent().shutdownDatabase();
    }

    private void negativeSpaceTruncationTest(String string) throws Exception {
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO CLOBTBL2 values (?,?,?,?)");
        try {
            this.insertClob2(string, preparedStatement, BIG_LOB_SZ, 4, 1, 33792 + BIG_LOB_SZ - 1, CHARDATAFILE);
            LobLimitsTest.fail((String)(string + ". Should have thrown XSDA4"));
        }
        catch (SQLException sQLException) {
            LobLimitsTest.assertSQLState("XSDA4", sQLException);
        }
        try {
            this.insertClob2(string, preparedStatement, BIG_LOB_SZ, 5, 1, 33792 + BIG_LOB_SZ + 1, CHARDATAFILE);
            LobLimitsTest.fail((String)(string + ". Should have thrown XSDA4"));
        }
        catch (SQLException sQLException) {
            LobLimitsTest.assertSQLState("XSDA4", sQLException);
        }
    }

    private void insertBlob_SetBinaryStream(String string, PreparedStatement preparedStatement, int n, int n2, int n3, int n4) throws SQLException {
        LobLimitsTest.println("========================================");
        LobLimitsTest.println("START " + string + "insertBlob of size = " + n);
        long l = System.currentTimeMillis();
        int n5 = 0;
        Random random = new Random();
        for (int i = n2; i < n2 + n3; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setInt(2, 0);
            preparedStatement.setLong(3, n);
            preparedStatement.setBinaryStream(4, (InputStream)new RandomByteStreamT(random, n), n4);
            n5 += preparedStatement.executeUpdate();
        }
        this.commit();
        LobLimitsTest.println("Insert Blob (" + n + ") rows= " + n5 + " = " + (System.currentTimeMillis() - l));
        LobLimitsTest.verifyTest(n5, n3, " Rows inserted with blob of size (" + n + ") =");
        LobLimitsTest.println("========================================");
    }

    private void insertBlob_SetBlob(String string, PreparedStatement preparedStatement, Blob blob, long l, int n, int n2, int n3) throws SQLException {
        LobLimitsTest.println("========================================");
        LobLimitsTest.println("START " + string + "insertBlob of size = " + l);
        long l2 = System.currentTimeMillis();
        int n4 = 0;
        for (int i = n; i < n + n2; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setInt(2, 0);
            preparedStatement.setLong(3, l);
            preparedStatement.setBlob(4, blob);
            n4 += preparedStatement.executeUpdate();
        }
        this.commit();
        LobLimitsTest.println("Insert Blob (" + l + ") rows= " + n4 + " = " + (System.currentTimeMillis() - l2));
        LobLimitsTest.verifyTest(n4, n3, " Rows inserted with blob of size (" + l + ") =");
        LobLimitsTest.println("========================================");
    }

    private void selectBlob(String string, PreparedStatement preparedStatement, int n, int n2, int n3) throws SQLException {
        LobLimitsTest.println("========================================");
        LobLimitsTest.println("START " + string + " - SELECT BLOB of size = " + n);
        long l = System.currentTimeMillis();
        int n4 = 0;
        preparedStatement.setInt(1, n2);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            ++n4;
            Blob blob = resultSet.getBlob(1);
            long l2 = blob.length();
            long l3 = resultSet.getLong(2);
            LobLimitsTest.assertEquals((String)("FAIL - MISMATCH LENGTHS GOT " + l2 + " expected " + l3 + " for row in BLOBTBL with ID=" + n2), (long)l3, (long)l2);
        }
        resultSet.close();
        this.commit();
        LobLimitsTest.verifyTest(n4, n3, "Matched rows selected with blob of size(" + n + ") =");
        LobLimitsTest.println("Select Blob (" + n + ") rows= " + n3 + " = " + (System.currentTimeMillis() - l));
        LobLimitsTest.println("========================================");
    }

    private void insertBlob2(String string, PreparedStatement preparedStatement, int n, int n2, int n3, int n4, String string2) throws Exception {
        LobLimitsTest.println("========================================");
        LobLimitsTest.println("START " + string + "insert Blob of size = " + n);
        int n5 = 0;
        long l = System.currentTimeMillis();
        for (int i = n2; i < n2 + n3; ++i) {
            FileInputStream fileInputStream = PrivilegedFileOpsForTests.getFileInputStream(new File(string2));
            preparedStatement.setInt(1, i);
            preparedStatement.setInt(2, 0);
            preparedStatement.setLong(4, n);
            preparedStatement.setBinaryStream(3, (InputStream)fileInputStream, n4);
            n5 += preparedStatement.executeUpdate();
            fileInputStream.close();
        }
        this.commit();
        LobLimitsTest.println("Insert Blob (" + n + ") rows= " + n5 + " = " + (System.currentTimeMillis() - l));
        LobLimitsTest.verifyTest(n5, n3, " Rows inserted with blob of size (" + n + ") =");
        LobLimitsTest.println("========================================");
    }

    private void selectBlob2(String string, PreparedStatement preparedStatement, int n, int n2, int n3, String string2) throws Exception {
        LobLimitsTest.println("========================================");
        LobLimitsTest.println("START " + string + " - SELECT BLOB of size = " + n);
        long l = System.currentTimeMillis();
        int n4 = 0;
        preparedStatement.setInt(1, n2);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            ++n4;
            Blob blob = resultSet.getBlob(1);
            long l2 = blob.length();
            long l3 = resultSet.getLong(2);
            LobLimitsTest.assertEquals((String)("FAIL - MISMATCH LENGTHS GOT " + l2 + " expected " + l3 + " for row in BLOBTBL with ID=" + n2), (long)l3, (long)l2);
            LobLimitsTest.compareBlobToFile(blob.getBinaryStream(), string2);
        }
        resultSet.close();
        this.commit();
        LobLimitsTest.verifyTest(n4, n3, "Matched rows selected with blob of size(" + n + ") =");
        LobLimitsTest.println("Select Blob (" + n + ") rows= " + n3 + " = " + (System.currentTimeMillis() - l));
        LobLimitsTest.println("========================================");
    }

    private void selectUpdateBlob(String string, PreparedStatement preparedStatement, int n, int n2, int n3) throws Exception {
        LobLimitsTest.println("========================================");
        LobLimitsTest.println("START " + string + " - select and then update blob of size= " + n + " - Uses getBlob api");
        preparedStatement.setInt(1, n2);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        Blob blob = resultSet.getBlob(1);
        long l = blob.length();
        long l2 = resultSet.getLong(2);
        LobLimitsTest.assertEquals((String)("FAIL - MISMATCH LENGTHS GOT " + l + " expected " + l2 + " for row in BLOBTBL with ID=" + n2), (long)l2, (long)l);
        PreparedStatement preparedStatement2 = this.prepareStatement("update BLOBTBL set content=?,dlen =?where id = ?");
        preparedStatement2.setBlob(1, blob);
        preparedStatement2.setLong(2, l);
        preparedStatement2.setInt(3, n3);
        LobLimitsTest.println("Rows Updated = " + preparedStatement2.executeUpdate());
        this.commit();
        preparedStatement.setInt(1, n3);
        ResultSet resultSet2 = preparedStatement.executeQuery();
        resultSet2.next();
        Blob blob2 = resultSet2.getBlob(1);
        LobLimitsTest.assertEquals((String)("FAIL - Retrieving the updated blob length does not match expected length = " + l + " found = " + blob2.length()), (long)l, (long)blob2.length());
        this.commit();
        resultSet.close();
        resultSet2.close();
        LobLimitsTest.println("========================================");
    }

    private void selectInsertBlob(String string, PreparedStatement preparedStatement, PreparedStatement preparedStatement2, int n, int n2, int n3) throws Exception {
        LobLimitsTest.println("========================================");
        LobLimitsTest.println("START " + string + " - select and then insert blob of size= " + n + " - Uses getBlob api to do select and setBlob for insert");
        preparedStatement.setInt(1, n2);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        Blob blob = resultSet.getBlob(1);
        long l = blob.length();
        long l2 = resultSet.getLong(2);
        LobLimitsTest.assertEquals((String)("FAIL - MISMATCH LENGTHS GOT " + l + " expected " + l2 + " for row in BLOBTBL with ID=" + n2), (long)l2, (long)l);
        preparedStatement2.setInt(1, n3);
        preparedStatement2.setInt(2, 0);
        preparedStatement2.setLong(3, l);
        preparedStatement2.setBlob(4, blob);
        LobLimitsTest.assertUpdateCount(preparedStatement2, 1);
        this.commit();
        preparedStatement.setInt(1, n3);
        ResultSet resultSet2 = preparedStatement.executeQuery();
        resultSet2.next();
        Blob blob2 = resultSet2.getBlob(1);
        LobLimitsTest.assertEquals((String)("FAIL - Retrieving the updated blob length does not match expected length = " + l + " found = " + blob2.length()), (long)l, (long)blob2.length());
        this.commit();
        resultSet.close();
        resultSet2.close();
        LobLimitsTest.println("========================================");
    }

    private void selectUpdateBlob2(String string, PreparedStatement preparedStatement, PreparedStatement preparedStatement2, int n, int n2, int n3, String string2) throws Exception {
        LobLimitsTest.println("========================================");
        LobLimitsTest.println("START " + string + " - select and then update blob of size= " + n + " - Uses getBlob and setBlob  api");
        preparedStatement.setInt(1, n2);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        Blob blob = resultSet.getBlob(1);
        long l = blob.length();
        long l2 = resultSet.getLong(2);
        LobLimitsTest.assertEquals((String)("FAIL - MISMATCH LENGTHS GOT " + l + " expected " + l2 + " for row in BLOBTBL2 with ID=" + n2), (long)l2, (long)l);
        PreparedStatement preparedStatement3 = this.prepareStatement("update BLOBTBL set content=?,dlen =? where id = ?");
        preparedStatement3.setBlob(1, blob);
        preparedStatement3.setLong(2, l);
        preparedStatement3.setInt(3, n3);
        LobLimitsTest.assertUpdateCount(preparedStatement3, 1);
        this.commit();
        preparedStatement2.setInt(1, n3);
        ResultSet resultSet2 = preparedStatement2.executeQuery();
        resultSet2.next();
        Blob blob2 = resultSet2.getBlob(1);
        LobLimitsTest.assertEquals((String)("FAIL - MISMATCH length of updated blob value : expected=" + l + " found =" + blob2.length()), (long)l, (long)blob2.length());
        LobLimitsTest.compareBlobToFile(blob2.getBinaryStream(), string2);
        this.commit();
        resultSet.close();
        resultSet2.close();
        LobLimitsTest.println("========================================");
    }

    private static void compareBlobToFile(InputStream inputStream, String string) throws Exception {
        FileInputStream fileInputStream = PrivilegedFileOpsForTests.getFileInputStream(new File(string));
        LobLimitsTest.assertEquals(fileInputStream, inputStream);
    }

    private void deleteAndTruncateTable(String string, int n) throws SQLException {
        Statement statement = this.createStatement();
        int n2 = statement.executeUpdate("DELETE FROM " + JDBC.escape(string));
        statement.executeUpdate("TRUNCATE TABLE " + JDBC.escape(string));
        this.commit();
        LobLimitsTest.verifyTest(n2, n, "Rows deleted =");
    }

    private void insertClob_SetCharacterStream(String string, PreparedStatement preparedStatement, int n, int n2, int n3, int n4) throws SQLException {
        LobLimitsTest.println("========================================");
        LobLimitsTest.println("START " + string + "  -insertClob of size = " + n);
        Random random = new Random();
        int n5 = 0;
        long l = System.currentTimeMillis();
        for (int i = n2; i < n2 + n3; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setInt(2, 0);
            preparedStatement.setLong(3, n);
            preparedStatement.setCharacterStream(4, (Reader)new RandomCharReaderT(random, n), n4);
            n5 += preparedStatement.executeUpdate();
        }
        this.commit();
        LobLimitsTest.println("Insert Clob (" + n + ") rows= " + n5 + " = " + (System.currentTimeMillis() - l));
        LobLimitsTest.verifyTest(n5, n3, "Rows inserted with clob of size (" + n + ") = ");
        LobLimitsTest.println("========================================");
    }

    private void insertClob_SetClob(String string, PreparedStatement preparedStatement, Clob clob, long l, int n, int n2, int n3) throws SQLException {
        LobLimitsTest.println("========================================");
        LobLimitsTest.println("START " + string + "insertClob of size = " + l);
        long l2 = System.currentTimeMillis();
        int n4 = 0;
        for (int i = n; i < n + n2; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setInt(2, 0);
            preparedStatement.setLong(3, l);
            preparedStatement.setClob(4, clob);
            n4 += preparedStatement.executeUpdate();
        }
        this.commit();
        LobLimitsTest.println("Insert Clob (" + l + ") rows= " + n4 + " = " + (System.currentTimeMillis() - l2));
        LobLimitsTest.verifyTest(n4, n3, " Rows inserted with clob of size (" + l + ") =");
        LobLimitsTest.println("========================================");
    }

    private void selectClob(String string, PreparedStatement preparedStatement, int n, int n2, int n3) throws SQLException {
        LobLimitsTest.println("========================================");
        LobLimitsTest.println("START " + string + " - SELECT CLOB of size = " + n);
        int n4 = 0;
        long l = System.currentTimeMillis();
        preparedStatement.setInt(1, n2);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            ++n4;
            Clob clob = resultSet.getClob(1);
            long l2 = clob.length();
            long l3 = resultSet.getLong(2);
            LobLimitsTest.assertEquals((String)("FAIL - MISMATCH LENGTHS GOT " + l2 + " expected " + l3 + " for row in CLOBTBL with ID=" + n2), (long)l2, (long)l3);
        }
        resultSet.close();
        this.commit();
        LobLimitsTest.println("Select Clob (" + n + ") rows= " + n3 + " = " + (System.currentTimeMillis() - l));
        LobLimitsTest.verifyTest(n4, n3, "Matched rows selected with clob of size(" + n + ") =");
        LobLimitsTest.println("========================================");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertClob2(String string, PreparedStatement preparedStatement, int n, int n2, int n3, int n4, String string2) throws Exception {
        LobLimitsTest.println("========================================");
        LobLimitsTest.println("START " + string + "insert Clob of size = " + n);
        int n5 = 0;
        long l = System.currentTimeMillis();
        for (int i = n2; i < n2 + n3; ++i) {
            FileReader fileReader = PrivilegedFileOpsForTests.getFileReader(new File(string2));
            try {
                LobLimitsTest.println("Got reader for file " + string2 + " " + String.valueOf(fileReader));
                preparedStatement.setInt(1, i);
                preparedStatement.setInt(2, 0);
                preparedStatement.setLong(4, n);
                preparedStatement.setCharacterStream(3, (Reader)fileReader, n4);
                n5 += preparedStatement.executeUpdate();
                continue;
            }
            finally {
                fileReader.close();
                LobLimitsTest.println("Closed reader for file " + string2 + " " + String.valueOf(fileReader));
            }
        }
        this.commit();
        LobLimitsTest.println("Insert Clob (" + n + ") rows= " + n5 + " = " + (System.currentTimeMillis() - l));
        LobLimitsTest.verifyTest(n5, n3, " Rows inserted with clob of size (" + n + ") =");
        LobLimitsTest.println("========================================");
    }

    private void selectClob2(String string, PreparedStatement preparedStatement, int n, int n2, int n3, String string2) throws Exception {
        LobLimitsTest.println("========================================");
        LobLimitsTest.println("START " + string + " - SELECT CLOB of size = " + n);
        long l = System.currentTimeMillis();
        int n4 = 0;
        preparedStatement.setInt(1, n2);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            ++n4;
            Clob clob = resultSet.getClob(1);
            long l2 = clob.length();
            long l3 = resultSet.getLong(2);
            LobLimitsTest.assertEquals((String)("FAIL - MISMATCH LENGTHS GOT " + l2 + " expected " + l3 + " for row in CLOBTBL2 with ID=" + n2), (long)l2, (long)n);
            LobLimitsTest.compareClobToFile(clob.getCharacterStream(), string2, n);
        }
        resultSet.close();
        this.commit();
        LobLimitsTest.verifyTest(n4, n3, "Matched rows selected with clob of size(" + n + ") =");
        LobLimitsTest.println("Select Clob (" + n + ") rows= " + n3 + " = " + (System.currentTimeMillis() - l));
        LobLimitsTest.println("========================================");
    }

    private void selectUpdateClob(String string, PreparedStatement preparedStatement, int n, int n2, int n3) throws Exception {
        LobLimitsTest.println("========================================");
        LobLimitsTest.println("START " + string + " - select and then update clob of size= " + n + " - Uses setClob api");
        preparedStatement.setInt(1, n2);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        Clob clob = resultSet.getClob(1);
        long l = clob.length();
        long l2 = resultSet.getLong(2);
        LobLimitsTest.assertEquals((String)("FAIL - MISMATCH LENGTHS GOT " + l + " expected " + l2 + " for row in CLOBTBL with ID=" + n2), (long)l2, (long)l);
        PreparedStatement preparedStatement2 = this.prepareStatement("update CLOBTBL set content=?, dlen =? where id = ?");
        preparedStatement2.setCharacterStream(1, clob.getCharacterStream(), (int)l);
        preparedStatement2.setLong(2, l);
        preparedStatement2.setInt(3, n3);
        if (LobLimitsTest.usingDerbyNetClient()) {
            LobLimitsTest.assertPreparedStatementError("XN023", preparedStatement2);
            return;
        }
        LobLimitsTest.assertUpdateCount(preparedStatement2, 1);
        this.commit();
        preparedStatement.setInt(1, n3);
        ResultSet resultSet2 = preparedStatement.executeQuery();
        resultSet2.next();
        Clob clob2 = resultSet2.getClob(1);
        LobLimitsTest.assertEquals((String)("FAIL - Retrieving the updated clob length does not match expected length = " + l + " found = " + clob2.length()), (long)l, (long)clob2.length());
        this.commit();
        resultSet.close();
        resultSet2.close();
        LobLimitsTest.println("========================================");
    }

    private void selectUpdateClob2(String string, PreparedStatement preparedStatement, PreparedStatement preparedStatement2, int n, int n2, int n3, String string2) throws Exception {
        LobLimitsTest.println("========================================");
        LobLimitsTest.println("START " + string + " - select and then update clob of size= " + n + " - Uses setClob api");
        preparedStatement.setInt(1, n2);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        Clob clob = resultSet.getClob(1);
        long l = clob.length();
        long l2 = resultSet.getLong(2);
        LobLimitsTest.assertEquals((String)("FAIL - MISMATCH LENGTHS GOT " + l + " expected " + l2 + " for row in CLOBTBL2 with ID=" + n2), (long)l2, (long)l);
        PreparedStatement preparedStatement3 = this.prepareStatement("update CLOBTBL set content=?,dlen =? where id = ?");
        preparedStatement3.setClob(1, clob);
        preparedStatement3.setLong(2, l);
        preparedStatement3.setInt(3, n3);
        LobLimitsTest.assertUpdateCount(preparedStatement3, 1);
        this.commit();
        preparedStatement2.setInt(1, n3);
        ResultSet resultSet2 = preparedStatement2.executeQuery();
        resultSet2.next();
        Clob clob2 = resultSet2.getClob(1);
        LobLimitsTest.assertEquals((String)("FAIL - MISMATCH length of updated clob value , found=" + clob2.length() + ",expected = " + l), (long)l, (long)clob2.length());
        LobLimitsTest.compareClobToFile(clob2.getCharacterStream(), string2, (int)l);
        this.commit();
        resultSet.close();
        resultSet2.close();
        LobLimitsTest.println("========================================");
    }

    private void updateClob2(String string, PreparedStatement preparedStatement, int n, int n2, int n3, int n4, String string2) throws Exception {
        LobLimitsTest.println("========================================");
        LobLimitsTest.println("START " + string + " - select and then update clob of size= " + n + " - Uses updateClob api");
        PreparedStatement preparedStatement2 = this.prepareStatement("SELECT * FROM CLOBTBL FOR UPDATE", 1003, 1008);
        PreparedStatement preparedStatement3 = this.prepareStatement("SELECT CONTENT,DLEN FROM CLOBTBL2 where ID =?");
        preparedStatement3.setInt(1, n2);
        ResultSet resultSet = preparedStatement3.executeQuery();
        resultSet.next();
        Clob clob = resultSet.getClob(1);
        long l = clob.length();
        long l2 = resultSet.getLong(2);
        if (l2 != l) {
            LobLimitsTest.println("FAIL - MISMATCH LENGTHS GOT " + l + " expected " + l2 + " for row in CLOBTBL2 with ID=" + n2);
        }
        ResultSet resultSet2 = preparedStatement2.executeQuery();
        while (resultSet2.next()) {
            if (resultSet2.getInt(1) != n3) continue;
            resultSet2.updateClob(4, clob);
            resultSet2.updateInt(1, n4);
            resultSet2.updateInt(2, 0);
            resultSet2.updateLong(3, l2);
            resultSet2.updateRow();
            break;
        }
        this.commit();
        resultSet.close();
        resultSet2.close();
        preparedStatement.setInt(1, n4);
        ResultSet resultSet3 = preparedStatement.executeQuery();
        resultSet3.next();
        Clob clob2 = resultSet3.getClob(1);
        LobLimitsTest.assertEquals((String)("FAIL - MISMATCH length of updated clob value ,found=" + clob2.length() + ",expected = " + l), (long)l, (long)clob2.length());
        LobLimitsTest.compareClobToFile(clob2.getCharacterStream(), string2, (int)l);
        if (clob2.length() != l) {
            LobLimitsTest.println("FAIL - MISMATCH length of updated clob value ,found=" + clob2.length() + ",expected = " + l);
        } else {
            LobLimitsTest.compareClobToFile(clob2.getCharacterStream(), string2, (int)l);
        }
        LobLimitsTest.println("========================================");
    }

    private static void compareClobToFile(Reader reader, String string, int n) throws Exception {
        FileReader fileReader = PrivilegedFileOpsForTests.getFileReader(new File(string));
        int n2 = 0;
        int n3 = 0;
        long l = 0L;
        do {
            n2 = reader.read();
            n3 = fileReader.read();
            LobLimitsTest.assertEquals((String)("FAIL -- MISMATCH in data stored versus data retrieved at " + l + " " + n2 + " does not match " + n3), (int)n3, (int)n2);
            ++l;
        } while (n2 != -1 && n3 != -1 && --n > 0);
        fileReader.close();
    }

    private static void verifyTest(int n, int n2, String string) {
        LobLimitsTest.assertEquals((String)("FAIL --" + string + n + " , but expected rows =" + n2), (int)n2, (int)n);
        LobLimitsTest.println(string + n);
    }

    private static void writeToFile(String string, Reader reader) throws IOException {
        File file = new File(string);
        if (PrivilegedFileOpsForTests.exists(file)) {
            LobLimitsTest.assertTrue((boolean)PrivilegedFileOpsForTests.delete(file));
        }
        FileWriter fileWriter = PrivilegedFileOpsForTests.getFileWriter(file);
        LobLimitsTest.println("Got FileWriter for " + string + " " + String.valueOf(fileWriter));
        char[] cArray = new char[32768];
        int n = 0;
        while ((n = reader.read(cArray)) >= 0) {
            fileWriter.write(cArray, 0, n);
        }
        fileWriter.flush();
        fileWriter.close();
        LobLimitsTest.println("writer " + String.valueOf(fileWriter) + " for file " + string + " closed");
    }
}

