/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.RuntimeStatisticsParser;
import org.apache.derbyTesting.junit.SQLUtilities;

public class SelectivityTest
extends BaseJDBCTestCase {
    public SelectivityTest(String string) {
        super(string);
    }

    public static Test suite() {
        Properties properties = new Properties();
        properties.setProperty("derby.storage.indexStats.auto", "false");
        properties.setProperty("derby.language.statementCacheSize", "0");
        DatabasePropertyTestSetup databasePropertyTestSetup = new DatabasePropertyTestSetup((Test)new BaseTestSuite(SelectivityTest.class), properties, true);
        return new CleanDatabaseTestSetup((Test)databasePropertyTestSetup){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.executeUpdate("create table two (x int)");
                statement.executeUpdate("insert into two values (1),(2)");
                statement.executeUpdate("create table ten (x int)");
                statement.executeUpdate("insert into ten values (1),(2),(3),(4),(5),(6),(7),(8),(9),(10)");
                statement.executeUpdate("create table twenty (x int)");
                statement.executeUpdate("insert into twenty values (1),(2),(3),(4),(5),(6),(7),(8),(9),(10),(11),(12),(13),(14),(15),(16),(17),(18),(19),(20)");
                statement.executeUpdate("create table hundred (x int generated always as identity, dc int)");
                statement.executeUpdate("insert into hundred (dc) select t1.x from ten t1, ten t2");
                statement.executeUpdate("create table template (id int not null generated always as identity, two int, twenty int, hundred int)");
                statement.executeUpdate("insert into template (two, twenty, hundred) select two.x, twenty.x, hundred.x from two, twenty, hundred");
                statement.executeUpdate("create index template_two on template(two)");
                statement.executeUpdate("create index template_twenty on template(twenty)");
                statement.executeUpdate("create index template_22 on template(twenty,two)");
                statement.executeUpdate("create unique index template_id on template(id)");
                statement.executeUpdate("create index template_102 on template(hundred,two)");
                statement.executeUpdate("create table test (id int, two int, twenty int, hundred int)");
                statement.executeUpdate("create index test_id on test(id)");
                statement.executeUpdate("insert into test select * from template");
                statement.executeUpdate("create view showstats as select cast (conglomeratename as varchar(60)) indexname, cast (statistics as varchar(60)) stats, creationtimestamp createtime, colcount ncols from sys.sysstatistics, sys.sysconglomerates where conglomerateid = referenceid");
                ResultSet resultSet = statement.executeQuery("select indexname, stats, ncols from showstats order by indexname, stats, createtime, ncols");
                JDBC.assertFullResultSet(resultSet, new String[][]{{"TEMPLATE_102", "numunique= 100 numrows= 4000", "1"}, {"TEMPLATE_102", "numunique= 200 numrows= 4000", "2"}, {"TEMPLATE_22", "numunique= 20 numrows= 4000", "1"}, {"TEMPLATE_22", "numunique= 40 numrows= 4000", "2"}, {"TEMPLATE_TWENTY", "numunique= 20 numrows= 4000", "1"}, {"TEMPLATE_TWO", "numunique= 2 numrows= 4000", "1"}});
                statement.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TEMPLATE',null)");
                statement.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TEST',null)");
                resultSet = statement.executeQuery("select indexname, stats, ncols from showstats order by indexname, stats, createtime, ncols");
                JDBC.assertFullResultSet(resultSet, new String[][]{{"TEMPLATE_102", "numunique= 100 numrows= 4000", "1"}, {"TEMPLATE_102", "numunique= 200 numrows= 4000", "2"}, {"TEMPLATE_22", "numunique= 20 numrows= 4000", "1"}, {"TEMPLATE_22", "numunique= 40 numrows= 4000", "2"}, {"TEMPLATE_TWENTY", "numunique= 20 numrows= 4000", "1"}, {"TEMPLATE_TWO", "numunique= 2 numrows= 4000", "1"}, {"TEST_ID", "numunique= 4000 numrows= 4000", "1"}});
                statement.executeUpdate("create table t1 (id int generated always as identity, two int, twenty int, hundred varchar(3))");
                statement.executeUpdate("insert into t1 (hundred, twenty, two) select CAST(CHAR(hundred.x) AS VARCHAR(3)), twenty.x, two.x from hundred, twenty, two");
                statement.executeUpdate("create table t2 (id int generated always as identity, two int, twenty int, hundred varchar(3))");
                statement.executeUpdate("insert into t2 (hundred, twenty, two) select CAST(CHAR(hundred.x) AS VARCHAR(3)) , twenty.x, two.x from hundred, twenty, two");
                statement.executeUpdate("create table t3 (id int generated always as identity, two int, twenty int, hundred varchar(3))");
                statement.executeUpdate("insert into t3 (hundred, twenty, two) select CAST(CHAR(hundred.x) AS VARCHAR(3)), twenty.x, two.x from hundred, twenty, two");
                statement.executeUpdate("create index t1_hundred on t1(hundred)");
                statement.executeUpdate("create index t1_two_twenty on t1(two,twenty)");
                statement.executeUpdate("create index t1_twenty_hundred on t1(twenty, hundred)");
                statement.executeUpdate("create index t2_hundred on t2(hundred)");
                statement.executeUpdate("create index t2_two_twenty on t2(two,twenty)");
                statement.executeUpdate("create index t2_twenty_hundred on t2(twenty, hundred)");
                statement.executeUpdate("create index t3_hundred on t3(hundred)");
                statement.executeUpdate("create index t3_two_twenty on t3(two,twenty)");
                statement.executeUpdate("create index t3_twenty_hundred on t3(twenty, hundred)");
                statement.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T1',null)");
                statement.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T2',null)");
                statement.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T3',null)");
                resultSet = statement.executeQuery("select indexname, stats, ncols from showstats where indexname like 'T1%' order by indexname, stats");
                JDBC.assertFullResultSet(resultSet, new String[][]{{"T1_HUNDRED", "numunique= 100 numrows= 4000", "1"}, {"T1_TWENTY_HUNDRED", "numunique= 20 numrows= 4000", "1"}, {"T1_TWENTY_HUNDRED", "numunique= 2000 numrows= 4000", "2"}, {"T1_TWO_TWENTY", "numunique= 2 numrows= 4000", "1"}, {"T1_TWO_TWENTY", "numunique= 40 numrows= 4000", "2"}});
                resultSet = statement.executeQuery("select indexname, stats, ncols from showstats where indexname like 'T2%' order by indexname, stats");
                JDBC.assertFullResultSet(resultSet, new String[][]{{"T2_HUNDRED", "numunique= 100 numrows= 4000", "1"}, {"T2_TWENTY_HUNDRED", "numunique= 20 numrows= 4000", "1"}, {"T2_TWENTY_HUNDRED", "numunique= 2000 numrows= 4000", "2"}, {"T2_TWO_TWENTY", "numunique= 2 numrows= 4000", "1"}, {"T2_TWO_TWENTY", "numunique= 40 numrows= 4000", "2"}});
                resultSet = statement.executeQuery("select indexname, stats, ncols from showstats where indexname like 'T3%' order by indexname, stats");
                JDBC.assertFullResultSet(resultSet, new String[][]{{"T3_HUNDRED", "numunique= 100 numrows= 4000", "1"}, {"T3_TWENTY_HUNDRED", "numunique= 20 numrows= 4000", "1"}, {"T3_TWENTY_HUNDRED", "numunique= 2000 numrows= 4000", "2"}, {"T3_TWO_TWENTY", "numunique= 2 numrows= 4000", "1"}, {"T3_TWO_TWENTY", "numunique= 40 numrows= 4000", "2"}});
                statement.executeUpdate("create table scratch_table(id int, two int, twenty int, hundred int)");
                statement.executeUpdate("insert into scratch_table select id, two, twenty, CAST(CHAR(hundred) AS INTEGER) from t1");
                statement.executeUpdate("create index st_all on scratch_table(two, twenty, hundred)");
                statement.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','SCRATCH_TABLE',null)");
                statement.executeUpdate("create table complex(id int generated always as identity, two int, twenty int, hundred int, a int, b int)");
                statement.executeUpdate("insert into complex (two, twenty, hundred, a, b) select two.x, twenty.x, hundred.x, two.x, twenty.x from two, twenty, hundred");
                statement.executeUpdate("create index complexind on complex(two, twenty, hundred, a, b)");
                statement.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','COMPLEX',null)");
            }
        };
    }

    public void testSingleColumnSelectivity() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = this.createStatement();
        statement.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TEMPLATE',NULL)");
        statement.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TEST',NULL)");
        statement.executeUpdate("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        statement.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed\ntest, template where test.two = template.two").close();
        SelectivityTest.checkEstimatedRowCount(connection, 8020012.5);
        statement.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=hash \nwhere test.two = template.two").close();
        SelectivityTest.checkEstimatedRowCount(connection, 8020012.5);
        RuntimeStatisticsParser runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.usedHashJoin());
        statement.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=nestedLoop, index=null \nwhere test.two = template.two").close();
        SelectivityTest.checkEstimatedRowCount(connection, 8020012.5);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertFalse((boolean)runtimeStatisticsParser.usedHashJoin());
        statement.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=nestedLoop, index=template_two \nwhere test.two = template.two").close();
        SelectivityTest.checkEstimatedRowCount(connection, 8020012.5);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.usedSpecificIndexForIndexScan("TEMPLATE", "TEMPLATE_TWO"));
        statement.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=nestedLoop, index=template_twenty \nwhere test.twenty = template.twenty").close();
        SelectivityTest.checkEstimatedRowCount(connection, 802001.25);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.usedSpecificIndexForIndexScan("TEMPLATE", "TEMPLATE_TWENTY"));
        statement.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=nestedLoop, index=template_22 \nwhere test.twenty = template.twenty").close();
        SelectivityTest.checkEstimatedRowCount(connection, 802001.25);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.usedSpecificIndexForIndexScan("TEMPLATE", "TEMPLATE_22"));
        statement.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=nestedLoop, index=null \nwhere test.twenty = template.twenty").close();
        SelectivityTest.checkEstimatedRowCount(connection, 802001.25);
        statement.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=nestedLoop, index=template_102 \nwhere test.hundred = template.hundred and test.id <= 100").close();
        SelectivityTest.checkEstimatedRowCount(connection, 3924.9);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.usedSpecificIndexForIndexScan("TEST", "TEST_ID"));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.usedSpecificIndexForIndexScan("TEMPLATE", "TEMPLATE_102"));
        statement.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=nestedLoop, index=null \nwhere test.hundred = template.hundred and test.id <= 100").close();
        SelectivityTest.checkEstimatedRowCount(connection, 3924.9);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.usedSpecificIndexForIndexScan("TEST", "TEST_ID"));
        statement.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=hash, index=null \nwhere test.hundred = template.hundred and test.id <= 100").close();
        SelectivityTest.checkEstimatedRowCount(connection, 3924.9);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.usedHashJoin());
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.usedSpecificIndexForIndexScan("TEST", "TEST_ID"));
    }

    public void testMultiPredicate() throws SQLException {
        this.setAutoCommit(false);
        Connection connection = this.getConnection();
        Statement statement = this.createStatement();
        statement.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TEST',NULL)");
        statement.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TEMPLATE',NULL)");
        statement.executeUpdate("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        statement.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=hash, index=null \nwhere test.twenty = template.twenty and test.two = template.two").close();
        SelectivityTest.checkEstimatedRowCount(connection, 401000.625);
        RuntimeStatisticsParser runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.usedHashJoin());
        statement.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=nestedLoop, index=template_two \nwhere test.twenty = template.twenty and test.two = template.two").close();
        SelectivityTest.checkEstimatedRowCount(connection, 401000.625);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.usedSpecificIndexForIndexScan("TEMPLATE", "TEMPLATE_TWO"));
        statement.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=nestedLoop, index=template_twenty \nwhere test.twenty = template.twenty and test.two = template.two").close();
        SelectivityTest.checkEstimatedRowCount(connection, 401000.625);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.usedSpecificIndexForIndexScan("TEMPLATE", "TEMPLATE_TWENTY"));
        statement.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=nestedLoop, index=template_22 \nwhere test.twenty = template.twenty and test.two = template.two").close();
        SelectivityTest.checkEstimatedRowCount(connection, 401000.625);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.usedSpecificIndexForIndexScan("TEMPLATE", "TEMPLATE_22"));
        statement.executeUpdate("drop index template_22");
        statement.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=hash, index=null \nwhere test.twenty = template.twenty and test.two = template.two").close();
        SelectivityTest.checkEstimatedRowCount(connection, 401000.625);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.usedHashJoin());
        statement.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=nestedLoop, index=template_two \nwhere test.twenty = template.twenty and test.two = template.two").close();
        SelectivityTest.checkEstimatedRowCount(connection, 401000.625);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.usedSpecificIndexForIndexScan("TEMPLATE", "TEMPLATE_TWO"));
        statement.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=nestedLoop, index=template_twenty \nwhere test.twenty = template.twenty and test.two = template.two").close();
        SelectivityTest.checkEstimatedRowCount(connection, 401000.625);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.usedSpecificIndexForIndexScan("TEMPLATE", "TEMPLATE_TWENTY"));
        statement.executeUpdate("drop index template_two");
        statement.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=nestedLoop, index=null \nwhere test.twenty = template.twenty and test.two = template.two").close();
        SelectivityTest.checkEstimatedRowCount(connection, 80200.12500000001);
        statement.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=nestedLoop, index=template_twenty \nwhere test.twenty = template.twenty and test.two = template.two").close();
        SelectivityTest.checkEstimatedRowCount(connection, 80200.12500000001);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.usedSpecificIndexForIndexScan("TEMPLATE", "TEMPLATE_TWENTY"));
        statement.executeUpdate("drop index template_twenty");
        statement.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=nestedLoop, index=null \nwhere test.twenty = template.twenty and test.two = template.two").close();
        SelectivityTest.checkEstimatedRowCount(connection, 160400.25000000003);
        this.rollback();
    }

    public void testTwoWayJoins() throws SQLException {
        this.setAutoCommit(false);
        Connection connection = this.getConnection();
        Statement statement = this.createStatement();
        statement.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TEMPLATE',NULL)");
        statement.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TEST',NULL)");
        statement.executeUpdate("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        statement.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=nestedLoop, index=null \nwhere test.hundred = template.hundred and 1 = template.two").close();
        SelectivityTest.checkEstimatedRowCount(connection, 80200.125);
        statement.executeUpdate("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        statement.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=nestedLoop, index=template_102 \nwhere test.hundred = template.hundred and 1 = template.two").close();
        SelectivityTest.checkEstimatedRowCount(connection, 80200.125);
        RuntimeStatisticsParser runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.usedSpecificIndexForIndexScan("TEMPLATE", "TEMPLATE_102"));
        statement.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=nestedLoop, index=null \nwhere test.hundred = template.hundred and 1 = template.twenty").close();
        SelectivityTest.checkEstimatedRowCount(connection, 8020.0125);
        statement.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=nestedLoop, index=template_102 \nwhere test.hundred = template.hundred and 1 = template.twenty").close();
        SelectivityTest.checkEstimatedRowCount(connection, 8020.0125);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.usedSpecificIndexForIndexScan("TEMPLATE", "TEMPLATE_102"));
    }

    public void testThreeWayJoins() throws SQLException {
        this.setAutoCommit(false);
        Connection connection = this.getConnection();
        Statement statement = this.createStatement();
        statement.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T1',NULL)");
        statement.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T2',NULL)");
        statement.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T3',NULL)");
        statement.executeUpdate("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        statement.executeQuery("select t1.id from --DERBY-PROPERTIES joinOrder=fixed \nt1, t2, t3 where t1.hundred = t2.hundred and t1.twenty = t2.twenty and t2.two = t3.two").close();
        SelectivityTest.checkEstimatedRowCount(connection, 1.606007503125E7);
        RuntimeStatisticsParser runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Table Scan ResultSet for T1", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={0, 2, 3}", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Hash Scan ResultSet for T2", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={1, 2, 3}", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Hash Scan ResultSet for T3 using index T3_TWO_TWENTY", 1));
        statement.executeQuery("select t1.id from --DERBY-PROPERTIES joinOrder=fixed \nt1, t2, t3 where t1.hundred = t2.hundred and t2.two = t3.two and t1.hundred = t3.hundred").close();
        SelectivityTest.checkEstimatedRowCount(connection, 3212015.00625);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Table Scan ResultSet for T1", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={0, 3}", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Hash Scan ResultSet for T2", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={1, 3}", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Hash Scan ResultSet for T3", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={1, 3}", 1));
        statement.executeQuery("select t1.id from --DERBY-PROPERTIES joinOrder=fixed \nt1, t2, t3 --DERBY-PROPERTIES joinStrategy=hash \nwhere t1.hundred = t2.hundred and t2.two = t3.two and t1.hundred = t3.hundred").close();
        SelectivityTest.checkEstimatedRowCount(connection, 3212015.00625);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Table Scan ResultSet for T1", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={0, 3}", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Hash Scan ResultSet for T2", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={1, 3}", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Hash Scan ResultSet for T3", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={1, 3}", 1));
        statement.executeQuery("select t1.id from --DERBY-PROPERTIES joinOrder=fixed \nt1, t2, t3 --DERBY-PROPERTIES joinStrategy=nestedLoop \nwhere t1.hundred = t2.hundred and t2.two = t3.two and t1.hundred = t3.hundred").close();
        SelectivityTest.checkEstimatedRowCount(connection, 3212015.00625);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Table Scan ResultSet for T1", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={0, 3}", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Hash Scan ResultSet for T2", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={1, 3}", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.usedSpecificIndexForIndexScan("T3", "T3_HUNDRED"));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched=All", 1));
        statement.executeQuery("select t1.id from --DERBY-PROPERTIES joinOrder=fixed \nt1, t2 --DERBY-PROPERTIES joinStrategy=hash \n, t3 where t1.hundred = t2.hundred and t2.two = t3.two and t1.hundred = t3.hundred").close();
        SelectivityTest.checkEstimatedRowCount(connection, 3212015.00625);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Table Scan ResultSet for T1", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={0, 3}", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Hash Scan ResultSet for T2", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={1, 3}", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Hash Scan ResultSet for T3", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={1, 3}", 1));
        statement.executeQuery("select t1.id from --DERBY-PROPERTIES joinOrder=fixed \nt1, t2 --DERBY-PROPERTIES joinStrategy=hash \n, t3 where t1.hundred = t2.hundred and t2.two = t3.two and t1.hundred = t3.hundred").close();
        SelectivityTest.checkEstimatedRowCount(connection, 3212015.00625);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Table Scan ResultSet for T1", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={0, 3}", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Hash Scan ResultSet for T2", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={1, 3}", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Hash Scan ResultSet for T3", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={1, 3}", 1));
        statement.executeQuery("select t1.id from --DERBY-PROPERTIES joinOrder=fixed \nt2, t3, t1 where t1.hundred = t2.hundred and t2.two = t3.two and t1.hundred = t3.hundred").close();
        SelectivityTest.checkEstimatedRowCount(connection, 3212015.00625);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Table Scan ResultSet for T2", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={1, 3}", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Hash Scan ResultSet for T3", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={1, 3}", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Hash Scan ResultSet for T1", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={0, 3}", 1));
        statement.executeQuery("select t1.id from --DERBY-PROPERTIES joinOrder=fixed \nt3, t2, t1 --DERBY-PROPERTIES joinStrategy=hash \nwhere t1.hundred = t2.hundred and t2.two = t3.two and t1.hundred = t3.hundred").close();
        SelectivityTest.checkEstimatedRowCount(connection, 3212015.00625);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Table Scan ResultSet for T3", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={1, 3}", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Hash Scan ResultSet for T2", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={1, 3}", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Hash Scan ResultSet for T1", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={0, 3}", 1));
        statement.executeQuery("select t1.id from --DERBY-PROPERTIES joinOrder=fixed \nt3, t2, t1 --DERBY-PROPERTIES joinStrategy=nestedLoop \nwhere t1.hundred = t2.hundred and t2.two = t3.two and t1.hundred = t3.hundred").close();
        SelectivityTest.checkEstimatedRowCount(connection, 3212015.00625);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Table Scan ResultSet for T3", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={1, 3}", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Hash Scan ResultSet for T2", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={1, 3}", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.usedSpecificIndexForIndexScan("T1", "T1_HUNDRED"));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched=All", 1));
        statement.executeQuery("select t1.id from --DERBY-PROPERTIES joinOrder=fixed \nt2, t3 --DERBY-PROPERTIES joinStrategy=nestedLoop \n, t1 where t1.hundred = t2.hundred and t2.two = t3.two and t1.hundred = t3.hundred").close();
        SelectivityTest.checkEstimatedRowCount(connection, 3212015.00625);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Table Scan ResultSet for T2", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={1, 3}", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.usedSpecificIndexForIndexScan("T3", "T3_HUNDRED"));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched=All", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Hash Scan ResultSet for T1", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={0, 3}", 1));
        statement.executeQuery("select t1.id from --DERBY-PROPERTIES joinOrder=fixed \nt3, t2 --DERBY-PROPERTIES joinStrategy=hash \n, t1 where t1.hundred = t2.hundred and t2.two = t3.two and t1.hundred = t3.hundred").close();
        SelectivityTest.checkEstimatedRowCount(connection, 3212015.00625);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Table Scan ResultSet for T3", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={1, 3}", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Hash Scan ResultSet for T2", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={1, 3}", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Hash Scan ResultSet for T1", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={0, 3}", 1));
        statement.executeQuery("select t1.id from --DERBY-PROPERTIES joinOrder=fixed \nt2, t3, t1 where t1.hundred = t2.hundred and t2.two = t3.two and t1.hundred = t3.hundred and t1.hundred='1'").close();
        SelectivityTest.checkEstimatedRowCount(connection, 30458.025);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.usedSpecificIndexForIndexScan("T2", "T2_HUNDRED"));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched=All", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Hash Scan ResultSet for T3", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={1, 3}", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.usedSpecificIndexForIndexScan("T1", "T1_HUNDRED"));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched=All", 1));
        statement.executeQuery("select t1.id from --DERBY-PROPERTIES joinOrder=fixed \nt2, t3, t1 where t1.hundred = t2.hundred and t2.two = t3.two and t1.hundred = t3.hundred and t2.hundred = t3.hundred").close();
        SelectivityTest.checkEstimatedRowCount(connection, 3212015.00625);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Table Scan ResultSet for T2", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={1, 3}", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Hash Scan ResultSet for T3", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={1, 3}", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Hash Scan ResultSet for T1", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={0, 3}", 1));
        statement.executeQuery("select t1.id from --DERBY-PROPERTIES joinOrder=fixed \nt2, t3, t1 where t1.hundred = t2.hundred and t2.two = t3.two and t2.twenty = t3.twenty").close();
        SelectivityTest.checkEstimatedRowCount(connection, 1.606007503125E7);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Table Scan ResultSet for T2", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={1, 2, 3}", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Hash Scan ResultSet for T3 using index T3_TWO_TWENTY", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={0, 1}", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Hash Scan ResultSet for T1", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={0, 3}", 1));
        statement.executeQuery("select t1.id from --DERBY-PROPERTIES joinOrder=fixed \nt1, t2, t3 where t1.hundred = t2.hundred and t2.two = t3.two and t2.twenty = t3.twenty").close();
        SelectivityTest.checkEstimatedRowCount(connection, 1.606007503125E7);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Table Scan ResultSet for T1", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={0, 3}", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Hash Scan ResultSet for T2", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={1, 2, 3}", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Hash Scan ResultSet for T3 using index T3_TWO_TWENTY", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={0, 1}", 1));
        statement.executeQuery("select t1.id from --DERBY-PROPERTIES joinOrder=fixed \nt2, t1, t3 where t1.hundred = t2.hundred and t2.two = t3.two and t2.twenty = t3.twenty").close();
        SelectivityTest.checkEstimatedRowCount(connection, 1.606007503125E7);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Table Scan ResultSet for T2", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={1, 2, 3}", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Hash Scan ResultSet for T1", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={0, 3}", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Hash Scan ResultSet for T3 using index T3_TWO_TWENTY", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={0, 1}", 1));
        statement.executeQuery("select t1.id from --DERBY-PROPERTIES joinOrder=fixed \nt1, t3, t2 where t1.hundred = t2.hundred and t2.two = t3.two and t2.twenty = t3.twenty").close();
        SelectivityTest.checkEstimatedRowCount(connection, 1.606007503125E7);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Table Scan ResultSet for T1", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={0, 3}", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.usedSpecificIndexForIndexScan("T3", "T3_TWO_TWENTY"));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={0, 1}", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Hash Scan ResultSet for T2", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={1, 2, 3}", 1));
        statement.executeQuery("select t1.id from --DERBY-PROPERTIES joinOrder=fixed \nt3, t2, t1 where t1.hundred = t2.hundred and t2.two = t3.two and t2.twenty = t3.twenty").close();
        SelectivityTest.checkEstimatedRowCount(connection, 1.606007503125E7);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.usedSpecificIndexForIndexScan("T3", "T3_TWO_TWENTY"));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={0, 1}", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Hash Scan ResultSet for T2", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={1, 2, 3}", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Hash Scan ResultSet for T1", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={0, 3}", 1));
        statement.executeQuery("select t1.id from --DERBY-PROPERTIES joinOrder=fixed \nt3, t1, t2 where t1.hundred = t2.hundred and t2.two = t3.two and t2.twenty = t3.twenty").close();
        SelectivityTest.checkEstimatedRowCount(connection, 1.606007503125E7);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.usedSpecificIndexForIndexScan("T3", "T3_TWO_TWENTY"));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={0, 1}", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Table Scan ResultSet for T1", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={0, 3}", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Hash Scan ResultSet for T2", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={1, 2, 3}", 1));
        statement.executeQuery("select t1.id from --DERBY-PROPERTIES useStatistics=false, joinOrder=fixed \nt3, t1, t2 where t1.hundred = t2.hundred and t2.two = t3.two and t2.twenty = t3.twenty").close();
        SelectivityTest.checkEstimatedRowCount(connection, 6.4240300125000015E7);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.usedSpecificIndexForIndexScan("T3", "T3_TWO_TWENTY"));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={0, 1}", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Table Scan ResultSet for T1", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={0, 3}", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Hash Scan ResultSet for T2", 1));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched={1, 2, 3}", 1));
    }

    public void testScratch() throws SQLException {
        this.setAutoCommit(false);
        Connection connection = this.getConnection();
        Statement statement = this.createStatement();
        statement.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T1',NULL)");
        statement.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','SCRATCH_TABLE',NULL)");
        statement.executeUpdate("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        statement.executeQuery("select s.id from --DERBY-PROPERTIES joinOrder=fixed \nt1, scratch_table s where t1.two = s.two and s.hundred = CAST(CHAR(t1.hundred) AS INTEGER)").close();
        SelectivityTest.checkEstimatedRowCount(connection, 802001.25);
        RuntimeStatisticsParser runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.usedHashJoin());
        statement.executeQuery("select s.id from --DERBY-PROPERTIES joinOrder=fixed \nt1, scratch_table s where t1.twenty = s.twenty").close();
        SelectivityTest.checkEstimatedRowCount(connection, 1604002.5);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.usedSpecificIndexForIndexScan("T1", "T1_TWO_TWENTY"));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.usedHashJoin());
        statement.executeQuery("select s.id from --DERBY-PROPERTIES joinOrder=fixed \nt1, scratch_table s where t1.twenty = s.twenty and s.hundred = CAST(CHAR(t1.hundred) AS INTEGER)").close();
        SelectivityTest.checkEstimatedRowCount(connection, 160400.25);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.usedSpecificIndexForIndexScan("T1", "T1_TWENTY_HUNDRED"));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.usedHashJoin());
    }

    public void testStatMatcher() throws SQLException {
        this.setAutoCommit(false);
        Connection connection = this.getConnection();
        Statement statement = this.createStatement();
        statement.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T1',NULL)");
        statement.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T2',NULL)");
        statement.executeUpdate("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        statement.executeQuery("select t1.id from t1, t2 where t1.two = t2.two and t1.twenty = t2.twenty and t1.hundred = t2.hundred").close();
        SelectivityTest.checkEstimatedRowCount(connection, 4010.00625);
        RuntimeStatisticsParser runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.usedHashJoin());
        statement.executeQuery("select t1.id from t1, t2 where t1.two = t2.two and t1.hundred = t2.hundred and t1.twenty = t2.twenty").close();
        SelectivityTest.checkEstimatedRowCount(connection, 4010.00625);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.usedHashJoin());
        statement.executeQuery("select t1.id from t1, t2 where t1.hundred = t2.hundred and t1.twenty = t2.twenty and t1.two = t2.two").close();
        SelectivityTest.checkEstimatedRowCount(connection, 4010.00625);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.usedHashJoin());
        statement.executeQuery("select t1.id from t1, t2 where t1.hundred = t2.hundred and t1.two = t2.two and t1.twenty = t2.twenty").close();
        SelectivityTest.checkEstimatedRowCount(connection, 4010.00625);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.usedHashJoin());
        statement.executeQuery("select t1.id from t1, t2 where t1.twenty = t2.twenty and t1.hundred = t2.hundred and t1.two = t2.two").close();
        SelectivityTest.checkEstimatedRowCount(connection, 4010.00625);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.usedHashJoin());
        statement.executeQuery("select t1.id from t1, t2 where t1.twenty = t2.twenty and t1.two = t2.two and t1.hundred = t2.hundred").close();
        SelectivityTest.checkEstimatedRowCount(connection, 4010.00625);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.usedHashJoin());
    }

    public void testBeetle4321() throws SQLException {
        this.setAutoCommit(false);
        Connection connection = this.getConnection();
        Statement statement = this.createStatement();
        statement.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','COMPLEX',NULL)");
        statement.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TEMPLATE',NULL)");
        statement.executeUpdate("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        statement.executeQuery("select t10.two from complex t10, template t20 where t10.two = 1 and t10.hundred = 2 and t10.a = 2 and t10.b = 2").close();
        SelectivityTest.checkEstimatedRowCount(connection, 7945.92);
        RuntimeStatisticsParser runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.usedSpecificIndexForIndexScan("COMPLEX", "COMPLEXIND"));
        SelectivityTest.assertTrue((boolean)runtimeStatisticsParser.usedSpecificIndexForIndexScan("TEMPLATE", "TEMPLATE_TWO"));
    }

    public void testBasic() throws SQLException {
        int n;
        int n2;
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        statement.executeUpdate("create table tbasic1 (c1 int generated always as identity, c2 int, c3 int)");
        for (int i = 1; i < 5; ++i) {
            for (int j = 1; j < 3; ++j) {
                for (n2 = 0; n2 < 2; ++n2) {
                    statement.executeUpdate("insert into tbasic1 values (default, " + i + ", " + j + ")");
                }
            }
        }
        statement.executeUpdate("create index t1_c1c2 on tbasic1 (c1, c2)");
        ResultSet resultSet = statement.executeQuery("select indexname, stats, ncols from showstats where indexname like 'T1_C1C2%' order by indexname, stats, ncols");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"T1_C1C2", "numunique= 16 numrows= 16", "1"}, {"T1_C1C2", "numunique= 16 numrows= 16", "2"}});
        statement.executeUpdate("drop index t1_c1c2");
        resultSet = statement.executeQuery("select indexname, stats, ncols from showstats where indexname like 'T1_C1C2%' order by indexname");
        JDBC.assertEmpty(resultSet);
        statement.executeUpdate("create table tbasic2 (i int not null, vc varchar(32) not null, dt date, ch char(20), constraint pk primary key (i, vc))");
        statement.executeUpdate("create index tbasic2_i on tbasic2(i)");
        statement.executeUpdate("create index tbasic2_ch_dt on tbasic2(ch, dt)");
        statement.executeUpdate("create index tbasic2_dt_vc on tbasic2(dt, vc)");
        statement.executeUpdate("insert into tbasic2 values (1, 'one', '2001-01-01', 'one')");
        statement.executeUpdate("insert into tbasic2 values (2, 'two', '2001-01-02', 'two')");
        statement.executeUpdate("insert into tbasic2 values (3, 'three', '2001-01-03', 'three')");
        statement.executeUpdate("insert into tbasic2 values (1, 'two', '2001-01-02', 'one')");
        statement.executeUpdate("insert into tbasic2 values (1, 'three', '2001-01-03', 'one')");
        statement.executeUpdate("insert into tbasic2 values (2, 'one', '2001-01-01', 'two')");
        resultSet = statement.executeQuery("select conglomeratename from sys.sysconglomerates where conglomeratename like 'SQL%'");
        resultSet.next();
        String string = resultSet.getString("conglomeratename");
        statement.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TBASIC2','" + string + "')");
        resultSet = statement.executeQuery("select indexname, stats, ncols from showstats where indexname like 'SQL%' order by indexname, stats, ncols");
        JDBC.assertFullResultSet(resultSet, new String[][]{{string, "numunique= 3 numrows= 6", "1"}, {string, "numunique= 6 numrows= 6", "2"}});
        statement.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TBASIC2','TBASIC2_I')");
        resultSet = statement.executeQuery("select indexname, stats, ncols from showstats where indexname = 'TBASIC2_I' order by indexname");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"TBASIC2_I", "numunique= 3 numrows= 6", "1"}});
        statement.executeUpdate("insert into tbasic2 values(2, 'three', '2001-01-03', 'two')");
        statement.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TBASIC2',null)");
        resultSet = statement.executeQuery("select indexname, stats, ncols from showstats where indexname = 'TBASIC2_I' order by indexname");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"TBASIC2_I", "numunique= 3 numrows= 7", "1"}});
        resultSet = statement.executeQuery("select count(*) from (select distinct i from tbasic2) t");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"3"}});
        resultSet = statement.executeQuery("select indexname, stats, ncols from showstats where indexname = 'TBASIC2_CH_DT' order by indexname, stats");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"TBASIC2_CH_DT", "numunique= 3 numrows= 7", "1"}, {"TBASIC2_CH_DT", "numunique= 7 numrows= 7", "2"}});
        resultSet = statement.executeQuery("select count(*) from (select distinct ch from tbasic2) t");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"3"}});
        resultSet = statement.executeQuery("select count(*) from (select distinct ch, dt from tbasic2) t");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"7"}});
        resultSet = statement.executeQuery("select indexname, stats, ncols from showstats where indexname = 'TBASIC2_DT_VC' order by indexname, stats, ncols");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"TBASIC2_DT_VC", "numunique= 3 numrows= 7", "1"}, {"TBASIC2_DT_VC", "numunique= 3 numrows= 7", "2"}});
        resultSet = statement.executeQuery("select count(*) from (select distinct dt from tbasic2) t");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"3"}});
        resultSet = statement.executeQuery("select count(*) from (select distinct dt, vc from tbasic2) t");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"3"}});
        resultSet = statement.executeQuery("select stats, ncols from showstats where indexname like 'SQL%' order by stats, ncols");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"numunique= 3 numrows= 7", "1"}, {"numunique= 7 numrows= 7", "2"}});
        SelectivityTest.assertUpdateCount(statement, 7, "delete from tbasic2");
        resultSet = statement.executeQuery("select indexname, stats, ncols from showstats where indexname like 'TBASIC2%' order by indexname, stats, ncols");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"TBASIC2_CH_DT", "numunique= 3 numrows= 7", "1"}, {"TBASIC2_CH_DT", "numunique= 7 numrows= 7", "2"}, {"TBASIC2_DT_VC", "numunique= 3 numrows= 7", "1"}, {"TBASIC2_DT_VC", "numunique= 3 numrows= 7", "2"}, {"TBASIC2_I", "numunique= 3 numrows= 7", "1"}});
        statement.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TBASIC2',null)");
        resultSet = statement.executeQuery("select indexname, stats, ncols from showstats where indexname like 'TBASIC2%' order by indexname, stats, ncols");
        JDBC.assertEmpty(resultSet);
        statement.executeUpdate("drop table tbasic2");
        statement.executeUpdate("create table tbasic3 (x int not null generated always as identity, y int not null, z int)");
        statement.executeUpdate("insert into tbasic3 (y,z) values (1,1),(1,2),(1,3),(1,null),(2,1),(2,2),(2,3),(2,null)");
        statement.executeUpdate("alter table tbasic3 add constraint pk_tbasic3 primary key (x,y)");
        resultSet = statement.executeQuery("select conglomeratename from sys.sysconglomerates where conglomeratename like 'SQL%'");
        resultSet.next();
        string = resultSet.getString("conglomeratename");
        resultSet = statement.executeQuery("select stats, ncols from showstats where indexname like '" + string + "' order by stats, ncols");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"numunique= 8 numrows= 8", "1"}, {"numunique= 8 numrows= 8", "2"}});
        statement.executeUpdate("alter table tbasic3 drop constraint pk_tbasic3");
        resultSet = statement.executeQuery("select stats, ncols from showstats where indexname like '" + string + "' order by stats, ncols");
        JDBC.assertEmpty(resultSet);
        for (n2 = 0; n2 < 9; ++n2) {
            statement.executeUpdate("insert into tbasic3(y,z) select y,z from tbasic3");
        }
        resultSet = statement.executeQuery("select count(*) from tbasic3");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"4096"}});
        statement.executeUpdate("create index tbasic3_xy on tbasic3(x,y)");
        resultSet = statement.executeQuery("select indexname, stats, ncols from showstats where indexname like 'TBASIC3_XY%' order by indexname, stats, ncols");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"TBASIC3_XY", "numunique= 4096 numrows= 4096", "1"}, {"TBASIC3_XY", "numunique= 4096 numrows= 4096", "2"}});
        statement.executeUpdate("delete from tbasic3 where z is null");
        statement.executeUpdate("call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'TBASIC3', 0)");
        resultSet = statement.executeQuery("select indexname, stats, ncols from showstats where indexname like 'TBASIC3_XY%' order by indexname, stats, ncols");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"TBASIC3_XY", "numunique= 3072 numrows= 3072", "1"}, {"TBASIC3_XY", "numunique= 3072 numrows= 3072", "2"}});
        statement.executeUpdate("drop table tbasic3");
        statement.executeUpdate("create table tbasic4 (x int, y int, z int)");
        statement.executeUpdate("insert into tbasic4 values (1,1,1)");
        statement.executeUpdate("insert into tbasic4 values (1,2,1)");
        statement.executeUpdate("insert into tbasic4 values (1,1,2)");
        statement.executeUpdate("create index tbasic4_x on tbasic4(x)");
        statement.executeUpdate("create index tbasic4_xy on tbasic4(x,y)");
        statement.executeUpdate("create index tbasic4_yz on tbasic4(y,z)");
        resultSet = statement.executeQuery("select indexname, stats, ncols from showstats where indexname like 'TBASIC4%' order by indexname, stats, ncols");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"TBASIC4_X", "numunique= 1 numrows= 3", "1"}, {"TBASIC4_XY", "numunique= 1 numrows= 3", "1"}, {"TBASIC4_XY", "numunique= 2 numrows= 3", "2"}, {"TBASIC4_YZ", "numunique= 2 numrows= 3", "1"}, {"TBASIC4_YZ", "numunique= 3 numrows= 3", "2"}});
        statement.executeUpdate("alter table tbasic4 drop column x");
        resultSet = statement.executeQuery("select indexname, stats, ncols from showstats where indexname like 'TBASIC4%' order by indexname, stats, ncols");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"TBASIC4_XY", "numunique= 2 numrows= 3", "1"}, {"TBASIC4_YZ", "numunique= 2 numrows= 3", "1"}, {"TBASIC4_YZ", "numunique= 3 numrows= 3", "2"}});
        statement.executeUpdate("drop table tbasic4");
        statement.executeUpdate("create table tbasic6 (i int generated always as identity, j varchar(10))");
        statement.executeUpdate("create index tbasic6_i on tbasic6(i)");
        statement.executeUpdate("create index tbasic6_j on tbasic6(j)");
        statement.executeUpdate("create index tbasic6_ji on tbasic6(j,i)");
        char[] cArray = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i'};
        for (n = 0; n < cArray.length - 1; ++n) {
            statement.executeUpdate("insert into tbasic6 values (default, '" + cArray[n] + "')");
        }
        for (n = 0; n < cArray.length; ++n) {
            statement.executeUpdate("insert into tbasic6 values (default, '" + cArray[n] + "')");
        }
        for (n = 0; n < cArray.length - 1; ++n) {
            statement.executeUpdate("insert into tbasic6 values (default, '" + cArray[n] + "')");
        }
        statement.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TBASIC6','TBASIC6_J')");
        statement.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TBASIC6',NULL)");
        resultSet = statement.executeQuery("select indexname, stats, ncols from showstats where indexname like 'TBASIC6%' order by indexname, stats, ncols");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"TBASIC6_I", "numunique= 25 numrows= 25", "1"}, {"TBASIC6_J", "numunique= 9 numrows= 25", "1"}, {"TBASIC6_JI", "numunique= 25 numrows= 25", "2"}, {"TBASIC6_JI", "numunique= 9 numrows= 25", "1"}});
        statement.executeUpdate("delete from TBASIC6");
        for (n = 0; n < 17; ++n) {
            statement.executeUpdate("insert into tbasic6 values (default, 'a')");
        }
        statement.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TBASIC6',NULL)");
        resultSet = statement.executeQuery("select indexname, stats, ncols from showstats where indexname like 'TBASIC6%' order by indexname, stats, ncols");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"TBASIC6_I", "numunique= 17 numrows= 17", "1"}, {"TBASIC6_J", "numunique= 1 numrows= 17", "1"}, {"TBASIC6_JI", "numunique= 1 numrows= 17", "1"}, {"TBASIC6_JI", "numunique= 17 numrows= 17", "2"}});
        statement.executeUpdate("drop table tbasic6");
        statement.executeUpdate("create table et (x int, y int)");
        statement.executeUpdate("create index etx on et(x)");
        statement.executeUpdate("create index ety on et(y)");
        statement.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','ET','ETX')");
        statement.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','ET',NULL)");
        resultSet = statement.executeQuery("select indexname, stats, ncols from showstats where indexname like 'ET%' order by indexname, stats, ncols");
        JDBC.assertEmpty(resultSet);
        statement.executeUpdate("drop table et");
        statement.executeUpdate("create table null_table (x int, y varchar(2))");
        statement.executeUpdate("create index nt_x on null_table(x desc)");
        for (n = 1; n < 4; ++n) {
            statement.executeUpdate("insert into null_table values (" + n + ", '" + cArray[n - 1] + "')");
        }
        for (n = 0; n < 2; ++n) {
            for (int i = 1; i < 4; ++i) {
                statement.executeUpdate("insert into null_table values (null, '" + cArray[i - 1] + "')");
            }
        }
        statement.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','NULL_TABLE',NULL)");
        resultSet = statement.executeQuery("select indexname, stats, ncols from showstats where indexname = 'NT_X' order by indexname, stats, ncols");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"NT_X", "numunique= 9 numrows= 9", "1"}});
        statement.executeUpdate("drop index nt_x");
        statement.executeUpdate("create index nt_yx on null_table(y,x)");
        resultSet = statement.executeQuery("select indexname, stats, ncols from showstats where indexname = 'NT_YX' order by indexname, stats, ncols");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"NT_YX", "numunique= 3 numrows= 9", "1"}, {"NT_YX", "numunique= 9 numrows= 9", "2"}});
    }

    @Override
    protected void tearDown() throws Exception {
        Statement statement = this.createStatement();
        try {
            statement.execute("drop table tbasic1");
            statement.execute("drop table tbasic2");
            statement.execute("drop table tbasic3");
            statement.execute("drop table tbasic4");
            statement.execute("drop table tbasic6");
            statement.execute("drop table et");
            statement.execute("drop table null_table");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        statement.close();
        super.tearDown();
    }
}

