/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import java.awt.Color;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.EnumNumber;
import org.apache.fop.fo.properties.EnumProperty;
import org.apache.fop.fo.properties.FixedLength;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyMaker;

public class NumberProperty
extends Property
implements Numeric {
    private Number number;

    public NumberProperty(Number num) {
        this.number = num;
    }

    public NumberProperty(double num) {
        this.number = new Double(num);
    }

    public NumberProperty(int num) {
        this.number = new Integer(num);
    }

    public int getDimension() {
        return 0;
    }

    public double getNumericValue() {
        return this.number.doubleValue();
    }

    public double getNumericValue(PercentBaseContext context) {
        return this.getNumericValue();
    }

    public int getValue() {
        return this.number.intValue();
    }

    public int getValue(PercentBaseContext context) {
        return this.getValue();
    }

    public boolean isAbsolute() {
        return true;
    }

    public Number getNumber() {
        return this.number;
    }

    public Object getObject() {
        return this.number;
    }

    public Numeric getNumeric() {
        return this;
    }

    public Length getLength() {
        return new FixedLength(this.getNumericValue(), "px");
    }

    public Color getColor(FOUserAgent foUserAgent) {
        return Color.black;
    }

    public static class Maker
    extends PropertyMaker {
        public Maker(int propId) {
            super(propId);
        }

        public Property convertProperty(Property p, PropertyList propertyList, FObj fo) throws PropertyException {
            if (p instanceof NumberProperty) {
                return p;
            }
            if (p instanceof EnumProperty) {
                return EnumNumber.getInstance(p);
            }
            Number val = p.getNumber();
            if (val != null) {
                return new NumberProperty(val);
            }
            return this.convertPropertyDatatype(p, propertyList, fo);
        }
    }
}

