/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class UngroupedAggregatesNegativeTest
extends BaseJDBCTestCase {
    public UngroupedAggregatesNegativeTest(String string) {
        super(string);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(UngroupedAggregatesNegativeTest.class);
    }

    public void setUp() throws SQLException {
        String string = "create table t1 (c1 int)";
        Statement statement = this.createStatement();
        statement.executeUpdate(string);
        string = "create table t2 (c1 int)";
        statement.executeUpdate(string);
        string = "insert into t2 values 1,2,3";
        UngroupedAggregatesNegativeTest.assertEquals((int)3, (int)statement.executeUpdate(string));
        statement.close();
    }

    @Override
    public void tearDown() throws Exception {
        this.dropTable("t1");
        this.dropTable("t2");
        super.tearDown();
    }

    public void testSelect() throws SQLException {
        String string = "select c1, max(c1) from t1";
        this.assertCompileError("42Y35", string);
        string = "select c1 * max(c1) from t1";
        this.assertCompileError("42Y35", string);
    }

    public void testWhereClause() {
        String string = "select c1 from t1 where max(c1) = 1";
        this.assertCompileError("42903", string);
    }

    public void testOnClause() {
        String string = "select * from t1 join t1 as t2 on avg(t2.c1) > 10";
        this.assertCompileError("42Z07", string);
    }

    public void testSubquery() throws SQLException {
        String string = "select max(c1), (select t2.c1 from t2 where t1.c1 = t2.c1) from t1";
        this.assertCompileError("42Y29", string);
        string = "select max(c1), (select t2.c1 from t2) from t1";
        Statement statement = this.createStatement();
        UngroupedAggregatesNegativeTest.assertStatementError("21000", statement, string);
        statement.close();
    }
}

