/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;

public class metadataMultiConnTest
extends BaseJDBCTestCase {
    public metadataMultiConnTest(String string) {
        super(string);
    }

    public static Test suite() {
        return new BaseTestSuite(metadataMultiConnTest.class);
    }

    public void testMetadataMultiConn() throws SQLException {
        Connection connection = this.openDefaultConnection();
        this.metadataCalls(connection);
        Connection connection2 = this.openDefaultConnection();
        this.metadataCalls(connection2);
        Connection connection3 = this.openDefaultConnection();
        this.metadataCalls(connection3);
        connection.commit();
        connection2.commit();
        this.checkConsistencyOfAllTables(connection3);
    }

    public void metadataCalls(Connection connection) throws SQLException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        this.getTypeInfo(databaseMetaData);
        this.getTables(databaseMetaData);
        this.getColumnInfo(databaseMetaData);
        this.getPrimaryKeys(databaseMetaData);
        this.getExportedKeys(databaseMetaData);
    }

    public void getTypeInfo(DatabaseMetaData databaseMetaData) throws SQLException {
        ResultSet resultSet = databaseMetaData.getTypeInfo();
        JDBC.assertDrainResults(resultSet);
    }

    public void getTables(DatabaseMetaData databaseMetaData) throws SQLException {
        String[] stringArray = new String[]{"TABLE"};
        ResultSet resultSet = databaseMetaData.getTables(null, null, null, stringArray);
        JDBC.assertDrainResults(resultSet);
    }

    public void getColumnInfo(DatabaseMetaData databaseMetaData) throws SQLException {
        ResultSet resultSet = databaseMetaData.getColumns(null, null, "%", "%");
        JDBC.assertDrainResults(resultSet);
    }

    public void getPrimaryKeys(DatabaseMetaData databaseMetaData) throws SQLException {
        ResultSet resultSet = databaseMetaData.getPrimaryKeys(null, null, "%");
        JDBC.assertDrainResults(resultSet);
    }

    public void getExportedKeys(DatabaseMetaData databaseMetaData) throws SQLException {
        ResultSet resultSet = databaseMetaData.getExportedKeys(null, null, "%");
        JDBC.assertDrainResults(resultSet);
    }

    public void checkConsistencyOfAllTables(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT schemaname, tablename, SYSCS_UTIL.SYSCS_CHECK_TABLE(schemaname, tablename) FROM sys.sysschemas s, sys.systables t WHERE s.schemaid = t.schemaid");
        while (resultSet.next()) {
            metadataMultiConnTest.assertTrue((boolean)resultSet.getBoolean(3));
        }
        resultSet.close();
        statement.close();
    }
}

