/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class BTreeMaxScanTest
extends BaseJDBCTestCase {
    private List<String> traceFlags = new ArrayList<String>();

    public BTreeMaxScanTest(String string) {
        super(string);
    }

    public static Test suite() {
        return new CleanDatabaseTestSetup(TestConfiguration.embeddedSuite(BTreeMaxScanTest.class));
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRestartScanAfterWaitOnMaxRow() throws Exception {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("create table t(x int, y int)");
        PreparedStatement preparedStatement = this.prepareStatement("insert into t(x) values ?");
        for (int i = 1; i <= 800; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.executeUpdate();
        }
        statement.execute("create index i on t(x)");
        this.commit();
        statement.execute("update t set y = 0 where x = 800");
        Connection connection = this.openDefaultConnection();
        try {
            connection.setAutoCommit(false);
            Statement statement2 = connection.createStatement();
            Result result = BTreeMaxScanTest.asyncGetSingleResult(statement2, "select max(x) from t --derby-properties index=i");
            Thread.sleep(2000L);
            preparedStatement.setInt(1, 801);
            preparedStatement.executeUpdate();
            this.commit();
            BTreeMaxScanTest.assertEquals((String)"801", (String)result.get());
        }
        finally {
            connection.rollback();
            connection.close();
        }
        this.dropTable("T");
        this.commit();
    }

    public void testOppositeScanDirections() throws Exception {
        int n;
        String string;
        this.setTraceFlag("BTreeMaxScan.latchConflict");
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("create table t(x int)");
        PreparedStatement preparedStatement = this.prepareStatement("insert into t values ?");
        final String[][] stringArray = new String[800][];
        for (int i = 1; i <= stringArray.length; ++i) {
            string = i <= 100 ? Integer.toString(i) : null;
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
            stringArray[i - 1] = new String[]{string};
        }
        statement.execute("create index i on t(x)");
        this.commit();
        String string2 = "select x from t --derby-properties index=i";
        string = "select max(x) from t --derby-properties index=i";
        final PreparedStatement[] preparedStatementArray = new PreparedStatement[]{this.openDefaultConnection().prepareStatement(string2), this.openDefaultConnection().prepareStatement(string2), this.openDefaultConnection().prepareStatement(string), this.openDefaultConnection().prepareStatement(string)};
        final Exception[] exceptionArray = new Exception[preparedStatementArray.length];
        Thread[] threadArray = new Thread[preparedStatementArray.length];
        for (n = 0; n < preparedStatementArray.length; ++n) {
            final int n2 = n;
            threadArray[n] = new Thread(){

                @Override
                public void run() {
                    String[][] stringArray3;
                    if (n2 < 2) {
                        stringArray3 = stringArray;
                    } else {
                        String[][] stringArrayArray = new String[1][];
                        stringArray3 = stringArrayArray;
                        stringArrayArray[0] = new String[]{"100"};
                    }
                    String[][] stringArray2 = stringArray3;
                    try {
                        for (int i = 0; i < 1000; ++i) {
                            ResultSet resultSet = preparedStatementArray[n2].executeQuery();
                            JDBC.assertFullResultSet(resultSet, stringArray2);
                        }
                    }
                    catch (Exception exception) {
                        exceptionArray[n2] = exception;
                    }
                }
            };
            threadArray[n].start();
        }
        for (n = 0; n < preparedStatementArray.length; ++n) {
            threadArray[n].join();
            preparedStatementArray[n].getConnection().close();
        }
        for (n = 0; n < exceptionArray.length; ++n) {
            if (exceptionArray[n] == null) continue;
            throw exceptionArray[n];
        }
        this.dropTable("T");
        this.commit();
    }

    public void testEmptyRightmostLeaf() throws Exception {
        int n;
        this.setTraceFlag("BTreeMaxScan.latchConflict");
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("create table t(x int)");
        PreparedStatement preparedStatement = this.prepareStatement("insert into t values ?");
        for (int i = 1; i <= 800; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.executeUpdate();
        }
        statement.execute("create index i on t(x)");
        this.commit();
        String string = "select x from t --derby-properties index=i";
        String string2 = "select max(x) from t --derby-properties index=i";
        final PreparedStatement[] preparedStatementArray = new PreparedStatement[]{this.openDefaultConnection().prepareStatement(string), this.openDefaultConnection().prepareStatement(string), this.openDefaultConnection().prepareStatement(string2), this.openDefaultConnection().prepareStatement(string2)};
        final Exception[] exceptionArray = new Exception[preparedStatementArray.length];
        Thread[] threadArray = new Thread[preparedStatementArray.length];
        final AtomicInt atomicInt = new AtomicInt();
        for (int i = 0; i < preparedStatementArray.length; ++i) {
            final int n2 = i;
            preparedStatementArray[i].getConnection().setTransactionIsolation(1);
            threadArray[i] = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        for (int i = 0; i < 1000; ++i) {
                            int n;
                            ResultSet resultSet = preparedStatementArray[n2].executeQuery();
                            if (n2 < 2) {
                                n = JDBC.assertDrainResults(resultSet);
                                if (n >= 400 && n <= 800) continue;
                                Assert.fail((String)("Unexpected row count: " + n));
                                continue;
                            }
                            Assert.assertTrue((boolean)resultSet.next());
                            n = resultSet.getInt(1);
                            if (n < 400 || n > 800) {
                                Assert.fail((String)("Unexpected max value: " + n));
                            }
                            Assert.assertFalse((boolean)resultSet.next());
                            resultSet.close();
                        }
                    }
                    catch (Exception exception) {
                        exceptionArray[n2] = exception;
                    }
                    finally {
                        atomicInt.decrement();
                    }
                }
            };
            threadArray[i].start();
            atomicInt.increment();
        }
        PreparedStatement preparedStatement2 = this.prepareStatement("delete from t where x > 400");
        PreparedStatement preparedStatement3 = this.prepareStatement("insert into t select x+400 from t");
        while (atomicInt.get() > 0) {
            BTreeMaxScanTest.assertEquals((String)"deleted rows", (int)400, (int)preparedStatement2.executeUpdate());
            this.commit();
            Thread.sleep(100L);
            BTreeMaxScanTest.assertEquals((String)"inserted rows", (int)400, (int)preparedStatement3.executeUpdate());
            this.commit();
        }
        for (n = 0; n < preparedStatementArray.length; ++n) {
            threadArray[n].join();
            preparedStatementArray[n].getConnection().close();
        }
        for (n = 0; n < exceptionArray.length; ++n) {
            if (exceptionArray[n] == null) continue;
            throw exceptionArray[n];
        }
        this.dropTable("T");
        this.commit();
    }

    public void testSerializable() throws Exception {
        this.setAutoCommit(false);
        this.getConnection().setTransactionIsolation(8);
        Statement statement = this.createStatement();
        statement.execute("create table t(x int, y int)");
        statement.execute("insert into t(x) values 0,1,2,3,4,null,null,null");
        statement.execute("create index i on t(x)");
        PreparedStatement preparedStatement = this.prepareStatement("select max(x) from t --derby-properties index=i");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "4");
        this.commit();
        final Connection connection = this.openDefaultConnection();
        final Statement statement2 = connection.createStatement();
        connection.setAutoCommit(false);
        statement2.execute("update t set y = x where x = 4");
        final Exception[] exceptionArray = new Exception[1];
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                    statement2.execute("insert into t(x) values 5");
                    connection.commit();
                }
                catch (Exception exception) {
                    exceptionArray[0] = exception;
                }
            }
        };
        thread.start();
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "5");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "5");
        this.commit();
        thread.join();
        statement2.close();
        connection.rollback();
        connection.close();
        if (exceptionArray[0] != null) {
            throw exceptionArray[0];
        }
        this.dropTable("T");
        this.commit();
    }

    private static Result asyncGetSingleResult(final Statement statement, final String string) {
        final Result result = new Result();
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    ResultSet resultSet = statement.executeQuery(string);
                    Assert.assertEquals((String)"expected single value", (int)1, (int)resultSet.getMetaData().getColumnCount());
                    Assert.assertTrue((String)"empty result", (boolean)resultSet.next());
                    String string2 = resultSet.getString(1);
                    Assert.assertFalse((String)"multiple rows", (boolean)resultSet.next());
                    resultSet.close();
                    result.set(string2);
                }
                catch (Exception exception) {
                    result.error(exception);
                }
            }
        };
        thread.start();
        return result;
    }

    private void setTraceFlag(String string) {
    }

    private static class AtomicInt {
        private int i;

        private AtomicInt() {
        }

        synchronized void increment() {
            ++this.i;
        }

        synchronized void decrement() {
            --this.i;
        }

        synchronized int get() {
            return this.i;
        }
    }

    private static class Result {
        private boolean complete;
        private Exception ex;
        private String value;

        private Result() {
        }

        synchronized void error(Exception exception) {
            this.ex = exception;
            this.complete = true;
            this.notifyAll();
        }

        synchronized void set(String string) {
            this.value = string;
            this.complete = true;
            this.notifyAll();
        }

        synchronized String get() throws Exception {
            while (!this.complete) {
                this.wait();
            }
            if (this.ex != null) {
                throw this.ex;
            }
            return this.value;
        }
    }
}

