/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ParameterMetaDataWrapperTest
extends BaseJDBCTestCase {
    private PreparedStatement ps = null;
    private ParameterMetaData pmd = null;

    public ParameterMetaDataWrapperTest(String name) {
        super(name);
    }

    protected void setUp() throws SQLException {
        this.ps = this.prepareStatement("values 1");
        this.pmd = this.ps.getParameterMetaData();
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.ps != null && !this.ps.isClosed()) {
            this.ps.close();
        }
        this.ps = null;
        this.pmd = null;
        super.tearDown();
    }

    public void testIsWrapperForParameterMetaData() throws SQLException {
        ParameterMetaDataWrapperTest.assertTrue((boolean)this.pmd.isWrapperFor(ParameterMetaData.class));
    }

    public void testUnwrapParameterMetaData() throws SQLException {
        ParameterMetaData pmd2 = this.pmd.unwrap(ParameterMetaData.class);
        ParameterMetaDataWrapperTest.assertSame((String)"Unwrap returned wrong object.", (Object)this.pmd, (Object)pmd2);
    }

    public void testIsNotWrapperForResultSet() throws SQLException {
        ParameterMetaDataWrapperTest.assertFalse((boolean)this.pmd.isWrapperFor(ResultSet.class));
    }

    public void testUnwrapResultSet() {
        try {
            ResultSet rs = this.pmd.unwrap(ResultSet.class);
            ParameterMetaDataWrapperTest.fail((String)"Unwrap didn't fail.");
        }
        catch (SQLException e) {
            ParameterMetaDataWrapperTest.assertSQLState("XJ128", e);
        }
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(ParameterMetaDataWrapperTest.class);
    }
}

