/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import javax.security.auth.Subject;
import junit.framework.Test;
import org.apache.derby.authentication.SystemPrincipal;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.security.DatabasePermission;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.security.SystemPermission;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.SecurityManagerSetup;

public class SystemPrivilegesPermissionTest
extends BaseTestCase {
    private static final String POLICY_FILE_NAME = "org/apache/derbyTesting/unitTests/junit/SystemPrivilegesPermissionTest.policy";
    private static final String POLICY_FILE_NAME1 = "org/apache/derbyTesting/unitTests/junit/SystemPrivilegesPermissionTest1.policy";
    private static final String[] dirPaths;
    private static final String[] relDirPaths;
    private static final String[] relDirPathAliases;
    private static final String[] absDirPaths;
    private static final String[] absDirPathAliases;
    private static final boolean[][] dirPathImpls;
    private static final String[] VALID_SYSPERM_NAMES;
    private static final String[] VALID_SYSPERM_ACTIONS;

    public SystemPrivilegesPermissionTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("SystemPrivilegesPermissionTest");
        baseTestSuite.addTest((Test)new SystemPrivilegesPermissionTest("testSystemPrincipal"));
        baseTestSuite.addTest((Test)new SystemPrivilegesPermissionTest("testSystemPermission"));
        baseTestSuite.addTest((Test)new SystemPrivilegesPermissionTest("testSystemPermissionCollections"));
        baseTestSuite.addTest((Test)new SecurityManagerSetup((Test)new SystemPrivilegesPermissionTest("testDatabasePermission"), POLICY_FILE_NAME1));
        if (SecurityManagerSetup.JVM_HAS_SUBJECT_AUTHORIZATION) {
            baseTestSuite.addTest((Test)new SecurityManagerSetup((Test)new SystemPrivilegesPermissionTest("policyTestSystemPermissionGrants"), POLICY_FILE_NAME));
            baseTestSuite.addTest((Test)new SecurityManagerSetup((Test)new SystemPrivilegesPermissionTest("policyTestDatabasePermissionGrants"), POLICY_FILE_NAME));
        }
        if (SystemPrivilegesPermissionTest.isJava8()) {
            baseTestSuite.addTest(SecurityManagerSetup.noSecurityManager((Test)new SystemPrivilegesPermissionTest("testSerialization")));
        }
        return baseTestSuite;
    }

    public void testSystemPrincipal() {
        SystemPrincipal systemPrincipal = new SystemPrincipal("superuser");
        SystemPrivilegesPermissionTest.assertEquals((String)"superuser", (String)systemPrincipal.getName());
        try {
            new SystemPrincipal(null);
            SystemPrivilegesPermissionTest.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            new SystemPrincipal("");
            SystemPrivilegesPermissionTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        SystemPrivilegesPermissionTest.assertTrue((boolean)Modifier.isFinal(SystemPrincipal.class.getModifiers()));
    }

    public void testSystemPermission() {
        SystemPermission systemPermission;
        int n;
        int n2;
        try {
            new SystemPermission(null, null);
            SystemPrivilegesPermissionTest.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            new SystemPermission("", null);
            SystemPrivilegesPermissionTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new SystemPermission("illegal_name", null);
            SystemPrivilegesPermissionTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new SystemPermission("server", null);
            SystemPrivilegesPermissionTest.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        SystemPrivilegesPermissionTest.assertEquals((String)"", (String)new SystemPermission("server", "").getActions());
        SystemPrivilegesPermissionTest.assertEquals((String)"", (String)new SystemPermission("server", ",,").getActions());
        SystemPrivilegesPermissionTest.assertEquals((String)"", (String)new SystemPermission("server", "illegal_action").getActions());
        SystemPrivilegesPermissionTest.assertEquals((String)"control", (String)new SystemPermission("server", "control,").getActions());
        SystemPrivilegesPermissionTest.assertEquals((String)"control", (String)new SystemPermission("server", "control,illegal_action").getActions());
        SystemPrivilegesPermissionTest.assertEquals((String)"control", (String)new SystemPermission("server", "control,control").getActions());
        SystemPrivilegesPermissionTest.assertEquals((String)"control,monitor", (String)new SystemPermission("server", "control, monitor, control").getActions());
        SystemPrivilegesPermissionTest.assertEquals((String)"control,monitor", (String)new SystemPermission("server", "monitor, control, monitor").getActions());
        SystemPrivilegesPermissionTest.assertEquals((String)"control", (String)new SystemPermission("server", "CoNtRoL").getActions());
        SystemPrivilegesPermissionTest.assertEquals((String)"control", (String)new SystemPermission("server", "CoNtRoL,control").getActions());
        String[] stringArray = new String[]{"engine", "jmx", "server"};
        String[] stringArray2 = new String[]{"control", "monitor", "shutdown"};
        Permission[] permissionArray = new Permission[stringArray.length * stringArray2.length];
        int n3 = 0;
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            for (n = 0; n < stringArray2.length; ++n) {
                systemPermission = new SystemPermission(stringArray[n2], stringArray2[n]);
                SystemPrivilegesPermissionTest.assertEquals((String)stringArray[n2], (String)systemPermission.getName());
                SystemPrivilegesPermissionTest.assertEquals((String)stringArray2[n], (String)systemPermission.getActions());
                SystemPrivilegesPermissionTest.assertFalse((boolean)systemPermission.equals(null));
                SystemPrivilegesPermissionTest.assertFalse((boolean)systemPermission.equals(new Object()));
                this.assertEquivalentPermissions((Permission)systemPermission, (Permission)systemPermission);
                permissionArray[n3++] = systemPermission;
            }
        }
        this.checkDistinctPermissions(permissionArray);
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            for (n = 0; n < stringArray2.length; ++n) {
                systemPermission = new SystemPermission(stringArray[n2], stringArray2[n]);
                for (int i = 0; i < stringArray2.length; ++i) {
                    int n4;
                    int n5;
                    SystemPermission systemPermission2 = new SystemPermission(stringArray[n2], stringArray2[n] + "," + stringArray2[i]);
                    if (i == n) {
                        this.assertEquivalentPermissions((Permission)systemPermission, (Permission)systemPermission2);
                        SystemPrivilegesPermissionTest.assertEquals((String)stringArray2[n], (String)systemPermission2.getActions());
                        continue;
                    }
                    SystemPrivilegesPermissionTest.assertTrue((boolean)systemPermission2.implies((Permission)systemPermission));
                    SystemPrivilegesPermissionTest.assertFalse((boolean)systemPermission.implies((Permission)systemPermission2));
                    if (i < n) {
                        n5 = i;
                        n4 = n;
                    } else {
                        n5 = n;
                        n4 = i;
                    }
                    SystemPrivilegesPermissionTest.assertEquals((String)(stringArray2[n5] + "," + stringArray2[n4]), (String)systemPermission2.getActions());
                }
            }
        }
        SystemPrivilegesPermissionTest.assertTrue((boolean)Modifier.isFinal(SystemPermission.class.getModifiers()));
    }

    public void testSystemPermissionCollections() {
        Permissions permissions = new Permissions();
        for (String object2 : VALID_SYSPERM_NAMES) {
            for (String string2 : VALID_SYSPERM_ACTIONS) {
                permissions.add((Permission)new SystemPermission(object2, string2));
            }
        }
        SystemPrivilegesPermissionTest.assertEquals((int)VALID_SYSPERM_NAMES.length, (int)Collections.list(permissions.elements()).size());
        for (String string : VALID_SYSPERM_NAMES) {
            for (String string2 : VALID_SYSPERM_ACTIONS) {
                SystemPrivilegesPermissionTest.assertTrue((boolean)permissions.implies((Permission)new SystemPermission(string, string2)));
                for (String string3 : VALID_SYSPERM_ACTIONS) {
                    SystemPrivilegesPermissionTest.assertTrue((boolean)permissions.implies((Permission)new SystemPermission(string, string2 + "," + string3)));
                }
            }
        }
        Permissions permissions2 = new Permissions();
        permissions2.add((Permission)new SystemPermission("server", "shutdown"));
        SystemPrivilegesPermissionTest.assertTrue((boolean)permissions2.implies((Permission)new SystemPermission("server", "shutdown")));
        SystemPrivilegesPermissionTest.assertFalse((boolean)permissions2.implies((Permission)new SystemPermission("engine", "shutdown")));
        SystemPrivilegesPermissionTest.assertFalse((boolean)permissions2.implies((Permission)new SystemPermission("server", "shutdown,monitor")));
        Permissions permissions3 = new Permissions();
        permissions3.add((Permission)new SystemPermission("server", "shutdown"));
        permissions3.add((Permission)new SystemPermission("jmx", "shutdown,monitor"));
        permissions3.add((Permission)new SystemPermission("engine", "shutdown,control"));
        permissions3.add((Permission)new SystemPermission("engine", "control,monitor"));
        SystemPrivilegesPermissionTest.assertTrue((boolean)permissions3.implies((Permission)new SystemPermission("server", "shutdown")));
        SystemPrivilegesPermissionTest.assertFalse((boolean)permissions3.implies((Permission)new SystemPermission("server", "control")));
        SystemPrivilegesPermissionTest.assertFalse((boolean)permissions3.implies((Permission)new SystemPermission("server", "monitor")));
        SystemPrivilegesPermissionTest.assertFalse((boolean)permissions3.implies((Permission)new SystemPermission("server", "shutdown,monitor")));
        SystemPrivilegesPermissionTest.assertTrue((boolean)permissions3.implies((Permission)new SystemPermission("jmx", "shutdown")));
        SystemPrivilegesPermissionTest.assertTrue((boolean)permissions3.implies((Permission)new SystemPermission("jmx", "monitor")));
        SystemPrivilegesPermissionTest.assertFalse((boolean)permissions3.implies((Permission)new SystemPermission("jmx", "control")));
        SystemPrivilegesPermissionTest.assertTrue((boolean)permissions3.implies((Permission)new SystemPermission("jmx", "shutdown,monitor")));
        SystemPrivilegesPermissionTest.assertTrue((boolean)permissions3.implies((Permission)new SystemPermission("jmx", "monitor,shutdown")));
        SystemPrivilegesPermissionTest.assertFalse((boolean)permissions3.implies((Permission)new SystemPermission("jmx", "monitor,shutdown,control")));
        SystemPrivilegesPermissionTest.assertTrue((boolean)permissions3.implies((Permission)new SystemPermission("engine", "shutdown")));
        SystemPrivilegesPermissionTest.assertTrue((boolean)permissions3.implies((Permission)new SystemPermission("engine", "control")));
        SystemPrivilegesPermissionTest.assertTrue((boolean)permissions3.implies((Permission)new SystemPermission("engine", "monitor")));
        SystemPrivilegesPermissionTest.assertTrue((boolean)permissions3.implies((Permission)new SystemPermission("engine", "shutdown,monitor")));
        SystemPrivilegesPermissionTest.assertTrue((boolean)permissions3.implies((Permission)new SystemPermission("engine", "shutdown,monitor,control")));
        SystemPermission systemPermission = new SystemPermission("engine", "monitor");
        PermissionCollection permissionCollection = systemPermission.newPermissionCollection();
        try {
            permissionCollection.add(new AllPermission());
            SystemPrivilegesPermissionTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        permissionCollection.setReadOnly();
        try {
            permissionCollection.add((Permission)systemPermission);
            SystemPrivilegesPermissionTest.fail();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        SystemPrivilegesPermissionTest.assertFalse((boolean)permissionCollection.implies(new AllPermission()));
    }

    public void policyTestSystemPermissionGrants() {
        SystemPermission systemPermission = new SystemPermission("server", "shutdown");
        SystemPrincipal systemPrincipal = new SystemPrincipal("authorizedSystemUser");
        this.execute(systemPrincipal, new ShutdownAction((Permission)systemPermission), true);
        SystemPrincipal systemPrincipal2 = new SystemPrincipal("unAuthorizedSystemUser");
        this.execute(systemPrincipal2, new ShutdownAction((Permission)systemPermission), false);
    }

    public void testDatabasePermission() throws IOException {
        try {
            new DatabasePermission(null, "create");
            SystemPrivilegesPermissionTest.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            new DatabasePermission("", "create");
            SystemPrivilegesPermissionTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new DatabasePermission("no_url", "create");
            SystemPrivilegesPermissionTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new DatabasePermission("unknown:test", "create");
            SystemPrivilegesPermissionTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new DatabasePermission("directory:dir", null);
            SystemPrivilegesPermissionTest.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            new DatabasePermission("directory:dir", "");
            SystemPrivilegesPermissionTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new DatabasePermission("directory:dir", "illegal_action");
            SystemPrivilegesPermissionTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new DatabasePermission("directory:dir", "illegal,action");
            SystemPrivilegesPermissionTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new DatabasePermission("directory:dir", "illegal,create,action");
            SystemPrivilegesPermissionTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new DatabasePermission("directory:dir", "illegal;action");
            SystemPrivilegesPermissionTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new DatabasePermission("directory:dir", ",");
            SystemPrivilegesPermissionTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new DatabasePermission("directory:dir", " ");
            SystemPrivilegesPermissionTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new DatabasePermission("directory:dir", "create,");
            SystemPrivilegesPermissionTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        DatabasePermission[] databasePermissionArray = new DatabasePermission[relDirPaths.length];
        for (int i = 0; i < relDirPaths.length; ++i) {
            databasePermissionArray[i] = new DatabasePermission(relDirPaths[i], "create");
        }
        this.checkNameAndActions(databasePermissionArray, relDirPaths);
        this.checkHashCodeAndEquals((Permission[])databasePermissionArray, (Permission[])databasePermissionArray);
        this.checkImplies((Permission[])databasePermissionArray, (Permission[])databasePermissionArray, dirPathImpls);
        DatabasePermission[] databasePermissionArray2 = new DatabasePermission[relDirPathAliases.length];
        for (int i = 0; i < relDirPathAliases.length; ++i) {
            databasePermissionArray2[i] = new DatabasePermission(relDirPathAliases[i], "create");
        }
        this.checkNameAndActions(databasePermissionArray2, relDirPathAliases);
        this.checkHashCodeAndEquals((Permission[])databasePermissionArray, (Permission[])databasePermissionArray2);
        this.checkImplies((Permission[])databasePermissionArray, (Permission[])databasePermissionArray2, dirPathImpls);
        this.checkImplies((Permission[])databasePermissionArray2, (Permission[])databasePermissionArray, dirPathImpls);
        DatabasePermission[] databasePermissionArray3 = new DatabasePermission[absDirPaths.length];
        for (int i = 0; i < absDirPaths.length; ++i) {
            databasePermissionArray3[i] = new DatabasePermission(absDirPaths[i], "create");
        }
        this.checkNameAndActions(databasePermissionArray3, absDirPaths);
        this.checkHashCodeAndEquals((Permission[])databasePermissionArray3, (Permission[])databasePermissionArray3);
        this.checkImplies((Permission[])databasePermissionArray3, (Permission[])databasePermissionArray3, dirPathImpls);
        DatabasePermission[] databasePermissionArray4 = new DatabasePermission[absDirPathAliases.length];
        for (int i = 0; i < absDirPathAliases.length; ++i) {
            databasePermissionArray4[i] = new DatabasePermission(absDirPathAliases[i], "create");
        }
        this.checkNameAndActions(databasePermissionArray4, absDirPathAliases);
        this.checkHashCodeAndEquals((Permission[])databasePermissionArray3, (Permission[])databasePermissionArray4);
        this.checkImplies((Permission[])databasePermissionArray3, (Permission[])databasePermissionArray4, dirPathImpls);
        this.checkImplies((Permission[])databasePermissionArray4, (Permission[])databasePermissionArray3, dirPathImpls);
        DatabasePermission[] databasePermissionArray5 = new DatabasePermission[]{new DatabasePermission("directory:<<ALL FILES>>", "create")};
        this.checkNameAndActions(databasePermissionArray5, new String[]{"directory:<<ALL FILES>>"});
        DatabasePermission[] databasePermissionArray6 = new DatabasePermission[]{new DatabasePermission("directory:<<ALL FILES>>", "create")};
        this.checkHashCodeAndEquals((Permission[])databasePermissionArray5, (Permission[])databasePermissionArray6);
        this.checkImplies((Permission[])databasePermissionArray5, (Permission[])databasePermissionArray6, new boolean[][]{{true}});
        boolean[][] blArray = new boolean[1][dirPaths.length];
        for (int i = 0; i < dirPaths.length; ++i) {
            blArray[0][i] = true;
        }
        boolean[][] blArray2 = new boolean[dirPaths.length][1];
        for (int i = 0; i < dirPaths.length; ++i) {
            blArray2[i][0] = false;
        }
        this.checkImplies((Permission[])databasePermissionArray5, (Permission[])databasePermissionArray, blArray);
        this.checkImplies((Permission[])databasePermissionArray, (Permission[])databasePermissionArray5, blArray2);
        this.checkImplies((Permission[])databasePermissionArray5, (Permission[])databasePermissionArray2, blArray);
        this.checkImplies((Permission[])databasePermissionArray2, (Permission[])databasePermissionArray5, blArray2);
        this.checkImplies((Permission[])databasePermissionArray5, (Permission[])databasePermissionArray3, blArray);
        this.checkImplies((Permission[])databasePermissionArray3, (Permission[])databasePermissionArray5, blArray2);
        this.checkImplies((Permission[])databasePermissionArray5, (Permission[])databasePermissionArray4, blArray);
        this.checkImplies((Permission[])databasePermissionArray4, (Permission[])databasePermissionArray5, blArray2);
        DatabasePermission databasePermission = new DatabasePermission("directory:dir", "create, create");
        SystemPrivilegesPermissionTest.assertEquals((String)"create", (String)databasePermission.getActions());
        databasePermission = new DatabasePermission("directory:dir", "  CrEaTe  ");
        SystemPrivilegesPermissionTest.assertEquals((String)"create", (String)databasePermission.getActions());
        SystemPrivilegesPermissionTest.assertTrue((boolean)Modifier.isFinal(DatabasePermission.class.getModifiers()));
    }

    public void policyTestDatabasePermissionGrants() throws IOException {
        DatabasePermission[] databasePermissionArray = new DatabasePermission[relDirPaths.length];
        for (int i = 0; i < relDirPaths.length; ++i) {
            databasePermissionArray[i] = new DatabasePermission(relDirPaths[i], "create");
        }
        int[] nArray = new int[]{2, 3, 6, 7};
        SystemPrincipal systemPrincipal = new SystemPrincipal("authorizedSystemUser");
        SystemPrincipal systemPrincipal2 = new SystemPrincipal("unAuthorizedSystemUser");
        SystemPrincipal systemPrincipal3 = new SystemPrincipal("superUser");
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            this.execute(systemPrincipal2, new CreateDatabaseAction((Permission)databasePermissionArray[n]), false);
            this.execute(systemPrincipal, new CreateDatabaseAction((Permission)databasePermissionArray[n]), n != 6);
            this.execute(systemPrincipal3, new CreateDatabaseAction((Permission)databasePermissionArray[n]), true);
        }
        SystemPrincipal systemPrincipal4 = new SystemPrincipal("anyUser");
        DatabasePermission databasePermission = new DatabasePermission("directory:dir", "create");
        this.execute(systemPrincipal4, new CreateDatabaseAction((Permission)databasePermission), true);
    }

    public void testSerialization() throws IOException {
        this.testDatabasePermissionSerialization();
        this.testSystemPermissionSerialization();
        this.testSystemPrincipalSerialization();
    }

    private void testDatabasePermissionSerialization() throws IOException {
        DatabasePermission databasePermission = new DatabasePermission("directory:dir", "create");
        SystemPrivilegesPermissionTest.assertEquals((Object)databasePermission, (Object)SystemPrivilegesPermissionTest.serializeDeserialize(databasePermission, null));
        for (String string : relDirPaths) {
            databasePermission = new DatabasePermission(string, "create");
            SystemPrivilegesPermissionTest.assertEquals((Object)databasePermission, (Object)SystemPrivilegesPermissionTest.serializeDeserialize(databasePermission, null));
        }
        for (String string : relDirPathAliases) {
            databasePermission = new DatabasePermission(string, "create");
            SystemPrivilegesPermissionTest.assertEquals((Object)databasePermission, (Object)SystemPrivilegesPermissionTest.serializeDeserialize(databasePermission, null));
        }
        for (String string : absDirPaths) {
            databasePermission = new DatabasePermission(string, "create");
            SystemPrivilegesPermissionTest.assertEquals((Object)databasePermission, (Object)SystemPrivilegesPermissionTest.serializeDeserialize(databasePermission, null));
        }
        for (String string : absDirPathAliases) {
            databasePermission = new DatabasePermission(string, "create");
            SystemPrivilegesPermissionTest.assertEquals((Object)databasePermission, (Object)SystemPrivilegesPermissionTest.serializeDeserialize(databasePermission, null));
        }
        for (String string : Arrays.asList("create", "CrEaTe", " create ,  create")) {
            databasePermission = SystemPrivilegesPermissionTest.serializeDeserialize(SystemPrivilegesPermissionTest.createDBPermNoCheck("directory:dir", string), null);
            SystemPrivilegesPermissionTest.assertEquals((String)"create", (String)databasePermission.getActions());
        }
        databasePermission = SystemPrivilegesPermissionTest.createDBPermNoCheck(null, "create");
        SystemPrivilegesPermissionTest.serializeDeserialize(databasePermission, NullPointerException.class);
        databasePermission = SystemPrivilegesPermissionTest.createDBPermNoCheck("", "create");
        SystemPrivilegesPermissionTest.serializeDeserialize(databasePermission, IllegalArgumentException.class);
        databasePermission = SystemPrivilegesPermissionTest.createDBPermNoCheck("unknown:test", "create");
        SystemPrivilegesPermissionTest.serializeDeserialize(databasePermission, IllegalArgumentException.class);
        SystemPrivilegesPermissionTest.serializeDeserialize(SystemPrivilegesPermissionTest.createDBPermNoCheck("directory:dir", null), NullPointerException.class);
        SystemPrivilegesPermissionTest.serializeDeserialize(SystemPrivilegesPermissionTest.createDBPermNoCheck("directory:dir", ""), IllegalArgumentException.class);
        SystemPrivilegesPermissionTest.serializeDeserialize(SystemPrivilegesPermissionTest.createDBPermNoCheck("directory:dir", " "), IllegalArgumentException.class);
        SystemPrivilegesPermissionTest.serializeDeserialize(SystemPrivilegesPermissionTest.createDBPermNoCheck("directory:dir", ","), IllegalArgumentException.class);
        SystemPrivilegesPermissionTest.serializeDeserialize(SystemPrivilegesPermissionTest.createDBPermNoCheck("directory:dir", "create,"), IllegalArgumentException.class);
        SystemPrivilegesPermissionTest.serializeDeserialize(SystemPrivilegesPermissionTest.createDBPermNoCheck("directory:dir", "invalid"), IllegalArgumentException.class);
        SystemPrivilegesPermissionTest.serializeDeserialize(SystemPrivilegesPermissionTest.createDBPermNoCheck("directory:dir", "create,invalid"), IllegalArgumentException.class);
    }

    private void testSystemPermissionSerialization() throws IOException {
        Object object2;
        for (Object object2 : VALID_SYSPERM_NAMES) {
            for (String string : VALID_SYSPERM_ACTIONS) {
                SystemPermission systemPermission = new SystemPermission((String)object2, string.toLowerCase(Locale.US));
                SystemPermission systemPermission2 = new SystemPermission((String)object2, string.toUpperCase(Locale.US));
                SystemPrivilegesPermissionTest.assertEquals((Object)systemPermission, (Object)SystemPrivilegesPermissionTest.serializeDeserialize(systemPermission, null));
                SystemPrivilegesPermissionTest.assertEquals((Object)systemPermission2, (Object)SystemPrivilegesPermissionTest.serializeDeserialize(systemPermission2, null));
            }
        }
        SystemPermission systemPermission = new SystemPermission("server", "control,monitor,shutdown");
        SystemPrivilegesPermissionTest.assertEquals((Object)systemPermission, (Object)SystemPrivilegesPermissionTest.serializeDeserialize(systemPermission, null));
        SystemPrivilegesPermissionTest.serializeDeserialize(SystemPrivilegesPermissionTest.createSyspermNoCheck("server,jmx", "control"), IllegalArgumentException.class);
        systemPermission = SystemPrivilegesPermissionTest.serializeDeserialize(SystemPrivilegesPermissionTest.createSyspermNoCheck(VALID_SYSPERM_NAMES[0], "control,invalid,control,,shutdown"), null);
        SystemPrivilegesPermissionTest.assertEquals((String)"control,shutdown", (String)systemPermission.getActions());
        systemPermission = new SystemPermission(VALID_SYSPERM_NAMES[0], "");
        SystemPrivilegesPermissionTest.assertEquals((Object)systemPermission, (Object)SystemPrivilegesPermissionTest.serializeDeserialize(systemPermission, null));
        SystemPrivilegesPermissionTest.serializeDeserialize(SystemPrivilegesPermissionTest.createSyspermNoCheck(VALID_SYSPERM_NAMES[0].toUpperCase(Locale.US), VALID_SYSPERM_ACTIONS[0]), IllegalArgumentException.class);
        SystemPrivilegesPermissionTest.serializeDeserialize(SystemPrivilegesPermissionTest.createSyspermNoCheck("", VALID_SYSPERM_ACTIONS[0]), IllegalArgumentException.class);
        SystemPrivilegesPermissionTest.serializeDeserialize(SystemPrivilegesPermissionTest.createSyspermNoCheck(null, VALID_SYSPERM_ACTIONS[0]), NullPointerException.class);
        SystemPrivilegesPermissionTest.serializeDeserialize(SystemPrivilegesPermissionTest.createSyspermNoCheck(VALID_SYSPERM_NAMES[0], null), NullPointerException.class);
        PermissionCollection permissionCollection = systemPermission.newPermissionCollection();
        PermissionCollection permissionCollection2 = SystemPrivilegesPermissionTest.serializeDeserialize(permissionCollection, null);
        SystemPrivilegesPermissionTest.assertFalse((boolean)permissionCollection2.elements().hasMoreElements());
        systemPermission = new SystemPermission(VALID_SYSPERM_NAMES[0], VALID_SYSPERM_ACTIONS[0]);
        permissionCollection = systemPermission.newPermissionCollection();
        permissionCollection.add((Permission)systemPermission);
        permissionCollection2 = SystemPrivilegesPermissionTest.serializeDeserialize(permissionCollection, null);
        SystemPrivilegesPermissionTest.assertEquals(Arrays.asList(systemPermission), Collections.list(permissionCollection2.elements()));
        permissionCollection.add((Permission)SystemPrivilegesPermissionTest.createSyspermNoCheck("invalid_name", "control"));
        SystemPrivilegesPermissionTest.serializeDeserialize(permissionCollection, IllegalArgumentException.class);
        permissionCollection = systemPermission.newPermissionCollection();
        object2 = new HashMap();
        ((HashMap)object2).put("engine", new AllPermission());
        SystemPrivilegesPermissionTest.setField(permissionCollection.getClass(), "permissions", permissionCollection, object2);
        SystemPrivilegesPermissionTest.serializeDeserialize(permissionCollection, ClassCastException.class);
    }

    private void testSystemPrincipalSerialization() throws IOException {
        SystemPrincipal systemPrincipal = new SystemPrincipal("superuser");
        SystemPrivilegesPermissionTest.assertEquals((Object)systemPrincipal, (Object)SystemPrivilegesPermissionTest.serializeDeserialize(systemPrincipal, null));
        SystemPrivilegesPermissionTest.setField(SystemPrincipal.class, "name", systemPrincipal, null);
        SystemPrivilegesPermissionTest.serializeDeserialize(systemPrincipal, NullPointerException.class);
        SystemPrivilegesPermissionTest.setField(SystemPrincipal.class, "name", systemPrincipal, "");
        SystemPrivilegesPermissionTest.serializeDeserialize(systemPrincipal, IllegalArgumentException.class);
    }

    private static DatabasePermission createDBPermNoCheck(String string, String string2) throws IOException {
        DatabasePermission databasePermission = new DatabasePermission("directory:dir", "create");
        SystemPrivilegesPermissionTest.setField(Permission.class, "name", databasePermission, string);
        SystemPrivilegesPermissionTest.setField(DatabasePermission.class, "actions", databasePermission, string2);
        return databasePermission;
    }

    private static SystemPermission createSyspermNoCheck(String string, String string2) {
        SystemPermission systemPermission = new SystemPermission("server", "control");
        SystemPrivilegesPermissionTest.setField(Permission.class, "name", systemPermission, string);
        SystemPrivilegesPermissionTest.setField(SystemPermission.class, "actions", systemPermission, string2);
        return systemPermission;
    }

    private static void setField(Class<?> clazz, String string, Object object, Object object2) {
        try {
            Field field = clazz.getDeclaredField(string);
            field.setAccessible(true);
            field.set(object, object2);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            SystemPrivilegesPermissionTest.fail("Cannot find field " + string, noSuchFieldException);
        }
        catch (IllegalAccessException illegalAccessException) {
            SystemPrivilegesPermissionTest.fail("Cannot access field " + string, illegalAccessException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T serializeDeserialize(T t, Class<? extends Exception> clazz) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(t);
        objectOutputStream.close();
        try (ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));){
            Object object = objectInputStream.readObject();
            SystemPrivilegesPermissionTest.assertNull((String)"should have failed", clazz);
            SystemPrivilegesPermissionTest.assertEquals(t.getClass(), object.getClass());
            Object object2 = object;
            return (T)object2;
        }
    }

    private <T> void execute(SystemPrincipal systemPrincipal, PrivilegedAction<T> privilegedAction, boolean bl) {
        SystemPrivilegesPermissionTest.println("");
        SystemPrivilegesPermissionTest.println("    testing action " + privilegedAction + " for principal " + systemPrincipal);
        RunAsPrivilegedUserAction<T> runAsPrivilegedUserAction = new RunAsPrivilegedUserAction<T>(systemPrincipal, privilegedAction);
        try {
            AccessController.doPrivileged(runAsPrivilegedUserAction);
            if (!bl) {
                SystemPrivilegesPermissionTest.fail((String)"expected AccessControlException");
            }
            SystemPrivilegesPermissionTest.println("        successfully executed action " + privilegedAction + " for principal " + systemPrincipal);
        }
        catch (AccessControlException accessControlException) {
            if (bl) {
                throw accessControlException;
            }
            SystemPrivilegesPermissionTest.println("        as expected, failed to execute action " + privilegedAction + " for principal " + systemPrincipal);
        }
        SystemPrivilegesPermissionTest.println("");
    }

    private void checkNameAndActions(DatabasePermission[] databasePermissionArray, String[] stringArray) throws IOException {
        for (int i = 0; i < databasePermissionArray.length; ++i) {
            DatabasePermission databasePermission = databasePermissionArray[i];
            SystemPrivilegesPermissionTest.assertEquals((String)("test: " + databasePermission + ".getName()"), (String)stringArray[i], (String)databasePermission.getName());
            SystemPrivilegesPermissionTest.assertEquals((String)("test: " + databasePermission + ".getActions()"), (String)"create", (String)databasePermission.getActions());
        }
    }

    private void checkHashCodeAndEquals(Permission[] permissionArray, Permission[] permissionArray2) throws IOException {
        for (int i = 0; i < permissionArray.length; ++i) {
            Permission permission = permissionArray[i];
            for (int j = 0; j < permissionArray.length; ++j) {
                Permission permission2 = permissionArray2[j];
                if (i == j) {
                    SystemPrivilegesPermissionTest.assertTrue((permission.hashCode() == permission2.hashCode() ? 1 : 0) != 0);
                    SystemPrivilegesPermissionTest.assertTrue((boolean)permission.equals(permission2));
                    continue;
                }
                SystemPrivilegesPermissionTest.assertTrue((permission.hashCode() != permission2.hashCode() ? 1 : 0) != 0);
                SystemPrivilegesPermissionTest.assertTrue((!permission.equals(permission2) ? 1 : 0) != 0);
            }
        }
    }

    private void checkImplies(Permission[] permissionArray, Permission[] permissionArray2, boolean[][] blArray) throws IOException {
        for (int i = 0; i < permissionArray.length; ++i) {
            Permission permission = permissionArray[i];
            for (int j = 0; j < permissionArray2.length; ++j) {
                Permission permission2 = permissionArray2[j];
                SystemPrivilegesPermissionTest.assertEquals((String)("test: " + permission + ".implies" + permission2), (boolean)blArray[i][j], (boolean)permission.implies(permission2));
            }
        }
    }

    private void checkDistinctPermissions(Permission[] permissionArray) {
        for (int i = 0; i < permissionArray.length; ++i) {
            Permission permission = permissionArray[i];
            for (int j = 0; j < permissionArray.length; ++j) {
                Permission permission2 = permissionArray[j];
                if (i == j) {
                    this.assertEquivalentPermissions(permission, permission2);
                    continue;
                }
                SystemPrivilegesPermissionTest.assertFalse((boolean)permission.equals(permission2));
                SystemPrivilegesPermissionTest.assertFalse((boolean)permission2.equals(permission));
                SystemPrivilegesPermissionTest.assertFalse((boolean)permission.implies(permission2));
                SystemPrivilegesPermissionTest.assertFalse((boolean)permission2.implies(permission));
            }
        }
    }

    private void assertEquivalentPermissions(Permission permission, Permission permission2) {
        SystemPrivilegesPermissionTest.assertTrue((boolean)permission.equals(permission2));
        SystemPrivilegesPermissionTest.assertTrue((boolean)permission2.equals(permission));
        SystemPrivilegesPermissionTest.assertEquals((int)permission.hashCode(), (int)permission2.hashCode());
        SystemPrivilegesPermissionTest.assertTrue((boolean)permission.implies(permission2));
        SystemPrivilegesPermissionTest.assertTrue((boolean)permission2.implies(permission));
    }

    private static String getAuthorizationId(String string) {
        if (string == null) {
            throw new NullPointerException("name can't be null");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("name can't be empty");
        }
        try {
            return IdUtil.getUserAuthorizationId((String)string);
        }
        catch (StandardException standardException) {
            throw new IllegalArgumentException(standardException.getMessage());
        }
    }

    static {
        int n;
        dirPaths = new String[]{"-", "*", "level0", "level0a", "level0/-", "level0/*", "level0/level1", "level0/level1/level2"};
        relDirPaths = new String[dirPaths.length];
        for (n = 0; n < relDirPaths.length; ++n) {
            SystemPrivilegesPermissionTest.relDirPaths[n] = "directory:" + dirPaths[n];
        }
        relDirPathAliases = new String[dirPaths.length];
        for (n = 0; n < relDirPaths.length; ++n) {
            SystemPrivilegesPermissionTest.relDirPathAliases[n] = "directory:./" + dirPaths[n];
        }
        absDirPaths = new String[dirPaths.length];
        for (n = 0; n < relDirPaths.length; ++n) {
            SystemPrivilegesPermissionTest.absDirPaths[n] = "directory:/" + dirPaths[n];
        }
        absDirPathAliases = new String[dirPaths.length];
        for (n = 0; n < relDirPaths.length; ++n) {
            SystemPrivilegesPermissionTest.absDirPathAliases[n] = "directory:/dummy/../" + dirPaths[n];
        }
        dirPathImpls = new boolean[][]{{true, true, true, true, true, true, true, true}, {false, true, true, true, false, false, false, false}, {false, false, true, false, false, false, false, false}, {false, false, false, true, false, false, false, false}, {false, false, false, false, true, true, true, true}, {false, false, false, false, false, true, true, false}, {false, false, false, false, false, false, true, false}, {false, false, false, false, false, false, false, true}};
        VALID_SYSPERM_NAMES = new String[]{"server", "engine", "jmx"};
        VALID_SYSPERM_ACTIONS = new String[]{"shutdown", "control", "monitor"};
    }

    public static class RunAsPrivilegedUserAction<T>
    implements PrivilegedAction<T> {
        private final SystemPrincipal principal;
        private final PrivilegedAction<? extends T> action;

        public RunAsPrivilegedUserAction(SystemPrincipal systemPrincipal, PrivilegedAction<? extends T> privilegedAction) {
            this.principal = systemPrincipal;
            this.action = privilegedAction;
        }

        @Override
        public T run() {
            HashSet<SystemPrincipal> hashSet = new HashSet<SystemPrincipal>();
            HashSet hashSet2 = new HashSet();
            HashSet hashSet3 = new HashSet();
            hashSet.add(this.principal);
            String string = SystemPrivilegesPermissionTest.getAuthorizationId(this.principal.getName());
            hashSet.add(new SystemPrincipal(string));
            Subject subject = new Subject(true, hashSet, hashSet2, hashSet3);
            return Subject.doAsPrivileged(subject, this.action, null);
        }
    }

    public class CreateDatabaseAction
    implements PrivilegedAction<Void> {
        protected final Permission permission;

        public CreateDatabaseAction(Permission permission) {
            this.permission = permission;
        }

        @Override
        public Void run() {
            BaseTestCase.println("    checking access " + this.permission + ":");
            AccessController.checkPermission(this.permission);
            BaseTestCase.println("    granted access " + this);
            return null;
        }

        public String toString() {
            return this.permission.toString();
        }
    }

    public class ShutdownAction
    implements PrivilegedAction<Void> {
        protected final Permission permission;

        public ShutdownAction(Permission permission) {
            this.permission = permission;
        }

        @Override
        public Void run() {
            AccessController.checkPermission(this.permission);
            return null;
        }

        public String toString() {
            return this.permission.toString();
        }
    }
}

