/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.hash;

import java.io.IOException;
import org.apache.datasketches.pig.PigTestingUtil;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.junit.Assert;
import org.testng.annotations.Test;

public class MurmurHash3Test {
    private static final TupleFactory mTupleFactory = TupleFactory.getInstance();
    private String hashUdfName = "org.apache.datasketches.pig.hash.MurmurHash3";

    @Test
    public void checkExceptions1() throws IOException {
        EvalFunc hashUdf = (EvalFunc)PigContext.instantiateFuncFromSpec((FuncSpec)new FuncSpec(this.hashUdfName));
        Tuple in = mTupleFactory.newTuple(0);
        Tuple out = (Tuple)hashUdf.exec(in);
        org.testng.Assert.assertNull((Object)out);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void checkExceptions2() throws IOException {
        EvalFunc hashUdf = (EvalFunc)PigContext.instantiateFuncFromSpec((FuncSpec)new FuncSpec(this.hashUdfName));
        Tuple in = mTupleFactory.newTuple(2);
        in.set(0, (Object)"ABC");
        in.set(1, (Object)9001.0);
        Tuple out = (Tuple)hashUdf.exec(in);
        Assert.assertNotNull((Object)out);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void checkExceptions3() throws IOException {
        EvalFunc hashUdf = (EvalFunc)PigContext.instantiateFuncFromSpec((FuncSpec)new FuncSpec(this.hashUdfName));
        Tuple in = mTupleFactory.newTuple(1);
        in.set(0, (Object)in);
        Tuple out = (Tuple)hashUdf.exec(in);
        Assert.assertNotNull((Object)out);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void checkExceptions4() throws IOException {
        EvalFunc hashUdf = (EvalFunc)PigContext.instantiateFuncFromSpec((FuncSpec)new FuncSpec(this.hashUdfName));
        Tuple in = mTupleFactory.newTuple(3);
        in.set(0, (Object)"ABC");
        in.set(1, (Object)0);
        in.set(2, (Object)8L);
        Tuple out = (Tuple)hashUdf.exec(in);
        Assert.assertNotNull((Object)out);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void checkExceptions5() throws IOException {
        EvalFunc hashUdf = (EvalFunc)PigContext.instantiateFuncFromSpec((FuncSpec)new FuncSpec(this.hashUdfName));
        Tuple in = mTupleFactory.newTuple(3);
        in.set(0, (Object)"ABC");
        in.set(1, (Object)0);
        in.set(2, (Object)0);
        Tuple out = (Tuple)hashUdf.exec(in);
        Assert.assertNotNull((Object)out);
    }

    @Test
    public void check1ValidArg() throws IOException {
        EvalFunc hashUdf = (EvalFunc)PigContext.instantiateFuncFromSpec((FuncSpec)new FuncSpec(this.hashUdfName));
        Tuple in = mTupleFactory.newTuple(1);
        in.set(0, null);
        Tuple out = (Tuple)hashUdf.exec(in);
        org.testng.Assert.assertNull((Object)out.get(0));
        org.testng.Assert.assertNull((Object)out.get(1));
        org.testng.Assert.assertNull((Object)out.get(2));
        in.set(0, (Object)1);
        out = (Tuple)hashUdf.exec(in);
        MurmurHash3Test.checkOutput(out, false);
        in.set(0, (Object)1L);
        out = (Tuple)hashUdf.exec(in);
        MurmurHash3Test.checkOutput(out, false);
        in.set(0, (Object)Float.valueOf(1.0f));
        out = (Tuple)hashUdf.exec(in);
        MurmurHash3Test.checkOutput(out, false);
        in.set(0, (Object)0.0);
        out = (Tuple)hashUdf.exec(in);
        MurmurHash3Test.checkOutput(out, false);
        in.set(0, (Object)-0.0);
        out = (Tuple)hashUdf.exec(in);
        MurmurHash3Test.checkOutput(out, false);
        in.set(0, (Object)Double.NaN);
        out = (Tuple)hashUdf.exec(in);
        MurmurHash3Test.checkOutput(out, false);
        in.set(0, (Object)"1");
        out = (Tuple)hashUdf.exec(in);
        MurmurHash3Test.checkOutput(out, false);
        in.set(0, (Object)"");
        out = (Tuple)hashUdf.exec(in);
        org.testng.Assert.assertNull((Object)out.get(0));
        org.testng.Assert.assertNull((Object)out.get(1));
        org.testng.Assert.assertNull((Object)out.get(2));
        byte[] bArr = new byte[]{1, 2, 3, 4};
        DataByteArray dba = new DataByteArray(bArr);
        in.set(0, (Object)dba);
        out = (Tuple)hashUdf.exec(in);
        MurmurHash3Test.checkOutput(out, false);
        bArr = new byte[]{};
        dba = new DataByteArray(bArr);
        in.set(0, (Object)dba);
        out = (Tuple)hashUdf.exec(in);
        org.testng.Assert.assertNull((Object)out.get(0));
        org.testng.Assert.assertNull((Object)out.get(1));
        org.testng.Assert.assertNull((Object)out.get(2));
    }

    @Test
    public void check2ValidArg() throws IOException {
        EvalFunc hashUdf = (EvalFunc)PigContext.instantiateFuncFromSpec((FuncSpec)new FuncSpec(this.hashUdfName));
        Tuple in = mTupleFactory.newTuple(2);
        in.set(0, (Object)"1");
        Tuple out = (Tuple)hashUdf.exec(in);
        MurmurHash3Test.checkOutput(out, false);
        in.set(0, (Object)"1");
        in.set(1, (Object)9001);
        out = (Tuple)hashUdf.exec(in);
        MurmurHash3Test.checkOutput(out, false);
        in.set(0, (Object)"1");
        in.set(1, (Object)9001L);
        out = (Tuple)hashUdf.exec(in);
        MurmurHash3Test.checkOutput(out, false);
    }

    @Test
    public void check3ValidArg() throws IOException {
        EvalFunc hashUdf = (EvalFunc)PigContext.instantiateFuncFromSpec((FuncSpec)new FuncSpec(this.hashUdfName));
        Tuple in = mTupleFactory.newTuple(3);
        in.set(0, (Object)"1");
        Tuple out = (Tuple)hashUdf.exec(in);
        MurmurHash3Test.checkOutput(out, false);
        in.set(0, (Object)"1");
        in.set(1, (Object)9001);
        out = (Tuple)hashUdf.exec(in);
        MurmurHash3Test.checkOutput(out, false);
        in.set(0, (Object)"1");
        in.set(1, (Object)9001);
        in.set(2, (Object)7);
        out = (Tuple)hashUdf.exec(in);
        MurmurHash3Test.checkOutput(out, true);
    }

    @Test
    public void check3ValidArgs() throws IOException {
        EvalFunc hashUdf = (EvalFunc)PigContext.instantiateFuncFromSpec((FuncSpec)new FuncSpec(this.hashUdfName));
        Tuple in = mTupleFactory.newTuple(3);
        for (int i = 0; i < 10; ++i) {
            in.set(0, (Object)i);
            in.set(1, (Object)9001);
            in.set(2, (Object)7);
            Tuple out = (Tuple)hashUdf.exec(in);
            MurmurHash3Test.checkOutput(out, true);
        }
    }

    private static void checkOutput(Tuple out, boolean checkMod) throws IOException {
        long h0 = (Long)out.get(0);
        long h1 = (Long)out.get(1);
        org.testng.Assert.assertNotEquals((Object)h0, (Object)0L);
        org.testng.Assert.assertNotEquals((Object)h1, (Object)0L);
        if (checkMod) {
            int r = (Integer)out.get(2);
            org.testng.Assert.assertTrue((r >= 0 ? 1 : 0) != 0, (String)("" + r));
        }
    }

    @Test
    public void outputSchemaTestMurmurHash3Udf() throws IOException {
        EvalFunc hashUdf = (EvalFunc)PigContext.instantiateFuncFromSpec((FuncSpec)new FuncSpec(this.hashUdfName));
        Schema inputSchema = null;
        Schema nullOutputSchema = null;
        Schema outputSchema = null;
        Schema.FieldSchema outputOuterFs0 = null;
        Schema outputInnerSchema = null;
        Schema.FieldSchema outputInnerFs0 = null;
        Schema.FieldSchema outputInnerFs1 = null;
        Schema.FieldSchema outputInnerFs2 = null;
        nullOutputSchema = hashUdf.outputSchema(null);
        inputSchema = Schema.generateNestedSchema((byte)120, (byte[])new byte[]{55});
        outputSchema = hashUdf.outputSchema(inputSchema);
        outputOuterFs0 = outputSchema.getField(0);
        outputInnerSchema = outputOuterFs0.schema;
        outputInnerFs0 = outputInnerSchema.getField(0);
        outputInnerFs1 = outputInnerSchema.getField(1);
        outputInnerFs2 = outputInnerSchema.getField(2);
        org.testng.Assert.assertNull((Object)nullOutputSchema, (String)"Should be null");
        org.testng.Assert.assertNotNull((Object)outputOuterFs0, (String)"outputSchema.getField(0) may not be null");
        String expected = "tuple";
        String result = DataType.findTypeName((byte)outputOuterFs0.type);
        org.testng.Assert.assertEquals((String)result, (String)expected);
        expected = "long";
        org.testng.Assert.assertNotNull((Object)outputInnerFs0, (String)"innerSchema.getField(0) may not be null");
        result = DataType.findTypeName((byte)outputInnerFs0.type);
        org.testng.Assert.assertEquals((String)result, (String)expected);
        expected = "long";
        org.testng.Assert.assertNotNull((Object)outputInnerFs1, (String)"innerSchema.getField(1) may not be null");
        result = DataType.findTypeName((byte)outputInnerFs1.type);
        org.testng.Assert.assertEquals((String)result, (String)expected);
        expected = "int";
        org.testng.Assert.assertNotNull((Object)outputInnerFs2, (String)"innerSchema.getField(2) may not be null");
        result = DataType.findTypeName((byte)outputInnerFs2.type);
        org.testng.Assert.assertEquals((String)result, (String)expected);
        StringBuilder sb = new StringBuilder();
        sb.append("input schema: ").append(inputSchema).append(PigTestingUtil.LS).append("output schema: ").append(outputSchema).append(PigTestingUtil.LS).append("outputOuterFs: ").append(outputOuterFs0).append(", type: ").append(DataType.findTypeName((byte)outputOuterFs0.type)).append(PigTestingUtil.LS).append("outputInnerSchema: ").append(outputInnerSchema).append(PigTestingUtil.LS).append("outputInnerFs0: ").append(outputInnerFs0).append(", type: ").append(DataType.findTypeName((byte)outputInnerFs0.type)).append(PigTestingUtil.LS).append("outputInnerFs1: ").append(outputInnerFs1).append(", type: ").append(DataType.findTypeName((byte)outputInnerFs1.type)).append(PigTestingUtil.LS).append("outputInnerFs2: ").append(outputInnerFs2).append(", type: ").append(DataType.findTypeName((byte)outputInnerFs2.type)).append(PigTestingUtil.LS);
        MurmurHash3Test.println(sb.toString());
    }

    @Test
    public void printlnTest() {
        MurmurHash3Test.println(this.getClass().getSimpleName());
    }

    static void println(String s) {
    }
}

