/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import jdk.incubator.foreign.ResourceScope;
import org.apache.datasketches.memory.Buffer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.Resource;
import org.apache.datasketches.memory.WritableBuffer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.memory.internal.ResourceImpl;
import org.testng.Assert;
import org.testng.annotations.Test;

public class NativeWritableMemoryImplTest {
    private static final MemoryRequestServer memReqSvr = Resource.defaultMemReqSvr;

    @Test
    public void checkNativeCapacityAndClose() throws Exception {
        int memCapacity = 64;
        ResourceScope scope = ResourceScope.newConfinedScope();
        WritableMemory wmem = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ResourceScope)scope, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr);
        Assert.assertEquals((long)memCapacity, (long)wmem.getCapacity());
        wmem.close();
        Assert.assertFalse((boolean)wmem.isAlive());
        try {
            wmem.close();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void checkByteArray() {
        byte[] srcArray = new byte[]{1, -2, 3, -4, 5, -6, 7, -8};
        byte[] dstArray = new byte[8];
        Memory mem = Memory.wrap((byte[])srcArray);
        mem.getByteArray(0L, dstArray, 0, 8);
        for (int i = 0; i < 8; ++i) {
            Assert.assertEquals((byte)dstArray[i], (byte)srcArray[i]);
        }
        WritableMemory wmem = WritableMemory.writableWrap((byte[])srcArray);
        wmem.getByteArray(0L, dstArray, 0, 8);
        for (int i = 0; i < 8; ++i) {
            Assert.assertEquals((byte)dstArray[i], (byte)srcArray[i]);
        }
    }

    @Test
    public void checkCharArray() {
        char[] srcArray = new char[]{'\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b'};
        char[] dstArray = new char[8];
        Memory mem = Memory.wrap((char[])srcArray);
        mem.getCharArray(0L, dstArray, 0, 8);
        for (int i = 0; i < 8; ++i) {
            Assert.assertEquals((char)dstArray[i], (char)srcArray[i]);
        }
        WritableMemory wmem = WritableMemory.writableWrap((char[])srcArray);
        wmem.getCharArray(0L, dstArray, 0, 8);
        for (int i = 0; i < 8; ++i) {
            Assert.assertEquals((char)dstArray[i], (char)srcArray[i]);
        }
    }

    @Test
    public void checkShortArray() {
        short[] srcArray = new short[]{1, -2, 3, -4, 5, -6, 7, -8};
        short[] dstArray = new short[8];
        Memory mem = Memory.wrap((short[])srcArray);
        mem.getShortArray(0L, dstArray, 0, 8);
        for (int i = 0; i < 8; ++i) {
            Assert.assertEquals((short)dstArray[i], (short)srcArray[i]);
        }
        WritableMemory wmem = WritableMemory.writableWrap((short[])srcArray);
        wmem.getShortArray(0L, dstArray, 0, 8);
        for (int i = 0; i < 8; ++i) {
            Assert.assertEquals((short)dstArray[i], (short)srcArray[i]);
        }
    }

    @Test
    public void checkIntArray() {
        int[] srcArray = new int[]{1, -2, 3, -4, 5, -6, 7, -8};
        int[] dstArray = new int[8];
        Memory mem = Memory.wrap((int[])srcArray);
        mem.getIntArray(0L, dstArray, 0, 8);
        for (int i = 0; i < 8; ++i) {
            Assert.assertEquals((int)dstArray[i], (int)srcArray[i]);
        }
        WritableMemory wmem = WritableMemory.writableWrap((int[])srcArray);
        wmem.getIntArray(0L, dstArray, 0, 8);
        for (int i = 0; i < 8; ++i) {
            Assert.assertEquals((int)dstArray[i], (int)srcArray[i]);
        }
    }

    @Test
    public void checkLongArray() {
        long[] srcArray = new long[]{1L, -2L, 3L, -4L, 5L, -6L, 7L, -8L};
        long[] dstArray = new long[8];
        Memory mem = Memory.wrap((long[])srcArray);
        mem.getLongArray(0L, dstArray, 0, 8);
        for (int i = 0; i < 8; ++i) {
            Assert.assertEquals((long)dstArray[i], (long)srcArray[i]);
        }
        WritableMemory wmem = WritableMemory.writableWrap((long[])srcArray);
        wmem.getLongArray(0L, dstArray, 0, 8);
        for (int i = 0; i < 8; ++i) {
            Assert.assertEquals((long)dstArray[i], (long)srcArray[i]);
        }
    }

    @Test
    public void checkFloatArray() {
        float[] srcArray = new float[]{1.0f, -2.0f, 3.0f, -4.0f, 5.0f, -6.0f, 7.0f, -8.0f};
        float[] dstArray = new float[8];
        Memory mem = Memory.wrap((float[])srcArray);
        mem.getFloatArray(0L, dstArray, 0, 8);
        for (int i = 0; i < 8; ++i) {
            Assert.assertEquals((float)dstArray[i], (float)srcArray[i]);
        }
        WritableMemory wmem = WritableMemory.writableWrap((float[])srcArray);
        wmem.getFloatArray(0L, dstArray, 0, 8);
        for (int i = 0; i < 8; ++i) {
            Assert.assertEquals((float)dstArray[i], (float)srcArray[i]);
        }
    }

    @Test
    public void checkDoubleArray() {
        double[] srcArray = new double[]{1.0, -2.0, 3.0, -4.0, 5.0, -6.0, 7.0, -8.0};
        double[] dstArray = new double[8];
        Memory mem = Memory.wrap((double[])srcArray);
        mem.getDoubleArray(0L, dstArray, 0, 8);
        for (int i = 0; i < 8; ++i) {
            Assert.assertEquals((double)dstArray[i], (double)srcArray[i]);
        }
        WritableMemory wmem = WritableMemory.writableWrap((double[])srcArray);
        wmem.getDoubleArray(0L, dstArray, 0, 8);
        for (int i = 0; i < 8; ++i) {
            Assert.assertEquals((double)dstArray[i], (double)srcArray[i]);
        }
    }

    @Test
    public void checkNativeBaseBound() throws Exception {
        int memCapacity = 64;
        try (ResourceScope scope = ResourceScope.newConfinedScope();){
            WritableMemory wmem = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ResourceScope)scope, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr);
            wmem.toString("Force Assertion Error", (long)memCapacity, 8, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkNativeSrcArrayBound() throws Exception {
        long memCapacity = 64L;
        try (ResourceScope scope = ResourceScope.newConfinedScope();){
            WritableMemory wmem = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ResourceScope)scope, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr);
            byte[] srcArray = new byte[]{1, -2, 3, -4};
            wmem.putByteArray(0L, srcArray, 0, 5);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void checkDegenerateCopyTo() {
        WritableMemory wmem = WritableMemory.allocate((int)64);
        wmem.copyTo(0L, wmem, 0L, 64L);
    }

    @Test
    public void checkCopyWithinNativeSmall() throws Exception {
        int memCapacity = 64;
        int half = memCapacity / 2;
        try (ResourceScope scope = ResourceScope.newConfinedScope();){
            int i;
            WritableMemory wmem = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ResourceScope)scope, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr);
            wmem.clear();
            for (i = 0; i < half; ++i) {
                wmem.putByte((long)i, (byte)i);
            }
            wmem.copyTo(0L, wmem, (long)half, (long)half);
            for (i = 0; i < half; ++i) {
                Assert.assertEquals((byte)wmem.getByte((long)(i + half)), (byte)((byte)i));
            }
        }
    }

    @Test
    public void checkCopyWithinNativeLarge() throws Exception {
        int memCapacity = 0x200040;
        int memCapLongs = memCapacity / 8;
        int halfBytes = memCapacity / 2;
        int halfLongs = memCapLongs / 2;
        try (ResourceScope scope = ResourceScope.newConfinedScope();){
            int i;
            WritableMemory wmem = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ResourceScope)scope, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr);
            wmem.clear();
            for (i = 0; i < halfLongs; ++i) {
                wmem.putLong((long)(i * 8), (long)i);
            }
            wmem.copyTo(0L, wmem, (long)halfBytes, (long)halfBytes);
            for (i = 0; i < halfLongs; ++i) {
                Assert.assertEquals((long)wmem.getLong((long)((i + halfLongs) * 8)), (long)i);
            }
        }
    }

    @Test
    public void checkCopyWithinNativeSrcBound() throws Exception {
        int memCapacity = 64;
        try (ResourceScope scope = ResourceScope.newConfinedScope();){
            WritableMemory wmem = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ResourceScope)scope, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr);
            wmem.copyTo(32L, wmem, 32L, 33L);
            Assert.fail((String)"Did Not Catch Assertion Error: source bound");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void checkCopyWithinNativeDstBound() throws Exception {
        int memCapacity = 64;
        try (ResourceScope scope = ResourceScope.newConfinedScope();){
            WritableMemory wmem = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ResourceScope)scope, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr);
            wmem.copyTo(0L, wmem, 32L, 33L);
            Assert.fail((String)"Did Not Catch Assertion Error: dst bound");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void checkCopyCrossNativeSmall() throws Exception {
        int memCapacity = 64;
        try (ResourceScope scope = ResourceScope.newConfinedScope();){
            int i;
            WritableMemory wmem1 = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ResourceScope)scope, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr);
            WritableMemory wmem2 = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ResourceScope)scope, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr);
            for (i = 0; i < memCapacity; ++i) {
                wmem1.putByte((long)i, (byte)i);
            }
            wmem2.clear();
            wmem1.copyTo(0L, wmem2, 0L, (long)memCapacity);
            for (i = 0; i < memCapacity; ++i) {
                Assert.assertEquals((byte)wmem2.getByte((long)i), (byte)((byte)i));
            }
        }
    }

    @Test
    public void checkCopyCrossNativeLarge() throws Exception {
        int memCapacity = 0x200040;
        int memCapLongs = memCapacity / 8;
        try (ResourceScope scope = ResourceScope.newConfinedScope();){
            int i;
            WritableMemory wmem1 = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ResourceScope)scope, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr);
            WritableMemory wmem2 = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ResourceScope)scope, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr);
            for (i = 0; i < memCapLongs; ++i) {
                wmem1.putLong((long)(i * 8), (long)i);
            }
            wmem2.clear();
            wmem1.copyTo(0L, wmem2, 0L, (long)memCapacity);
            for (i = 0; i < memCapLongs; ++i) {
                Assert.assertEquals((long)wmem2.getLong((long)(i * 8)), (long)i);
            }
        }
    }

    @Test
    public void checkCopyCrossNativeAndByteArray() throws Exception {
        int memCapacity = 64;
        try (ResourceScope scope = ResourceScope.newConfinedScope();){
            WritableMemory wmem = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ResourceScope)scope, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr);
            int i = 0;
            while ((long)i < wmem.getCapacity()) {
                wmem.putByte((long)i, (byte)i);
                ++i;
            }
            WritableMemory wmem2 = WritableMemory.allocate((int)memCapacity);
            wmem.copyTo(8L, wmem2, 16L, 16L);
            for (int i2 = 0; i2 < 16; ++i2) {
                Assert.assertEquals((byte)wmem.getByte((long)(8 + i2)), (byte)wmem2.getByte((long)(16 + i2)));
            }
        }
    }

    @Test
    public void checkCopyCrossRegionsSameNative() throws Exception {
        int memCapacity = 128;
        try (ResourceScope scope = ResourceScope.newConfinedScope();){
            WritableMemory wmem1 = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ResourceScope)scope, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr);
            int i = 0;
            while ((long)i < wmem1.getCapacity()) {
                wmem1.putByte((long)i, (byte)i);
                ++i;
            }
            Memory reg1 = wmem1.region(8L, 16L);
            WritableMemory reg2 = wmem1.writableRegion(24L, 16L);
            reg1.copyTo(0L, reg2, 0L, 16L);
            for (int i2 = 0; i2 < 16; ++i2) {
                Assert.assertEquals((byte)reg1.getByte((long)i2), (byte)reg2.getByte((long)i2));
                Assert.assertEquals((byte)wmem1.getByte((long)(8 + i2)), (byte)wmem1.getByte((long)(24 + i2)));
            }
        }
    }

    @Test
    public void checkCopyCrossNativeArrayAndHierarchicalRegions() throws Exception {
        int memCapacity = 64;
        try (ResourceScope scope = ResourceScope.newConfinedScope();){
            WritableMemory wmem1 = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ResourceScope)scope, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr);
            int i = 0;
            while ((long)i < wmem1.getCapacity()) {
                wmem1.putByte((long)i, (byte)i);
                ++i;
            }
            WritableMemory wmem2 = WritableMemory.allocate((int)memCapacity);
            Memory reg1 = wmem1.region(8L, 32L);
            Memory reg1B = reg1.region(8L, 16L);
            WritableMemory reg2 = wmem2.writableRegion(32L, 16L);
            reg1B.copyTo(0L, reg2, 0L, 16L);
            int i2 = 32;
            int j = 16;
            while (i2 < 40) {
                Assert.assertEquals((int)wmem2.getByte((long)i2), (int)j);
                ++i2;
                ++j;
            }
        }
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void checkRegionBounds() throws Exception {
        int memCapacity = 64;
        try (ResourceScope scope = ResourceScope.newConfinedScope();){
            WritableMemory wmem = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ResourceScope)scope, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr);
            wmem.writableRegion(1L, 64L);
        }
    }

    @Test
    public void checkByteBufferWrap() {
        int memCapacity = 64;
        ByteBuffer byteBuf = ByteBuffer.allocate(memCapacity);
        byteBuf.order(ByteOrder.nativeOrder());
        for (int i = 0; i < memCapacity; ++i) {
            byteBuf.put(i, (byte)i);
        }
        WritableMemory wmem = WritableMemory.writableWrap((ByteBuffer)byteBuf);
        for (int i = 0; i < memCapacity; ++i) {
            Assert.assertEquals((byte)wmem.getByte((long)i), (byte)byteBuf.get(i));
        }
        Assert.assertTrue((boolean)wmem.hasByteBuffer());
        ByteBuffer byteBuf2 = wmem.toByteBuffer(ByteOrder.nativeOrder());
        Assert.assertEquals((Object)byteBuf2, (Object)byteBuf);
    }

    @Test
    public void checkWrapWithBBReadonly1() {
        int memCapacity = 64;
        ByteBuffer byteBuf = ByteBuffer.allocate(memCapacity);
        byteBuf.order(ByteOrder.nativeOrder());
        for (int i = 0; i < memCapacity; ++i) {
            byteBuf.put(i, (byte)i);
        }
        WritableMemory mem = WritableMemory.writableWrap((ByteBuffer)byteBuf);
        for (int i = 0; i < memCapacity; ++i) {
            Assert.assertEquals((byte)mem.getByte((long)i), (byte)byteBuf.get(i));
        }
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void checkWrapWithBBReadonly2() {
        int memCapacity = 64;
        ByteBuffer byteBuf = ByteBuffer.allocate(memCapacity);
        byteBuf.order(ByteOrder.nativeOrder());
        ByteBuffer byteBufRO = byteBuf.asReadOnlyBuffer();
        WritableMemory.writableWrap((ByteBuffer)byteBufRO);
    }

    @Test
    public void checkWrapWithDirectBBReadonly() {
        int memCapacity = 64;
        ByteBuffer byteBuf = ByteBuffer.allocateDirect(memCapacity);
        byteBuf.order(ByteOrder.nativeOrder());
        for (int i = 0; i < memCapacity; ++i) {
            byteBuf.put(i, (byte)i);
        }
        ByteBuffer byteBufRO = byteBuf.asReadOnlyBuffer();
        byteBufRO.order(ByteOrder.nativeOrder());
        Memory mem = Memory.wrap((ByteBuffer)byteBufRO);
        for (int i = 0; i < memCapacity; ++i) {
            Assert.assertEquals((byte)mem.getByte((long)i), (byte)byteBuf.get(i));
        }
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void checkWrapWithDirectBBReadonlyPut() {
        int memCapacity = 64;
        ByteBuffer byteBuf = ByteBuffer.allocateDirect(memCapacity);
        ByteBuffer byteBufRO = byteBuf.asReadOnlyBuffer();
        byteBufRO.order(ByteOrder.nativeOrder());
        WritableMemory.writableWrap((ByteBuffer)byteBufRO);
    }

    @Test
    public void checkByteBufferWrapDirectAccess() {
        int memCapacity = 64;
        ByteBuffer byteBuf = ByteBuffer.allocateDirect(memCapacity);
        byteBuf.order(ByteOrder.nativeOrder());
        for (int i = 0; i < memCapacity; ++i) {
            byteBuf.put(i, (byte)i);
        }
        Memory mem = Memory.wrap((ByteBuffer)byteBuf);
        for (int i = 0; i < memCapacity; ++i) {
            Assert.assertEquals((byte)mem.getByte((long)i), (byte)byteBuf.get(i));
        }
    }

    @Test
    public void checkIsDirect() throws Exception {
        int memCapacity = 64;
        WritableMemory mem = WritableMemory.allocate((int)memCapacity);
        Assert.assertFalse((boolean)mem.isDirect());
        try (ResourceScope scope = ResourceScope.newConfinedScope();){
            WritableMemory wmem = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ResourceScope)scope, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr);
            Assert.assertTrue((boolean)wmem.isDirect());
        }
    }

    @Test
    public void checkIsReadOnly() {
        long[] srcArray = new long[]{1L, -2L, 3L, -4L, 5L, -6L, 7L, -8L};
        WritableMemory wmem = WritableMemory.writableWrap((long[])srcArray);
        Assert.assertFalse((boolean)wmem.isReadOnly());
        WritableMemory memRO = wmem;
        Assert.assertFalse((boolean)memRO.isReadOnly());
        int i = 0;
        while ((long)i < wmem.getCapacity()) {
            Assert.assertEquals((byte)wmem.getByte((long)i), (byte)memRO.getByte((long)i));
            ++i;
        }
    }

    @Test
    public void checkGoodBounds() {
        ResourceImpl.checkBounds((long)50L, (long)50L, (long)100L);
    }

    @Test
    public void checkCompareToHeap() {
        byte[] arr1 = new byte[]{0, 1, 2, 3};
        byte[] arr2 = new byte[]{0, 1, 2, 4};
        byte[] arr3 = new byte[]{0, 1, 2, 3, 4};
        Memory mem1 = Memory.wrap((byte[])arr1);
        Memory mem2 = Memory.wrap((byte[])arr2);
        Memory mem3 = Memory.wrap((byte[])arr3);
        Memory mem4 = Memory.wrap((byte[])arr3);
        int comp = mem1.compareTo(0L, 3L, mem2, 0L, 3L);
        Assert.assertEquals((int)comp, (int)0);
        comp = mem1.compareTo(0L, 4L, mem2, 0L, 4L);
        Assert.assertEquals((int)comp, (int)-1);
        comp = mem2.compareTo(0L, 4L, mem1, 0L, 4L);
        Assert.assertEquals((int)comp, (int)1);
        comp = mem1.compareTo(0L, 4L, mem3, 0L, 5L);
        Assert.assertEquals((int)comp, (int)-1);
        comp = mem3.compareTo(0L, 5L, mem1, 0L, 4L);
        Assert.assertEquals((int)comp, (int)1);
        comp = mem3.compareTo(0L, 5L, mem4, 0L, 5L);
        Assert.assertEquals((int)comp, (int)0);
        comp = mem3.compareTo(0L, 4L, mem4, 1L, 4L);
        Assert.assertEquals((int)comp, (int)-1);
        ResourceImpl.checkBounds((long)0L, (long)5L, (long)mem3.getCapacity());
    }

    @Test
    public void checkCompareToDirect() throws Exception {
        byte[] arr1 = new byte[]{0, 1, 2, 3};
        byte[] arr2 = new byte[]{0, 1, 2, 4};
        byte[] arr3 = new byte[]{0, 1, 2, 3, 4};
        try (ResourceScope scope = ResourceScope.newConfinedScope();){
            WritableMemory mem1 = WritableMemory.allocateDirect((long)4L, (long)1L, (ResourceScope)scope, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr);
            WritableMemory mem2 = WritableMemory.allocateDirect((long)4L, (long)1L, (ResourceScope)scope, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr);
            WritableMemory mem3 = WritableMemory.allocateDirect((long)5L, (long)1L, (ResourceScope)scope, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr);
            mem1.putByteArray(0L, arr1, 0, 4);
            mem2.putByteArray(0L, arr2, 0, 4);
            mem3.putByteArray(0L, arr3, 0, 5);
            int comp = mem1.compareTo(0L, 3L, (Memory)mem2, 0L, 3L);
            Assert.assertEquals((int)comp, (int)0);
            comp = mem1.compareTo(0L, 4L, (Memory)mem2, 0L, 4L);
            Assert.assertEquals((int)comp, (int)-1);
            comp = mem2.compareTo(0L, 4L, (Memory)mem1, 0L, 4L);
            Assert.assertEquals((int)comp, (int)1);
            comp = mem1.compareTo(0L, 4L, (Memory)mem3, 0L, 5L);
            Assert.assertEquals((int)comp, (int)-1);
            comp = mem3.compareTo(0L, 5L, (Memory)mem1, 0L, 4L);
            Assert.assertEquals((int)comp, (int)1);
        }
    }

    @Test
    public void testCompareToSameStart() {
        WritableMemory mem = WritableMemory.allocate((int)3);
        Assert.assertEquals((int)-1, (int)mem.compareTo(0L, 1L, (Memory)mem, 0L, 2L));
        Assert.assertEquals((int)0, (int)mem.compareTo(1L, 1L, (Memory)mem, 1L, 1L));
        Assert.assertEquals((int)1, (int)mem.compareTo(1L, 2L, (Memory)mem, 1L, 1L));
    }

    @Test
    public void checkAsBuffer() {
        WritableMemory wmem = WritableMemory.allocate((int)64);
        WritableBuffer wbuf = wmem.asWritableBuffer();
        wbuf.setPosition(32L);
        for (int i = 32; i < 64; ++i) {
            wbuf.putByte((byte)i);
        }
        Buffer buf = wmem.asBuffer();
        buf.setPosition(32L);
        for (int i = 32; i < 64; ++i) {
            Assert.assertEquals((int)buf.getByte(), (int)i);
        }
    }

    @Test
    public void checkAsWritableBufferWithBB() {
        ByteBuffer byteBuf = ByteBuffer.allocate(64);
        byteBuf.position(16);
        byteBuf.limit(48);
        WritableMemory wmem = WritableMemory.writableWrap((ByteBuffer)byteBuf);
        WritableBuffer wbuf = wmem.asWritableBuffer();
        Assert.assertEquals((long)wbuf.getCapacity(), (long)64L);
        Assert.assertEquals((long)wbuf.getPosition(), (long)0L);
        Assert.assertEquals((long)wbuf.getEnd(), (long)64L);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void checkAsWritableRegionRO() {
        ByteBuffer byteBuf = ByteBuffer.allocate(64);
        WritableMemory wmem = (WritableMemory)Memory.wrap((ByteBuffer)byteBuf);
        wmem.writableRegion(0L, 1L);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void checkAsWritableBufferRO() {
        ByteBuffer byteBuf = ByteBuffer.allocate(64);
        WritableMemory wmem = (WritableMemory)Memory.wrap((ByteBuffer)byteBuf);
        wmem.asWritableBuffer();
    }

    @Test
    void checkZeroMemory() {
        WritableMemory wmem = WritableMemory.allocate((int)8);
        WritableMemory reg = wmem.writableRegion(0L, 0L);
        Assert.assertEquals((long)reg.getCapacity(), (long)0L);
    }

    @Test
    public void checkAsBufferNonNative() {
        WritableMemory wmem = WritableMemory.allocate((int)64);
        wmem.putShort(0L, (short)1);
        Buffer buf = wmem.asBuffer(ResourceImpl.NON_NATIVE_BYTE_ORDER);
        Assert.assertEquals((int)buf.getShort(0L), (int)256);
    }

    @Test
    public void printlnTest() {
        NativeWritableMemoryImplTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

