/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.processors.parsers;

import com.ibm.icu.math.BigDecimal;
import com.ibm.icu.text.DecimalFormat;
import java.io.Serializable;
import java.text.ParsePosition;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.runtime1.dpath.InvalidPrimitiveDataException;
import org.apache.daffodil.runtime1.dpath.NodeInfo;
import org.apache.daffodil.runtime1.infoset.DISimple;
import org.apache.daffodil.runtime1.processors.ElementRuntimeData;
import org.apache.daffodil.runtime1.processors.Evaluatable;
import org.apache.daffodil.runtime1.processors.PrimProcessor;
import org.apache.daffodil.runtime1.processors.Processor;
import org.apache.daffodil.runtime1.processors.TextNumberFormatEv;
import org.apache.daffodil.runtime1.processors.ToBriefXMLImpl;
import org.apache.daffodil.runtime1.processors.parsers.ConvertTextStandardNumberParser$;
import org.apache.daffodil.runtime1.processors.parsers.PState;
import org.apache.daffodil.runtime1.processors.parsers.Parser;
import org.apache.daffodil.runtime1.processors.parsers.TextDecimalVirtualPointMixin;
import org.apache.daffodil.runtime1.processors.parsers.TextPrimParser;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.matching.Regex;

public class ConvertTextStandardNumberParser
implements ToBriefXMLImpl,
Processor,
PrimProcessor,
Parser,
TextPrimParser,
TextDecimalVirtualPointMixin,
Product {
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(ConvertTextStandardNumberParser.class.getDeclaredField("virtualPointScaleFactor$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(ConvertTextStandardNumberParser.class.getDeclaredField("parserName$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ConvertTextStandardNumberParser.class.getDeclaredField("org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1"));
    private volatile Object org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1;
    private boolean isInitialized;
    private volatile Object parserName$lzy1;
    private volatile Object virtualPointScaleFactor$lzy1;
    private final TextNumberFormatEv textNumberFormatEv;
    private final List zeroRepsRegex;
    private final ElementRuntimeData context;
    private final int textDecimalVirtualPoint;
    private final NodeInfo.PrimType.PrimNumeric primNumeric;

    public static ConvertTextStandardNumberParser apply(TextNumberFormatEv textNumberFormatEv, List<Regex> list, ElementRuntimeData elementRuntimeData, int n) {
        return ConvertTextStandardNumberParser$.MODULE$.apply(textNumberFormatEv, list, elementRuntimeData, n);
    }

    public static ConvertTextStandardNumberParser fromProduct(Product product) {
        return ConvertTextStandardNumberParser$.MODULE$.fromProduct(product);
    }

    public static ConvertTextStandardNumberParser unapply(ConvertTextStandardNumberParser convertTextStandardNumberParser) {
        return ConvertTextStandardNumberParser$.MODULE$.unapply(convertTextStandardNumberParser);
    }

    public ConvertTextStandardNumberParser(TextNumberFormatEv textNumberFormatEv, List<Regex> zeroRepsRegex, ElementRuntimeData context, int textDecimalVirtualPoint) {
        this.textNumberFormatEv = textNumberFormatEv;
        this.zeroRepsRegex = zeroRepsRegex;
        this.context = context;
        this.textDecimalVirtualPoint = textDecimalVirtualPoint;
        ToBriefXMLImpl.$init$(this);
        Processor.$init$(this);
        Parser.$init$(this);
        TextDecimalVirtualPointMixin.$init$(this);
        this.primNumeric = (NodeInfo.PrimType.PrimNumeric)context.optPrimType().get();
    }

    @Override
    public String org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_() {
        Object object = this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzyINIT1();
    }

    private Object org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = ToBriefXMLImpl.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$(this);
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public void isInitialized_$eq(boolean x$1) {
        this.isInitialized = x$1;
    }

    @Override
    public String parserName() {
        Object object = this.parserName$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.parserName$lzyINIT1();
    }

    private Object parserName$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.parserName$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = Parser.parserName$(this);
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.parserName$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public final double virtualPointScaleFactor() {
        Object object = this.virtualPointScaleFactor$lzy1;
        if (object instanceof Double) {
            return BoxesRunTime.unboxToDouble((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToDouble(null);
        }
        return BoxesRunTime.unboxToDouble((Object)this.virtualPointScaleFactor$lzyINIT1());
    }

    private Object virtualPointScaleFactor$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.virtualPointScaleFactor$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Double d = null;
                    try {
                        d = BoxesRunTime.boxToDouble((double)TextDecimalVirtualPointMixin.virtualPointScaleFactor$(this));
                        object2 = d == null ? LazyVals.NullValue$.MODULE$ : d;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.virtualPointScaleFactor$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return d;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.textNumberFormatEv()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.zeroRepsRegex()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.context()));
        n = Statics.mix((int)n, (int)this.textDecimalVirtualPoint());
        return Statics.finalizeHash((int)n, (int)4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ConvertTextStandardNumberParser)) return false;
        ConvertTextStandardNumberParser convertTextStandardNumberParser = (ConvertTextStandardNumberParser)object;
        if (this.textDecimalVirtualPoint() != convertTextStandardNumberParser.textDecimalVirtualPoint()) return false;
        TextNumberFormatEv textNumberFormatEv = this.textNumberFormatEv();
        TextNumberFormatEv textNumberFormatEv2 = convertTextStandardNumberParser.textNumberFormatEv();
        if (textNumberFormatEv == null) {
            if (textNumberFormatEv2 != null) {
                return false;
            }
        } else if (!textNumberFormatEv.equals(textNumberFormatEv2)) return false;
        List<Regex> list = this.zeroRepsRegex();
        List<Regex> list2 = convertTextStandardNumberParser.zeroRepsRegex();
        if (list == null) {
            if (list2 != null) {
                return false;
            }
        } else if (!list.equals(list2)) return false;
        ElementRuntimeData elementRuntimeData = this.context();
        ElementRuntimeData elementRuntimeData2 = convertTextStandardNumberParser.context();
        if (elementRuntimeData == null) {
            if (elementRuntimeData2 != null) {
                return false;
            }
        } else if (!((Object)elementRuntimeData).equals(elementRuntimeData2)) return false;
        if (!convertTextStandardNumberParser.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof ConvertTextStandardNumberParser;
    }

    public int productArity() {
        return 4;
    }

    public String productPrefix() {
        return "ConvertTextStandardNumberParser";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return BoxesRunTime.boxToInteger((int)this._4());
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "textNumberFormatEv";
            }
            case 1: {
                return "zeroRepsRegex";
            }
            case 2: {
                return "context";
            }
            case 3: {
                return "textDecimalVirtualPoint";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public TextNumberFormatEv textNumberFormatEv() {
        return this.textNumberFormatEv;
    }

    public List<Regex> zeroRepsRegex() {
        return this.zeroRepsRegex;
    }

    @Override
    public ElementRuntimeData context() {
        return this.context;
    }

    @Override
    public int textDecimalVirtualPoint() {
        return this.textDecimalVirtualPoint;
    }

    @Override
    public Vector<Evaluatable<Object>> runtimeDependencies() {
        return (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TextNumberFormatEv[]{this.textNumberFormatEv()}));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void parse(PState start) {
        Number number;
        DISimple node = start.simpleElement();
        String str = node.dataValueAsString();
        if (str == null) {
            throw Assert$.MODULE$.abort("Invariant broken: str.!=(null)");
        }
        String string = str;
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.PE(start, "Unable to parse %s from empty string", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{((NodeInfo.Kind)this.context().optPrimType().get()).globalQName()}));
            return;
        }
        Option option = this.zeroRepsRegex().find((Function1 & Serializable)_$3 -> _$3.findFirstIn((CharSequence)str).isDefined());
        if (option instanceof Some) {
            number = this.primNumeric.fromNumber(Predef$.MODULE$.int2Integer(0));
        } else {
            Number numValue;
            Number number2;
            Number number3;
            ParsePosition pos;
            DecimalFormat df;
            if (!None$.MODULE$.equals(option)) {
                throw new MatchError((Object)option);
            }
            String strToParse = (df = (DecimalFormat)this.textNumberFormatEv().evaluate(start)).isParseStrict() ? str : str.trim();
            Number number4 = df.parse(strToParse, pos = new ParsePosition(0));
            if (number4 == null) {
                Double infNaN;
                if (df.isDecimalPatternMatchRequired()) {
                    pos.setIndex(0);
                    DecimalFormat newDF = (DecimalFormat)df.clone();
                    newDF.setDecimalPatternMatchRequired(false);
                    Number number5 = newDF.parse(strToParse, pos);
                    if (number5 instanceof Double) {
                        Double d = (Double)number5;
                        if (!d.isNaN() && !d.isInfinite()) {
                            throw Assert$.MODULE$.abort("Invariant broken: d.isNaN().||(d.isInfinite())");
                        }
                        v2 = d;
                    } else {
                        v2 = null;
                    }
                } else {
                    v2 = infNaN = null;
                }
                if (infNaN == null) {
                    this.PE(start, "Unable to parse %s from text: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{((NodeInfo.Kind)this.context().optPrimType().get()).globalQName(), str}));
                    return;
                }
                number3 = infNaN;
            } else if (number4 instanceof Double) {
                Double d = (Double)number4;
                if (!d.isNaN() && !d.isInfinite() && Double.doubleToLongBits(Predef$.MODULE$.Double2double(d)) != Long.MIN_VALUE) {
                    throw Assert$.MODULE$.abort("Invariant broken: d.isNaN().||(d.isInfinite()).||(java.lang.Double.doubleToLongBits(scala.Predef.Double2double(d)).==(-9223372036854775808L))");
                }
                number3 = d;
            } else if (number4 instanceof BigDecimal) {
                boolean fractionalPartMustBeZero;
                BigDecimal bd = (BigDecimal)number4;
                boolean bl = fractionalPartMustBeZero = this.primNumeric.isInteger() || this.textDecimalVirtualPoint() > 0;
                if (bd.scale() == 0) {
                    number3 = bd.unscaledValue();
                } else {
                    if (fractionalPartMustBeZero) {
                        this.PE(start, "Unable to parse %s from text: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{((NodeInfo.Kind)this.context().optPrimType().get()).globalQName(), str}));
                        return;
                    }
                    number3 = bd.toBigDecimal();
                }
            } else if (number4 instanceof Long) {
                Long l = (Long)number4;
                number3 = l;
            } else {
                if (number4 != null) {
                    Number num = number4;
                    throw Assert$.MODULE$.invariantFailed("ICU returned an unexpected type. Expected either Double, ICU BigDecimal, or Long, but got " + num.getClass().getName());
                }
                throw new MatchError((Object)number4);
            }
            Number icuNum = number3;
            if (pos.getIndex() != strToParse.length()) {
                boolean isValid;
                if (df.getPadPosition() == 3) {
                    char padChar = df.getPadCharacter();
                    String afterPosition = str.substring(pos.getIndex());
                    v5 = StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(afterPosition), (Function1 & Serializable)_$4 -> ConvertTextStandardNumberParser.$anonfun$2(padChar, BoxesRunTime.unboxToChar((Object)_$4)));
                } else {
                    v5 = isValid = false;
                }
                if (!isValid) {
                    this.PE(start, "Unable to parse %s from text: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{((NodeInfo.Kind)this.context().optPrimType().get()).globalQName(), str}));
                    return;
                }
            }
            Number num = this.applyTextDecimalVirtualPointForParse(icuNum);
            try {
                number2 = this.primNumeric.fromNumber(num);
            }
            catch (InvalidPrimitiveDataException e) {
                this.PE(start, "%s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{e.getMessage()}));
                return;
            }
            number = numValue = number2;
        }
        Number numValue = number;
        node.overwriteDataValue(numValue);
    }

    public ConvertTextStandardNumberParser copy(TextNumberFormatEv textNumberFormatEv, List<Regex> zeroRepsRegex, ElementRuntimeData context, int textDecimalVirtualPoint) {
        return new ConvertTextStandardNumberParser(textNumberFormatEv, zeroRepsRegex, context, textDecimalVirtualPoint);
    }

    public TextNumberFormatEv copy$default$1() {
        return this.textNumberFormatEv();
    }

    public List<Regex> copy$default$2() {
        return this.zeroRepsRegex();
    }

    public ElementRuntimeData copy$default$3() {
        return this.context();
    }

    public int copy$default$4() {
        return this.textDecimalVirtualPoint();
    }

    public TextNumberFormatEv _1() {
        return this.textNumberFormatEv();
    }

    public List<Regex> _2() {
        return this.zeroRepsRegex();
    }

    public ElementRuntimeData _3() {
        return this.context();
    }

    public int _4() {
        return this.textDecimalVirtualPoint();
    }

    private static final /* synthetic */ boolean $anonfun$2(char padChar$1, char _$4) {
        return _$4 == padChar$1;
    }
}

