/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.debugger;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import org.apache.daffodil.api.Diagnostic;
import org.apache.daffodil.api.debugger.DaffodilDebuggerRunner;
import org.apache.daffodil.api.debugger.Debugger;
import org.apache.daffodil.api.infoset.InfosetElement;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.exceptions.UnsuppressableException;
import org.apache.daffodil.lib.oolag.ErrorsNotYetRecorded;
import org.apache.daffodil.lib.util.Misc$;
import org.apache.daffodil.lib.xml.GlobalQName;
import org.apache.daffodil.lib.xml.GlobalQName$;
import org.apache.daffodil.lib.xml.NS;
import org.apache.daffodil.lib.xml.NamedQName;
import org.apache.daffodil.lib.xml.QName$;
import org.apache.daffodil.lib.xml.RefQName;
import org.apache.daffodil.lib.xml.XMLUtils$;
import org.apache.daffodil.runtime1.debugger.DaffodilDebugger;
import org.apache.daffodil.runtime1.debugger.DaffodilDebugger$Breakpoint$;
import org.apache.daffodil.runtime1.debugger.DaffodilDebugger$DebugCommandBase$;
import org.apache.daffodil.runtime1.debugger.DaffodilDebugger$DebugException$;
import org.apache.daffodil.runtime1.debugger.DaffodilDebugger$DebugState$;
import org.apache.daffodil.runtime1.debugger.DaffodilDebugger$DebugState$Pause$;
import org.apache.daffodil.runtime1.debugger.DaffodilDebugger$DebugState$Trace$;
import org.apache.daffodil.runtime1.debugger.DaffodilDebugger$DebuggerConfig$;
import org.apache.daffodil.runtime1.debugger.DaffodilDebugger$Display$;
import org.apache.daffodil.runtime1.debugger.DebuggerHost;
import org.apache.daffodil.runtime1.dpath.ExpressionEvaluationException;
import org.apache.daffodil.runtime1.dpath.NodeInfo$;
import org.apache.daffodil.runtime1.dsom.CompiledExpression;
import org.apache.daffodil.runtime1.dsom.ExpressionCompilerClass;
import org.apache.daffodil.runtime1.dsom.RelativePathPastRootError;
import org.apache.daffodil.runtime1.dsom.RuntimeSchemaDefinitionError;
import org.apache.daffodil.runtime1.events.EventHandler;
import org.apache.daffodil.runtime1.infoset.DIElement;
import org.apache.daffodil.runtime1.infoset.InfosetException;
import org.apache.daffodil.runtime1.infoset.InfosetWalker;
import org.apache.daffodil.runtime1.infoset.InfosetWalker$;
import org.apache.daffodil.runtime1.infoset.XMLTextInfosetOutputter;
import org.apache.daffodil.runtime1.infoset.XMLTextInfosetOutputter$;
import org.apache.daffodil.runtime1.processors.ElementRuntimeData;
import org.apache.daffodil.runtime1.processors.ParseOrUnparseState;
import org.apache.daffodil.runtime1.processors.Processor;
import org.apache.daffodil.runtime1.processors.RuntimeData;
import org.apache.daffodil.runtime1.processors.StateForDebugger;
import org.apache.daffodil.runtime1.processors.Success$;
import org.apache.daffodil.runtime1.processors.VariableException;
import org.apache.daffodil.runtime1.processors.parsers.CombinatorParser;
import org.apache.daffodil.runtime1.processors.parsers.ComplexTypeParser;
import org.apache.daffodil.runtime1.processors.parsers.ConvertTextCombinatorParser;
import org.apache.daffodil.runtime1.processors.parsers.PState;
import org.apache.daffodil.runtime1.processors.parsers.Parser;
import org.apache.daffodil.runtime1.processors.parsers.RepeatingChildParser;
import org.apache.daffodil.runtime1.processors.parsers.SeqCompParser;
import org.apache.daffodil.runtime1.processors.unparsers.UState;
import org.apache.daffodil.runtime1.processors.unparsers.UStateForSuspension;
import org.apache.daffodil.runtime1.processors.unparsers.Unparser;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Try;
import scala.util.control.ControlThrowable;

public class DaffodilDebugger
implements EventHandler,
Debugger {
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(DaffodilDebugger.class.getDeclaredField("DebugCommandBase$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(DaffodilDebugger.class.getDeclaredField("DebuggerConfig$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DaffodilDebugger.class.getDeclaredField("DebugState$lzy1"));
    private final DaffodilDebuggerRunner runner;
    public final ExpressionCompilerClass org$apache$daffodil$runtime1$debugger$DaffodilDebugger$$eCompilers;
    private volatile Object DebugState$lzy1;
    public final DaffodilDebugger$DebugException$ DebugException$lzy1;
    public final DaffodilDebugger$Breakpoint$ Breakpoint$lzy1;
    public final DaffodilDebugger$Display$ Display$lzy1;
    private volatile Object DebuggerConfig$lzy1;
    private DebugState.Type debugState;
    private StateForDebugger previousProcessorState;
    public final GlobalQName org$apache$daffodil$runtime1$debugger$DaffodilDebugger$$debuggerQName;
    private volatile Object DebugCommandBase$lzy1;

    public DaffodilDebugger(DaffodilDebuggerRunner runner, ExpressionCompilerClass eCompilers) {
        this.runner = runner;
        this.org$apache$daffodil$runtime1$debugger$DaffodilDebugger$$eCompilers = eCompilers;
        this.DebugException$lzy1 = new DaffodilDebugger$DebugException$(this);
        this.Breakpoint$lzy1 = new DaffodilDebugger$Breakpoint$(this);
        this.Display$lzy1 = new DaffodilDebugger$Display$(this);
        this.debugState = this.DebugState().Pause();
        this.org$apache$daffodil$runtime1$debugger$DaffodilDebugger$$debuggerQName = GlobalQName$.MODULE$.apply((Option<String>)Some$.MODULE$.apply((Object)"daf"), "debugger", XMLUtils$.MODULE$.dafintURI());
        this.DebugCommandBase().checkNameConflicts();
    }

    public final DaffodilDebugger$DebugState$ DebugState() {
        Object object = this.DebugState$lzy1;
        if (object instanceof DaffodilDebugger$DebugState$) {
            return (DaffodilDebugger$DebugState$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (DaffodilDebugger$DebugState$)this.DebugState$lzyINIT1();
    }

    private Object DebugState$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.DebugState$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    DaffodilDebugger$DebugState$ daffodilDebugger$DebugState$ = null;
                    try {
                        daffodilDebugger$DebugState$ = new DaffodilDebugger$DebugState$();
                        object2 = daffodilDebugger$DebugState$ == null ? LazyVals.NullValue$.MODULE$ : daffodilDebugger$DebugState$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.DebugState$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return daffodilDebugger$DebugState$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public final DaffodilDebugger$DebugException$ DebugException() {
        return this.DebugException$lzy1;
    }

    public final DaffodilDebugger$Breakpoint$ Breakpoint() {
        return this.Breakpoint$lzy1;
    }

    public final DaffodilDebugger$Display$ Display() {
        return this.Display$lzy1;
    }

    public final DaffodilDebugger$DebuggerConfig$ DebuggerConfig() {
        Object object = this.DebuggerConfig$lzy1;
        if (object instanceof DaffodilDebugger$DebuggerConfig$) {
            return (DaffodilDebugger$DebuggerConfig$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (DaffodilDebugger$DebuggerConfig$)this.DebuggerConfig$lzyINIT1();
    }

    private Object DebuggerConfig$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.DebuggerConfig$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    DaffodilDebugger$DebuggerConfig$ daffodilDebugger$DebuggerConfig$ = null;
                    try {
                        daffodilDebugger$DebuggerConfig$ = new DaffodilDebugger$DebuggerConfig$();
                        object2 = daffodilDebugger$DebuggerConfig$ == null ? LazyVals.NullValue$.MODULE$ : daffodilDebugger$DebuggerConfig$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.DebuggerConfig$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return daffodilDebugger$DebuggerConfig$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public DebugState.Type debugState() {
        return this.debugState;
    }

    public void debugState_$eq(DebugState.Type x$1) {
        this.debugState = x$1;
    }

    public StateForDebugger previousProcessorState() {
        return this.previousProcessorState;
    }

    public void previousProcessorState_$eq(StateForDebugger x$1) {
        this.previousProcessorState = x$1;
    }

    @Override
    public void init(PState state, Parser parser) {
        this.runner.init(this);
        this.previousProcessorState_$eq(state.copyStateForDebugger());
    }

    @Override
    public void init(UState state, Unparser unparser) {
        this.runner.init(this);
        this.previousProcessorState_$eq(state.copyStateForDebugger());
    }

    @Override
    public void fini(Parser parser) {
        this.runner.fini();
    }

    @Override
    public void fini(Unparser unparser) {
        this.runner.fini();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void debugStep(ParseOrUnparseState state, Processor processor, boolean ignoreBreakpoints) {
        block17: {
            block16: {
                DebugState.Type type;
                if (state instanceof UStateForSuspension) {
                    return;
                }
                DebugState.Type type2 = this.debugState();
                if (state.processorStatus() != Success$.MODULE$ && this.DebuggerConfig().breakOnFailure()) {
                    type = this.DebugState().Pause();
                } else if ((this.DebugState().Continue().equals(type2) || this.DebugState().Trace().equals(type2)) && !ignoreBreakpoints) {
                    Option<Breakpoint> option = this.findBreakpoint(state, processor);
                    if (option instanceof Some) {
                        Breakpoint bp = (Breakpoint)((Some)option).value();
                        this.org$apache$daffodil$runtime1$debugger$DaffodilDebugger$$debugPrintln(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("breakpoint %s: %s   %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)bp.id()), bp.breakpoint(), bp.condition().getOrElse(DaffodilDebugger::debugStep$$anonfun$1)})), this.org$apache$daffodil$runtime1$debugger$DaffodilDebugger$$debugPrintln$default$2());
                        type = this.DebugState().Pause();
                    } else {
                        if (!None$.MODULE$.equals(option)) {
                            throw new MatchError(option);
                        }
                        type = this.debugState();
                    }
                } else {
                    type = this.DebugState().Step().equals(type2) ? this.DebugState().Pause() : this.debugState();
                }
                this.debugState_$eq(type);
                DebugState.Type type3 = this.debugState();
                DaffodilDebugger$DebugState$Pause$ daffodilDebugger$DebugState$Pause$ = this.DebugState().Pause();
                if (!(type3 == null ? daffodilDebugger$DebugState$Pause$ != null : !type3.equals(daffodilDebugger$DebugState$Pause$))) break block16;
                DebugState.Type type4 = this.debugState();
                DaffodilDebugger$DebugState$Trace$ daffodilDebugger$DebugState$Trace$ = this.DebugState().Trace();
                if (type4 != null ? !type4.equals(daffodilDebugger$DebugState$Trace$) : daffodilDebugger$DebugState$Trace$ != null) break block17;
            }
            DaffodilDebugger$DebuggerConfig$ dc = this.DebuggerConfig();
            ListBuffer<Display> rawDisplays = dc.displays();
            ListBuffer displays = (ListBuffer)rawDisplays.filter((Function1 & Serializable)_$40 -> _$40.enabled());
            displays.foreach((Function1 & Serializable)d -> this.runCommand(d.cmd(), state, processor));
            if (state.processorStatus() != Success$.MODULE$) {
                this.org$apache$daffodil$runtime1$debugger$DaffodilDebugger$$debugPrintln("failure:", this.org$apache$daffodil$runtime1$debugger$DaffodilDebugger$$debugPrintln$default$2());
                this.org$apache$daffodil$runtime1$debugger$DaffodilDebugger$$debugPrintln(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{((Diagnostic)state.diagnostics().head()).toString()})), "  ");
            }
            DebugState.Type type = this.debugState();
            DaffodilDebugger$DebugState$Trace$ daffodilDebugger$DebugState$Trace$ = this.DebugState().Trace();
            if (!(type != null ? !type.equals(daffodilDebugger$DebugState$Trace$) : daffodilDebugger$DebugState$Trace$ != null)) {
                this.org$apache$daffodil$runtime1$debugger$DaffodilDebugger$$debugPrintln("----------------------------------------------------------------- " + this.DebuggerConfig().parseStep(), this.org$apache$daffodil$runtime1$debugger$DaffodilDebugger$$debugPrintln$default$2());
            }
        }
        DaffodilDebugger$DebuggerConfig$ daffodilDebugger$DebuggerConfig$ = this.DebuggerConfig();
        daffodilDebugger$DebuggerConfig$.parseStep_$eq(daffodilDebugger$DebuggerConfig$.parseStep() + 1);
        while (true) {
            DebugState.Type type = this.debugState();
            DaffodilDebugger$DebugState$Pause$ daffodilDebugger$DebugState$Pause$ = this.DebugState().Pause();
            if (type != null ? !type.equals(daffodilDebugger$DebugState$Pause$) : daffodilDebugger$DebugState$Pause$ != null) break;
            Seq<String> args = this.readCmd();
            this.debugState_$eq(this.runCommand(args, state, processor));
        }
        this.previousProcessorState_$eq(state.copyStateForDebugger());
    }

    private boolean isInteresting(Parser parser) {
        Parser parser2 = parser;
        boolean interesting = parser2 instanceof ComplexTypeParser ? false : (parser2 instanceof SeqCompParser ? false : (parser2 instanceof RepeatingChildParser ? false : (parser2 instanceof ConvertTextCombinatorParser ? false : !(parser2 instanceof CombinatorParser))));
        return interesting;
    }

    @Override
    public void startElement(PState state, Parser parser) {
        this.debugStep(state, parser, false);
    }

    @Override
    public void endElement(UState state, Unparser unparser) {
        this.debugStep(state, unparser, false);
    }

    @Override
    public void before(PState before, Parser parser) {
    }

    @Override
    public void after(PState state, Parser parser) {
        if (this.isInteresting(parser)) {
            this.debugStep(state, parser, this.DebuggerConfig().breakOnlyOnCreation());
            return;
        }
    }

    @Override
    public void beforeRepetition(PState before, Parser processor) {
    }

    @Override
    public void afterRepetition(PState after, Parser processor) {
    }

    private boolean isInteresting(Unparser unparser) {
        return true;
    }

    @Override
    public void before(UState before, Unparser unparser) {
    }

    @Override
    public void after(UState state, Unparser unparser) {
        if (this.isInteresting(unparser)) {
            this.debugStep(state, unparser, this.DebuggerConfig().breakOnlyOnCreation());
            return;
        }
    }

    private Seq<String> readCmd() {
        String string;
        String input = this.runner.getCommand().trim();
        this.DebuggerConfig().history().$plus$eq((Object)input);
        String string2 = input;
        if ("".equals(string2)) {
            string = this.DebuggerConfig().lastCommand();
        } else {
            this.DebuggerConfig().lastCommand_$eq(input);
            string = input;
        }
        String cmd = string;
        Object object = Predef$.MODULE$.refArrayOps((Object[])cmd.split(" "));
        return ArraySeq$.MODULE$.unsafeWrapArray(ArrayOps$.MODULE$.filter$extension(object, (Function1 & Serializable)_$41 -> {
            String string = _$41;
            String string2 = "";
            return string == null ? string2 != null : !string.equals(string2);
        }));
    }

    /*
     * Loose catch block
     */
    private boolean evaluateBooleanExpression(String expression, ParseOrUnparseState state, Processor processor) {
        boolean bl;
        CompiledExpression<Boolean> compiledExpression;
        ElementRuntimeData context = state.getContext();
        try {
            DebuggerHost hostForDiags = new DebuggerHost(state.tunable());
            CompiledExpression<Boolean> ce = this.org$apache$daffodil$runtime1$debugger$DaffodilDebugger$$eCompilers.JBoolean().compileExpression(this.org$apache$daffodil$runtime1$debugger$DaffodilDebugger$$debuggerQName, NodeInfo$.MODULE$.Boolean(), expression, context.dpathCompileInfo().namespaces(), context.dpathCompileInfo().noPrefixNamespace(), context.dpathCompileInfo(), false, hostForDiags, context.dpathCompileInfo());
            Buffer warnings = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(hostForDiags.getDiagnostics()).asScala().filterNot((Function1 & Serializable)_$42 -> _$42.isError());
            warnings.foreach((Function1)(JProcedure1 & Serializable)_$43 -> this.org$apache$daffodil$runtime1$debugger$DaffodilDebugger$$debugPrintln(_$43, this.org$apache$daffodil$runtime1$debugger$DaffodilDebugger$$debugPrintln$default$2()));
            compiledExpression = ce;
        }
        catch (ErrorsNotYetRecorded errs) {
            this.org$apache$daffodil$runtime1$debugger$DaffodilDebugger$$debugPrintln(errs, this.org$apache$daffodil$runtime1$debugger$DaffodilDebugger$$debugPrintln$default$2());
            throw errs;
        }
        CompiledExpression<Boolean> compiledExpr = compiledExpression;
        try {
            bl = compiledExpr.evaluate(state);
        }
        catch (ControlThrowable s) {
            throw s;
        }
        catch (UnsuppressableException u) {
            throw u;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ExpressionEvaluationException || throwable2 instanceof InfosetException || throwable2 instanceof VariableException) {
                state.setSuccess();
                bl = false;
            }
            if (throwable2 instanceof RuntimeSchemaDefinitionError) {
                RuntimeSchemaDefinitionError e = (RuntimeSchemaDefinitionError)throwable2;
                state.suppressDiagnosticAndSucceed(e);
                bl = false;
            }
            throw throwable;
            {
                catch (ControlThrowable s) {
                    throw s;
                }
                catch (UnsuppressableException u) {
                    throw u;
                }
                catch (Throwable e2) {
                    this.org$apache$daffodil$runtime1$debugger$DaffodilDebugger$$debugPrintln("caught throwable " + e2.toString(), this.org$apache$daffodil$runtime1$debugger$DaffodilDebugger$$debugPrintln$default$2());
                    state.setSuccess();
                    bl = false;
                }
            }
        }
        return bl;
    }

    private Option<Breakpoint> findBreakpoint(ParseOrUnparseState state, Processor processor) {
        Option foundBreakpoint = ((IterableOnceOps)((StrictOptimizedIterableOps)this.DebuggerConfig().breakpoints().filter((Function1 & Serializable)_$44 -> _$44.enabled())).filter((Function1 & Serializable)bp -> {
            Try<RefQName> tryBPQName = QName$.MODULE$.refQNameFromExtendedSyntax(bp.breakpoint());
            if (tryBPQName.isFailure()) {
                String string = bp.breakpoint();
                String string2 = processor.context().path();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            RuntimeData runtimeData = processor.context();
            if (runtimeData instanceof ElementRuntimeData) {
                ElementRuntimeData erd = (ElementRuntimeData)runtimeData;
                NamedQName elemQName = erd.namedQName();
                RefQName bpqnx = (RefQName)tryBPQName.get();
                String string = bpqnx.local();
                String string3 = elemQName.local();
                if (!(string != null ? !string.equals(string3) : string3 != null)) {
                    NS nS = bpqnx.namespace();
                    NS nS2 = elemQName.namespace();
                    if (!(nS != null ? !((Object)nS).equals(nS2) : nS2 != null)) {
                        return true;
                    }
                }
                String bpQNameString = bpqnx.toQNameString();
                RefQName bpqn = processor.context().resolveQName(bpQNameString);
                boolean isMatch = bpqn.toStepQName().matches(elemQName);
                if (isMatch) {
                    return true;
                }
                String string4 = bpqnx.local();
                String string5 = elemQName.local();
                boolean isLocalMatch = !(string4 != null ? !string4.equals(string5) : string5 != null);
                return isLocalMatch;
            }
            return false;
        })).find((Function1 & Serializable)bp -> {
            Option<String> option = bp.condition();
            if (option instanceof Some) {
                String expression = (String)((Some)option).value();
                return this.evaluateBooleanExpression(expression, state, processor);
            }
            if (None$.MODULE$.equals(option)) {
                return true;
            }
            throw new MatchError(option);
        });
        return foundBreakpoint;
    }

    private DebugState.Type runCommand(Seq<String> cmd, ParseOrUnparseState state, Processor processor) {
        DebugState.Type type;
        try {
            type = this.DebugCommandBase().apply(cmd, state, processor);
        }
        catch (DebugException e) {
            this.org$apache$daffodil$runtime1$debugger$DaffodilDebugger$$debugPrintln(e, this.org$apache$daffodil$runtime1$debugger$DaffodilDebugger$$debugPrintln$default$2());
            type = this.DebugState().Pause();
        }
        return type;
    }

    public void org$apache$daffodil$runtime1$debugger$DaffodilDebugger$$debugPrintln(Object obj, String prefix) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])obj.toString().split("\n"));
        ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)line -> {
            String out = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s%s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{prefix, line}));
            this.runner.lineOutput(out);
        });
    }

    public Object org$apache$daffodil$runtime1$debugger$DaffodilDebugger$$debugPrintln$default$1() {
        return "";
    }

    public String org$apache$daffodil$runtime1$debugger$DaffodilDebugger$$debugPrintln$default$2() {
        return "";
    }

    public String org$apache$daffodil$runtime1$debugger$DaffodilDebugger$$infosetToString(InfosetElement ie) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLTextInfosetOutputter xml = new XMLTextInfosetOutputter(bos, true, XMLTextInfosetOutputter$.MODULE$.$lessinit$greater$default$3(), true);
        InfosetWalker iw = InfosetWalker$.MODULE$.apply((DIElement)ie, xml, !this.DebuggerConfig().removeHidden(), true, false, InfosetWalker$.MODULE$.apply$default$6(), InfosetWalker$.MODULE$.apply$default$7());
        iw.walk(true);
        return bos.toString("UTF-8");
    }

    public void org$apache$daffodil$runtime1$debugger$DaffodilDebugger$$debugPrettyPrintXML(InfosetElement ie) {
        String infosetString = this.org$apache$daffodil$runtime1$debugger$DaffodilDebugger$$infosetToString(ie);
        this.org$apache$daffodil$runtime1$debugger$DaffodilDebugger$$debugPrintln(infosetString, this.org$apache$daffodil$runtime1$debugger$DaffodilDebugger$$debugPrintln$default$2());
    }

    public final DaffodilDebugger$DebugCommandBase$ DebugCommandBase() {
        Object object = this.DebugCommandBase$lzy1;
        if (object instanceof DaffodilDebugger$DebugCommandBase$) {
            return (DaffodilDebugger$DebugCommandBase$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (DaffodilDebugger$DebugCommandBase$)this.DebugCommandBase$lzyINIT1();
    }

    private Object DebugCommandBase$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.DebugCommandBase$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    DaffodilDebugger$DebugCommandBase$ daffodilDebugger$DebugCommandBase$ = null;
                    try {
                        daffodilDebugger$DebugCommandBase$ = new DaffodilDebugger$DebugCommandBase$(this);
                        object2 = daffodilDebugger$DebugCommandBase$ == null ? LazyVals.NullValue$.MODULE$ : daffodilDebugger$DebugCommandBase$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.DebugCommandBase$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return daffodilDebugger$DebugCommandBase$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private static final String debugStep$$anonfun$1() {
        return "";
    }

    public static final List org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommand$$_$wrapLine$1(String line, int width) {
        if (line.length() == 0) {
            return package$.MODULE$.Nil();
        }
        int spaceIndex = line.lastIndexOf(" ", width);
        if (line.length() < width || spaceIndex == -1) {
            return (List)new .colon.colon((Object)line, (List)Nil$.MODULE$);
        }
        String string = StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(line), spaceIndex);
        List wrapped = DaffodilDebugger.org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommand$$_$wrapLine$1(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(line), spaceIndex + 1), width).$colon$colon((Object)string);
        return wrapped;
    }

    public static final /* synthetic */ boolean org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommand$$_$_$$anonfun$7(DebugCommand _$45) {
        return !_$45.hidden();
    }

    public static /* bridge */ /* synthetic */ int org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommand$$_$_$$anonfun$adapted$1(Object i, Object c) {
        return RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt((Object)i)), ((DebugCommand)c).name().length());
    }

    public static final String org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommand$$_$_$$anonfun$9() {
        return "";
    }

    public static final /* synthetic */ boolean org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommand$$_$help$$anonfun$2(String subcmd$1, DebugCommand _$46) {
        return _$46.matches(subcmd$1);
    }

    public static final /* synthetic */ IterableOnce org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommand$$_$_$$anonfun$10(DebugCommand cmd) {
        return (IterableOnce)((SeqOps)new .colon.colon((Object)cmd.name(), (List)new .colon.colon((Object)cmd.short(), (List)Nil$.MODULE$))).distinct();
    }

    public static final /* synthetic */ String org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommand$$_$_$$anonfun$11(String x) {
        return (String)Predef$.MODULE$.identity((Object)x);
    }

    public static final /* synthetic */ void org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommand$$_$checkNameConflicts$$anonfun$1(DebugCommand _$47) {
        _$47.checkNameConflicts();
    }

    public static final /* synthetic */ boolean org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandValidateSubcommands$$_$validate$$anonfun$1(String subcmd$2, DebugCommand _$48) {
        return _$48.matches(subcmd$2);
    }

    public static final /* synthetic */ boolean org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandBase$$$_$_$$anonfun$12(String subcmd$3, DebugCommand _$49) {
        return _$49.matches(subcmd$3);
    }

    public static final /* synthetic */ void org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandBase$Complete$$$_$act$$anonfun$1(Breakpoint _$50) {
        _$50.disable();
    }

    public static final /* synthetic */ void org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandBase$Complete$$$_$act$$anonfun$2(Display _$51) {
        _$51.disable();
    }

    public static final /* synthetic */ boolean org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandBase$Condition$$$_$validate$$anonfun$2(int id$1, Breakpoint _$52) {
        return _$52.id() == id$1;
    }

    public static final /* synthetic */ boolean org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandBase$Condition$$$_$_$$anonfun$13(int id$3, Breakpoint _$53) {
        return _$53.id() == id$3;
    }

    public static final /* synthetic */ boolean org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandBase$Delete$$$_$act$$anonfun$3(String subcmd$4, DebugCommand _$54) {
        return _$54.matches(subcmd$4);
    }

    public static final /* synthetic */ boolean org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandBase$Delete$DeleteBreakpoint$$$_$act$$anonfun$4(int id$4, Breakpoint _$55) {
        return _$55.id() == id$4;
    }

    public static final /* synthetic */ boolean org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandBase$Delete$DeleteDisplay$$$_$act$$anonfun$5(int id$5, Display d) {
        return d.id() == id$5;
    }

    public static final /* synthetic */ boolean org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandBase$Disable$$$_$act$$anonfun$6(String subcmd$5, DebugCommand _$56) {
        return _$56.matches(subcmd$5);
    }

    public static final /* synthetic */ boolean org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandBase$Disable$DisableBreakpoint$$$_$act$$anonfun$7(int id$6, Breakpoint _$57) {
        return _$57.id() == id$6;
    }

    public static final /* synthetic */ boolean org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandBase$Disable$DisableDisplay$$$_$act$$anonfun$8(int id$7, Display _$58) {
        return _$58.id() == id$7;
    }

    public static final /* synthetic */ boolean org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandBase$Enable$$$_$act$$anonfun$9(String subcmd$6, DebugCommand _$59) {
        return _$59.matches(subcmd$6);
    }

    public static final /* synthetic */ boolean org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandBase$Enable$EnableBreakpoint$$$_$act$$anonfun$10(int id$8, Breakpoint _$60) {
        return _$60.id() == id$8;
    }

    public static final /* synthetic */ boolean org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandBase$Enable$EnableDisplay$$$_$act$$anonfun$11(int id$9, Display _$61) {
        return _$61.id() == id$9;
    }

    public static final /* synthetic */ boolean org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandBase$Eval$$$_$_$$anonfun$14(Diagnostic _$62) {
        return _$62.isError();
    }

    public static final /* synthetic */ IterableOnce org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandBase$Eval$$$_$_$$anonfun$15(org.apache.daffodil.lib.iapi.Diagnostic d) {
        org.apache.daffodil.lib.iapi.Diagnostic diagnostic = d;
        if (diagnostic instanceof RelativePathPastRootError) {
            RelativePathPastRootError rel = (RelativePathPastRootError)diagnostic;
            return package$.MODULE$.Nil();
        }
        return (List)new .colon.colon((Object)d, (List)Nil$.MODULE$);
    }

    public static final /* synthetic */ void org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandBase$History$$$_$act$$anonfun$15(BufferedWriter bw$1, String cmd) {
        bw$1.write(cmd);
        bw$1.newLine();
    }

    public static final /* synthetic */ boolean org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandBase$Info$$$_$_$$anonfun$17(String arg$1, DebugCommand _$64) {
        return _$64.matches(arg$1);
    }

    public static final /* synthetic */ Seq org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandBase$Info$$$_$buildInfoCommands$$anonfun$1(Seq _$65) {
        return (Seq)_$65.reverse();
    }

    public static final /* synthetic */ boolean org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandBase$Info$$$_$validate$$anonfun$4$$anonfun$1(String cmd$1, DebugCommand _$66) {
        return _$66.matches(cmd$1);
    }

    public static final /* synthetic */ boolean org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandBase$Info$$$_$_$$anonfun$18(String cmd$2, DebugCommand _$67) {
        return _$67.matches(cmd$2);
    }

    public static final /* synthetic */ String org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandBase$Info$InfoSimpleValue$$_$_$$anonfun$19(Object _$68) {
        return _$68.toString();
    }

    public static final String org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandBase$Info$InfoSimpleValue$$_$_$$anonfun$20() {
        return "(no value)";
    }

    public static final /* synthetic */ String org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandBase$Info$InfoSimpleValue$$_$_$$anonfun$21(Object _$69) {
        return _$69.toString();
    }

    public static final String org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandBase$Info$InfoSimpleValue$$_$_$$anonfun$22() {
        return "(no value)";
    }

    public static final /* synthetic */ String org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandBase$Info$InfoSimpleValue$$_$_$$anonfun$23(Object _$70) {
        return _$70.toString();
    }

    public static final String org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandBase$Info$InfoSimpleValue$$_$_$$anonfun$24() {
        return "(no value)";
    }

    public static final String org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandBase$Info$InfoBreakpoints$$$_$act$$anonfun$18$$anonfun$1() {
        return "";
    }

    public static final /* synthetic */ String org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandBase$Info$InfoData$$$_$validate$$anonfun$5(String _$71) {
        return _$71.toLowerCase();
    }

    public static final /* synthetic */ boolean org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandBase$Info$InfoDiff$$$_$infoDiffables$lzyINIT1$$anonfun$1(DebugCommand _$72) {
        return _$72 instanceof DebugCommandBase.Info.InfoDiffable;
    }

    public static final /* synthetic */ DebugCommandBase.Info.InfoDiffable org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandBase$Info$InfoDiff$$$_$infoDiffables$lzyINIT1$$anonfun$2(DebugCommand _$73) {
        return (DebugCommandBase.Info.InfoDiffable)((Object)_$73);
    }

    public static final /* synthetic */ boolean org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandBase$Info$InfoDiff$$$_$_$$anonfun$26(DebugCommandBase.Info.InfoDiffable curCmd$1, String de) {
        return ((DebugCommand)((Object)curCmd$1)).matches(de);
    }

    public static final /* synthetic */ boolean org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandBase$Info$InfoVariables$$$_$_$$anonfun$27(Seq args$1, GlobalQName qname) {
        return args$1.contains((Object)qname.local()) || args$1.contains((Object)qname.toPrettyString());
    }

    public static final /* synthetic */ String org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandBase$Info$InfoVariables$$$_$act$$anonfun$22(GlobalQName _$74) {
        return _$74.toPrettyString();
    }

    public static final /* synthetic */ boolean org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandBase$Set$$$_$act$$anonfun$24(String subcmd$7, DebugCommand _$75) {
        return _$75.matches(subcmd$7);
    }

    public static final /* synthetic */ boolean org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandBase$Set$SetDiffExcludes$$$_$$anonfun$28$$anonfun$1(String arg$2, DebugCommandBase.Info.InfoDiffable _$76) {
        return ((DebugCommand)((Object)_$76)).matches(arg$2);
    }

    public class Breakpoint
    implements Disablable,
    Product,
    Serializable {
        private boolean enabled;
        private final int id;
        private final String breakpoint;
        private Option condition;
        private final /* synthetic */ DaffodilDebugger $outer;

        public Breakpoint(DaffodilDebugger $outer, int id, String breakpoint) {
            this.id = id;
            this.breakpoint = breakpoint;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Disablable.$init$(this);
            this.condition = None$.MODULE$;
        }

        @Override
        public boolean enabled() {
            return this.enabled;
        }

        @Override
        public void enabled_$eq(boolean x$1) {
            this.enabled = x$1;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.id());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.breakpoint()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Breakpoint)) return false;
            if (((Breakpoint)object).org$apache$daffodil$runtime1$debugger$DaffodilDebugger$Breakpoint$$$outer() != this.$outer) return false;
            Breakpoint breakpoint = (Breakpoint)object;
            if (this.id() != breakpoint.id()) return false;
            String string = this.breakpoint();
            String string2 = breakpoint.breakpoint();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!breakpoint.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Breakpoint;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Breakpoint";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return BoxesRunTime.boxToInteger((int)this._1());
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "id";
            }
            if (1 == n2) {
                return "breakpoint";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int id() {
            return this.id;
        }

        public String breakpoint() {
            return this.breakpoint;
        }

        public Option<String> condition() {
            return this.condition;
        }

        public void condition_$eq(Option<String> x$1) {
            this.condition = x$1;
        }

        public Breakpoint copy(int id, String breakpoint) {
            return new Breakpoint(this.$outer, id, breakpoint);
        }

        public int copy$default$1() {
            return this.id();
        }

        public String copy$default$2() {
            return this.breakpoint();
        }

        public int _1() {
            return this.id();
        }

        public String _2() {
            return this.breakpoint();
        }

        public final /* synthetic */ DaffodilDebugger org$apache$daffodil$runtime1$debugger$DaffodilDebugger$Breakpoint$$$outer() {
            return this.$outer;
        }

        @Override
        public final /* synthetic */ DaffodilDebugger org$apache$daffodil$runtime1$debugger$DaffodilDebugger$Disablable$$$outer() {
            return this.$outer;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public abstract class DebugCommand {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DebugCommand.class.getDeclaredField("short$lzy1"));
        private volatile Object short$lzy1;
        private final Seq subcommands;
        private final boolean hidden;

        public DebugCommand() {
            if (DaffodilDebugger.this == null) {
                throw new NullPointerException();
            }
            this.subcommands = (Seq)((SeqOps)Nil$.MODULE$);
            this.hidden = false;
        }

        public abstract String name();

        public String short() {
            Object object = this.short$lzy1;
            if (object instanceof String) {
                return (String)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (String)this.short$lzyINIT1();
        }

        private Object short$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.short$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        String string = null;
                        try {
                            string = BoxesRunTime.boxToCharacter((char)StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.name()), 0)).toString();
                            object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.short$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return string;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        public abstract String desc();

        public abstract String longDesc();

        public Seq<DebugCommand> subcommands() {
            return this.subcommands;
        }

        public boolean hidden() {
            return this.hidden;
        }

        public DebugState.Type apply(Seq<String> args, ParseOrUnparseState state, Processor processor) {
            this.validate(args);
            return this.act(args, state, processor);
        }

        public abstract void validate(Seq<String> var1);

        public abstract DebugState.Type act(Seq<String> var1, ParseOrUnparseState var2, Processor var3);

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean matches(String str) {
            String string = str;
            String string2 = this.name();
            if (string == null) {
                if (string2 == null) return true;
            } else if (string.equals(string2)) return true;
            String string3 = str;
            String string4 = this.short();
            if (string3 != null) {
                if (!string3.equals(string4)) return false;
                return true;
            }
            if (string4 == null) return true;
            return false;
        }

        public void help(Seq<String> args) {
            int n = args.length();
            if (0 == n) {
                Seq visibleSubcommands = (Seq)this.subcommands().filter(DaffodilDebugger::org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommand$$_$_$$anonfun$7);
                String string = this.name();
                String string2 = "";
                if (string == null ? string2 != null : !string.equals(string2)) {
                    DaffodilDebugger.this.org$apache$daffodil$runtime1$debugger$DaffodilDebugger$$debugPrintln(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.longDesc()})), DaffodilDebugger.this.org$apache$daffodil$runtime1$debugger$DaffodilDebugger$$debugPrintln$default$2());
                    if (!visibleSubcommands.isEmpty()) {
                        DaffodilDebugger.this.org$apache$daffodil$runtime1$debugger$DaffodilDebugger$$debugPrintln(DaffodilDebugger.this.org$apache$daffodil$runtime1$debugger$DaffodilDebugger$$debugPrintln$default$1(), DaffodilDebugger.this.org$apache$daffodil$runtime1$debugger$DaffodilDebugger$$debugPrintln$default$2());
                        DaffodilDebugger.this.org$apache$daffodil$runtime1$debugger$DaffodilDebugger$$debugPrintln("Subcommands:", DaffodilDebugger.this.org$apache$daffodil$runtime1$debugger$DaffodilDebugger$$debugPrintln$default$2());
                    }
                }
                int maxLen = BoxesRunTime.unboxToInt((Object)visibleSubcommands.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), DaffodilDebugger::org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommand$$_$_$$anonfun$adapted$1));
                String formatString = "  %-" + maxLen + "s  %s";
                visibleSubcommands.foreach((Function1)(JProcedure1 & Serializable)c -> {
                    int descColumnWidth = 75;
                    List descLines = DaffodilDebugger.org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommand$$_$wrapLine$1(c.desc(), descColumnWidth - maxLen);
                    String string = c.name();
                    List prefixes = ((List)package$.MODULE$.List().fill(descLines.length() - 1, DaffodilDebugger::org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommand$$_$_$$anonfun$9)).$colon$colon((Object)string);
                    ((List)prefixes.zip((IterableOnce)descLines)).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            String p = (String)tuple2._1();
                            String d = (String)tuple2._2();
                            DaffodilDebugger.this.org$apache$daffodil$runtime1$debugger$DaffodilDebugger$$debugPrintln(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(formatString), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{p, d})), DaffodilDebugger.this.org$apache$daffodil$runtime1$debugger$DaffodilDebugger$$debugPrintln$default$2());
                            return;
                        }
                        throw new MatchError((Object)tuple2);
                    });
                });
                return;
            }
            String subcmd = (String)args.head();
            Seq subcmdArgs = (Seq)args.tail();
            Option option = this.subcommands().find(arg_0 -> DaffodilDebugger.org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommand$$_$help$$anonfun$2(subcmd, arg_0));
            if (option instanceof Some) {
                DebugCommand cmd = (DebugCommand)((Some)option).value();
                cmd.help((Seq<String>)subcmdArgs);
                return;
            }
            if (None$.MODULE$.equals(option)) {
                throw new DebugException(DaffodilDebugger.this, StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("unknown command: %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{subcmd})));
            }
            throw new MatchError((Object)option);
        }

        public void checkNameConflicts() {
            Seq allNames = (Seq)this.subcommands().flatMap(DaffodilDebugger::org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommand$$_$_$$anonfun$10);
            Iterable duplicates = (Iterable)allNames.groupBy(DaffodilDebugger::org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommand$$_$_$$anonfun$11).collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Tuple2 x) {
                    Tuple2 tuple2 = x;
                    if (tuple2 != null) {
                        String elem = (String)tuple2._1();
                        Seq occurs = (Seq)tuple2._2();
                        if (occurs.size() > 1) {
                            return true;
                        }
                    }
                    return false;
                }

                public final Object applyOrElse(Tuple2 x, Function1 function1) {
                    Tuple2 tuple2 = x;
                    if (tuple2 != null) {
                        String elem = (String)tuple2._1();
                        Seq occurs = (Seq)tuple2._2();
                        if (occurs.size() > 1) {
                            return elem;
                        }
                    }
                    return function1.apply((Object)x);
                }
            });
            if (duplicates.size() != 0) {
                throw Assert$.MODULE$.abort("Invariant broken: " + ("Duplicate debug commands found in '" + this.name() + "' command: " + duplicates.mkString(", ")) + "(duplicates.size.==(0))");
            }
            this.subcommands().foreach((Function1)((JProcedure1 & Serializable)DaffodilDebugger::org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommand$$_$checkNameConflicts$$anonfun$1));
        }

        public final /* synthetic */ DaffodilDebugger org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommand$$$outer() {
            return DaffodilDebugger.this;
        }
    }

    public interface DebugCommandValidateBoolean {
        public static void validate$(DebugCommandValidateBoolean $this, Seq args) {
            $this.validate((Seq<String>)args);
        }

        default public void validate(Seq<String> args) {
            String state;
            if (args.size() != 1) {
                throw new DebugException(this.org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandValidateBoolean$$$outer(), StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s command requires a single argument"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{((DebugCommand)((Object)this)).name()})));
            }
            String string = state = (String)args.head();
            String string2 = "true";
            if (string == null ? string2 != null : !string.equals(string2)) {
                String string3 = state;
                String string4 = "1";
                if (string3 == null ? string4 != null : !string3.equals(string4)) {
                    String string5 = state;
                    String string6 = "false";
                    if (string5 == null ? string6 != null : !string5.equals(string6)) {
                        String string7 = state;
                        String string8 = "0";
                        if (string7 == null ? string8 != null : !string7.equals(string8)) {
                            throw new DebugException(this.org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandValidateBoolean$$$outer(), "argument must be true/false or 1/0");
                        }
                    }
                }
            }
        }

        public /* synthetic */ DaffodilDebugger org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandValidateBoolean$$$outer();
    }

    public interface DebugCommandValidateInt {
        public static void validate$(DebugCommandValidateInt $this, Seq args) {
            $this.validate((Seq<String>)args);
        }

        default public void validate(Seq<String> args) {
            if (args.size() != 1) {
                throw new DebugException(this.org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandValidateInt$$$outer(), StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s command requires a single argument"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{((DebugCommand)((Object)this)).name()})));
            }
            try {
                StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)args.head()));
            }
            catch (NumberFormatException numberFormatException) {
                throw new DebugException(this.org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandValidateInt$$$outer(), "integer argument is required");
            }
        }

        public /* synthetic */ DaffodilDebugger org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandValidateInt$$$outer();
    }

    public interface DebugCommandValidateOptionalArg {
        public static void validate$(DebugCommandValidateOptionalArg $this, Seq args) {
            $this.validate((Seq<String>)args);
        }

        default public void validate(Seq<String> args) {
            if (args.size() > 1) {
                throw new DebugException(this.org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandValidateOptionalArg$$$outer(), StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s command zero or one arguments"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{((DebugCommand)((Object)this)).name()})));
            }
        }

        public /* synthetic */ DaffodilDebugger org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandValidateOptionalArg$$$outer();
    }

    public interface DebugCommandValidateSingleArg {
        public static void validate$(DebugCommandValidateSingleArg $this, Seq args) {
            $this.validate((Seq<String>)args);
        }

        default public void validate(Seq<String> args) {
            if (args.length() != 1) {
                throw new DebugException(this.org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandValidateSingleArg$$$outer(), StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s command requires a single argument"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{((DebugCommand)((Object)this)).name()})));
            }
        }

        public /* synthetic */ DaffodilDebugger org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandValidateSingleArg$$$outer();
    }

    public interface DebugCommandValidateSubcommands {
        public static void validate$(DebugCommandValidateSubcommands $this, Seq args) {
            $this.validate((Seq<String>)args);
        }

        default public void validate(Seq<String> args) {
            if (args.size() == 0) {
                throw new DebugException(this.org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandValidateSubcommands$$$outer(), "no command specified");
            }
            String subcmd = (String)args.head();
            Seq subcmdArgs = (Seq)args.tail();
            Option option = ((DebugCommand)((Object)this)).subcommands().find(arg_0 -> DaffodilDebugger.org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandValidateSubcommands$$_$validate$$anonfun$1(subcmd, arg_0));
            if (option instanceof Some) {
                DebugCommand c = (DebugCommand)((Some)option).value();
                c.validate((Seq<String>)subcmdArgs);
                return;
            }
            if (None$.MODULE$.equals(option)) {
                throw new DebugException(this.org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandValidateSubcommands$$$outer(), StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("undefined command: %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{subcmd})));
            }
            throw new MatchError((Object)option);
        }

        public /* synthetic */ DaffodilDebugger org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandValidateSubcommands$$$outer();
    }

    public interface DebugCommandValidateZeroArgs {
        public static void validate$(DebugCommandValidateZeroArgs $this, Seq args) {
            $this.validate((Seq<String>)args);
        }

        default public void validate(Seq<String> args) {
            if (args.length() != 0) {
                throw new DebugException(this.org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandValidateZeroArgs$$$outer(), StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s command requires zero arguments"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{((DebugCommand)((Object)this)).name()})));
            }
        }

        public /* synthetic */ DaffodilDebugger org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugCommandValidateZeroArgs$$$outer();
    }

    public class DebugException
    extends Exception
    implements Product {
        private final String str;
        private final Throwable cause;
        private final /* synthetic */ DaffodilDebugger $outer;

        public DebugException(DaffodilDebugger $outer, String str, Throwable cause) {
            this.str = str;
            this.cause = cause;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super(str, cause);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DebugException)) return false;
            if (((DebugException)object).org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugException$$$outer() != this.$outer) return false;
            DebugException debugException = (DebugException)object;
            String string = this.str();
            String string2 = debugException.str();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Throwable throwable = this.cause();
            Throwable throwable2 = debugException.cause();
            if (throwable == null) {
                if (throwable2 != null) {
                    return false;
                }
            } else if (!throwable.equals(throwable2)) return false;
            if (!debugException.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof DebugException;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "DebugException";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "str";
            }
            if (1 == n2) {
                return "cause";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String str() {
            return this.str;
        }

        public Throwable cause() {
            return this.cause;
        }

        @Override
        public String toString() {
            return "Debugger error: " + Misc$.MODULE$.getSomeMessage(this).get();
        }

        public DebugException(DaffodilDebugger $outer, String str) {
            this($outer, str, null);
        }

        public DebugException copy(String str, Throwable cause) {
            return new DebugException(this.$outer, str, cause);
        }

        public String copy$default$1() {
            return this.str();
        }

        public Throwable copy$default$2() {
            return this.cause();
        }

        public String _1() {
            return this.str();
        }

        public Throwable _2() {
            return this.cause();
        }

        public final /* synthetic */ DaffodilDebugger org$apache$daffodil$runtime1$debugger$DaffodilDebugger$DebugException$$$outer() {
            return this.$outer;
        }
    }

    public interface Disablable {
        public static void $init$(Disablable $this) {
            $this.enabled_$eq(true);
        }

        public boolean enabled();

        public void enabled_$eq(boolean var1);

        public static void disable$(Disablable $this) {
            $this.disable();
        }

        default public void disable() {
            this.enabled_$eq(false);
        }

        public static void enable$(Disablable $this) {
            $this.enable();
        }

        default public void enable() {
            this.enabled_$eq(true);
        }

        public /* synthetic */ DaffodilDebugger org$apache$daffodil$runtime1$debugger$DaffodilDebugger$Disablable$$$outer();
    }

    public class Display
    implements Disablable,
    Product,
    Serializable {
        private boolean enabled;
        private final int id;
        private final Seq cmd;
        private final /* synthetic */ DaffodilDebugger $outer;

        public Display(DaffodilDebugger $outer, int id, Seq<String> cmd) {
            this.id = id;
            this.cmd = cmd;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Disablable.$init$(this);
        }

        @Override
        public boolean enabled() {
            return this.enabled;
        }

        @Override
        public void enabled_$eq(boolean x$1) {
            this.enabled = x$1;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.id());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.cmd()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Display)) return false;
            if (((Display)object).org$apache$daffodil$runtime1$debugger$DaffodilDebugger$Display$$$outer() != this.$outer) return false;
            Display display = (Display)object;
            if (this.id() != display.id()) return false;
            Seq<String> seq = this.cmd();
            Seq<String> seq2 = display.cmd();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!display.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Display;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Display";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return BoxesRunTime.boxToInteger((int)this._1());
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "id";
            }
            if (1 == n2) {
                return "cmd";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int id() {
            return this.id;
        }

        public Seq<String> cmd() {
            return this.cmd;
        }

        public Display copy(int id, Seq<String> cmd) {
            return new Display(this.$outer, id, cmd);
        }

        public int copy$default$1() {
            return this.id();
        }

        public Seq<String> copy$default$2() {
            return this.cmd();
        }

        public int _1() {
            return this.id();
        }

        public Seq<String> _2() {
            return this.cmd();
        }

        public final /* synthetic */ DaffodilDebugger org$apache$daffodil$runtime1$debugger$DaffodilDebugger$Display$$$outer() {
            return this.$outer;
        }

        @Override
        public final /* synthetic */ DaffodilDebugger org$apache$daffodil$runtime1$debugger$DaffodilDebugger$Disablable$$$outer() {
            return this.$outer;
        }
    }
}

