/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.lib.iapi;

import java.io.Serializable;
import java.util.List;
import org.apache.daffodil.api.DataLocation;
import org.apache.daffodil.api.LocationInSchemaFile;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.exceptions.SchemaFileLocation;
import org.apache.daffodil.lib.util.Maybe;
import org.apache.daffodil.lib.util.Maybe$;
import org.apache.daffodil.lib.util.Misc$;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public abstract class Diagnostic
extends org.apache.daffodil.api.Diagnostic {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Diagnostic.class.getDeclaredField("message$lzy1"));
    private final Object schemaContext;
    private final Object dataContext;
    private final Object maybeCause;
    private final Object maybeFormatString;
    private final Seq args;
    private volatile Object message$lzy1;

    public Diagnostic(boolean isThick, Object schemaContext, Object dataContext, Object maybeCause, Object maybeFormatString, Seq<Object> args) {
        this.schemaContext = schemaContext;
        this.dataContext = dataContext;
        this.maybeCause = maybeCause;
        this.maybeFormatString = maybeFormatString;
        this.args = args;
        super((String)Maybe$.MODULE$.orNull$extension(maybeFormatString), (Throwable)Maybe$.MODULE$.orNull$extension(maybeCause), isThick, isThick);
    }

    private Object schemaContext() {
        return this.schemaContext;
    }

    private Object dataContext() {
        return this.dataContext;
    }

    private Object maybeCause() {
        return this.maybeCause;
    }

    private Object maybeFormatString() {
        return this.maybeFormatString;
    }

    private Seq<Object> args() {
        return this.args;
    }

    public Diagnostic(Object schemaContext, Object dataContext, Object maybeCause, Object maybeFormatString, Seq<Object> args) {
        this(true, schemaContext, dataContext, maybeCause, maybeFormatString, args);
    }

    public final Nothing$ toss() {
        throw this;
    }

    @Override
    public boolean isValidation() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object b) {
        Object object = b;
        if (!(object instanceof Diagnostic)) return false;
        Diagnostic other = (Diagnostic)object;
        if (this == other) return true;
        if (!BoxesRunTime.equals((Object)this.schemaContext(), (Object)other.schemaContext())) return false;
        if (!BoxesRunTime.equals((Object)this.dataContext(), (Object)other.dataContext())) return false;
        if (!BoxesRunTime.equals((Object)this.maybeCause(), (Object)other.maybeCause())) return false;
        if (!BoxesRunTime.equals((Object)this.maybeFormatString(), (Object)other.maybeFormatString())) return false;
        Seq<Object> seq = this.args();
        Seq<Object> seq2 = other.args();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (this.isError() != other.isError()) return false;
        String string = this.modeName();
        String string2 = other.modeName();
        if (string == null) {
            if (string2 == null) return true;
            return false;
        } else {
            if (!string.equals(string2)) return false;
            return true;
        }
    }

    public int hashCode() {
        return new Maybe(this.schemaContext()).hashCode() + new Maybe(this.dataContext()).hashCode() + new Maybe(this.maybeCause()).hashCode() + new Maybe(this.maybeFormatString()).hashCode() + this.args().hashCode() + BoxesRunTime.boxToBoolean((boolean)this.isError()).hashCode() + this.modeName().hashCode();
    }

    @Override
    public String getMessage() {
        return this.message();
    }

    @Override
    public String toString() {
        return this.getModeName() + ": " + this.getMessage() + this.schemaContextString() + this.dataLocationString();
    }

    @Override
    public abstract boolean isError();

    public abstract String modeName();

    @Override
    public String getModeName() {
        String errorOrWarning = this.isError() ? "Error" : "Warning";
        return this.modeName() + " " + errorOrWarning;
    }

    @Override
    public List<DataLocation> getDataLocations() {
        return CollectionConverters$.MODULE$.SeqHasAsJava(Maybe$.MODULE$.toSeq$extension(this.dataContext())).asJava();
    }

    @Override
    public List<? extends LocationInSchemaFile> getLocationsInSchemaFiles() {
        return CollectionConverters$.MODULE$.SeqHasAsJava(Maybe$.MODULE$.toSeq$extension(this.schemaContext())).asJava();
    }

    private String schemaLocationsString() {
        Buffer strings = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(this.getLocationsInSchemaFiles()).asScala().map((Function1 & Serializable)_$3 -> _$3.locationDescription());
        String res = strings.nonEmpty() ? " " + strings.mkString(", ") : " (no schema file location)";
        return res;
    }

    public String schemaContextString() {
        if (Maybe$.MODULE$.isEmpty$extension(this.schemaContext())) {
            return "";
        }
        String ddn = ((SchemaFileLocation)Maybe$.MODULE$.get$extension(this.schemaContext())).diagnosticDebugName();
        Object pn = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(ddn)) ? " " + ddn : "";
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\nSchema context:%s%s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{pn, this.schemaLocationsString()}));
    }

    private String dataLocationString() {
        if (Maybe$.MODULE$.isEmpty$extension(this.dataContext())) {
            return "";
        }
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\nData location was preceding %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{(DataLocation)Maybe$.MODULE$.value$extension(this.dataContext())}));
    }

    private String message() {
        Object object = this.message$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.message$lzyINIT1();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object message$lzyINIT1() {
        while (true) {
            Object object;
            if ((object = this.message$lzy1) == null) {
                void var2_5;
                if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                Object var2_2 = null;
                Object object2 = null;
                try {
                    if (this.getCause() != null) {
                        Throwable throwable = this.getCause();
                        if (throwable instanceof Diagnostic) {
                            Diagnostic d = (Diagnostic)throwable;
                            v0 = d.getModeName() + ": " + d.getMessage();
                        } else {
                            Throwable th = throwable;
                            v0 = (String)Misc$.MODULE$.getSomeMessage(th).get();
                        }
                    } else {
                        String string;
                        if (!Maybe$.MODULE$.isDefined$extension(this.maybeFormatString())) {
                            throw Assert$.MODULE$.abort("Invariant broken: Diagnostic.this.maybeFormatString.isDefined");
                        }
                        if (this.args().size() > 0) {
                            try {
                                string = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString((String)Maybe$.MODULE$.get$extension(this.maybeFormatString())), this.args());
                            }
                            catch (IllegalArgumentException e) {
                                throw Assert$.MODULE$.abort(e.getMessage() + StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\\nFormat string \"%s\" did not accept these arguments: %s."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{(String)Maybe$.MODULE$.get$extension(this.maybeFormatString()), this.args().mkString(", ")})));
                            }
                        } else {
                            string = (String)Maybe$.MODULE$.get$extension(this.maybeFormatString());
                        }
                        String m = string;
                        v0 = object2 = m;
                    }
                    if (object2 == null) {
                        LazyVals.NullValue$ nullValue$ = LazyVals.NullValue$.MODULE$;
                    } else {
                        Object object3 = object2;
                    }
                }
                catch (Throwable throwable) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, var2_2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.message$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, var2_2);
                        waiting.countDown();
                    }
                    throw throwable;
                }
                if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, (Object)var2_5)) {
                    LazyVals.Waiting waiting = (LazyVals.Waiting)this.message$lzy1;
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, (Object)var2_5);
                    waiting.countDown();
                }
                return object2;
            }
            if (!(object instanceof LazyVals.LazyValControlState)) {
                return object;
            }
            if (object == LazyVals.Evaluating$.MODULE$) {
                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                continue;
            }
            if (!(object instanceof LazyVals.Waiting)) {
                return null;
            }
            ((LazyVals.Waiting)object).await();
        }
    }
}

