/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.io.IOException;
import java.io.StringWriter;
import java.text.Normalizer;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ReceiverWithOutputProperties;
import net.sf.saxon.event.SequenceWriter;
import net.sf.saxon.functions.FormatNumber;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.regex.ARegularExpression;
import net.sf.saxon.serialize.CharacterMap;
import net.sf.saxon.serialize.CharacterMapIndex;
import net.sf.saxon.serialize.SerializationProperties;
import net.sf.saxon.str.BMPString;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.str.UnicodeWriter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.QualifiedNameValue;

public class AdaptiveEmitter
extends SequenceWriter
implements ReceiverWithOutputProperties {
    private final UnicodeWriter writer;
    private CharacterMap characterMap;
    private Properties outputProperties;
    private String itemSeparator = "\n";
    private boolean started = false;
    private boolean mustClose = true;
    static ARegularExpression QUOTES = ARegularExpression.compile("\"", "");

    public AdaptiveEmitter(PipelineConfiguration pipe, UnicodeWriter writer) {
        super(pipe);
        this.writer = writer;
    }

    public void setOutputProperties(Properties props) {
        this.outputProperties = props;
        String sep = props.getProperty("item-separator");
        if (sep != null && !"#absent".equals(sep)) {
            this.itemSeparator = sep;
        }
    }

    public void setNormalizationForm(Normalizer.Form normalizationForm) {
    }

    public void setMustClose(boolean mustClose) {
        this.mustClose = mustClose;
    }

    public void setCharacterMap(CharacterMap map) {
        this.characterMap = map;
    }

    @Override
    public Properties getOutputProperties() {
        return this.outputProperties;
    }

    private void emit(String s) throws XPathException {
        try {
            this.writer.write(s);
        }
        catch (IOException e) {
            throw new XPathException(e);
        }
    }

    private void emit(UnicodeString s) throws XPathException {
        try {
            this.writer.write(s);
        }
        catch (IOException e) {
            throw new XPathException(e);
        }
    }

    @Override
    public void write(Item item) throws XPathException {
        if (this.started) {
            this.emit(this.itemSeparator);
        } else {
            this.started = true;
        }
        this.serializeItem(item);
    }

    private void serializeItem(Item item) throws XPathException {
        if (item instanceof AtomicValue) {
            this.emit(this.serializeAtomicValue((AtomicValue)item));
        } else if (item instanceof NodeInfo) {
            this.serializeNode((NodeInfo)item);
        } else if (item instanceof MapItem) {
            this.serializeMap((MapItem)item);
        } else if (item instanceof ArrayItem) {
            this.serializeArray((ArrayItem)item);
        } else if (item instanceof FunctionItem) {
            this.serializeFunction((FunctionItem)item);
        }
    }

    private String serializeAtomicValue(AtomicValue value) throws XPathException {
        switch (value.getPrimitiveType().getFingerprint()) {
            case 513: 
            case 529: 
            case 631: {
                UnicodeString s = value.getUnicodeStringValue();
                s = QUOTES.replace(s, BMPString.of("\"\""));
                if (this.characterMap != null) {
                    s = this.characterMap.map(s, false);
                }
                return "\"" + s.toString() + "\"";
            }
            case 514: {
                return value.effectiveBooleanValue() ? "true()" : "false()";
            }
            case 515: 
            case 533: {
                return value.getStringValue();
            }
            case 517: {
                return FormatNumber.formatExponential((DoubleValue)value);
            }
            case 516: 
            case 518: 
            case 519: 
            case 520: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: 
            case 527: 
            case 528: {
                return value.getPrimitiveType().getDisplayName() + "(\"" + value.getUnicodeStringValue() + "\")";
            }
            case 633: 
            case 634: {
                return "xs:duration(\"" + value.getUnicodeStringValue() + "\")";
            }
            case 530: 
            case 531: {
                return ((QualifiedNameValue)value).getStructuredQName().getEQName();
            }
        }
        return "***";
    }

    private void serializeFunction(FunctionItem fn) throws XPathException {
        StructuredQName fname = fn.getFunctionName();
        if (fname == null || fname.hasURI(NamespaceUri.ANONYMOUS)) {
            this.emit("(anonymous-function)");
        } else if (fname.hasURI(NamespaceUri.FN)) {
            this.emit("fn:" + fname.getLocalPart());
        } else if (fname.hasURI(NamespaceUri.MATH)) {
            this.emit("math:" + fname.getLocalPart());
        } else if (fname.hasURI(NamespaceUri.MAP_FUNCTIONS)) {
            this.emit("map:" + fname.getLocalPart());
        } else if (fname.hasURI(NamespaceUri.ARRAY_FUNCTIONS)) {
            this.emit("array:" + fname.getLocalPart());
        } else if (fname.hasURI(NamespaceUri.SCHEMA)) {
            this.emit("xs:" + fname.getLocalPart());
        } else {
            this.emit(fname.getEQName());
        }
        this.emit("#" + fn.getArity());
    }

    private void serializeNode(NodeInfo node) throws XPathException {
        switch (node.getNodeKind()) {
            case 2: {
                this.emit(node.getDisplayName());
                this.emit("=\"");
                this.emit(this.escapeAttributeValue(node.getStringValue()));
                this.emit("\"");
                break;
            }
            case 13: {
                this.emit(node.getLocalPart().isEmpty() ? "xmlns" : "xmlns:" + node.getLocalPart());
                this.emit("=\"");
                this.emit(this.escapeAttributeValue(node.getStringValue()));
                this.emit("\"");
                break;
            }
            default: {
                StringWriter sw = new StringWriter();
                Properties props = new Properties(this.outputProperties);
                props.setProperty("method", "xml");
                if (props.getProperty("omit-xml-declaration") == null) {
                    props.setProperty("omit-xml-declaration", "no");
                }
                props.setProperty("{http://saxon.sf.net/}unfailing", "yes");
                CharacterMapIndex cmi = null;
                if (this.characterMap != null) {
                    cmi = new CharacterMapIndex();
                    cmi.putCharacterMap(this.characterMap.getName(), this.characterMap);
                }
                SerializationProperties sProps = new SerializationProperties(props, cmi);
                QueryResult.serialize(node, (Result)new StreamResult(sw), sProps);
                this.emit(sw.toString());
            }
        }
    }

    private String escapeAttributeValue(String value) {
        StringBuilder sb = new StringBuilder(value.length() * 2);
        block9: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\r': {
                    sb.append("&#xD;");
                    continue block9;
                }
                case '\t': {
                    sb.append("&#x9;");
                    continue block9;
                }
                case '\n': {
                    sb.append("&#xA;");
                    continue block9;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block9;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block9;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block9;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block9;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private void serializeArray(ArrayItem array) throws XPathException {
        this.emit("[");
        boolean first = true;
        for (Sequence sequence : array.members()) {
            if (first) {
                first = false;
            } else {
                this.emit(",");
            }
            this.outputInternalSequence(sequence);
        }
        this.emit("]");
    }

    private void serializeMap(MapItem map) throws XPathException {
        this.emit("map{");
        boolean first = true;
        for (KeyValuePair pair : map.keyValuePairs()) {
            if (first) {
                first = false;
            } else {
                this.emit(",");
            }
            this.serializeItem(pair.key);
            this.emit(":");
            GroundedValue value = pair.value;
            this.outputInternalSequence(value);
        }
        this.emit("}");
    }

    private void outputInternalSequence(Sequence value) throws XPathException {
        Item it;
        boolean omitParens;
        boolean first = true;
        SequenceIterator iter = value.iterate();
        boolean bl = omitParens = value instanceof GroundedValue && ((GroundedValue)value).getLength() == 1;
        if (!omitParens) {
            this.emit("(");
        }
        while ((it = iter.next()) != null) {
            if (!first) {
                this.emit(",");
            }
            first = false;
            this.serializeItem(it);
        }
        if (!omitParens) {
            this.emit(")");
        }
    }

    @Override
    public void close() throws XPathException {
        super.close();
        if (this.writer != null) {
            try {
                if (this.mustClose) {
                    this.writer.close();
                } else {
                    this.writer.flush();
                }
            }
            catch (IOException e) {
                throw new XPathException(e);
            }
        }
    }
}

