/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.InputSource;
import org.xmlresolver.ResolverConfiguration;
import org.xmlresolver.ResolverFeature;
import org.xmlresolver.XMLCatalogResolver;
import org.xmlresolver.catalog.entry.EntryCatalog;
import org.xmlresolver.catalog.query.QueryDoctype;
import org.xmlresolver.catalog.query.QueryDocument;
import org.xmlresolver.catalog.query.QueryEntity;
import org.xmlresolver.catalog.query.QueryNotation;
import org.xmlresolver.catalog.query.QueryPublic;
import org.xmlresolver.catalog.query.QuerySystem;
import org.xmlresolver.catalog.query.QueryUri;
import org.xmlresolver.loaders.CatalogLoader;
import org.xmlresolver.logging.ResolverLogger;
import org.xmlresolver.utils.PublicId;
import org.xmlresolver.utils.SaxProducer;
import org.xmlresolver.utils.URIUtils;

public class CatalogManager
implements XMLCatalogResolver {
    protected final ResolverLogger logger;
    protected final ResolverConfiguration resolverConfiguration;
    protected CatalogLoader catalogLoader;

    protected CatalogManager(ResolverConfiguration config) {
        this.resolverConfiguration = config;
        String loaderClassName = config.getFeature(ResolverFeature.CATALOG_LOADER_CLASS);
        if (loaderClassName == null || "".equals(loaderClassName)) {
            loaderClassName = ResolverFeature.CATALOG_LOADER_CLASS.getDefaultValue();
        }
        try {
            Class<?> loaderClass = Class.forName(loaderClassName);
            Constructor<?> constructor = loaderClass.getConstructor(ResolverConfiguration.class);
            this.catalogLoader = (CatalogLoader)constructor.newInstance(config);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new IllegalArgumentException("Failed to instantiate catalog loader: " + loaderClassName + ": " + ex.getMessage());
        }
        this.catalogLoader.setPreferPublic(config.getFeature(ResolverFeature.PREFER_PUBLIC));
        this.catalogLoader.setArchivedCatalogs(config.getFeature(ResolverFeature.ARCHIVED_CATALOGS));
        this.logger = this.resolverConfiguration.getFeature(ResolverFeature.RESOLVER_LOGGER);
    }

    protected CatalogManager(CatalogManager current, ResolverConfiguration newConfig) {
        this.catalogLoader = current.catalogLoader;
        this.resolverConfiguration = newConfig;
        this.logger = this.resolverConfiguration.getFeature(ResolverFeature.RESOLVER_LOGGER);
    }

    public ResolverConfiguration getResolverConfiguration() {
        return this.resolverConfiguration;
    }

    public CatalogLoader getCatalogLoader() {
        return this.catalogLoader;
    }

    public void setCatalogLoader(CatalogLoader loader) {
        this.catalogLoader = loader;
    }

    public List<URI> catalogs() {
        ArrayList<URI> catlist = new ArrayList<URI>();
        for (String cat : this.resolverConfiguration.getFeature(ResolverFeature.CATALOG_FILES)) {
            cat = URIUtils.normalizeURI(cat);
            catlist.add(URIUtils.cwd().resolve(cat));
        }
        return catlist;
    }

    public EntryCatalog loadCatalog(URI catalog) {
        return this.catalogLoader.loadCatalog(catalog);
    }

    public EntryCatalog loadCatalog(URI catalog, InputSource source) {
        return this.catalogLoader.loadCatalog(catalog, source);
    }

    public EntryCatalog loadCatalog(URI catalog, SaxProducer producer) {
        return this.catalogLoader.loadCatalog(catalog, producer);
    }

    @Override
    public URI lookupURI(String uri) {
        return this.lookupNamespaceURI(uri, null, null);
    }

    public URI lookupNamespaceURI(String uri, String nature, String purpose) {
        return new QueryUri(uri, nature, purpose).search(this).uri();
    }

    private String fixWindowsSystemIdentifier(String systemId) {
        if (systemId != null && this.resolverConfiguration.getFeature(ResolverFeature.FIX_WINDOWS_SYSTEM_IDENTIFIERS).booleanValue()) {
            systemId = systemId.replace("\\", "/");
        }
        return systemId;
    }

    @Override
    public URI lookupPublic(String systemId, String publicId) {
        systemId = this.fixWindowsSystemIdentifier(systemId);
        ExternalIdentifiers external = this.normalizeExternalIdentifiers(systemId, publicId);
        return new QueryPublic(external.systemId, external.publicId).search(this).uri();
    }

    @Override
    public URI lookupSystem(String systemId) {
        ExternalIdentifiers external = this.normalizeExternalIdentifiers(systemId = this.fixWindowsSystemIdentifier(systemId), null);
        if (external.systemId == null) {
            return null;
        }
        return new QuerySystem(systemId).search(this).uri();
    }

    @Override
    public URI lookupDoctype(String entityName, String systemId, String publicId) {
        systemId = this.fixWindowsSystemIdentifier(systemId);
        ExternalIdentifiers external = this.normalizeExternalIdentifiers(systemId, publicId);
        return new QueryDoctype(entityName, external.systemId, external.publicId).search(this).uri();
    }

    @Override
    public URI lookupDocument() {
        return new QueryDocument().search(this).uri();
    }

    @Override
    public URI lookupEntity(String entityName, String systemId, String publicId) {
        systemId = this.fixWindowsSystemIdentifier(systemId);
        ExternalIdentifiers external = this.normalizeExternalIdentifiers(systemId, publicId);
        return new QueryEntity(entityName, external.systemId, external.publicId).search(this).uri();
    }

    @Override
    public URI lookupNotation(String notationName, String systemId, String publicId) {
        systemId = this.fixWindowsSystemIdentifier(systemId);
        ExternalIdentifiers external = this.normalizeExternalIdentifiers(systemId, publicId);
        return new QueryNotation(notationName, external.systemId, external.publicId).search(this).uri();
    }

    private ExternalIdentifiers normalizeExternalIdentifiers(String systemId, String publicId) {
        if (systemId != null) {
            systemId = URIUtils.normalizeURI(systemId);
        }
        if (publicId != null && publicId.startsWith("urn:publicid:")) {
            publicId = PublicId.decodeURN(publicId);
        }
        if (systemId != null && systemId.startsWith("urn:publicid:")) {
            String decodedSysId = PublicId.decodeURN(systemId);
            if (publicId != null && !publicId.equals(decodedSysId)) {
                this.logger.log("error", "urn:publicid: system identifier differs from public identifier; using public identifier", new Object[0]);
            } else {
                publicId = decodedSysId;
            }
            systemId = null;
        }
        return new ExternalIdentifiers(systemId, publicId);
    }

    public String normalizedForComparison(String uri) {
        if (uri == null) {
            return null;
        }
        if (uri.startsWith("classpath:/")) {
            return "classpath:" + uri.substring(11);
        }
        if (this.resolverConfiguration.getFeature(ResolverFeature.MERGE_HTTPS).booleanValue() && uri.startsWith("http:")) {
            return "https:" + uri.substring(5);
        }
        return uri;
    }

    private static class ExternalIdentifiers {
        private final String systemId;
        private final String publicId;

        private ExternalIdentifiers(String systemId, String publicId) {
            this.systemId = systemId;
            this.publicId = publicId;
        }
    }
}

