/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core.saml;

import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import org.apache.wss4j.common.saml.OpenSAMLUtil;
import org.apache.wss4j.common.saml.SAMLKeyInfo;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;

public final class SAMLUtil {
    private SAMLUtil() {
    }

    public static boolean checkHolderOfKey(SamlAssertionWrapper assertionWrapper, Certificate[] tlsCerts) {
        List confirmationMethods = assertionWrapper.getConfirmationMethods();
        for (String confirmationMethod : confirmationMethods) {
            if (!OpenSAMLUtil.isMethodHolderOfKey((String)confirmationMethod)) continue;
            if (tlsCerts == null || tlsCerts.length == 0) {
                return false;
            }
            SAMLKeyInfo subjectKeyInfo = assertionWrapper.getSubjectKeyInfo();
            if (SAMLUtil.compareCredentials(subjectKeyInfo, tlsCerts)) continue;
            return false;
        }
        return true;
    }

    private static boolean compareCredentials(SAMLKeyInfo subjectKeyInfo, Certificate[] tlsCerts) {
        X509Certificate[] subjectCerts = subjectKeyInfo.getCerts();
        PublicKey subjectPublicKey = subjectKeyInfo.getPublicKey();
        if (subjectCerts != null && subjectCerts.length > 0 && tlsCerts[0].equals(subjectCerts[0])) {
            return true;
        }
        return tlsCerts[0].getPublicKey().equals(subjectPublicKey);
    }
}

